/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.JavaClass;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JField;
import jadx.gui.treemodel.JMethod;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class JNode
extends DefaultMutableTreeNode {
    public static JNode makeFrom(JavaNode node) {
        if (node instanceof JavaClass) {
            JClass p = (JClass)JNode.makeFrom((JavaNode)node.getDeclaringClass());
            return new JClass((JavaClass)node, p);
        }
        if (node instanceof JavaMethod) {
            JavaMethod mth = (JavaMethod)node;
            return new JMethod(mth, new JClass(mth.getDeclaringClass()));
        }
        if (node instanceof JavaField) {
            JavaField fld = (JavaField)node;
            return new JField(fld, new JClass(fld.getDeclaringClass()));
        }
        if (node == null) {
            return null;
        }
        throw new JadxRuntimeException("Unknown type for JavaNode: " + node.getClass());
    }

    public abstract JClass getJParent();

    public JClass getRootClass() {
        return null;
    }

    public abstract int getLine();

    public abstract Icon getIcon();

    public abstract String makeString();

    public String makeLongString() {
        return this.makeString();
    }

    @Override
    public String toString() {
        return this.makeString();
    }
}

