/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.JavaPackage;
import jadx.gui.JadxWrapper;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JPackage;
import jadx.gui.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;

public class JRoot
extends JNode {
    private static final long serialVersionUID = 8888495789773527342L;
    private static final ImageIcon ROOT_ICON = Utils.openIcon("java_model_obj");
    private final JadxWrapper wrapper;
    private boolean flatPackages = false;

    public JRoot(JadxWrapper wrapper) {
        this.wrapper = wrapper;
        this.update();
    }

    public final void update() {
        this.removeAllChildren();
        if (this.flatPackages) {
            for (JavaPackage pkg : this.wrapper.getPackages()) {
                this.add(new JPackage(pkg));
            }
        } else {
            List<JPackage> rootPkgs = this.getHierarchyPackages(this.wrapper.getPackages());
            for (JPackage jPackage : rootPkgs) {
                jPackage.update();
                this.add(jPackage);
            }
        }
    }

    List<JPackage> getHierarchyPackages(List<JavaPackage> packages) {
        boolean repeat;
        HashMap<String, JPackage> pkgMap = new HashMap<String, JPackage>();
        for (JavaPackage pkg : packages) {
            this.addPackage(pkgMap, new JPackage(pkg));
        }
        block1: do {
            repeat = false;
            for (JPackage pkg : pkgMap.values()) {
                if (pkg.getInnerPackages().size() != 1 || !pkg.getClasses().isEmpty()) continue;
                JPackage innerPkg = pkg.getInnerPackages().get(0);
                pkg.getInnerPackages().clear();
                pkg.getInnerPackages().addAll(innerPkg.getInnerPackages());
                pkg.getClasses().addAll(innerPkg.getClasses());
                pkg.setName(pkg.getName() + "." + innerPkg.getName());
                innerPkg.getInnerPackages().clear();
                innerPkg.getClasses().clear();
                repeat = true;
                continue block1;
            }
        } while (repeat);
        Iterator it = pkgMap.entrySet().iterator();
        while (it.hasNext()) {
            JPackage pkg;
            pkg = (JPackage)it.next().getValue();
            if (!pkg.getInnerPackages().isEmpty() || !pkg.getClasses().isEmpty()) continue;
            it.remove();
        }
        Set innerPackages = Collections.newSetFromMap(new IdentityHashMap());
        for (JPackage pkg : pkgMap.values()) {
            innerPackages.addAll(pkg.getInnerPackages());
        }
        ArrayList<JPackage> rootPkgs = new ArrayList<JPackage>();
        for (JPackage pkg : pkgMap.values()) {
            if (innerPackages.contains(pkg)) continue;
            rootPkgs.add(pkg);
        }
        Collections.sort(rootPkgs);
        return rootPkgs;
    }

    private void addPackage(Map<String, JPackage> pkgs, JPackage pkg) {
        int dot;
        String pkgName = pkg.getName();
        JPackage replaced = pkgs.put(pkgName, pkg);
        if (replaced != null) {
            pkg.getInnerPackages().addAll(replaced.getInnerPackages());
            pkg.getClasses().addAll(replaced.getClasses());
        }
        if ((dot = pkgName.lastIndexOf(46)) > 0) {
            String prevPart = pkgName.substring(0, dot);
            String shortName = pkgName.substring(dot + 1);
            pkg.setName(shortName);
            JPackage prevPkg = pkgs.get(prevPart);
            if (prevPkg == null) {
                prevPkg = new JPackage(prevPart);
                this.addPackage(pkgs, prevPkg);
            }
            prevPkg.getInnerPackages().add(pkg);
        }
    }

    public JClass searchClassInTree(JClass node) {
        Enumeration<TreeNode> en = this.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            TreeNode obj = en.nextElement();
            if (!node.equals(obj)) continue;
            return (JClass)obj;
        }
        return null;
    }

    public boolean isFlatPackages() {
        return this.flatPackages;
    }

    public void setFlatPackages(boolean flatPackages) {
        if (this.flatPackages != flatPackages) {
            this.flatPackages = flatPackages;
            this.update();
        }
    }

    @Override
    public Icon getIcon() {
        return ROOT_ICON;
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    @Override
    public int getLine() {
        return 0;
    }

    @Override
    public String makeString() {
        File file = this.wrapper.getOpenFile();
        return file != null ? file.getName() : "File not open";
    }
}

