/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.api.JavaClass;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.gui.JadxWrapper;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.TabbedPane;
import jadx.gui.utils.NLS;
import jadx.gui.utils.NameIndex;
import jadx.gui.utils.Position;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SearchDialog
extends JDialog {
    private static final long serialVersionUID = -5105405456969134105L;
    private static final int MAX_RESULTS_COUNT = 100;
    private static final Set<SearchOptions> OPTIONS = EnumSet.of(SearchOptions.CLASS, SearchOptions.METHOD, SearchOptions.FIELD);
    private final TabbedPane tabbedPane;
    private final JadxWrapper wrapper;
    private NameIndex<JavaNode> index;
    private JTextField searchField;
    private ResultsModel resultsModel;
    private JList resultsList;
    private JProgressBar busyBar;

    public SearchDialog(Frame owner, TabbedPane tabbedPane, JadxWrapper wrapper) {
        super(owner);
        this.tabbedPane = tabbedPane;
        this.wrapper = wrapper;
        this.initUI();
    }

    public void prepare() {
        LoadTask task = new LoadTask();
        task.init();
        task.execute();
    }

    private void loadData() {
        this.index = new NameIndex();
        for (JavaClass cls : this.wrapper.getClasses()) {
            this.indexClass(cls);
        }
    }

    private synchronized void performSearch() {
        String text = this.searchField.getText();
        List<Object> results = text == null || text.isEmpty() || this.index == null ? Collections.emptyList() : this.index.search(text);
        this.resultsModel.setResults(results);
    }

    private void openSelectedItem() {
        int selectedId = this.resultsList.getSelectedIndex();
        if (selectedId == -1) {
            return;
        }
        JNode node = (JNode)this.resultsModel.get(selectedId);
        this.tabbedPane.showCode(new Position(node.getRootClass(), node.getLine()));
        this.dispose();
    }

    private void indexClass(JavaClass cls) {
        if (OPTIONS.contains((Object)SearchOptions.CLASS)) {
            this.index.add(cls.getFullName(), (JavaNode)cls);
        }
        if (OPTIONS.contains((Object)SearchOptions.METHOD)) {
            for (JavaMethod mth : cls.getMethods()) {
                this.index.add(mth.getFullName(), (JavaNode)mth);
            }
        }
        if (OPTIONS.contains((Object)SearchOptions.FIELD)) {
            for (JavaField fld : cls.getFields()) {
                this.index.add(fld.getFullName(), (JavaNode)fld);
            }
        }
        if (OPTIONS.contains((Object)SearchOptions.CODE)) {
            String code = cls.getCode();
            this.index.add(code, (JavaNode)cls);
        }
        for (JavaClass innerCls : cls.getInnerClasses()) {
            this.indexClass(innerCls);
        }
    }

    private void initUI() {
        JLabel findLabel = new JLabel(NLS.str("search_dialog.open_by_name"));
        this.searchField = new JTextField();
        this.searchField.setAlignmentX(0.0f);
        this.searchField.getDocument().addDocumentListener(new SearchFieldListener());
        JCheckBox clsChBox = this.makeOptionsCheckBox(NLS.str("search_dialog.class"), SearchOptions.CLASS);
        JCheckBox mthChBox = this.makeOptionsCheckBox(NLS.str("search_dialog.method"), SearchOptions.METHOD);
        JCheckBox fldChBox = this.makeOptionsCheckBox(NLS.str("search_dialog.field"), SearchOptions.FIELD);
        JCheckBox codeChBox = this.makeOptionsCheckBox(NLS.str("search_dialog.code"), SearchOptions.CODE);
        codeChBox.setEnabled(false);
        this.resultsModel = new ResultsModel();
        this.resultsList = new JList(this.resultsModel);
        this.resultsList.setCellRenderer(new ResultsCellRenderer());
        this.resultsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    SearchDialog.this.openSelectedItem();
                }
            }
        });
        JPanel searchOptions = new JPanel(new FlowLayout(0));
        searchOptions.setBorder(BorderFactory.createTitledBorder(NLS.str("search_dialog.search_in")));
        searchOptions.add(clsChBox);
        searchOptions.add(mthChBox);
        searchOptions.add(fldChBox);
        searchOptions.add(codeChBox);
        searchOptions.setAlignmentX(0.0f);
        JPanel searchPane = new JPanel();
        searchPane.setLayout(new BoxLayout(searchPane, 3));
        findLabel.setLabelFor(this.searchField);
        searchPane.add(findLabel);
        searchPane.add(Box.createRigidArea(new Dimension(0, 5)));
        searchPane.add(this.searchField);
        searchPane.add(Box.createRigidArea(new Dimension(0, 5)));
        searchPane.add(searchOptions);
        searchPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 3));
        listPane.add(new JScrollPane(this.resultsList));
        listPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.busyBar = new JProgressBar();
        this.busyBar.setIndeterminate(true);
        this.busyBar.setVisible(false);
        JButton cancelButton = new JButton(NLS.str("search_dialog.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SearchDialog.this.dispose();
            }
        });
        JButton openBtn = new JButton(NLS.str("search_dialog.open"));
        openBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SearchDialog.this.openSelectedItem();
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(this.busyBar);
        searchPane.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(openBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)searchPane, "First");
        contentPane.add((Component)listPane, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.getRootPane().setDefaultButton(openBtn);
        this.setTitle(NLS.str("menu.search"));
        this.pack();
        this.setSize(700, 500);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
    }

    private JCheckBox makeOptionsCheckBox(String name, final SearchOptions opt) {
        JCheckBox chBox = new JCheckBox(name);
        chBox.setAlignmentX(0.0f);
        chBox.setSelected(OPTIONS.contains((Object)opt));
        chBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    OPTIONS.add(opt);
                } else {
                    OPTIONS.remove((Object)opt);
                }
                SearchDialog.this.loadData();
                SearchDialog.this.performSearch();
            }
        });
        return chBox;
    }

    private class SearchFieldListener
    implements DocumentListener {
        private SearchFieldListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SearchDialog.this.performSearch();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SearchDialog.this.performSearch();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SearchDialog.this.performSearch();
        }
    }

    private static class ResultsCellRenderer
    implements ListCellRenderer {
        private final Color selectedBackground;
        private final Color selectedForeground;

        ResultsCellRenderer() {
            UIDefaults defaults = UIManager.getDefaults();
            this.selectedBackground = defaults.getColor("List.selectionBackground");
            this.selectedForeground = defaults.getColor("List.selectionForeground");
        }

        public Component getListCellRendererComponent(JList list, Object obj, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(obj instanceof JNode)) {
                return null;
            }
            JNode value = (JNode)obj;
            JLabel label = new JLabel();
            label.setOpaque(true);
            label.setIcon(value.getIcon());
            label.setText(value.makeLongString());
            if (isSelected) {
                label.setBackground(this.selectedBackground);
                label.setForeground(this.selectedForeground);
            }
            return label;
        }
    }

    private static class ResultsModel
    extends DefaultListModel {
        private static final long serialVersionUID = -7821286846923903208L;

        private ResultsModel() {
        }

        private void setResults(List<JavaNode> results) {
            this.removeAllElements();
            if (results.isEmpty()) {
                return;
            }
            int count = Math.min(results.size(), 100);
            for (int i = 0; i < count; ++i) {
                this.addElement(JNode.makeFrom(results.get(i)));
            }
        }
    }

    private class LoadTask
    extends SwingWorker<Void, Void> {
        private LoadTask() {
        }

        public void init() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchDialog.this.busyBar.setVisible(true);
                    SearchDialog.this.searchField.setEnabled(false);
                    SearchDialog.this.resultsList.setEnabled(false);
                    SearchDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                }
            });
        }

        @Override
        public Void doInBackground() {
            SearchDialog.this.loadData();
            return null;
        }

        @Override
        public void done() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchDialog.this.setCursor(null);
                    SearchDialog.this.searchField.setEnabled(true);
                    SearchDialog.this.resultsList.setEnabled(true);
                    SearchDialog.this.busyBar.setVisible(false);
                }
            });
        }
    }

    private static enum SearchOptions {
        CLASS,
        METHOD,
        FIELD,
        CODE;

    }
}

