/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.gui.treemodel.JClass;
import jadx.gui.ui.CodeArea;
import jadx.gui.ui.CodePanel;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.JumpManager;
import jadx.gui.utils.NLS;
import jadx.gui.utils.Position;
import jadx.gui.utils.Utils;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonUI;

class TabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = -8833600618794570904L;
    private static final ImageIcon ICON_CLOSE = Utils.openIcon("cross");
    private static final ImageIcon ICON_CLOSE_INACTIVE = Utils.openIcon("cross_grayed");
    private final MainWindow mainWindow;
    private final Map<JClass, CodePanel> openTabs = new LinkedHashMap<JClass, CodePanel>();
    private JumpManager jumps = new JumpManager();

    TabbedPane(MainWindow window) {
        this.mainWindow = window;
        this.setTabLayoutPolicy(1);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int direction = e.getWheelRotation();
                int index = TabbedPane.this.getSelectedIndex();
                int maxIndex = TabbedPane.this.getTabCount() - 1;
                index = index == 0 && direction < 0 || index == maxIndex && direction > 0 ? maxIndex - index : (index += direction);
                TabbedPane.this.setSelectedIndex(index);
            }
        });
    }

    MainWindow getMainWindow() {
        return this.mainWindow;
    }

    void showCode(final Position pos) {
        final CodePanel codePanel = this.getCodePanel(pos.getCls());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TabbedPane.this.setSelectedComponent(codePanel);
                CodeArea codeArea = codePanel.getCodeArea();
                codeArea.scrollToLine(pos.getLine());
                codeArea.requestFocus();
            }
        });
    }

    public void navBack() {
        Position pos = this.jumps.getPrev();
        if (pos != null) {
            this.showCode(pos);
        }
    }

    public void navForward() {
        Position pos = this.jumps.getNext();
        if (pos != null) {
            this.showCode(pos);
        }
    }

    public JumpManager getJumpManager() {
        return this.jumps;
    }

    private void addCodePanel(CodePanel codePanel) {
        this.openTabs.put(codePanel.getCls(), codePanel);
        this.add(codePanel);
    }

    private void closeCodePanel(CodePanel codePanel) {
        this.openTabs.remove(codePanel.getCls());
        this.remove(codePanel);
    }

    private CodePanel getCodePanel(JClass cls) {
        CodePanel panel = this.openTabs.get(cls);
        if (panel == null) {
            panel = new CodePanel(this, cls);
            this.addCodePanel(panel);
            this.setTabComponentAt(this.indexOfComponent(panel), this.makeTabComponent(panel));
        }
        return panel;
    }

    CodePanel getSelectedCodePanel() {
        return (CodePanel)this.getSelectedComponent();
    }

    private Component makeTabComponent(final CodePanel codePanel) {
        JClass cls = codePanel.getCls();
        String name = cls.getCls().getFullName();
        final JPanel panel = new JPanel(new FlowLayout(1, 3, 0));
        panel.setOpaque(false);
        JLabel label = new JLabel(name);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        label.setIcon(cls.getIcon());
        JButton button = new JButton();
        button.setIcon(ICON_CLOSE_INACTIVE);
        button.setRolloverIcon(ICON_CLOSE);
        button.setRolloverEnabled(true);
        button.setOpaque(false);
        button.setUI(new BasicButtonUI());
        button.setContentAreaFilled(false);
        button.setFocusable(false);
        button.setBorder(null);
        button.setBorderPainted(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedPane.this.closeCodePanel(codePanel);
            }
        });
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isMiddleMouseButton(e)) {
                    TabbedPane.this.closeCodePanel(codePanel);
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    JPopupMenu menu = TabbedPane.this.createTabPopupMenu(codePanel);
                    menu.show(panel, e.getX(), e.getY());
                } else {
                    TabbedPane.this.setSelectedComponent(codePanel);
                }
            }
        });
        panel.add(label);
        panel.add(button);
        panel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        return panel;
    }

    private JPopupMenu createTabPopupMenu(final CodePanel codePanel) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem closeTab = new JMenuItem(NLS.str("tabs.close"));
        closeTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedPane.this.closeCodePanel(codePanel);
            }
        });
        menu.add(closeTab);
        if (this.openTabs.size() > 1) {
            JMenuItem closeOther = new JMenuItem(NLS.str("tabs.closeOthers"));
            closeOther.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrayList codePanels = new ArrayList(TabbedPane.this.openTabs.values());
                    for (CodePanel panel : codePanels) {
                        if (panel == codePanel) continue;
                        TabbedPane.this.closeCodePanel(panel);
                    }
                }
            });
            menu.add(closeOther);
            JMenuItem closeAll = new JMenuItem(NLS.str("tabs.closeAll"));
            closeAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrayList codePanels = new ArrayList(TabbedPane.this.openTabs.values());
                    for (CodePanel panel : codePanels) {
                        TabbedPane.this.closeCodePanel(panel);
                    }
                }
            });
            menu.add(closeAll);
            menu.addSeparator();
            CodePanel selectedCodePanel = this.getSelectedCodePanel();
            for (Map.Entry<JClass, CodePanel> entry : this.openTabs.entrySet()) {
                final CodePanel cp = entry.getValue();
                if (cp == selectedCodePanel) continue;
                JClass jClass = entry.getKey();
                String clsName = jClass.getCls().getFullName();
                JMenuItem item = new JMenuItem(clsName);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TabbedPane.this.setSelectedComponent(cp);
                    }
                });
                item.setIcon(jClass.getIcon());
                menu.add(item);
            }
        }
        return menu;
    }
}

