/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.info;

import com.android.dex.MethodId;
import com.android.dex.ProtoId;
import jadx.core.codegen.TypeGen;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.DexNode;
import jadx.core.utils.Utils;
import java.util.List;

public final class MethodInfo {
    private final String name;
    private final ArgType retType;
    private final List<ArgType> args;
    private final ClassInfo declClass;
    private final String shortId;

    private MethodInfo(DexNode dex, int mthIndex) {
        MethodId mthId = dex.getMethodId(mthIndex);
        this.name = dex.getString(mthId.getNameIndex());
        this.declClass = ClassInfo.fromDex(dex, mthId.getDeclaringClassIndex());
        ProtoId proto = dex.getProtoId(mthId.getProtoIndex());
        this.retType = dex.getType(proto.getReturnTypeIndex());
        this.args = dex.readParamList(proto.getParametersOffset());
        StringBuilder signature = new StringBuilder();
        signature.append(this.name);
        signature.append('(');
        for (ArgType arg : this.args) {
            signature.append(TypeGen.signature(arg));
        }
        signature.append(')');
        signature.append(TypeGen.signature(this.retType));
        this.shortId = signature.toString();
    }

    public static MethodInfo fromDex(DexNode dex, int mthIndex) {
        return new MethodInfo(dex, mthIndex);
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.declClass.getFullName() + "." + this.name;
    }

    public String getFullId() {
        return this.declClass.getFullName() + "." + this.shortId;
    }

    public String getShortId() {
        return this.shortId;
    }

    public ClassInfo getDeclClass() {
        return this.declClass;
    }

    public ArgType getReturnType() {
        return this.retType;
    }

    public List<ArgType> getArgumentsTypes() {
        return this.args;
    }

    public int getArgsCount() {
        return this.args.size();
    }

    public boolean isConstructor() {
        return this.name.equals("<init>");
    }

    public boolean isClassInit() {
        return this.name.equals("<clinit>");
    }

    public int hashCode() {
        int result = this.declClass.hashCode();
        result = 31 * result + this.retType.hashCode();
        result = 31 * result + this.shortId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodInfo other = (MethodInfo)obj;
        if (!this.shortId.equals(other.shortId)) {
            return false;
        }
        if (!this.retType.equals(other.retType)) {
            return false;
        }
        return this.declClass.equals(other.declClass);
    }

    public String toString() {
        return this.declClass.getFullName() + "." + this.name + "(" + Utils.listToString(this.args) + "):" + this.retType;
    }
}

