/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;

public final class InsnWrapArg
extends InsnArg {
    private final InsnNode wrappedInsn;

    public InsnWrapArg(InsnNode insn) {
        RegisterArg result = insn.getResult();
        this.type = result != null ? result.getType() : ArgType.VOID;
        this.wrappedInsn = insn;
    }

    public InsnNode getWrapInsn() {
        return this.wrappedInsn;
    }

    @Override
    public void setParentInsn(InsnNode parentInsn) {
        assert (parentInsn != this.wrappedInsn) : "Can't wrap instruction info itself: " + parentInsn;
        this.parentInsn = parentInsn;
    }

    @Override
    public boolean isInsnWrap() {
        return true;
    }

    public String toString() {
        return "(wrap: " + this.type + "\n  " + this.wrappedInsn + ")";
    }
}

