/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;

public class TypeImmutableArg
extends RegisterArg {
    private boolean isThis;

    public TypeImmutableArg(int rn, ArgType type) {
        super(rn, type);
    }

    @Override
    public boolean isTypeImmutable() {
        return true;
    }

    @Override
    public void setType(ArgType type) {
    }

    public void markAsThis() {
        this.isThis = true;
    }

    @Override
    public boolean isThis() {
        return this.isThis;
    }

    @Override
    public String getName() {
        if (this.isThis) {
            return "this";
        }
        return super.getName();
    }

    @Override
    void setSVar(SSAVar sVar) {
        if (this.isThis) {
            sVar.setName("this");
        }
        sVar.setTypeImmutable(this.type);
        super.setSVar(sVar);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeImmutableArg)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        TypeImmutableArg that = (TypeImmutableArg)obj;
        return this.isThis == that.isThis;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (this.isThis ? 1 : 0);
    }
}

