/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import com.android.dex.ClassData;
import com.android.dex.ClassDef;
import com.android.dex.Code;
import com.android.dex.Dex;
import com.android.dex.FieldId;
import com.android.dex.MethodId;
import com.android.dex.ProtoId;
import com.android.dex.TypeList;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.files.InputFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class DexNode {
    public static final int NO_INDEX = -1;
    private final RootNode root;
    private final Dex dexBuf;
    private final List<ClassNode> classes = new ArrayList<ClassNode>();
    private final Map<Object, FieldNode> constFields = new HashMap<Object, FieldNode>();

    public DexNode(RootNode root, InputFile input) {
        this.root = root;
        this.dexBuf = input.getDexBuffer();
    }

    public void loadClasses() throws DecodeException {
        for (ClassDef cls : this.dexBuf.classDefs()) {
            this.classes.add(new ClassNode(this, cls));
        }
    }

    public List<ClassNode> getClasses() {
        return this.classes;
    }

    @Nullable
    public ClassNode resolveClass(ClassInfo clsInfo) {
        return this.root.resolveClass(clsInfo);
    }

    @Nullable
    public MethodNode resolveMethod(MethodInfo mth) {
        ClassNode cls = this.resolveClass(mth.getDeclClass());
        if (cls != null) {
            return cls.searchMethod(mth);
        }
        return null;
    }

    @Nullable
    public FieldNode resolveField(FieldInfo field) {
        ClassNode cls = this.resolveClass(field.getDeclClass());
        if (cls != null) {
            return cls.searchField(field);
        }
        return null;
    }

    public Map<Object, FieldNode> getConstFields() {
        return this.constFields;
    }

    public String getString(int index) {
        return (String)this.dexBuf.strings().get(index);
    }

    public ArgType getType(int index) {
        return ArgType.parse(this.getString((Integer)this.dexBuf.typeIds().get(index)));
    }

    public MethodId getMethodId(int mthIndex) {
        return (MethodId)this.dexBuf.methodIds().get(mthIndex);
    }

    public FieldId getFieldId(int fieldIndex) {
        return (FieldId)this.dexBuf.fieldIds().get(fieldIndex);
    }

    public ProtoId getProtoId(int protoIndex) {
        return (ProtoId)this.dexBuf.protoIds().get(protoIndex);
    }

    public ClassData readClassData(ClassDef cls) {
        return this.dexBuf.readClassData(cls);
    }

    public List<ArgType> readParamList(int parametersOffset) {
        TypeList paramList = this.dexBuf.readTypeList(parametersOffset);
        ArrayList<ArgType> args = new ArrayList<ArgType>(paramList.getTypes().length);
        for (short t : paramList.getTypes()) {
            args.add(this.getType(t));
        }
        return Collections.unmodifiableList(args);
    }

    public Code readCode(ClassData.Method mth) {
        return this.dexBuf.readCode(mth);
    }

    public Dex.Section openSection(int offset) {
        return this.dexBuf.open(offset);
    }

    public RootNode root() {
        return this.root;
    }

    public String toString() {
        return "DEX";
    }
}

