/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import com.android.dx.io.instructions.DecodedInstruction;
import jadx.core.dex.attributes.nodes.LineAttrNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InsnNode
extends LineAttrNode {
    protected final InsnType insnType;
    private RegisterArg result;
    private final List<InsnArg> arguments;
    protected int offset;
    protected int insnHashCode = super.hashCode();

    public InsnNode(InsnType type, int argsCount) {
        this.insnType = type;
        this.offset = -1;
        this.arguments = argsCount == 0 ? Collections.emptyList() : new ArrayList<InsnArg>(argsCount);
    }

    public static InsnNode wrapArg(InsnArg arg) {
        InsnNode insn = new InsnNode(InsnType.ONE_ARG, 1);
        insn.addArg(arg);
        return insn;
    }

    public void setResult(RegisterArg res) {
        if (res != null) {
            res.setParentInsn(this);
        }
        this.result = res;
    }

    public void addArg(InsnArg arg) {
        arg.setParentInsn(this);
        this.arguments.add(arg);
    }

    public InsnType getType() {
        return this.insnType;
    }

    public RegisterArg getResult() {
        return this.result;
    }

    public Iterable<InsnArg> getArguments() {
        return this.arguments;
    }

    public int getArgsCount() {
        return this.arguments.size();
    }

    public InsnArg getArg(int n) {
        return this.arguments.get(n);
    }

    public boolean containsArg(RegisterArg arg) {
        for (InsnArg a : this.arguments) {
            if (a != arg && (!a.isRegister() || ((RegisterArg)a).getRegNum() != arg.getRegNum())) continue;
            return true;
        }
        return false;
    }

    public void setArg(int n, InsnArg arg) {
        arg.setParentInsn(this);
        this.arguments.set(n, arg);
    }

    public boolean replaceArg(InsnArg from, InsnArg to) {
        int count = this.getArgsCount();
        for (int i = 0; i < count; ++i) {
            InsnArg arg = this.arguments.get(i);
            if (arg == from) {
                this.setArg(i, to);
                return true;
            }
            if (!arg.isInsnWrap() || !((InsnWrapArg)arg).getWrapInsn().replaceArg(from, to)) continue;
            return true;
        }
        return false;
    }

    protected boolean removeArg(InsnArg arg) {
        int count = this.getArgsCount();
        for (int i = 0; i < count; ++i) {
            if (arg != this.arguments.get(i)) continue;
            this.arguments.remove(i);
            return true;
        }
        return false;
    }

    protected void addReg(DecodedInstruction insn, int i, ArgType type) {
        this.addArg(InsnArg.reg(insn, i, type));
    }

    protected void addReg(int regNum, ArgType type) {
        this.addArg(InsnArg.reg(regNum, type));
    }

    protected void addLit(long literal, ArgType type) {
        this.addArg(InsnArg.lit(literal, type));
    }

    protected void addLit(DecodedInstruction insn, ArgType type) {
        this.addArg(InsnArg.lit(insn, type));
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void getRegisterArgs(List<RegisterArg> list) {
        for (InsnArg arg : this.getArguments()) {
            if (arg.isRegister()) {
                list.add((RegisterArg)arg);
                continue;
            }
            if (!arg.isInsnWrap()) continue;
            ((InsnWrapArg)arg).getWrapInsn().getRegisterArgs(list);
        }
    }

    public boolean isConstInsn() {
        switch (this.getType()) {
            case CONST: 
            case CONST_STR: 
            case CONST_CLASS: {
                return true;
            }
        }
        return false;
    }

    public boolean canReorder() {
        switch (this.getType()) {
            case CONST: 
            case CONST_STR: 
            case CONST_CLASS: 
            case CAST: 
            case MOVE: 
            case ARITH: 
            case NEG: 
            case CMP_L: 
            case CMP_G: 
            case CHECK_CAST: 
            case INSTANCE_OF: 
            case FILL_ARRAY: 
            case FILLED_NEW_ARRAY: 
            case NEW_ARRAY: 
            case NEW_MULTIDIM_ARRAY: 
            case STR_CONCAT: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return InsnUtils.formatOffset(this.offset) + ": " + InsnUtils.insnTypeToString(this.insnType) + (this.result == null ? "" : this.result + " = ") + Utils.listToString(this.arguments);
    }

    public void setInsnHashCode(int insnHashCode) {
        this.insnHashCode = insnHashCode;
    }

    public int hashCode() {
        return this.insnHashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        if (!(obj instanceof InsnNode)) {
            return false;
        }
        InsnNode other = (InsnNode)obj;
        if (this.insnType != other.insnType) {
            return false;
        }
        return this.arguments.size() == other.arguments.size();
    }
}

