/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import jadx.core.clsp.ClspGraph;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.DexNode;
import jadx.core.utils.ErrorsCounter;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.files.InputFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RootNode {
    private final Map<String, ClassNode> names = new HashMap<String, ClassNode>();
    private final ErrorsCounter errorsCounter = new ErrorsCounter();
    private List<DexNode> dexNodes;

    public void load(List<InputFile> dexFiles) throws DecodeException {
        this.dexNodes = new ArrayList<DexNode>(dexFiles.size());
        for (InputFile dex : dexFiles) {
            DexNode dexNode;
            try {
                dexNode = new DexNode(this, dex);
            }
            catch (Exception e) {
                throw new DecodeException("Error decode file: " + dex, e);
            }
            this.dexNodes.add(dexNode);
        }
        for (DexNode dexNode : this.dexNodes) {
            dexNode.loadClasses();
        }
        ArrayList<ClassNode> classes = new ArrayList<ClassNode>();
        for (DexNode dexNode : this.dexNodes) {
            for (ClassNode cls : dexNode.getClasses()) {
                this.names.put(cls.getFullName(), cls);
            }
            classes.addAll(dexNode.getClasses());
        }
        try {
            RootNode.initClassPath(classes);
        }
        catch (IOException e) {
            throw new DecodeException("Error loading classpath", e);
        }
        this.initInnerClasses(classes);
    }

    private static void initClassPath(List<ClassNode> classes) throws IOException, DecodeException {
        if (!ArgType.isClspSet()) {
            ClspGraph clsp = new ClspGraph();
            clsp.load();
            clsp.addApp(classes);
            ArgType.setClsp(clsp);
        }
    }

    private void initInnerClasses(List<ClassNode> classes) {
        ArrayList<ClassNode> inner = new ArrayList<ClassNode>();
        for (ClassNode cls : classes) {
            if (!cls.getClassInfo().isInner()) continue;
            inner.add(cls);
        }
        for (ClassNode cls : inner) {
            ClassNode parent = this.resolveClass(cls.getClassInfo().getParentClass());
            if (parent == null) {
                this.names.remove(cls.getFullName());
                cls.getClassInfo().notInner();
                this.names.put(cls.getFullName(), cls);
                continue;
            }
            parent.addInnerClass(cls);
        }
    }

    public List<ClassNode> getClasses(boolean includeInner) {
        ArrayList<ClassNode> classes = new ArrayList<ClassNode>();
        for (DexNode dexNode : this.dexNodes) {
            for (ClassNode cls : dexNode.getClasses()) {
                if (includeInner) {
                    classes.add(cls);
                    continue;
                }
                if (cls.getClassInfo().isInner()) continue;
                classes.add(cls);
            }
        }
        return classes;
    }

    public ClassNode searchClassByName(String fullName) {
        return this.names.get(fullName);
    }

    public ClassNode resolveClass(ClassInfo cls) {
        String fullName = cls.getFullName();
        return this.searchClassByName(fullName);
    }

    public ErrorsCounter getErrorsCounter() {
        return this.errorsCounter;
    }
}

