/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.regions;

import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.regions.AbstractRegion;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.TryCatchBlock;
import jadx.core.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TryCatchRegion
extends AbstractRegion {
    private final IContainer tryRegion;
    private List<IContainer> catchRegions = Collections.emptyList();
    private TryCatchBlock tryCatchBlock;

    public TryCatchRegion(IRegion parent, IContainer tryRegion) {
        super(parent);
        this.tryRegion = tryRegion;
    }

    public IContainer getTryRegion() {
        return this.tryRegion;
    }

    public List<IContainer> getCatchRegions() {
        return this.catchRegions;
    }

    public TryCatchBlock geTryCatchBlock() {
        return this.tryCatchBlock;
    }

    public void setTryCatchBlock(TryCatchBlock tryCatchBlock) {
        this.tryCatchBlock = tryCatchBlock;
        this.catchRegions = new ArrayList<IContainer>(tryCatchBlock.getHandlersCount());
        for (ExceptionHandler handler : tryCatchBlock.getHandlers()) {
            this.catchRegions.add(handler.getHandlerRegion());
        }
    }

    @Override
    public List<IContainer> getSubBlocks() {
        ArrayList<IContainer> all = new ArrayList<IContainer>(1 + this.catchRegions.size());
        all.add(this.tryRegion);
        all.addAll(this.catchRegions);
        return Collections.unmodifiableList(all);
    }

    @Override
    public String baseString() {
        return this.tryRegion.baseString();
    }

    public String toString() {
        return "Try: " + this.tryRegion + " catches: " + Utils.listToString(this.catchRegions);
    }
}

