/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.trycatch;

import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.trycatch.TryCatchBlock;
import jadx.core.utils.InsnUtils;
import java.util.ArrayList;
import java.util.List;

public class ExceptionHandler {
    private final ClassInfo catchType;
    private final int handleOffset;
    private BlockNode handlerBlock;
    private final List<BlockNode> blocks = new ArrayList<BlockNode>();
    private IContainer handlerRegion;
    private InsnArg arg;
    private TryCatchBlock tryBlock;

    public ExceptionHandler(int addr, ClassInfo type) {
        this.handleOffset = addr;
        this.catchType = type;
    }

    public ClassInfo getCatchType() {
        return this.catchType;
    }

    public boolean isCatchAll() {
        return this.catchType == null || this.catchType.getFullName().equals("java.lang.Throwable");
    }

    public int getHandleOffset() {
        return this.handleOffset;
    }

    public BlockNode getHandlerBlock() {
        return this.handlerBlock;
    }

    public void setHandlerBlock(BlockNode handlerBlock) {
        this.handlerBlock = handlerBlock;
    }

    public List<BlockNode> getBlocks() {
        return this.blocks;
    }

    public void addBlock(BlockNode node) {
        this.blocks.add(node);
    }

    public IContainer getHandlerRegion() {
        return this.handlerRegion;
    }

    public void setHandlerRegion(IContainer handlerRegion) {
        this.handlerRegion = handlerRegion;
    }

    public InsnArg getArg() {
        return this.arg;
    }

    public void setArg(InsnArg arg) {
        this.arg = arg;
    }

    public void setTryBlock(TryCatchBlock tryBlock) {
        this.tryBlock = tryBlock;
    }

    public TryCatchBlock getTryBlock() {
        return this.tryBlock;
    }

    public int hashCode() {
        return (this.catchType == null ? 0 : 31 * this.catchType.hashCode()) + this.handleOffset;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExceptionHandler other = (ExceptionHandler)obj;
        if (this.catchType == null ? other.catchType != null : !this.catchType.equals(other.catchType)) {
            return false;
        }
        return this.handleOffset == other.handleOffset;
    }

    public String toString() {
        return (this.catchType == null ? "all" : this.catchType.getShortName()) + " -> " + InsnUtils.formatOffset(this.handleOffset);
    }
}

