/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.trycatch;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.InsnContainer;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.CatchAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.utils.InstructionRemover;
import jadx.core.utils.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TryCatchBlock {
    private final List<ExceptionHandler> handlers = new LinkedList<ExceptionHandler>();
    private IContainer finalRegion;
    private final List<InsnNode> insns = new ArrayList<InsnNode>();
    private final CatchAttr attr = new CatchAttr(this);

    public Iterable<ExceptionHandler> getHandlers() {
        return this.handlers;
    }

    public int getHandlersCount() {
        return this.handlers.size();
    }

    public boolean containsAllHandlers(TryCatchBlock tb) {
        return this.handlers.containsAll(tb.handlers);
    }

    public ExceptionHandler addHandler(MethodNode mth, int addr, ClassInfo type) {
        ExceptionHandler handler = new ExceptionHandler(addr, type);
        handler = mth.addExceptionHandler(handler);
        this.handlers.add(handler);
        handler.setTryBlock(this);
        return handler;
    }

    public void removeHandler(MethodNode mth, ExceptionHandler handler) {
        Iterator<ExceptionHandler> it = this.handlers.iterator();
        while (it.hasNext()) {
            ExceptionHandler h = it.next();
            if (h != handler) continue;
            it.remove();
            break;
        }
        if (this.handlers.isEmpty()) {
            this.removeWholeBlock(mth);
        }
    }

    private void removeWholeBlock(MethodNode mth) {
        if (this.finalRegion != null) {
            for (BlockNode block : mth.getBasicBlocks()) {
                CatchAttr cb = block.get(AType.CATCH_BLOCK);
                if (cb != this.attr) continue;
                for (ExceptionHandler eh : mth.getExceptionHandlers()) {
                    if (!eh.getBlocks().contains(block)) continue;
                    TryCatchBlock tb = eh.getTryBlock();
                    tb.setFinalRegionFromInsns(mth, ((IBlock)this.finalRegion).getInstructions());
                }
            }
        } else {
            for (InsnNode insn : this.insns) {
                insn.removeAttr(this.attr);
            }
            this.insns.clear();
            for (BlockNode block : mth.getBasicBlocks()) {
                block.removeAttr(this.attr);
            }
        }
    }

    public void addInsn(InsnNode insn) {
        this.insns.add(insn);
        insn.addAttr(this.attr);
    }

    public void removeInsn(InsnNode insn) {
        this.insns.remove(insn);
        insn.remove(AType.CATCH_BLOCK);
    }

    public Iterable<InsnNode> getInsns() {
        return this.insns;
    }

    public CatchAttr getCatchAttr() {
        return this.attr;
    }

    public IContainer getFinalRegion() {
        return this.finalRegion;
    }

    public void setFinalRegion(IContainer finalRegion) {
        this.finalRegion = finalRegion;
    }

    public void setFinalRegionFromInsns(MethodNode mth, List<InsnNode> insns) {
        ArrayList<InsnNode> finalBlockInsns = new ArrayList<InsnNode>(insns);
        this.setFinalRegion(new InsnContainer(finalBlockInsns));
        InstructionRemover.unbindInsnList(mth, finalBlockInsns);
        for (ExceptionHandler h : this.getHandlers()) {
            for (BlockNode ehb : h.getBlocks()) {
                ehb.getInstructions().removeAll(finalBlockInsns);
            }
        }
        for (BlockNode b : mth.getBasicBlocks()) {
            CatchAttr ca = b.get(AType.CATCH_BLOCK);
            if (this.attr != ca) continue;
            b.getInstructions().removeAll(finalBlockInsns);
        }
    }

    public void merge(MethodNode mth, TryCatchBlock tryBlock) {
        for (InsnNode insn : tryBlock.getInsns()) {
            this.addInsn(insn);
        }
        this.handlers.addAll(tryBlock.handlers);
        for (ExceptionHandler eh : this.handlers) {
            eh.setTryBlock(this);
        }
        tryBlock.handlers.clear();
        tryBlock.removeWholeBlock(mth);
    }

    public int hashCode() {
        return ((Object)this.handlers).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TryCatchBlock other = (TryCatchBlock)obj;
        return ((Object)this.handlers).equals(other.handlers);
    }

    public String toString() {
        return "Catch:{ " + Utils.listToString(this.handlers) + " }";
    }
}

