/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.codegen.TypeGen;
import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.ConstClassNode;
import jadx.core.dex.instructions.ConstStringNode;
import jadx.core.dex.instructions.FillArrayNode;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.SwitchNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.NamedArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.ExcHandlerAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.InstructionRemover;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModVisitor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(ModVisitor.class);

    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        InstructionRemover remover = new InstructionRemover(mth);
        ModVisitor.replaceStep(mth, remover);
        ModVisitor.removeStep(mth, remover);
        ModVisitor.checkArgsNames(mth);
        for (BlockNode block : mth.getBasicBlocks()) {
            ModVisitor.processExceptionHandler(mth, block);
        }
    }

    private static void replaceStep(MethodNode mth, InstructionRemover remover) {
        ClassNode parentClass = mth.getParentClass();
        for (BlockNode block : mth.getBasicBlocks()) {
            remover.setBlock(block);
            int size = block.getInstructions().size();
            block7: for (int i = 0; i < size; ++i) {
                InsnNode insn = block.getInstructions().get(i);
                switch (insn.getType()) {
                    case INVOKE: {
                        ModVisitor.processInvoke(mth, block, i, remover);
                        continue block7;
                    }
                    case CONST: 
                    case CONST_STR: 
                    case CONST_CLASS: {
                        FieldNode f;
                        if (insn.getType() == InsnType.CONST_STR) {
                            String s = ((ConstStringNode)insn).getString();
                            f = parentClass.getConstField(s);
                        } else if (insn.getType() == InsnType.CONST_CLASS) {
                            ArgType t = ((ConstClassNode)insn).getClsType();
                            f = parentClass.getConstField(t);
                        } else {
                            f = parentClass.getConstFieldByLiteralArg((LiteralArg)insn.getArg(0));
                        }
                        if (f == null) continue block7;
                        IndexInsnNode inode = new IndexInsnNode(InsnType.SGET, f.getFieldInfo(), 0);
                        inode.setResult(insn.getResult());
                        ModVisitor.replaceInsn(block, i, inode);
                        continue block7;
                    }
                    case SWITCH: {
                        FieldNode f;
                        SwitchNode sn = (SwitchNode)insn;
                        for (int k = 0; k < sn.getCasesCount(); ++k) {
                            f = parentClass.getConstField(sn.getKeys()[k]);
                            if (f == null) continue;
                            sn.getKeys()[k] = new IndexInsnNode(InsnType.SGET, f.getFieldInfo(), 0);
                        }
                        continue block7;
                    }
                    case RETURN: {
                        LiteralArg arg;
                        FieldNode f;
                        if (insn.getArgsCount() <= 0 || !insn.getArg(0).isLiteral() || (f = parentClass.getConstFieldByLiteralArg(arg = (LiteralArg)insn.getArg(0))) == null) continue block7;
                        arg.wrapInstruction(new IndexInsnNode(InsnType.SGET, f.getFieldInfo(), 0));
                        continue block7;
                    }
                }
            }
            remover.perform();
        }
    }

    private static void processInvoke(MethodNode mth, BlockNode block, int insnNumber, InstructionRemover remover) {
        block11: {
            InvokeNode inv;
            ClassNode parentClass;
            block9: {
                ConstructorInsn replace;
                InsnNode newInstInsn;
                ConstructorInsn co;
                InsnNode instArgAssignInsn;
                block10: {
                    MethodNode defCo;
                    parentClass = mth.getParentClass();
                    InsnNode insn = block.getInstructions().get(insnNumber);
                    inv = (InvokeNode)insn;
                    MethodInfo callMth = inv.getCallMth();
                    if (!callMth.isConstructor()) break block9;
                    instArgAssignInsn = ((RegisterArg)inv.getArg(0)).getAssignInsn();
                    co = new ConstructorInsn(mth, inv);
                    boolean remove = false;
                    if (co.isSuper() && (co.getArgsCount() == 0 || parentClass.isEnum())) {
                        remove = true;
                    } else if (co.isThis() && co.getArgsCount() == 0 && ((defCo = parentClass.searchMethodByName(callMth.getShortId())) == null || defCo.isNoCode())) {
                        remove = true;
                    }
                    if (parentClass.isAnonymous() && mth.isDefaultConstructor() && co.isSuper()) {
                        remove = true;
                    }
                    if (!remove) break block10;
                    remover.add(insn);
                    break block11;
                }
                ModVisitor.replaceInsn(block, insnNumber, co);
                if (co.isNewInstance() && (newInstInsn = ModVisitor.removeAssignChain(instArgAssignInsn, remover, InsnType.NEW_INSTANCE)) != null) {
                    RegisterArg instArg = newInstInsn.getResult();
                    RegisterArg resultArg = co.getResult();
                    if (!resultArg.equals(instArg)) {
                        for (RegisterArg useArg : new ArrayList<RegisterArg>(instArg.getSVar().getUseList())) {
                            RegisterArg dup = resultArg.duplicate();
                            InsnNode parentInsn = useArg.getParentInsn();
                            parentInsn.replaceArg(useArg, dup);
                            dup.setParentInsn(parentInsn);
                            resultArg.getSVar().use(dup);
                        }
                    }
                }
                if ((replace = ModVisitor.processConstructor(mth, co)) == null) break block11;
                ModVisitor.replaceInsn(block, insnNumber, replace);
                break block11;
            }
            if (inv.getArgsCount() > 0) {
                for (int j = 0; j < inv.getArgsCount(); ++j) {
                    FieldNode f;
                    InsnArg arg = inv.getArg(j);
                    if (!arg.isLiteral() || (f = parentClass.getConstFieldByLiteralArg((LiteralArg)arg)) == null) continue;
                    arg.wrapInstruction(new IndexInsnNode(InsnType.SGET, f.getFieldInfo(), 0));
                }
            }
        }
    }

    private static ConstructorInsn processConstructor(MethodNode mth, ConstructorInsn co) {
        MethodNode callMth = mth.dex().resolveMethod(co.getCallMth());
        if (callMth == null || !callMth.getAccessFlags().isSynthetic() || !ModVisitor.allArgsNull(co)) {
            return null;
        }
        ClassNode classNode = mth.dex().resolveClass(callMth.getParentClass().getClassInfo());
        if (classNode == null) {
            return null;
        }
        boolean passThis = co.getArgsCount() >= 1 && co.getArg(0).isThis();
        String ctrId = "<init>(" + (passThis ? TypeGen.signature(co.getArg(0).getType()) : "") + ")V";
        MethodNode defCtr = classNode.searchMethodByName(ctrId);
        if (defCtr == null) {
            return null;
        }
        ConstructorInsn newInsn = new ConstructorInsn(defCtr.getMethodInfo(), co.getCallType(), co.getInstanceArg());
        newInsn.setResult(co.getResult());
        return newInsn;
    }

    private static boolean allArgsNull(InsnNode insn) {
        for (InsnArg insnArg : insn.getArguments()) {
            LiteralArg lit;
            if (!(insnArg.isLiteral() ? (lit = (LiteralArg)insnArg).getLiteral() != 0L : !insnArg.isThis())) continue;
            return false;
        }
        return true;
    }

    private static InsnNode removeAssignChain(InsnNode insn, InstructionRemover remover, InsnType insnType) {
        if (insn == null) {
            return null;
        }
        remover.add(insn);
        InsnType type = insn.getType();
        if (type == insnType) {
            return insn;
        }
        if (type == InsnType.MOVE) {
            RegisterArg arg = (RegisterArg)insn.getArg(0);
            return ModVisitor.removeAssignChain(arg.getAssignInsn(), remover, insnType);
        }
        return null;
    }

    private static void removeStep(MethodNode mth, InstructionRemover remover) {
        for (BlockNode block : mth.getBasicBlocks()) {
            remover.setBlock(block);
            int size = block.getInstructions().size();
            block6: for (int i = 0; i < size; ++i) {
                InsnNode insn = block.getInstructions().get(i);
                switch (insn.getType()) {
                    case NOP: 
                    case GOTO: 
                    case NEW_INSTANCE: {
                        remover.add(insn);
                        continue block6;
                    }
                    case NEW_ARRAY: {
                        InsnNode ni;
                        int next = i + 1;
                        if (next >= size || (ni = block.getInstructions().get(next)).getType() != InsnType.FILL_ARRAY) continue block6;
                        ni.getResult().merge(insn.getResult());
                        ((FillArrayNode)ni).mergeElementType(insn.getResult().getType().getArrayElement());
                        remover.add(insn);
                        continue block6;
                    }
                    case RETURN: {
                        if (insn.getArgsCount() != 0) continue block6;
                        if (mth.getBasicBlocks().size() == 1 && i == size - 1) {
                            remover.add(insn);
                            continue block6;
                        }
                        if (!mth.getMethodInfo().isClassInit()) continue block6;
                        remover.add(insn);
                        continue block6;
                    }
                }
            }
            remover.perform();
        }
    }

    private static void processExceptionHandler(MethodNode mth, BlockNode block) {
        InsnNode insn;
        ExcHandlerAttr handlerAttr = block.get(AType.EXC_HANDLER);
        if (handlerAttr == null) {
            return;
        }
        ExceptionHandler excHandler = handlerAttr.getHandler();
        boolean noExitNode = true;
        boolean reThrow = false;
        for (BlockNode excBlock : excHandler.getBlocks()) {
            if (noExitNode) {
                noExitNode = excHandler.getBlocks().containsAll(excBlock.getCleanSuccessors());
            }
            List<InsnNode> insns = excBlock.getInstructions();
            int size = insns.size();
            if (!excHandler.isCatchAll() || size <= 0 || insns.get(size - 1).getType() != InsnType.THROW) continue;
            reThrow = true;
            InstructionRemover.remove(mth, excBlock, size - 1);
            if (insns.isEmpty()) continue;
            insns.clear();
        }
        List<InsnNode> blockInsns = block.getInstructions();
        if (!blockInsns.isEmpty() && (insn = blockInsns.get(0)).getType() == InsnType.MOVE_EXCEPTION) {
            SSAVar sVar;
            String name;
            RegisterArg resArg = insn.getResult();
            ArgType type = excHandler.isCatchAll() ? ArgType.THROWABLE : excHandler.getCatchType().getType();
            String string = name = excHandler.isCatchAll() ? "th" : "e";
            if (resArg.getName() == null) {
                resArg.setName(name);
            }
            if ((sVar = insn.getResult().getSVar()).getUseCount() == 0) {
                excHandler.setArg(new NamedArg(name, type));
                InstructionRemover.remove(mth, block, 0);
            } else if (sVar.isUsedInPhi()) {
                InsnNode moveInsn = new InsnNode(InsnType.MOVE, 1);
                moveInsn.setResult(insn.getResult());
                NamedArg namedArg = new NamedArg(name, type);
                moveInsn.addArg(namedArg);
                excHandler.setArg(namedArg);
                ModVisitor.replaceInsn(block, 0, moveInsn);
            }
        }
        int totalSize = 0;
        for (BlockNode excBlock : excHandler.getBlocks()) {
            totalSize += excBlock.getInstructions().size();
        }
        if (totalSize == 0 && noExitNode && reThrow) {
            handlerAttr.getTryBlock().removeHandler(mth, excHandler);
        }
    }

    private static void replaceInsn(BlockNode block, int i, InsnNode insn) {
        InsnNode prevInsn = block.getInstructions().get(i);
        insn.copyAttributesFrom(prevInsn);
        block.getInstructions().set(i, insn);
    }

    private static void checkArgsNames(MethodNode mth) {
        for (RegisterArg arg : mth.getArguments(false)) {
            String name = arg.getName();
            if (name == null || !NameMapper.isReserved(name)) continue;
            name = name + "_";
            arg.getSVar().setName(name);
        }
    }
}

