/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.regions.SynchronizedRegion;
import jadx.core.dex.regions.loops.LoopRegion;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.regions.AbstractRegionVisitor;
import jadx.core.dex.visitors.regions.CleanRegions;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import jadx.core.dex.visitors.regions.ProcessTryCatchRegions;
import jadx.core.dex.visitors.regions.RegionMaker;
import jadx.core.dex.visitors.regions.RegionStack;
import jadx.core.utils.InstructionRemover;
import jadx.core.utils.exceptions.JadxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionMakerVisitor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(RegionMakerVisitor.class);

    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isNoCode()) {
            return;
        }
        RegionMaker rm = new RegionMaker(mth);
        RegionStack state = new RegionStack(mth);
        mth.setRegion(rm.makeRegion(mth.getEnterBlock(), state));
        if (!mth.isNoExceptionHandlers()) {
            rm.processTryCatchBlocks(mth);
        }
        RegionMakerVisitor.postProcessRegions(mth);
    }

    private static void postProcessRegions(MethodNode mth) {
        ProcessTryCatchRegions.process(mth);
        if (mth.getLoopsCount() != 0) {
            DepthRegionTraversal.traverseAll(mth, new AbstractRegionVisitor(){

                @Override
                public void enterRegion(MethodNode mth, IRegion region) {
                    if (region instanceof LoopRegion) {
                        LoopRegion loop = (LoopRegion)region;
                        loop.mergePreCondition();
                    }
                }
            });
        }
        CleanRegions.process(mth);
        if (mth.getAccessFlags().isSynchronized()) {
            RegionMakerVisitor.removeSynchronized(mth);
        }
    }

    private static void removeSynchronized(MethodNode mth) {
        Region startRegion = mth.getRegion();
        List<IContainer> subBlocks = startRegion.getSubBlocks();
        if (!subBlocks.isEmpty() && subBlocks.get(0) instanceof SynchronizedRegion) {
            SynchronizedRegion synchRegion = (SynchronizedRegion)subBlocks.get(0);
            InsnNode synchInsn = synchRegion.getEnterInsn();
            if (!synchInsn.getArg(0).isThis()) {
                LOG.warn("In synchronized method {}, top region not synchronized by 'this' {}", (Object)mth, (Object)synchInsn);
                return;
            }
            startRegion.getSubBlocks().set(0, synchRegion.getRegion());
            InstructionRemover.remove(mth, synchInsn);
            for (InsnNode exit : synchRegion.getExitInsns()) {
                InstructionRemover.remove(mth, exit);
            }
            CleanRegions.process(mth);
        }
    }
}

