/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.gui.JadxWrapper;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JRoot;
import jadx.gui.ui.AboutDialog;
import jadx.gui.ui.CodePanel;
import jadx.gui.ui.SearchDialog;
import jadx.gui.ui.TabbedPane;
import jadx.gui.update.JadxUpdate;
import jadx.gui.update.data.Release;
import jadx.gui.utils.JadxPreferences;
import jadx.gui.utils.Link;
import jadx.gui.utils.NLS;
import jadx.gui.utils.Position;
import jadx.gui.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainWindow
extends JFrame {
    private static final Logger LOG = LoggerFactory.getLogger(MainWindow.class);
    private static final String DEFAULT_TITLE = "jadx-gui";
    private static final double BORDER_RATIO = 0.15;
    private static final double WINDOW_RATIO = 0.7;
    private static final double SPLIT_PANE_RESIZE_WEIGHT = 0.15;
    private static final ImageIcon ICON_OPEN = Utils.openIcon("folder");
    private static final ImageIcon ICON_SAVE_ALL = Utils.openIcon("disk_multiple");
    private static final ImageIcon ICON_CLOSE = Utils.openIcon("cross");
    private static final ImageIcon ICON_SYNC = Utils.openIcon("sync");
    private static final ImageIcon ICON_FLAT_PKG = Utils.openIcon("empty_logical_package_obj");
    private static final ImageIcon ICON_SEARCH = Utils.openIcon("wand");
    private static final ImageIcon ICON_FIND = Utils.openIcon("magnifier");
    private static final ImageIcon ICON_BACK = Utils.openIcon("icon_back");
    private static final ImageIcon ICON_FORWARD = Utils.openIcon("icon_forward");
    private final JadxWrapper wrapper;
    private JPanel mainPanel;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private JRoot treeRoot;
    private TabbedPane tabbedPane;
    private JCheckBoxMenuItem flatPkgMenuItem;
    private JToggleButton flatPkgButton;
    private boolean isFlattenPackage;
    private Link updateLink;

    public MainWindow(JadxWrapper wrapper) {
        this.wrapper = wrapper;
        this.initUI();
        this.initMenuAndToolbar();
        JadxUpdate.check(new JadxUpdate.IUpdateCallback(){

            @Override
            public void onUpdate(final Release r) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainWindow.this.updateLink.setText(String.format(NLS.str("menu.update_label"), r.getName()));
                        MainWindow.this.updateLink.setVisible(true);
                    }
                });
            }
        });
    }

    public void openFile() {
        int ret;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setFileFilter(new FileNameExtensionFilter("supported files", "dex", "apk", "jar"));
        fileChooser.setToolTipText(NLS.str("file.open"));
        String currentDirectory = JadxPreferences.getLastOpenFilePath();
        if (!currentDirectory.isEmpty()) {
            fileChooser.setCurrentDirectory(new File(currentDirectory));
        }
        if ((ret = fileChooser.showDialog(this.mainPanel, NLS.str("file.open"))) == 0) {
            JadxPreferences.putLastOpenFilePath(fileChooser.getCurrentDirectory().getPath());
            this.openFile(fileChooser.getSelectedFile());
        }
    }

    public void openFile(File file) {
        this.wrapper.openFile(file);
        this.initTree();
        this.setTitle("jadx-gui - " + file.getName());
    }

    private void saveAllAction() {
        int ret;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setToolTipText(NLS.str("file.save_all_msg"));
        String currentDirectory = JadxPreferences.getLastSaveFilePath();
        if (!currentDirectory.isEmpty()) {
            fileChooser.setCurrentDirectory(new File(currentDirectory));
        }
        if ((ret = fileChooser.showDialog(this.mainPanel, NLS.str("file.select"))) == 0) {
            JadxPreferences.putLastSaveFilePath(fileChooser.getCurrentDirectory().getPath());
            ProgressMonitor progressMonitor = new ProgressMonitor(this.mainPanel, NLS.str("msg.saving_sources"), "", 0, 100);
            progressMonitor.setMillisToPopup(500);
            this.wrapper.saveAll(fileChooser.getSelectedFile(), progressMonitor);
        }
    }

    private void initTree() {
        this.treeRoot = new JRoot(this.wrapper);
        this.treeRoot.setFlatPackages(this.isFlattenPackage);
        this.treeModel.setRoot(this.treeRoot);
        this.treeModel.reload();
        this.tree.expandRow(0);
    }

    private void toggleFlattenPackage() {
        this.setFlattenPackage(!this.isFlattenPackage);
    }

    private void setFlattenPackage(boolean value) {
        this.isFlattenPackage = value;
        JadxPreferences.putFlattenPackage(this.isFlattenPackage);
        this.flatPkgButton.setSelected(this.isFlattenPackage);
        this.flatPkgMenuItem.setState(this.isFlattenPackage);
        Object root = this.treeModel.getRoot();
        if (root instanceof JRoot) {
            JRoot treeRoot = (JRoot)root;
            treeRoot.setFlatPackages(this.isFlattenPackage);
            this.treeModel.reload();
            this.tree.expandRow(0);
        }
    }

    private void treeClickAction() {
        JNode node;
        JClass cls;
        Object obj = this.tree.getLastSelectedPathComponent();
        if (obj instanceof JNode && (cls = (node = (JNode)obj).getRootClass()) != null) {
            this.tabbedPane.showCode(new Position(cls, node.getLine()));
        }
    }

    private void syncWithEditor() {
        CodePanel selectedCodePanel = this.tabbedPane.getSelectedCodePanel();
        if (selectedCodePanel == null) {
            return;
        }
        JClass jCls = selectedCodePanel.getCls();
        if (jCls.getParent() == null && this.treeRoot != null && (jCls = this.treeRoot.searchClassInTree(jCls)) == null) {
            LOG.error("Class not found in tree");
            return;
        }
        Object[] pathNodes = this.treeModel.getPathToRoot(jCls);
        if (pathNodes == null) {
            return;
        }
        TreePath path = new TreePath(pathNodes);
        this.tree.setSelectionPath(path);
        this.tree.makeVisible(path);
    }

    private void toggleFind() {
        CodePanel codePanel = this.tabbedPane.getSelectedCodePanel();
        if (codePanel != null) {
            codePanel.getSearchBar().toggle();
        }
    }

    private void initMenuAndToolbar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu(NLS.str("menu.file"));
        file.setMnemonic(70);
        JMenuItem exit = new JMenuItem(NLS.str("file.exit"), ICON_CLOSE);
        exit.setMnemonic(69);
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainWindow.this.dispose();
            }
        });
        JMenuItem open = new JMenuItem(NLS.str("file.open"), ICON_OPEN);
        open.setMnemonic(79);
        open.addActionListener(new OpenListener());
        JMenuItem saveAll = new JMenuItem(NLS.str("file.save_all"), ICON_SAVE_ALL);
        saveAll.setMnemonic(83);
        saveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveAllAction();
            }
        });
        file.add(open);
        file.add(saveAll);
        file.addSeparator();
        file.add(exit);
        JMenu view = new JMenu(NLS.str("menu.view"));
        view.setMnemonic(86);
        this.isFlattenPackage = JadxPreferences.getFlattenPackage();
        this.flatPkgMenuItem = new JCheckBoxMenuItem(NLS.str("menu.flatten"), ICON_FLAT_PKG);
        view.add(this.flatPkgMenuItem);
        this.flatPkgMenuItem.setState(this.isFlattenPackage);
        JMenuItem syncItem = new JMenuItem(NLS.str("menu.sync"), ICON_SYNC);
        view.add(syncItem);
        syncItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.syncWithEditor();
            }
        });
        JMenu nav = new JMenu(NLS.str("menu.navigation"));
        nav.setMnemonic(78);
        JMenuItem search = new JMenuItem(NLS.str("menu.search"), ICON_SEARCH);
        nav.add(search);
        ActionListener searchAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                final SearchDialog dialog = new SearchDialog((Frame)MainWindow.this, MainWindow.this.tabbedPane, MainWindow.this.wrapper);
                dialog.prepare();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        dialog.setVisible(true);
                    }
                });
            }
        };
        search.addActionListener(searchAction);
        JMenuItem find = new JMenuItem(NLS.str("menu.find_in_file"), ICON_FIND);
        nav.add(find);
        ActionListener findAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.toggleFind();
            }
        };
        find.addActionListener(findAction);
        JMenu help = new JMenu(NLS.str("menu.help"));
        help.setMnemonic(72);
        JMenuItem about = new JMenuItem(NLS.str("menu.about"));
        help.add(about);
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AboutDialog ad = new AboutDialog();
                ad.setVisible(true);
            }
        });
        menuBar.add(file);
        menuBar.add(view);
        menuBar.add(nav);
        menuBar.add(help);
        this.setJMenuBar(menuBar);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        JButton openButton = new JButton(ICON_OPEN);
        openButton.addActionListener(new OpenListener());
        openButton.setToolTipText(NLS.str("file.open"));
        toolbar.add(openButton);
        JButton saveAllButton = new JButton(ICON_SAVE_ALL);
        saveAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveAllAction();
            }
        });
        saveAllButton.setToolTipText(NLS.str("file.save_all"));
        toolbar.add(saveAllButton);
        toolbar.addSeparator();
        JButton syncButton = new JButton(ICON_SYNC);
        syncButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.syncWithEditor();
            }
        });
        syncButton.setToolTipText(NLS.str("menu.sync"));
        toolbar.add(syncButton);
        this.flatPkgButton = new JToggleButton(ICON_FLAT_PKG);
        this.flatPkgButton.setSelected(this.isFlattenPackage);
        ActionListener flatPkgAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.toggleFlattenPackage();
            }
        };
        this.flatPkgButton.addActionListener(flatPkgAction);
        this.flatPkgMenuItem.addActionListener(flatPkgAction);
        this.flatPkgButton.setToolTipText(NLS.str("menu.flatten"));
        toolbar.add(this.flatPkgButton);
        toolbar.addSeparator();
        JButton searchButton = new JButton(ICON_SEARCH);
        searchButton.addActionListener(searchAction);
        searchButton.setToolTipText(NLS.str("menu.search"));
        toolbar.add(searchButton);
        JButton findButton = new JButton(ICON_FIND);
        findButton.addActionListener(findAction);
        findButton.setToolTipText(NLS.str("menu.find_in_file"));
        toolbar.add(findButton);
        toolbar.addSeparator();
        JButton backButton = new JButton(ICON_BACK);
        backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.tabbedPane.navBack();
            }
        });
        backButton.setToolTipText(NLS.str("nav.back"));
        toolbar.add(backButton);
        JButton forwardButton = new JButton(ICON_FORWARD);
        forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.tabbedPane.navForward();
            }
        });
        forwardButton.setToolTipText(NLS.str("nav.forward"));
        toolbar.add(forwardButton);
        toolbar.add(Box.createHorizontalGlue());
        this.updateLink = new Link("", "https://github.com/skylot/jadx/releases");
        this.updateLink.setVisible(false);
        toolbar.add(this.updateLink);
        this.mainPanel.add((Component)toolbar, "North");
    }

    private void initUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.15);
        this.mainPanel.add(splitPane);
        DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode(NLS.str("msg.open_file"));
        this.treeModel = new DefaultTreeModel(treeRoot);
        this.tree = new JTree(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MainWindow.this.treeClickAction();
            }
        });
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MainWindow.this.treeClickAction();
                }
            }
        });
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int row, boolean focused) {
                Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, isLeaf, row, focused);
                if (value instanceof JNode) {
                    this.setIcon(((JNode)value).getIcon());
                }
                return c;
            }
        });
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                TreePath path = event.getPath();
                Object node = path.getLastPathComponent();
                if (node instanceof JClass) {
                    JClass cls = (JClass)node;
                    cls.getRootClass().load();
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
        JScrollPane treeScrollPane = new JScrollPane(this.tree);
        splitPane.setLeftComponent(treeScrollPane);
        this.tabbedPane = new TabbedPane(this);
        splitPane.setRightComponent(this.tabbedPane);
        this.setContentPane(this.mainPanel);
        this.setTitle(DEFAULT_TITLE);
    }

    public void setLocationAndPosition() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode mode = gd.getDisplayMode();
        int w = mode.getWidth();
        int h = mode.getHeight();
        this.setLocation((int)((double)w * 0.15), (int)((double)h * 0.15));
        this.setSize((int)((double)w * 0.7), (int)((double)h * 0.7));
    }

    private class OpenListener
    implements ActionListener {
        private OpenListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MainWindow.this.openFile();
        }
    }
}

