/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.Vector;

class LogParser {
    private BufferedReader logfile;
    private Vector logdata;
    long lastTimeStamp = 0L;
    long addValue = 0L;

    public float ParseDuration(StringCharacterIterator stringCharacterIterator) throws ParseException {
        int n;
        int n2 = this.ConvertDecimalInteger(stringCharacterIterator);
        switch (stringCharacterIterator.next()) {
            case ':': {
                n = n2;
                n2 = 0;
                break;
            }
            case '.': {
                n = this.ConvertDecimalInteger(stringCharacterIterator);
                if (stringCharacterIterator.next() == ':') break;
                throw new ParseException("bad duration separator", stringCharacterIterator.getIndex());
            }
            default: {
                throw new ParseException("bad duration separator", stringCharacterIterator.getIndex());
            }
        }
        int n3 = this.ConvertDecimalInteger(stringCharacterIterator);
        if (stringCharacterIterator.next() != ':') {
            throw new ParseException("bad duration separator", stringCharacterIterator.getIndex());
        }
        float f = this.ConvertDecimalFloat(stringCharacterIterator);
        return (float)((24.0 * (double)n2 + (double)n) * 3600.0 + (double)((float)n3 * 60.0f) + (double)f);
    }

    private float ConvertDecimalFloat(StringCharacterIterator stringCharacterIterator) throws ParseException, NumberFormatException {
        String string;
        block2: {
            string = "";
            char c = stringCharacterIterator.next();
            if (c != '.' && (c < '0' || c > '9')) {
                stringCharacterIterator.previous();
                throw new ParseException("invalid digit2 " + c, stringCharacterIterator.getIndex());
            }
            do {
                string = string + c;
                c = stringCharacterIterator.next();
                if (c == '\uffff') break block2;
                if (c != ',') continue;
                c = stringCharacterIterator.next();
            } while (c == '.' || c >= '0' && c <= '9');
            stringCharacterIterator.previous();
        }
        return Float.valueOf(string).floatValue();
    }

    public LogParser(BufferedReader bufferedReader, Vector vector) {
        this.logfile = bufferedReader;
        this.logdata = vector;
    }

    public boolean ParseLogEntry(String string, String string2, GraphEntry graphEntry) {
        try {
            if (!string.startsWith("[")) {
                return false;
            }
            int n = string.indexOf("Completed ");
            if (n < 0) {
                return false;
            }
            boolean bl = string.charAt(n - 2) == ':';
            graphEntry.timestamp = this.ParseTimestamp(string.substring(1)) + this.addValue;
            if (graphEntry.timestamp - this.lastTimeStamp < -8640000L) {
                this.addValue += 315360000L;
                graphEntry.timestamp += 315360000L;
            }
            this.lastTimeStamp = graphEntry.timestamp;
            graphEntry.project = bl ? this.ParseProject(new StringCharacterIterator(string, n - 5)) : this.ParseProject(new StringCharacterIterator(string, n + 9));
            int n2 = string.indexOf(40);
            if (n2 < 0) {
                return false;
            }
            if (bl) {
                float f = this.ConvertDecimalFloat(new StringCharacterIterator(string, n2));
                graphEntry.keycount = graphEntry.project == 1 || graphEntry.project == 2 || graphEntry.project == 3 ? (long)(2.6843546E8f * f) : (long)f;
            } else {
                graphEntry.keycount = this.ConvertDecimalInteger(new StringCharacterIterator(string, n2));
            }
            int n3 = string2.lastIndexOf(91);
            if (n3 < 0) {
                return false;
            }
            graphEntry.rate = this.ConvertDecimalFloat(new StringCharacterIterator(string2, n3));
            int n4 = string2.lastIndexOf(32, n3 - 4);
            if (n4 < 0) {
                return false;
            }
            graphEntry.duration = this.ParseDuration(new StringCharacterIterator(string2, n4));
            return true;
        }
        catch (Exception exception) {
            System.out.println("parse exception " + exception);
            return false;
        }
    }

    private long ParseTimestamp(String string) throws ParseException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        if (Character.isDigit(stringCharacterIterator.first())) {
            n6 = this.ConvertDecimalInteger(stringCharacterIterator);
            if (stringCharacterIterator.next() != '/') {
                throw new ParseException("bad separator", stringCharacterIterator.getIndex());
            }
            n5 = this.ConvertDecimalInteger(stringCharacterIterator);
            if (stringCharacterIterator.next() != '/') {
                throw new ParseException("bad separator", stringCharacterIterator.getIndex());
            }
            n4 = this.ConvertDecimalInteger(stringCharacterIterator);
            if (stringCharacterIterator.next() != ' ') {
                throw new ParseException("bad separator", stringCharacterIterator.getIndex());
            }
            n3 = this.ConvertDecimalInteger(stringCharacterIterator);
            if (stringCharacterIterator.next() != ':') {
                throw new ParseException("bad separator", stringCharacterIterator.getIndex());
            }
            n2 = this.ConvertDecimalInteger(stringCharacterIterator);
            if (stringCharacterIterator.next() != ':') {
                throw new ParseException("bad separator", stringCharacterIterator.getIndex());
            }
            n = this.ConvertDecimalInteger(stringCharacterIterator);
        } else {
            n6 = this.ConvertMonthName(string.substring(0, 3));
            if (stringCharacterIterator.setIndex(3) != ' ') {
                throw new ParseException("bad separator1", stringCharacterIterator.getIndex());
            }
            n5 = this.ConvertDecimalInteger(stringCharacterIterator);
            if (stringCharacterIterator.next() != ' ') {
                throw new ParseException("bad separator2", stringCharacterIterator.getIndex());
            }
            n3 = this.ConvertDecimalInteger(stringCharacterIterator);
            if (stringCharacterIterator.next() != ':') {
                throw new ParseException("bad separator3", stringCharacterIterator.getIndex());
            }
            n2 = this.ConvertDecimalInteger(stringCharacterIterator);
            if (stringCharacterIterator.next() != ':') {
                throw new ParseException("bad separator4", stringCharacterIterator.getIndex());
            }
            n = this.ConvertDecimalInteger(stringCharacterIterator);
            n4 = 1998;
        }
        if (n4 < 0) {
            throw new ParseException("bad year", stringCharacterIterator.getIndex());
        }
        if (n4 < 70) {
            n4 += 2000;
        } else if (n4 < 100) {
            n4 += 1900;
        }
        if (n6 < 1 || n6 > 12 || n5 < 1 || n5 > 31 || n4 < 1970 || n4 >= 2038 || n3 < 0 || n3 > 23 || n2 < 0 || n2 > 59 || n < 0 || n > 59) {
            throw new ParseException("bad field value", stringCharacterIterator.getIndex());
        }
        return Date.UTC(n4 - 1900, n6 - 1, n5, n3, n2, n) / 100L;
    }

    private int ConvertDecimalInteger(StringCharacterIterator stringCharacterIterator) throws ParseException {
        int n;
        block2: {
            n = 0;
            char c = stringCharacterIterator.next();
            if (c < '0' || c > '9') {
                stringCharacterIterator.previous();
                throw new ParseException("invalid digit " + c, stringCharacterIterator.getIndex());
            }
            do {
                n = n * 10 + (c - 48);
                c = stringCharacterIterator.next();
                if (c == '\uffff') break block2;
                if (c != ',') continue;
                c = stringCharacterIterator.next();
            } while (c >= '0' && c <= '9');
            stringCharacterIterator.previous();
        }
        return n;
    }

    private int ConvertMonthName(String string) throws ParseException {
        if (string.compareTo("Jan") == 0) {
            return 1;
        }
        if (string.compareTo("Feb") == 0) {
            return 2;
        }
        if (string.compareTo("Mar") == 0) {
            return 3;
        }
        if (string.compareTo("Apr") == 0) {
            return 4;
        }
        if (string.compareTo("May") == 0) {
            return 5;
        }
        if (string.compareTo("Jun") == 0) {
            return 6;
        }
        if (string.compareTo("Jul") == 0) {
            return 7;
        }
        if (string.compareTo("Aug") == 0) {
            return 8;
        }
        if (string.compareTo("Sep") == 0) {
            return 9;
        }
        if (string.compareTo("Oct") == 0) {
            return 10;
        }
        if (string.compareTo("Nov") == 0) {
            return 11;
        }
        if (string.compareTo("Dec") == 0) {
            return 12;
        }
        throw new ParseException("invalid month " + string, 0);
    }

    public int ParseProject(StringCharacterIterator stringCharacterIterator) throws ParseException {
        String string = "";
        int n = 0;
        string = string + stringCharacterIterator.next();
        string = string + stringCharacterIterator.next();
        if ((string = string + stringCharacterIterator.next()).compareTo("RC5") == 0) {
            n = 1;
        } else if (string.compareTo("DES") == 0) {
            n = 2;
        } else if (string.compareTo("CSC") == 0) {
            n = 3;
        } else if (string.compareTo("OGR") == 0) {
            n = 4;
        }
        return n;
    }

    public void run() {
        GraphEntry graphEntry = new GraphEntry();
        String string = null;
        String string2 = null;
        try {
            string = this.logfile.readLine();
            while (this.logfile.ready()) {
                string2 = this.logfile.readLine();
                if (this.ParseLogEntry(string, string2, graphEntry)) {
                    this.logdata.addElement(graphEntry);
                    graphEntry = new GraphEntry();
                }
                string = string2;
            }
        }
        catch (IOException iOException) {
            System.out.println("LogParser.run(): " + iOException);
        }
    }
}

