// Copyright distributed.net 1997-1998 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: w32sock.cpp,v $
// Revision 1.3  1998/11/02 05:15:06  cyp
// Added code to search for winsock.dll before using LoadLibrary().
//
// Revision 1.2  1998/10/26 04:25:55  cyp
// Everything works now (tested under win16 Novell, Microsoft and Trumpet 
// stacks, as well as the win32 M$ stack)
//
#if (!defined(lint) && defined(__showids__))
const char *w32sock_cpp(void) {
return "@(#)$Id: w32sock.cpp,v 1.3 1998/11/02 05:15:06 cyp Exp $"; }
#endif

#include "w32sock.h"
#include <stdio.h>
#include <string.h>
#if defined(__WINDOWS_386__)
#undef FAR
#define FAR
#endif

/* ----------------------------------------------- */

#ifdef NO_W32SOCK /* dummy functions */
int closesocket(SOCKET s)
{ s=s; return -1; }  
int send(SOCKET s,char *buff,int len,int flags)
{ s=s; buff=buff; len=len; flags=flags; return -1; }
int recv(SOCKET s,char *buff,int len,int flags)
{ s=s; buff=buff; len=len; flags=flags; return -1; }
#endif

/* ---------------------------------------- */

#ifndef NO_W32SOCK

static struct 
{
  unsigned long ipaddr;
  char desc[WSADESCRIPTION_LEN+1];
  char status[WSASYS_STATUS_LEN+1];
} w32sockstatics = {0};  

static FARPROC ImportWinsockSymbol(LPCSTR lpszProcName)
{
  HMODULE ws = GetModuleHandle("WINSOCK");
  if (ws)
    return GetProcAddress(ws, lpszProcName);
  return (FARPROC)0;
}  

static HINSTANCE __LoadLibrary( LPCSTR lpszLibName )
{
  OFSTRUCT ofstruct;
  ofstruct.cBytes = sizeof(ofstruct);
  HINSTANCE hinst = 0;

  #ifndef OF_SEARCH
  #define OF_SEARCH 0x0400
  #endif
  if ( OpenFile( lpszLibName, &ofstruct, OF_EXIST|OF_SEARCH) >= 0 )
    {
    hinst = LoadLibrary( ofstruct.szPathName );
    if ((UINT)hinst <= 32)
      hinst = 0;
    }
  return hinst;  
}

/* ---------------------------------------- */

u_short PASCAL FAR htons(u_short s)
{ return ((((s)&0xff)<<8) | (((s)>>8)&0xff)); }
u_short PASCAL FAR ntohs(u_short s)
{  return htons(s); }
u_long PASCAL FAR htonl(u_long l)
{ return ((((l)&0xff)<<24) | (((l)>>24)&0xff) | (((l)&0xff00)<<8) | (((l)>>8)&0xff00)); }
u_long PASCAL FAR ntohl(u_long l)
{ return htonl(l); }
  
/* ---------------------------------------- */

static char *__inet_ultoa( u_long addr )
{
  static char buff[18];
  char *p = (char *)(&addr);
  sprintf( buff, "%d.%d.%d.%d", (p[0]&255),(p[1]&255),(p[2]&255),(p[3]&255) );
  return buff;
}  

char FAR * PASCAL FAR inet_ntoa( struct in_addr addr )
{ return __inet_ultoa( *((u_long *)(&addr)) ); }

/* ---------------------------------------- */

int PASCAL FAR gethostname(char FAR * name, int namelen)
{
  FARPROC __gethostname = ImportWinsockSymbol( "gethostname" );
  if (__gethostname)
    {
    #if defined(__WINDOWS_386__)
    char buf[256];
    short rc = -1;
    DWORD alias = AllocAlias16( (void *)(&buf[0]) );
    buf[0]=0;
    if (alias)
      {
      rc = (short)_Call16(__gethostname,"dw", alias, sizeof(buf) );
      FreeAlias16( alias );
      }
    if (rc == -1 && w32sockstatics.ipaddr != 0)
      {
      char *p = (char *)(&w32sockstatics.ipaddr);
      sprintf(buf,"%u.%u.%u.%u",(p[0]&0xFF),(p[1]&0xFF),
                                   (p[2]&0xFF),(p[3]&0xFF) );
      rc = 0;
      }
    if (rc == 0)
      {
      if (strlen(buf) > namelen)
        rc = -1;
      else
        strcpy( name, buf );
      }
    return ((rc!=0)?(-1):(0));
    #else
    return (*((int PASCAL FAR (*)(char FAR *,int))(__gethostname)))(name, namelen);
    #endif
    }
  return -1;
}  

/* ---------------------------------------- */

SOCKET PASCAL FAR socket(int domain, int type, int protocol)
{
#if 0
MessageBox(NULL,"beginning socket", "blah", MB_OK|MB_TASKMODAL);
char buffer[128];
buffer[0]=0;
gethostname( buffer, sizeof(buffer));
MessageBox(NULL,buffer, "gethostname", MB_OK|MB_TASKMODAL);
strcpy(buffer,"134.93.246.119");
unsigned long addr = inet_addr(buffer);
MessageBox(NULL, __inet_ultoa( addr ), "inet_addr/inet_ntoa test ", MB_OK|MB_TASKMODAL);
#endif

  FARPROC __socket = ImportWinsockSymbol( "socket" );
  if (__socket)
    {
    #if defined(__WINDOWS_386__)
    return (0xFFFF & (_Call16(__socket,"www",domain,type,protocol)));
    #else
    return (*(SOCKET PASCAL FAR (*)(int,int,int))(__socket))(domain,type,protocol);
    #endif
    }
  return -1;
}  

/* ---------------------------------------- */

int PASCAL FAR shutdown(SOCKET s, int how)
{
  FARPROC __shutdown = ImportWinsockSymbol( "shutdown" );
  if (__shutdown) 
    {
    #if defined(__WINDOWS_386__)
    return (((_Call16(__shutdown,"ww",s,how)) == 0)?(0):(-1));
    #else
    return (*((int PASCAL FAR (*)(SOCKET,int))(__shutdown)))(s,how);
    #endif
    }
  return -1;
}  

/* ---------------------------------------- */

int PASCAL FAR closesocket(SOCKET s)
{
  FARPROC __closesocket = ImportWinsockSymbol( "closesocket" );
  if (__closesocket) 
    {
    #if defined(__WINDOWS_386__)
    return ((_Call16(__closesocket,"w",s) == 0)?(0):(-1));
    #else
    return (*((int PASCAL FAR (*)(SOCKET))(__closesocket)))(s);
    #endif
    }
  return -1;
}  

/* ---------------------------------------- */

int PASCAL FAR connect(SOCKET s, const struct sockaddr FAR *name, int namelen)
{
  FARPROC __connect = ImportWinsockSymbol( "connect" );
  if (__connect)
    {
    #if defined(__WINDOWS_386__)
    return ((_Call16(__connect, "wpw", s, name, namelen)==0)?(0):(-1));
    #else
    return (*((int PASCAL FAR (*)(SOCKET, const struct sockaddr FAR *, int))
         (__connect)))( s, name, namelen );
    #endif
    }
  return -1;
}  

/* ---------------------------------------- */

unsigned long PASCAL FAR inet_addr(const char FAR * cp)
{
  FARPROC __inet_addr = ImportWinsockSymbol( "inet_addr" );
  if (__inet_addr)
    {
    #if defined(__WINDOWS_386__)
    return (unsigned long)_Call16(__inet_addr, "p", cp );
    #else
    return (*((int PASCAL FAR (*)(const char FAR *))(__inet_addr)))(cp);
    #endif
    }
  return -1;
}

/* ---------------------------------------- */

struct hostent FAR * PASCAL FAR gethostbyname(const char FAR * name)
{
  FARPROC __gethostbyname = ImportWinsockSymbol( "gethostbyname" );
  if (__gethostbyname)
    {
    #if defined(__WINDOWS_386__)
    if (name)
      {
      static u_long addresses[2]; /* MSWinsock 1.1 GPFs getting > 1 address */
      static char *addrlist[2];
      static char hostname[256];
      static struct hostent hent;
      struct hostent far *hp;
      unsigned int index;
      char far * far *pp;
      char far *p;

      hp = (struct hostent far *)_Call16(__gethostbyname, "p", name );
      if (hp)
        {
        hp = (struct hostent far *)MK_FP32( (void *)hp );
        
        hent.h_name = 0;
        hent.h_addrtype = hp->h_addrtype;
        hent.h_length = hp->h_length;
        hent.h_aliases = 0;
        hent.h_addr_list = 0;

        if (hp->h_addr_list)
          {
          index = 0;
          hent.h_addr_list = &addrlist[0];
          pp = (char far * far *)MK_FP32((void *)(hp->h_addr_list));
          while (pp[index] && index<((sizeof(addrlist)/sizeof(addrlist[0]))-1))
            {
            p = (char far *)MK_FP32((void *)(pp[index]));
            addresses[index] = *((u_long far *)(p));
            addrlist[index] = (char *)(&addresses[index]);
            index++;
            }
          addrlist[index]=0;
          }
#if 0 /* doesn't work - GPFs for some reason on MSWinsock 1.1 (win95/98) */
        if (hp->h_aliases)
          {
          static char aliasname[256];
          static char *aliaslist[2];
          aliaslist[0]=aliaslist[1]=0;
          hent.h_aliases = &aliaslist[0];
          pp = (char far * far *)MK_FP32((void *)(hp->h_aliases));
          if (pp[0])
            {
MessageBox(NULL,"beginning get aliases", "blah", MB_OK|MB_TASKMODAL);
            p = (char far *)MK_FP32((void *)(pp[0]));
            index = 0;
            while (*p && index<(sizeof(aliasname)-1))
              aliasname[index++] = *p++;
            aliasname[index]=0;
            aliaslist[0] = &aliasname[0];
sprintf(hostname,"alias %s", aliaslist[0] );
MessageBox(NULL,hostname, w32sockstatics.desc, MB_OK|MB_TASKMODAL);
            }
          }
#endif
        if (hp->h_name)
          {
          char far *p = (char far *)MK_FP32( (void *)hp->h_name );
          index=0;
          while (*p && index<(sizeof(hostname)-1))
            hostname[index++] = *p++;
          hostname[index]=0;
          hent.h_name = &hostname[0];
          }
        return &hent;
        }
      }
    #else
    return (*((struct hostent FAR * PASCAL FAR (*)(const char FAR *))
                                         (__gethostbyname)))(name);
    #endif
    }
  return (struct hostent FAR * )0;
}  

/* ---------------------------------------- */

int PASCAL FAR send(SOCKET s, const char FAR * buf, int len, int flags)
{
//MessageBox(NULL,"beginning send", "blah", MB_OK|MB_TASKMODAL);
  FARPROC __send = ImportWinsockSymbol( "send" );
  if (__send)
    {
    #if defined(__WINDOWS_386__)
    short rc = (short)(0xFFFF & (_Call16(__send, "wpww", s, buf, len, flags)));
    return ((rc<0)?(-1):(((int)(rc))&0xFFFF));
    #else
    return (*((int PASCAL FAR (*)(SOCKET, const char FAR *, int, int))(__send)))
                                                         (s, buf, len, flags);
    #endif
    }
  return -1;
}  

/* ---------------------------------------- */

int PASCAL FAR recv (SOCKET s, char FAR * buf, int len, int flags)
{
//MessageBox(NULL,"beginning recv", "blah", MB_OK|MB_TASKMODAL);
  FARPROC __recv = ImportWinsockSymbol( "recv" );
  if (__recv)
    {
    #if defined(__WINDOWS_386__)
    short rc = (short)(0xFFFF & (_Call16(__recv, "wpww", s, buf, len, flags)));
    return ((rc<0)?(-1):(((int)(rc))&0xFFFF));
    #else
    return (*((int PASCAL FAR (*)(SOCKET, char FAR *, int, int))(__recv)))
                                                         (s, buf, len, flags);
    #endif
    }
  return -1;
}  

/* ---------------------------------------- */

int PASCAL FAR ioctlsocket(SOCKET s, long cmd, u_long FAR *argp)
{
  FARPROC __ioctlsocket = ImportWinsockSymbol( "ioctlsocket" );
  if (__ioctlsocket)
    {
    #if defined(__WINDOWS_386__)
    return ((_Call16(__ioctlsocket, "wdp", s, cmd, argp )==0)?(0):(-1));
    #else
    return (*((int PASCAL FAR (*)(SOCKET, long, u_long FAR *))(__ioctlsocket)))
                                                          ( s, cmd, argp);
    #endif
    }
  return -1;
}  

/* ---------------------------------------- */

int PASCAL FAR WSAStartup(WORD wVerRequired, LPWSADATA lpWSAData)
{
  FARPROC __WSAStartup = ImportWinsockSymbol( "WSAStartup" );
  if (__WSAStartup)
    {
    #if defined(__WINDOWS_386__)
    lpWSAData->szSystemStatus[0]=0;
    int ec = 0xFFFF & (_Call16( __WSAStartup, "wp", wVerRequired, lpWSAData ));
    return ec;
    #else
    return (*((int PASCAL FAR (*)(WORD, LPWSADATA))(__WSAStartup)))
                                       (wVerRequired, lpWSAData);
    #endif
    }
  return -1;
}

/* ---------------------------------------- */

int PASCAL FAR WSACleanup(void)
{
  FARPROC __WSACleanup = ImportWinsockSymbol( "WSACleanup" );
  if (__WSACleanup)
    {
    #if defined(__WINDOWS_386__)
    return ((_Call16(__WSACleanup,"") == 0)?(0):(-1 /* SOCKET_ERROR */));
    #else
    return (*((int PASCAL FAR (*)(void))(__WSACleanup)))();
    #endif
    }
  return -1;
}

/* ---------------------------------------- */

static int __w32sockInitDeinit(int init_or_deinit )
{
  static int initlevel = 0;
  static HINSTANCE hinstWinsock = NULL;
  static HINSTANCE hinstwsl = NULL;

  if (init_or_deinit == 0)   /* getstate */
    {
    if (initlevel <= 0)
      return 0;
    return (GetModuleHandle("WINSOCK") != NULL);
    }
  else if (init_or_deinit < 0)   /* deinitialize */
    {
    if ((--initlevel)==0)
      {
      if (hinstWinsock)
        {
        WSACleanup();
        if (hinstwsl)
          FreeLibrary(hinstwsl);
        hinstwsl = NULL;
        FreeLibrary(hinstWinsock);
        hinstWinsock = NULL;
        }
      }
    }    
  else if (init_or_deinit > 0)   /* initialize */
    {
    if ((++initlevel)==1)
      {
      w32sockstatics.ipaddr = 0;
      hinstWinsock = __LoadLibrary("WINSOCK.DLL");
      if ((UINT) hinstWinsock > 32) 
        {
        hinstwsl = __LoadLibrary("WLIBSOCK.DLL");
        WSADATA wsaData;
        if ( WSAStartup( 0x101, &wsaData ) == 0 )
          {
          strcpy(w32sockstatics.desc, wsaData.szDescription);
          strcpy(w32sockstatics.status, wsaData.szSystemStatus);
          if (hinstwsl)
            {
            HMODULE wsl = GetModuleHandle("WLIBSOCK");
            if (wsl)
              {
              FARPROC fp = GetProcAddress(wsl, "getmyipaddr" );
              if (fp) 
                {
                w32sockstatics.ipaddr = (unsigned long)_Call16(fp,"");
                if (w32sockstatics.ipaddr == 0xFFFFFFFFUL)
                  w32sockstatics.ipaddr = 0;
                }
              }
            }
          return 1;
          }
        if (hinstwsl)
          FreeLibrary(hinstwsl);
        FreeLibrary(hinstWinsock);
        }
      hinstwsl = NULL;
      hinstWinsock = NULL;
      --initlevel;
      return 0;
      }
    }
  return 1;
}

int w32sockInitialize(void) { return __w32sockInitDeinit(+1); }
int w32sockDeinitialize(void) { return __w32sockInitDeinit(-1); }
int w32sockIsAlive(void) { return __w32sockInitDeinit(0); }

/* ---------------------------------------- */

#endif //no_winsock
