;
; Clearscreen for DOS:  void __clearscreen(void);
; Yes, its slow, but portable...
;     (ansi.sys, screen colors, graphics mode, pmode don't faze it).
; 
; Written May 29, 1998 Cyrus Patel <cyp@fb14.uni-mainz.de>
;

                 PUBLIC  __clearscreen
                 PUBLIC  _clearscreen       ; watcom asm prepends an extra '_'
_TEXT            SEGMENT 'CODE' BYTE PUBLIC USE32 'CODE'
                 ASSUME CS:_TEXT

_clearscreen:   
__clearscreen:  push bx                     ; save bx (for when in pmode)

                mov  ax,4400h               ; IOCTL: get device info
                mov  bx,1                   ; stdout
                int  21h                    ; ->dx=bits, bit 7 set if tty
                test dl,80h                 ; is it a character device?
                jz   __clearscreen9         ; exit if stdout is not the scrn

                mov  ah,0Fh                 ; get page/mode/maxcol
                int  10h                    ; ->ah=# of cols,al=mode,bh=page

                xor  dx,dx                  ; <-dh=row 0, dl=col 0
                mov  ah,02h                 ; set cursor pos
                int  10h                    ; <-dh=row, dl=col, bh=page#
                xor  cx,cx                  ; last cursor pos
                
__clearscreen1: mov  dl,' '                 ; char to write
                mov  ah,2                   ; write char function
                int  21h                    ; put ' ' at current cursor pos

                push cx                     ; save last col pos
                mov  ah,3                   ; get cursor size and pos
                int  10h                    ; -> cx=curs, dh=row, dl=col
                pop  cx                     ; restore last pos
                xchg dx,cx                  ; save new pos  

                or   cl,cl                  ; has the cursor wrapped?
                jnz  __clearscreen1         ; loop if not
                cmp  dh,ch                  ; is it on a new line?
                jnz  __clearscreen1         ; keep going if it is
                
                xor  dx,dx                  ; <-dh=row 0, dl=col 0
                mov  ah,02h                 ; set cursor pos
                int  10h                    ; <-dh=row, dl=col, bh=page#
                
__clearscreen9: pop  bx                     ; restore saved bx
                ret

_TEXT           ENDS
                END

