/*
 *  $Log: netware.h,v $
 *  Revision 1.1  1998/06/26 08:39:23  cyruspatel
 *  Modified netware.cpp to use new GetTimesliceBaseline() function. Added
 *  netware.h to repository.
 *
 *
 *
*/

#ifndef __CLINETWARE_H__
#define __CLINETWARE_H__
  #define PERCBAR_ON_ONE_LINE
  #include <sys/time.h>
  #include <process.h>
  #include <conio.h>     //ConsolePrintf()
  #include <direct.h>    //for chdir(), getcwd()
  #include <nwfile.h>    //ScanErasedFiles() PurgeErasedFile()
  #include <share.h>

  #include "client.h"
  extern "C" s32  x86cpuspeedtcs(void);  //in x86tcssp.asm

  //used in client.cpp
  extern int  CliIsNetworkAvailable(int dummy);
  extern int  CliSetThreadName( int threadID, int crunchernumber );
  extern int  CliClearThreadContextSpecifier( int threadID );
  extern int  CliGetNumberOfProcessors( void ); //also cliconfig.cpp
  extern int  CliMigrateThreadToSMP( void );
  extern int  CliRunProblemAsCallback( Problem *problem, int timeslice, int cpu_i, int niceness );
  extern int  CliWaitForThreadExit( int threadID );
  extern int  CliInitClient( int argc, char *argv[], void *client );
  extern int  CliValidateSinglePath( char *dest, unsigned int destsize,
                  char *defaultval, int defaultnoneifempty, char *source );
  extern int  CliSetScreenDestructionMode(int newmode);
  extern int  CliKickWatchdog(void);
  extern int  CliExitClient(void); //also used by signal handler/cliconfig.cpp

  //used in cliconfig.cpp
  extern int  CliValidateProcessorCount( int numcpu );
  extern int  CliIsClientRunning(void);
  extern void CliThreadSwitchLowPriority(void);
  extern void CliThreadSwitchWithDelay(void);
  extern int  CliGetSystemConsoleScreen(void);
  extern unsigned int CliGetCurrentTicks(void); //also used in clitime.cpp
  extern int  CliActivateConsoleScreen(void);
  extern void CliConsolePrintf(char *fmt,...);
  extern void CliForceClientShutdown(void);

  //used in clitime.cpp
  extern unsigned int CliConvertTicksToSeconds( unsigned int ticks, unsigned int *secs, unsigned int *hsecs );
  extern unsigned int CliConvertSecondsToTicks( unsigned int secs, unsigned int hsecs, unsigned int *ticks );

  //symbol redefinitions
  int CliGetHostName(char *, unsigned int);  //used in mail.cpp
  long my_inet_addr( char *hostname ); //(in hbyname.cpp) used in network.cpp
  extern int sizonly_stat( const char *fn, struct stat *statblk ); //buffwork.cpp
  extern int purged_unlink( const char *filename ); //buffwork.cpp

  #ifdef gethostname // emulated function in hbyname.cpp
  #undef gethostname
  #endif
  #ifdef inet_addr // emulated function in hbyname.cpp
  #undef inet_addr
  #endif
  #ifdef stat // stat and fstat have problems on nw 3.x
  #undef stat
  #endif
  #ifdef unlink  //purging unlink
  #undef unlink
  #endif

  #define inet_addr(p)           my_inet_addr(p)
  #define gethostname(b,s)       CliGetHostName(b,s)
  #define stat( _fn, _statblk )  sizonly_stat( _fn, _statblk )
  #define unlink( _fn )          purged_unlink( _fn )

#endif //__CLINETWARE_H__
