#include <stdio.h>
#if defined(__WIN32__)
  #include <winsock.h>
#elif defined(__OS2__)
  #include <types.h>
  #include <utils.h>
  #include <netinet/in.h>
#endif
#include <io.h>         /* For access() */

#define BUFFIN    "buff-in.rc5"
#define BUFFOUT   "buff-out.rc5"
#define READACCESS   04

/*
	Checks the block for *filename
	Returns the number of key blocks in file. 0 if no file found.
*/
int bcheck(char *filename)
	{
   FILE *fp;
	int ret;
	unsigned long count;

	ret = access(filename, READACCESS);
	if (ret)
		return 0;

	fp = fopen(filename, "r+b");
   fseek(fp, sizeof(unsigned long), SEEK_SET);
	fread(&count, sizeof(unsigned long), 1, fp);
	fclose(fp);

	return ntohl(count);
	}

int main(int argc, char **argv)
	{
	int num;
	
	printf("\nBlock Check v1.00 - Reports how many blocks are in a key buffer\n"
			 "(c) Copyright 1997 Oscar Chang <oscarc@divideby0.com> All Rights Reserved\n");

	if(argc == 1)  /* no arguments */
		{
		printf("\nbuff-in.rc5  = %d key blocks\n", bcheck(BUFFIN));
		printf("buff-out.rc5 = %d key blocks\n", bcheck(BUFFOUT));
		}
	else
		{
      num = bcheck(argv[1]);
		printf("\n%s = %d key blocks\n", argv[1], num);
		return num;
		}

	return 0;
	}
