#!/usr/local/bin/wishx -f

# $Id: rc5desgui.tcl,v 1.6 1999/01/01 02:45:18 cramer Exp $


# Configuration
global clientcmd optionsrun optionsconfig
set clientcmd "./rc5des"
set optionsrun "-run"
set optionsconfig "-config"


# Start out idle
global isrunning
set isrunning 0


# Version information
set title "Distributed.Net UNIX GUI Client"
set client "RC5DES+GUI"
set version "1.01"


# Define the list of menu items that will be added
set fileoptions {Start Stop Path Preferences Exit}
set viewoptions {BlockInfo}
set networkoptions {Flush Fetch Update}
set helpoptions {About}


# Create the main layout
wm title . "$title -- Idle"
frame .mbar -relief raised -bd 2
pack .mbar -side top -fill x
scrollbar .scroll -relief flat -command ".textbox yview"
pack .scroll -side right -fill y
text .textbox -relief raised -bd 2 -yscrollcommand ".scroll set" -setgrid true
.textbox tag configure bold -font *-Courier-*-Normal-*-120-*
pack .textbox -side left -fill both -expand 1


# Initialize the menubar
menubutton .mbar.file -text "File" -menu .mbar.file.menu
menubutton .mbar.view -text "View" -menu .mbar.view.menu
menubutton .mbar.network -text "Network" -menu .mbar.network.menu
menubutton .mbar.help -text "Help" -menu .mbar.help.menu
pack .mbar.file .mbar.view .mbar.network .mbar.help -side left
menu .mbar.file.menu 
menu .mbar.view.menu
menu .mbar.network.menu
menu .mbar.help.menu


# Shove some text into the textbox
.textbox insert end "$client $version client - a project of distributed.net\n"
.textbox insert end "Copyright distributed.net 1997-1999\n"
.textbox insert end "DES Search routines Copyright Svend Olaf Mikkelsen\n"
.textbox insert end "Visit http://www.distributed.net/ for more information.\n"


# Add all of the items to the various menus
foreach file $fileoptions {
    .mbar.file.menu add command \
	-label $file \
	-command "command.$file"
}
foreach view $viewoptions {
    .mbar.view.menu add command \
	-label $view \
	-command "command.$view"
}
foreach network $networkoptions {
    .mbar.network.menu add command \
	-label $network \
	-command "command.$network"
}
foreach help $helpoptions {
    .mbar.help.menu add command \
	-label $help \
	-command "command.$help"
}
tk_menuBar .mbar .mbar.file .mbar.view .mbar.network .mbar.help
focus .mbar




# Event handlers for the various menu items

proc "command.Start" {} {
    global optionsrun
    StartClient $optionsrun
}

proc "command.Stop" {} {
    StopClient
}

proc "command.Preferences" {} {
    # Preferences will simply run the cli's built in configuration, rather
    # than trying to replicate its functionality, since it will like be
    # difficult to keep this version up to date with the client.
    global isrunning optionsconfig optionsrun
    if {$isrunning != 0} {
        StopClient
        StartClient $optionsconfig
        WaitClient
        StartClient $optionsrun
    } else {
        StartClient $optionsconfig
    }
}

proc "command.Exit" {} {
    StopClient
    exit 0
}

proc "command.About" {} {
    dialog .d {About this application} {This is just a simple Tcl/Tk GUI frontend for the distributed.net distributed computing client.  Please see http://www.distributed.net/ } {} -1 OK
}




# Functions to control the child process

proc StartClient {options} {
    global childclient isrunning clientcmd title
    if {$isrunning == 0} {
        #set childclient [open {|$clientcmt $options} r+]
        #pid $childclient
        #flush $childclient
        #gets $childclient varname

        wm title . "$title -- Running"
        set isrunning 1
    }
}

proc StopClient {} {
    global childclient isrunning title
    if {$isrunning != 0} {
        wm title . "$title -- Halting"
        # send kill to process
        WaitClient
        wm title . "$title -- Idle"
    }
}

proc WaitClient {} {
    global childclient isrunning
    # wait for process to die
    set isrunning 0
}



# Convenient function for generating message boxes

proc dialog {w title text bitmap default args} {
    global button

    # 1. Create the top-level window and divide it

    toplevel $w -class Dialog
    wm title $w $title
    wm iconname $w Dialog
    frame $w.top -relief raised -bd 1
    pack $w.top -side top -fill both
    frame $w.bot -relief raised -bd 1
    pack $w.bot -side bottom -fill both

    # 2. Fill the top part with the bitmap and message.

    message $w.top.msg -width 3i -text $text \
	-font *-Times-*-Normal-*-180-*
    pack $w.top.msg -side right -expand 1 -fill both -padx 3m -pady 3m
    if {$bitmap != ""} {
	label $w.top.bitmap -bitmap $bitmap
	pack $w.top.bitmap -side left -padx 3m -pady 3m
    }

    # 3. Create a row of buttons at the bottom of the dialog

    set i 0
    foreach bit $args {
	button $w.bot.button$i -text $bit -command "set button $i"
	if {$i == $default} {
	    frame $w.bot.default -relief sunken -bd 1
	    raise $w.bot.button$i
	    pack $w.bot.default -side left -expand 1 -padx 3m -pady 2m
	    pack $w.bot.button$i -in $w.bot.default -side left \
		-padx 2m -pady 2m -ipadx 2m -ipady 1m
	} else {
	    pack $w.bot.button$i -side left -expand 1 \
		-padx 3m -pady 3m -ipadx 2m -ipady 1m
	}
	incr i
    }
}
