// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: DrawGUI.h,v $
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:14:25  dicamillo
// First Checked In.
//

#pragma once

#include <Appearance.h>


typedef struct
{
	RectPtr			inRect;
	ThemeDrawState	inState;
	
	void			*data;
	
} PrimitiveDrawingData, *PrimitiveDrawingDataPtr, **PrimitiveDrawingDataHndl;


typedef struct
{
	Boolean			useText;
	
	StringPtr		text;
	ControlHandle	control;
	
} GroupBoxData, *GroupBoxDataPtr, **GroupBoxDataHndl;


typedef struct
{
	short	amountFull;
	short	total;
	
	Boolean	drawInsidesOnly;
	
} BufferProgressData, *BufferProgressPtr, **BufferProgressHndl;


//Note - all these strings are pascal style.  The toolbox works with pascal, so that's what I do
//If you want to use C style, just replace it, and I'll fix the code.
#define kNumBufferedProjects		2 //I suppose this is going to be a constant - for now.
#define kMaxNumThreads				16//You said this is already defined somewhere.  This is temperary then.

typedef struct
{
	short	numBlocks;
	short	totalBlocks;
	Boolean changingRightNow;
	
} BufferInfo, *BufferInfoPtr, **BufferInfoHndl;

typedef struct
{
	BufferInfo	inputBuffer;
	
	BufferInfo	outputBuffer;
	
} BufferedProjectInfo, *BufferedProjectInfoPtr, **BufferedProjectInfoHndl;


enum {
	kRC5ProjectType = 0,
	kDESProjectType
};

typedef struct
{
	short			projectType;
	
	unsigned long long	blockKeysChecked; //This now stores the total keys checked within the current block
	
	double			totalMillionKeysChecked;	// Total for thread for session

	short			progressPercent;
	
	Boolean			inUse;					// true if included in thread count- for client
	
} ThreadInfo, *ThreadInfoPtr, **ThreadInfoHndl;


typedef struct
{
	BufferedProjectInfo		buffersInfo[kNumBufferedProjects];
	
	short					numThreads;
	ThreadInfo				threadsInfo[kMaxNumThreads];
	
	Boolean					hasServerMessageChanged;
	char					lastServerMessage[256]; //zero length if no message.
	
} ClientInfo, *ClientInfoPtr, **ClientInfoHndl;


typedef struct
{
	//appearance value only
	ControlHandle	progressBar;
	
	Boolean			updateAnyInfo;
	
	Boolean			updateProjectNameString;
	Boolean			updateTotalRateString;
	
	//non-appearance flag only
	Boolean			updateProgressBar;
	
	long			lastRate;
	unsigned long	lastCheckRateTicks;
	
} PrivateThreadInfo, *PrivateThreadInfoPtr, **PrivateThreadInfoHndl;

void InitializeMainWindow(void);
void DefineMainWindow(WindowPtr theWindow);
void UpdateMainWindow(void);
//void ClickMainWindow(Point localMouse);
ControlHandle ClickMainWindow(Point localMouse);
void ActivateMainWindow(Boolean activating);
void InitializeMainWindowInfo(ClientInfoPtr newInfo,  short threadnum, Boolean update);
void UpdateMainWindowInfo(ClientInfoPtr newInfo);

Boolean IsMainWindow(WindowPtr window);

#define kBaseWindowHeight		150

#define kThreadRectLeft			20
#define kThreadRectRight		331
#define kFirstThreadRectTop		114
#define kThreadRectHeight		43
void GetThreadRect(short threadID, RectPtr rect);
void RemoveGUIThread(short thread);
void CreateGUIThread(short threadID);
void UpdateThreadNumTypeDisplay(short threadID, RectPtr textRect);
void UpdateTotalRateDisplay(short threadID, RectPtr textRect);
void TotalKeysToString(double d_keys, StringPtr theString);
short SetWindowCorrectSize(Rect *updateRect);
void ChangeWindowHeight(short newHeight, Rect *updateRect);
void UpdateNumBlocksDisplay(BufferInfoPtr bufferInfo, RectPtr rect, Boolean input);
void CheckForBufferChanges(BufferInfoPtr oldBufferInfo, BufferInfoPtr newBufferInfo, Boolean input);
void SetFlushFetchControlsHilite(BufferInfoPtr newBufferInfo, Boolean input);
pascal void UpdateMainWindowInfoOnlyLoop(SInt16 depth, SInt16 flags, GDHandle device, long refCon);
void UpdateMainWindowInfoOnly(void);
void SetCurrentBuffersContest(short contest);

void SetGray(short gray);
void MyDrawThemePlacard(Rect *inRect, ThemeDrawState inState);
void CallPrimitiveDrawProc(RectPtr inRect, ThemeDrawState inState, void *extraData, DeviceLoopDrawingUPP proc);
void MyTextBox(StringPtr theString, RectPtr theRect, short justMode);
void MyResTextBox(short strID, short strIndex, RectPtr theRect, short justMode);
void MyTextPtrBox(Ptr string, short len, RectPtr theRect, short justMode);
short CalcTextBaseLineOffset(RectPtr theRect);
void SetAppropriateTextColor(GDHandle device, short depth, SInt16 flags, Boolean activated);
void SetAppropriateColor(GDHandle device, short red, short green, short blue, Boolean activated);
pascal void UpdateMainWindowLoop(SInt16 depth, SInt16 flags, GDHandle device, long refCon);

void DrawBufferProgress(RectPtr rect, Boolean drawInsidesOnly, short amountFull, short total);
void DrawProgressBar(RectPtr rect, Boolean drawInsidesOnly, short amountFull, short total, short depth);

pascal void DrawThemePrimaryGroupLoop(SInt16 depth, SInt16 flags, GDHandle device, PrimitiveDrawingDataPtr drawingInfo);
pascal void DrawBufferProgressLoop(SInt16 depth, SInt16 flags, GDHandle device, PrimitiveDrawingDataPtr drawingInfo);
pascal void DrawThemeEditTextFrameLoop(SInt16 depth, SInt16 flags, GDHandle device, PrimitiveDrawingDataPtr drawingInfo);
pascal void DrawThemePlacardLoop(SInt16 depth, SInt16 flags, GDHandle device, PrimitiveDrawingDataPtr drawingInfo);


enum {
	kMiscStringsID = 128,
	kStatusString = 1,
	kInputString,
	kOutputString,
	kOutOfString,
	kFlushString,
	kFetchString,
	kNotAvailableString,
	kCheckingKeyBlockString,
	kThreadString,
	kRC5String,
	kDESString,
	kMillionKeysCheckedString,
	kKKeysSecString
};

#define kBackgroundBufferPatID		128
#define kProgressBufferPatID		129
#define kAddForDisabled				2
#define kPixelsToCutOffFromLeft		1
#define kPixelsForEachValue			3

#define kServerMessageHeight		15
