// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: PointerList.cpp,v $
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:15:30  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *PointerList_cpp(void) {
return "@(#)$Id: PointerList.cpp,v 1.2 1999/01/01 02:45:17 cramer Exp $"; }
#endif

#include "PointerList.h"
#include "Memory.h"
#include "Errors.h"

PointerList::PointerList(void)
{
// initialize variables
record_count = 0;
head_pointer = (PointerListPtr)0;
next_pointer = (PointerListPtr)0;
}


PointerList::~PointerList(void)
{
DeleteAllPointers();
}

void * PointerList::GetFirstPointer(void)
{
if (head_pointer == 0) {
	next_pointer = 0;
	return((void *)0);
	}
else {
	next_pointer = (PointerListPtr)(head_pointer->next);
	return((void *)(head_pointer->thePointer));
	}
}

void * PointerList::GetNextPointer(void)
{
void *result;

if (next_pointer == 0) {
	return((void *)0);
	}
else {
	result = (void *)(next_pointer->thePointer);
	next_pointer = (PointerListPtr)(next_pointer->next);
	return(result);
	}
}

OSErr PointerList::AddPointer(void *thePointer)
{
PointerListPtr np, rp;

// allocate new record
np = (PointerListPtr)NewPtr((Size)sizeof(PointerListRec));
if (np == 0) {
	return(memFullErr);
	}

// increment count
record_count++;

// define fields
np->next = 0;					// will go at end of list
np->thePointer = thePointer;

// add to linked list
if (head_pointer == 0) {
	head_pointer = np;
	}
else {
	rp = head_pointer;
	while (rp != 0) {
		if (rp->next == 0) {
			rp->next = np;
			break;
			}
		rp = (PointerListPtr)(rp->next);
		}
	}

// make available for GetNextPointer
if (next_pointer == 0) {
	next_pointer = np;
	}

return(noErr);
}

Boolean PointerList::DeletePointer(void *thePointer)
{
PointerListPtr dp, rp;

// find the record containing thePointer, then set dp to point to it
// and remove it from the linked list
// return true if the deletion succeeded; otherwise return false

if (head_pointer == 0) return(false);

if (head_pointer->thePointer == thePointer) {
	dp = head_pointer;
	head_pointer = (PointerListPtr)dp->next;
	}
else {
		// rp points to the record to modify
		// dp points to the record to delete
	rp = head_pointer;
	dp = 0;
	while (rp != 0) {
		if (rp->next == 0) break;
		if (((PointerListPtr)(rp->next))->thePointer == thePointer) {
			dp = (PointerListPtr)(rp->next);
			rp->next = dp->next;
			break;			
			}
		rp = (PointerListPtr)(rp->next);
		}
	}

// return if no match
if (dp == 0) return(false);

// decrement count
record_count--;

// adjust GetNextPointer result
if (next_pointer == dp) {
	next_pointer = (PointerListPtr)(dp->next);
	}

// free storage
DisposePtr((Ptr)dp);

return(true);
}

void PointerList::DeleteAllPointers(void)
{
PointerListPtr np, dp;

if (head_pointer != 0) {
	// np = "next" from last deleted record
	np = (PointerListPtr)(head_pointer->next);
	while (np != 0) {
		dp = np;
		np = (PointerListPtr)(np->next);
		DisposePtr((Ptr)dp);
		}
	}

record_count = 0;
head_pointer = (PointerListPtr)0;
next_pointer = (PointerListPtr)0;
}

short PointerList::CountPointers(void)
{
return(record_count);
}

