// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: PointerList.h,v $
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:15:37  dicamillo
// First Checked In.
//

#include "Types.h"

// Definitions for pointer list object

// data structure definitions

struct PointerListRec {
	void *next;				// pointer to next record (or 0)
	void *thePointer;		// stored pointer
	};
typedef struct PointerListRec PointerListRec;
typedef struct PointerListRec *PointerListPtr;

// global variables and methods

class PointerList {

public:
	// public variables

protected:
	// protected variables
	short record_count;				// how many records we have stored
	PointerListPtr head_pointer;	// pointer to first list record
	PointerListPtr next_pointer;	// pointer to next record to return
	
public:
	// public methods
	PointerList(void);
	virtual ~PointerList(void);
	virtual void *GetFirstPointer(void);
	virtual void *GetNextPointer(void);
	virtual OSErr AddPointer(void *thePointer);
	virtual Boolean DeletePointer(void *thePointer);
	virtual void DeleteAllPointers(void);
	virtual short CountPointers(void);

protected:
	// protected methods
};
