// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: RC5Dialogs.cpp,v $
// Revision 1.12.2.2  1999/07/11 00:29:47  sampo
// simplify general config panel, add ability to set in and out buffers to different sizes.
//
// Revision 1.12.2.1  1999/05/18 03:28:20  sampo
// large block support added to mac configuration
//
// Revision 1.12  1999/04/29 05:59:09  dicamillo
// Add code to replace deleted routine to test for a blank string.
//
// Revision 1.11  1999/03/22 05:53:10  dicamillo
// Update to support client_loadorder instead of preferred_contest
//
// Revision 1.10  1999/01/17 18:23:39  sampo
// 3rd round fba changes
//
// Revision 1.9  1999/01/13 03:21:02  dicamillo
// Use MAXBLOCKSBUFFER constant for validating buffer size.
//
// Revision 1.8  1999/01/10 05:59:16  dicamillo
// Settings changes to match current common code.
//
// Revision 1.7  1999/01/08 03:21:40  dicamillo
// "Use MP Support" is off by default; issue warning on true MP machines.
//
// Revision 1.6  1999/01/06 07:30:30  dicamillo
// Default keyport changed from 2064 to 0.
//
// Revision 1.5  1999/01/06 06:17:27  dicamillo
// Update for one checkpoint file for all contests.
//
// Revision 1.4  1999/01/02 22:48:02  dicamillo
// Fix network settings bug due to handling of default proxy name.
//
// Revision 1.3  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.2  1998/12/31 08:23:25  dicamillo
// New setting "use_MP" replaces "all_fonts" in MacOS settings.
//
// Revision 1.1  1998/12/15 06:16:19  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *RC5Dialogs_cpp(void) {
return "@(#)$Id: RC5Dialogs.cpp,v 1.12.2.2 1999/07/11 00:29:47 sampo Exp $"; }
#endif

#include "macdefs.h"
#include <MP.h>
#include "WASTE.h"
#include "resdefs.h"
#include "apputils.h"
#include "window_info.h"
#include "DrawGUI.h"
#include <Icons.h>

#include "PointerList.h"
#include "ViewObject.h"
#include "GUIView.h"
#include "WTextView.h"
#include "TextRscView.h"
#include "WindowObject.h"
#include "AppObject.h"
#include "ViewWindow.h"
#include "GUIWindow.h"
#include "WTextDisplayWindow.h"
#include "TextRscWindow.h"
#include "client.h"
#include "Mac_Client.h"
#include "RC5Dialogs.h"
#include "settings.h"
#include "my_settings.h"
#include "RC5App.h"
#include "cpucheck.h"
#include "confopt.h"
#include "stat.mac.h"
#include "mac_extras.h"

#ifdef powerc
RoutineDescriptor configiconprocRD =
	BUILD_ROUTINE_DESCRIPTOR(uppUserItemProcInfo, configiconproc);
RoutineDescriptor passDlgFilterRD =
	BUILD_ROUTINE_DESCRIPTOR(uppModalFilterProcInfo, passDlgFilter);
#endif

extern RC5App *theApp;
extern Boolean haveMP;

char passtext[64];

Boolean configIconSelected, app_colormac, app_sweeticons;
extern Boolean useCPUdialog;

#ifdef MAC_GUI
void RC5App::ConfigureDialog(dialog_settings *default_settings,
							 dialog_settings *new_settings,
							 settings_list *ds,
							 settings_list *ns)
{
DialogPtr dlgptr;
short itemHit;
short gtype;
Handle gitem;
Rect gbox;
char temp_id[256];
Boolean showOK;
WindowPtr front_window;

waitcursor = ibeamcursor = false;
mySetCursor(kArrowCursor);

app_colormac = colormac;
app_sweeticons = sweeticons;

front_window = FrontWindow();
dlgptr = GetNewDialog(kConfigureDialog, 0, (WindowPtr)-1);
ctrwindow(dlgptr, kCenterHigh, 20, 0, 0);

/* define routine to draw user items */
GetDialogItem(dlgptr, kConfigIconGeneralItem, &gtype, &gitem, &gbox);
#ifdef powerc
SetDialogItem(dlgptr, kConfigIconGeneralItem, gtype, (Handle)&configiconprocRD, &gbox);
#else
SetDialogItem(dlgptr, kConfigIconGeneralItem, gtype, (Handle)configiconproc, &gbox);
#endif

GetDialogItem(dlgptr, kConfigIconFileItem, &gtype, &gitem, &gbox);
#ifdef powerc
SetDialogItem(dlgptr, kConfigIconFileItem, gtype, (Handle)&configiconprocRD, &gbox);
#else
SetDialogItem(dlgptr, kConfigIconFileItem, gtype, (Handle)configiconproc, &gbox);
#endif

GetDialogItem(dlgptr, kConfigIconCPUItem, &gtype, &gitem, &gbox);
#ifdef powerc
SetDialogItem(dlgptr, kConfigIconCPUItem, gtype, (Handle)&configiconprocRD, &gbox);
#else
SetDialogItem(dlgptr, kConfigIconCPUItem, gtype, (Handle)configiconproc, &gbox);
#endif

GetDialogItem(dlgptr, kConfigIconNetworkItem, &gtype, &gitem, &gbox);
#ifdef powerc
SetDialogItem(dlgptr, kConfigIconNetworkItem, gtype, (Handle)&configiconprocRD, &gbox);
#else
SetDialogItem(dlgptr, kConfigIconNetworkItem, gtype, (Handle)configiconproc, &gbox);
#endif

GetDialogItem(dlgptr, kConfigIconMacOSItem, &gtype, &gitem, &gbox);
#ifdef powerc
SetDialogItem(dlgptr, kConfigIconMacOSItem, gtype, (Handle)&configiconprocRD, &gbox);
#else
SetDialogItem(dlgptr, kConfigIconMacOSItem, gtype, (Handle)configiconproc, &gbox);
#endif
configIconSelected = false;

/* show current values of items */
setemail(dlgptr, new_settings->id);

/* select host name text */
SelectDialogItemText(dlgptr, kConfigEMailTextItem, 0, 32767);

/* export scrap for TextEdit */
if (theWTextDisplayWindow != 0) {
	theWTextDisplayWindow->export_scrap();
	}

ShowWindow(dlgptr);
deactivate_controls(front_window);

/* disable OK if no email */
showOK = true;
newemail(dlgptr, new_settings->id, &showOK, true);		/* calls framedflt */
														/* must follow ShowWindow */
  
/* loop to process changes */
 
config_dlgptr = dlgptr;
while (true) {
#ifdef powerc
	ModalDialog(&DlgFilter2RD, &itemHit);
#else
	ModalDialog(DlgFilter2, &itemHit);
#endif
	switch(itemHit) {
		case kConfigOKItem:						/* OK */
				GetDialogItem(dlgptr, kConfigEMailTextItem, &gtype, &gitem, &gbox);
				GetDialogItemText(gitem, (unsigned char *)(new_settings->id));
				p2cstr((unsigned char *)(new_settings->id));
				break;
		case kConfigEMailTextItem:
				GetDialogItem(dlgptr, kConfigEMailTextItem, &gtype, &gitem, &gbox);
				GetDialogItemText(gitem, (unsigned char *)temp_id);
				p2cstr((unsigned char *)temp_id);
				newemail(dlgptr, temp_id, &showOK, false);
				break;
		case kConfigIconGeneralItem:
				if (!trackConfigIcon(dlgptr, itemHit))
					break;
				GeneralDialog(default_settings, new_settings);
				if (theWTextDisplayWindow != 0) {
					theWTextDisplayWindow->draw_window();
					}
				if (theHelpWindow != 0) {
					theHelpWindow->draw_window();
					}
				if (theGUIWindow != 0) {
					theGUIWindow->draw_window_update();
					}
				framedflt(dlgptr, colormac);
				break;
		case kConfigIconFileItem:
				if (!trackConfigIcon(dlgptr, itemHit))
					break;
				FilesDialog(default_settings, new_settings);
				if (theWTextDisplayWindow != 0) {
					theWTextDisplayWindow->draw_window();
					}
				if (theHelpWindow != 0) {
					theHelpWindow->draw_window();
					}
				if (theGUIWindow != 0) {
					theGUIWindow->draw_window_update();
					}
				framedflt(dlgptr, colormac);
				break;
		case kConfigIconCPUItem:
				if (!useCPUdialog) break;
				if (!trackConfigIcon(dlgptr, itemHit))
					break;
				CPUDialog(default_settings, new_settings);
				if (theWTextDisplayWindow != 0) {
					theWTextDisplayWindow->draw_window();
					}
				if (theHelpWindow != 0) {
					theHelpWindow->draw_window();
					}
				if (theGUIWindow != 0) {
					theGUIWindow->draw_window_update();
					}
				framedflt(dlgptr, colormac);
				break;
		case kConfigIconNetworkItem:
				if (!trackConfigIcon(dlgptr, itemHit))
					break;
				NetworkDialog(default_settings, new_settings);
				if (theWTextDisplayWindow != 0) {
					theWTextDisplayWindow->draw_window();
					}
				if (theHelpWindow != 0) {
					theHelpWindow->draw_window();
					}
				if (theGUIWindow != 0) {
					theGUIWindow->draw_window_update();
					}
				framedflt(dlgptr, colormac);
				break;
		case kConfigIconMacOSItem:
				if (!trackConfigIcon(dlgptr, itemHit))
					break;
				MacOSDialog(dlgptr, ds, ns);
				if (theWTextDisplayWindow != 0) {
					theWTextDisplayWindow->draw_window();
					}
				if (theHelpWindow != 0) {
					theHelpWindow->draw_window();
					}
				if (theGUIWindow != 0) {
					theGUIWindow->draw_window_update();
					}
				framedflt(dlgptr, colormac);
				break;
		default:
				break;
		}
	if ((itemHit == kConfigOKItem) || (itemHit == kConfigCancelItem)) break;
	}

config_dlgptr = 0;
DisposeDialog(dlgptr);
}
#endif

Boolean RC5App::trackConfigIcon(WindowPtr dlgptr, short itemHit)
{
GrafPtr gp;
short gtype;
Handle gitem;
Rect itemrect;
Boolean newselected;
Point mouseloc;

GetPort(&gp);
SetPort(dlgptr);
configIconSelected = true; 
configiconproc(dlgptr, itemHit);
GetDialogItem(dlgptr, itemHit, &gtype, &gitem, &itemrect);
while (StillDown()) {
	GetMouse(&mouseloc);
	newselected = PtInRect(mouseloc, &itemrect);
	if (newselected != configIconSelected) {
		configIconSelected = newselected;
		configiconproc(dlgptr, itemHit);
		}
	}
if (configIconSelected) {
	configIconSelected = false;
	configiconproc(dlgptr, itemHit);
	}
SetPort(gp);
return(newselected);
}

void RC5App::newemail(DialogPtr dlgptr, char *email,
					  Boolean *showOK, Boolean doframe)
{
short gtype;
Handle gitem;
Rect gbox;
Boolean didframe;

didframe = false;
				
if (strlen(email) == 0) {
	if (*showOK) {
		*showOK = 0;
		GetDialogItem(dlgptr, kConfigOKItem, &gtype, &gitem, &gbox);
		HiliteControl((ControlHandle)gitem, 255);
		framedflt(dlgptr, colormac);
		didframe = true;
		}
	}
else {
	if (!(*showOK)) {
		*showOK = 1;
		GetDialogItem(dlgptr, kConfigOKItem, &gtype, &gitem, &gbox);
		HiliteControl((ControlHandle)gitem, 0);
		framedflt(dlgptr, colormac);
		didframe = true;
		}
	}

if (doframe) {
	if (!didframe) framedflt(dlgptr, colormac);
	}
}

void RC5App::setemail(DialogPtr dlgptr, char *email)
{
short gtype;
Handle gitem;
Rect gbox;
 
if (email != 0) {
	GetDialogItem(dlgptr, kConfigEMailTextItem, &gtype, &gitem, &gbox);
	settext(gitem, email);
	}
}
 
pascal void configiconproc(WindowPtr dlgwindow, short item)
{
GrafPtr gp;
Rect myrect, iconrect, textrect;
short dtype;
Handle ditem;
short dlgfont, dlgmode, dlgsize;
Style dlgface;
short width1, width2, widthadj1, widthadj2;
short iconresnum, strnum1, strnum2;
Str255 str1, str2;
char colorok, disableflag;
PenState savedstate;
RGBColor rgbsave;
short plottype;
RGBColor RGBGray = {0x8000, 0x8000, 0x8000};
SInt16 inDepth;
Boolean inIsColorDevice;

GetDialogItem(dlgwindow, item, &dtype, &ditem, &myrect);
GetPort(&gp);
SetPort(dlgwindow);
GetForeColor(&rgbsave);

/* define icon rectangle */
iconrect.top = myrect.top + 2;
iconrect.bottom = iconrect.top + 32;
iconrect.left = myrect.left + (myrect.right - myrect.left - 32)/2;
iconrect.right = iconrect.left + 32;

/* define icon and strings */
switch (item) {
	case kConfigIconGeneralItem:
			iconresnum = kRC5Icon;
			strnum1 = kIconGeneralLabel1;
			strnum2 = kIconGeneralLabel2;
			disableflag = 0;
			break;
	case kConfigIconFileItem:
			iconresnum = kFileIcon;
			strnum1 = kIconFileLabel1;
			strnum2 = kIconFileLabel2;
			disableflag = 0;
			break;
	case kConfigIconCPUItem:
			iconresnum = kCPUIcon;
			strnum1 = kIconCPULabel1;
			strnum2 = kIconCPULabel2;
			disableflag = !useCPUdialog;
			break;
	case kConfigIconNetworkItem:
			iconresnum = kNetworkIcon;
			strnum1 = kIconNetworkLabel1;
			strnum2 = kIconNetworkLabel2;
			disableflag = 0;
			break;
	case kConfigIconMacOSItem:
			iconresnum = kMacOSIcon;
			strnum1 = kIconMacOSLabel1;
			strnum2 = kIconMacOSLabel2;
			disableflag = 0;
			break;
	default:
			iconresnum = 0;
			strnum1 = 0;
			strnum2 = 0;
			disableflag = 0;
	}
	
if (iconresnum == 0) {			/* shouldn't happen */
	SetPort(gp);
	return;
	}

/* define strings */
/* (numbers should be ok, since icon was ok) */
GetIndString(str1, kIconLabelsNum, strnum1);
GetIndString(str2, kIconLabelsNum, strnum2);

/* determine if we can use color for drawing */
colorok = colordialog(dlgwindow, app_colormac);

/* erase the full rectangle */
EraseRect(&myrect);

/* draw the icons */
if (disableflag) {
	plottype = kTransformDisabled;
	}
else {
	if (configIconSelected) {
		plottype = kTransformSelected;
		}
	else {
		plottype = kTransformNone;
		}
	}
if (app_sweeticons) {
	PlotIconID(&iconrect, atNone, plottype, iconresnum);
	}
else {
	myPlotIconID(&iconrect, kAlignNone, plottype, iconresnum, app_colormac);
	}

/* set color for text */
if (disableflag) {
	if (theApp->haveAppearance && colorok) {
		get_port_color_info(theApp->colormac, &inDepth, &inIsColorDevice);
		SetThemeTextColor(kThemeInactiveDialogTextColor, inDepth,
					  	inIsColorDevice);
		}
	else if (colorok) {
		RGBForeColor(&RGBGray);
		}
	else {
		GetPenState(&savedstate);
		PenPat(&qd.gray);
		}
	}
else {
	if (theApp->haveAppearance) {
		get_port_color_info(theApp->colormac, &inDepth, &inIsColorDevice);
		SetThemeTextColor(kThemeActiveDialogTextColor, inDepth,
						  inIsColorDevice);
		}
	}
	
/* draw the lines of text */
dlgfont = dlgwindow->txFont;
dlgface = dlgwindow->txFace;
dlgmode = dlgwindow->txMode;
dlgsize = dlgwindow->txSize;

TextFont(3);
TextFace(0);
TextMode(srcOr);
TextSize(9);

width1 = StringWidth(str1);
if (width1 > 0) {
	widthadj1= (myrect.right - myrect.left - width1)/2;
	MoveTo(myrect.left + widthadj1, iconrect.bottom + 12);
	DrawString(str1);
	}
width2 = StringWidth(str2);
if (width2 > 0) {
	widthadj2 = (myrect.right - myrect.left - width2)/2;
	MoveTo(myrect.left + widthadj2, iconrect.bottom + 24);
	DrawString(str2);
	}

TextFont(dlgfont);
TextFace(dlgface);
TextMode(dlgmode);
TextSize(dlgsize);

if (configIconSelected) {
	if (width1 > 0) {
		textrect.top = iconrect.bottom + 3;
		textrect.bottom = textrect.top + 12;
		textrect.left = myrect.left + widthadj1 - 2;
		if (textrect.left < myrect.left) textrect.left = myrect.left;
		textrect.right = myrect.right - widthadj1 + 1;
		if (textrect.right > myrect.right) textrect.right = myrect.right;
		InvertRect(&textrect);
		}
	if (width2 > 0) {
		textrect.top = iconrect.bottom + 15;
		textrect.bottom = textrect.top + 12;
		textrect.left = myrect.left + widthadj2 - 2;
		if (textrect.left < myrect.left) textrect.left = myrect.left;
		textrect.right = myrect.right - widthadj2 + 1;
		if (textrect.right > myrect.right) textrect.right = myrect.right;
		InvertRect(&textrect);
		}
	}

/* finish with disabled item */
if (disableflag && (!colorok)) {
	PenMode(notPatBic);
	textrect.top = iconrect.bottom + 3;
	textrect.bottom = textrect.top + 24;
	textrect.left = myrect.left;
	textrect.right = myrect.right;
	PaintRect(&textrect);
	SetPenState(&savedstate);
	}

/* retore enviornment and return */
RGBForeColor(&rgbsave);
SetPort(gp);
}

void RC5App::GeneralDialog(dialog_settings *default_settings,
						   dialog_settings *new_settings)
{
DialogPtr dlgptr;
short itemHit, oldHit;
short gtype, i;
Handle gitem;
Rect gbox;
long r;
double d;
char s[256];
short d_preferred_blocksize;
char d_loadorder_map[CONTEST_COUNT];
short d_percentprintingoff;
short d_inthresholds[CONTEST_COUNT];
short d_outthresholds[CONTEST_COUNT];
short d_count;
long d_minutes;
 
static char des_map[CONTEST_COUNT] = {1, 2, 0};
static char rc5_map[CONTEST_COUNT] = {0, 1, 2};
 
dlgptr = GetNewDialog(kGeneralDialog, 0, (WindowPtr)-1);
ctrwindow(dlgptr, kCenterDefault, 20, 0, 0);
 
/* copy current values of items */
for (i = 0; i < CONTEST_COUNT; i++) d_loadorder_map[i] =
	(new_settings->loadorder_map)[i];
d_preferred_blocksize = new_settings->preferred_blocksize;
for (i = 0; i < CONTEST_COUNT; i++) 
{
	d_inthresholds[i] = (new_settings->inthreshold)[i];
	d_outthresholds[i] = (new_settings->outthreshold)[i];
}
d_count = new_settings->blockcount;
d_minutes = new_settings->minutes;
d_percentprintingoff = new_settings->percentprintingoff;

 /* show current values of items */
setgeneral(dlgptr, d_loadorder_map, d_preferred_blocksize,
		   d_inthresholds, d_outthresholds, d_count, d_minutes, 
		   d_percentprintingoff);
/* move cursor to end of text for first item */
set_text_cursor(dlgptr, kGeneralRC5BufferTextItem);

/* show dialog */
ShowWindow(dlgptr);
 
/* frame the default selection */
framedflt(dlgptr, colormac);

/* loop to process changes */
oldHit = kGeneralRC5BufferTextItem;
while (true) {
#ifdef powerc
	ModalDialog(&DlgFilter2RD, &itemHit);
#else
	ModalDialog(DlgFilter2, &itemHit);
#endif
	if (oldHit != itemHit)
		switch(oldHit) {
		case kGeneralRC5BufferTextItem:	
		case kGeneralDESBufferTextItem:	
		case kGeneralRC5BufferTextItem2:	
		case kGeneralDESBufferTextItem2:	
		case kGeneralCountTextItem:
		case kGeneralHoursTextItem:
				GetDialogItem(dlgptr, oldHit, &gtype, &gitem, &gbox);
				GetDialogItemText(gitem, (unsigned char *)s);
				p2cstr((unsigned char *)s);
				if ((oldHit == kGeneralRC5BufferTextItem) ||
					(oldHit == kGeneralRC5BufferTextItem2)||
					(oldHit == kGeneralDESBufferTextItem) ||
					(oldHit == kGeneralDESBufferTextItem2)) {
					if (sscanf(s, "%d", &r) != 1) r = 0;
					if (r < 1) {
						r = 1;
						}
					else if (r > MAXBLOCKSPERBUFFER) {
						r = MAXBLOCKSPERBUFFER;
						}
					sprintf(s, "%d", r);
					if (oldHit == kGeneralRC5BufferTextItem) {
						d_inthresholds[0] = r;
						}
					else if (oldHit == kGeneralRC5BufferTextItem2) {
						d_outthresholds[0] = r;
						}
					else if (oldHit == kGeneralDESBufferTextItem) {
						d_inthresholds[1] = r;
						}
					else {
						d_outthresholds[1] = r;
						}
					}
				else if (oldHit == kGeneralCountTextItem) {
					if (sscanf(s, "%d", &r) != 1) r = 0;
					d_count = r;
					sprintf(s, "%d", d_count);
					}
				else {	// kGeneralHoursTextItem
					d = atof(s);
					if (d < 0.0) d = 0.0;
					d_minutes = d * 60.0 + 0.5;
					if (d_minutes < 0) d_minutes = 0;
					sprintf(s, "%.2f", d_minutes / 60.0);
					}
				settext(gitem, s);
				break;
		default:
				break;
		}
	oldHit = itemHit;

	switch(itemHit) {
		case kGeneralOKItem:						/* copy new values */
				for (i = 0; i < CONTEST_COUNT; i++) (new_settings->loadorder_map)[i] =
					d_loadorder_map[i];
				new_settings->preferred_blocksize = d_preferred_blocksize;
				new_settings->inthreshold[0] = d_inthresholds[0];
				new_settings->inthreshold[1] = d_inthresholds[1];
				new_settings->outthreshold[0] = d_outthresholds[0];
				new_settings->outthreshold[1] = d_outthresholds[1];
				new_settings->blockcount = d_count;
				new_settings->minutes = d_minutes;
				new_settings->percentprintingoff = d_percentprintingoff;
				break;
		case kGeneralDefaultItem:					/* set defaults */
				for (i = 0; i < CONTEST_COUNT; i++) d_loadorder_map[i] =
					(default_settings->loadorder_map)[i];
				d_preferred_blocksize = default_settings->preferred_blocksize;
				d_inthresholds[0] = default_settings->inthreshold[0];
				d_inthresholds[1] = default_settings->inthreshold[1];
				d_outthresholds[0] = default_settings->outthreshold[0];
				d_outthresholds[1] = default_settings->outthreshold[1];
				d_count = default_settings->blockcount;
				d_minutes = default_settings->minutes;
				d_percentprintingoff = default_settings->percentprintingoff;
				setgeneral(dlgptr, d_loadorder_map, d_preferred_blocksize,
						   d_inthresholds, d_outthresholds, d_count, d_minutes, 
						   d_percentprintingoff);
				break;
		case kBlockSizePopupItem:
			d_preferred_blocksize = getit(kBlockSizePopupItem, dlgptr) + 27;
			setgeneral(dlgptr, d_loadorder_map, d_preferred_blocksize,
					   d_inthresholds, d_outthresholds, d_count, d_minutes, 
					   d_percentprintingoff);
			break;
		default: break;
		}
	if ((itemHit == kGeneralOKItem) || (itemHit == kGeneralCancelItem)) {
		break;
		}
	}
 
/* dispose of dialog and return */
DisposeDialog(dlgptr);
}
 
void RC5App::setgeneral(DialogPtr dlgptr, char *loadorder_map,
					    short preferred_blocksize, short *inthresholds,
					    short *outthresholds, short count, long minutes,
						short percentprintingoff)
{
short gtype;
Handle gitem;
Rect gbox;
char s[256];
 
setit(kBlockSizePopupItem, dlgptr, preferred_blocksize - 27); 

GetDialogItem(dlgptr, kGeneralRC5BufferTextItem, &gtype, &gitem, &gbox);
sprintf(s, "%d", inthresholds[0]);
settext(gitem, s);

GetDialogItem(dlgptr, kGeneralDESBufferTextItem, &gtype, &gitem, &gbox);
sprintf(s, "%d", inthresholds[1]);
settext(gitem, s);
 
GetDialogItem(dlgptr, kGeneralRC5BufferTextItem2, &gtype, &gitem, &gbox);
sprintf(s, "%d", outthresholds[0]);
settext(gitem, s);

GetDialogItem(dlgptr, kGeneralDESBufferTextItem2, &gtype, &gitem, &gbox);
sprintf(s, "%d", outthresholds[1]);
settext(gitem, s);
 
GetDialogItem(dlgptr, kGeneralCountTextItem, &gtype, &gitem, &gbox);
sprintf(s, "%d", count);
settext(gitem, s);
 
GetDialogItem(dlgptr, kGeneralHoursTextItem, &gtype, &gitem, &gbox);
sprintf(s, "%.2f", minutes / 60.0);
settext(gitem, s);
}

void RC5App::NetworkDialog(dialog_settings *default_settings,
						   dialog_settings *new_settings)
{
DialogPtr dlgptr;
short itemHit, oldHit;
short gtype;
Handle gitem;
Rect gbox;
long r;
char s[256];
char firemode;
char d_keyproxy[256];
long d_keyport;
char d_httpproxy[256];
long d_httpport;
char d_uuehttpmode;
char d_httpid[256];
char use_keyport, use_keyproxy;
char use_HTTPport, use_HTTPproxy;
Boolean use_id;
char userid[64], pass[64];
 
dlgptr = GetNewDialog(kNetworkDialog, 0, (WindowPtr)-1);
ctrwindow(dlgptr, kCenterDefault, 20, 0, 0);

/* copy current values of items */
strcpy(d_keyproxy, new_settings->keyproxy);
d_keyport = new_settings->keyport;
strcpy(d_httpproxy, new_settings->httpproxy);
d_httpport = new_settings->httpport;
d_uuehttpmode = new_settings->uuehttpmode;
strcpy(d_httpid, new_settings->httpid);

/* set firemode from current settings */
if (net_is_default_proxy(d_keyproxy) &&
     ((d_keyport == 0) || (d_keyport == 2064)) &&
     (d_uuehttpmode == 0))
     firemode = 1;
// firemode 2 was for telnet without uuencoding, which no longer works
// because port 23 is not written to the .ini file
else if (net_is_default_proxy(d_keyproxy) &&
     ((d_keyport == 0) || (d_keyport == 23)) &&
     (d_uuehttpmode == 1))
     firemode = 3;
else if (net_is_default_proxy(d_keyproxy) &&
     ((d_keyport == 0) || (d_keyport == 80)) &&
     (d_uuehttpmode == 3))
     firemode = 4;
else firemode = 5;

// if defaults wanted, set standard values
if (firemode < 5) {
	d_keyport = 0;				// 0 specifies the default port for the current mode
	d_keyproxy[0] = 0;			// use default proxy
	}

use_keyport = use_keyproxy = use_HTTPport = use_HTTPproxy = 127;

 /* show current values of items */
setnetwork(dlgptr, firemode, d_keyproxy, d_keyport,
		   d_httpproxy, d_httpport, d_uuehttpmode,
		   &use_keyport, &use_keyproxy, &use_HTTPport,
		   &use_HTTPproxy, d_httpid, false);

/* show dialog */
ShowWindow(dlgptr);
 
/* frame the default selection */
framedflt(dlgptr, colormac);
 
/* loop to process changes */
oldHit = 0 /*kGeneralThresholdTextItem*/;
while (true) {
#ifdef powerc
	ModalDialog(&DlgFilter2RD, &itemHit);
#else
	ModalDialog(DlgFilter2, &itemHit);
#endif
	if (oldHit != itemHit)
		switch(oldHit) {
		case kNetworkKeyPortTextItem:	
		case kNetworkHTTPPortTextItem:
				GetDialogItem(dlgptr, oldHit, &gtype, &gitem, &gbox);
				GetDialogItemText(gitem, (unsigned char *)s);
				p2cstr((unsigned char *)s);
				if (sscanf(s, "%d", &r) != 1) r = 0;
				if (oldHit == kNetworkKeyPortTextItem) {
					d_keyport = r;
					sprintf(s, "%d", d_keyport);
					}
				else {		// kNetworkHTTPPortTextItem
					d_httpport = r;
					sprintf(s, "%d", d_httpport);
					}
				settext(gitem, s);
				break;

		case kNetworkKeyAddrTextItem:
		case kNetworkHTTPAddrTextItem:
				GetDialogItem(dlgptr, oldHit, &gtype, &gitem, &gbox);
				GetDialogItemText(gitem, (unsigned char *)s);
				p2cstr((unsigned char *)s);
				if (oldHit == kNetworkKeyAddrTextItem) {
					strcpy(d_keyproxy, s);
					}
				else {
					strcpy(d_httpproxy, s);
					}
				break;
			
		default:
				break;
		}
	oldHit = itemHit;

	switch(itemHit) {
		case kNetworkOKItem:						/* copy new values */
				new_settings->autofindkeyserver = net_is_default_proxy(d_keyproxy);
				if (new_settings->autofindkeyserver) {
					d_keyproxy[0] = 0;		// needed for firemode 5
					}
				strcpy(new_settings->keyproxy, d_keyproxy);
				new_settings->keyport = d_keyport;
				strcpy(new_settings->httpproxy, d_httpproxy);
	  			new_settings->httpport = d_httpport;
				new_settings->uuehttpmode = d_uuehttpmode;
				strcpy(new_settings->httpid, d_httpid);
				break;

		case kNetworkDefaultItem:					/* set defaults */
				firemode = 1;
				strcpy(d_keyproxy, default_settings->keyproxy);
				d_keyport = default_settings->keyport;
				strcpy(d_httpproxy, default_settings->httpproxy);
				d_httpport = default_settings->httpport;
				d_uuehttpmode = default_settings->uuehttpmode;
				strcpy(d_httpid, default_settings->httpid);
				setnetwork(dlgptr, firemode, d_keyproxy, d_keyport,
						   d_httpproxy, d_httpport, d_uuehttpmode,
		  				   &use_keyport, &use_keyproxy, &use_HTTPport,
		  				   &use_HTTPproxy, d_httpid, false);
				break;

		case kNetworkMode1ButtonItem:
				firemode = 1;
				strcpy(d_keyproxy, "" );
				d_keyport = 0;
				d_uuehttpmode = 0;
				setnetwork(dlgptr, firemode, d_keyproxy, d_keyport,
						   d_httpproxy, d_httpport, d_uuehttpmode,
		   				   &use_keyport, &use_keyproxy, &use_HTTPport,
		   				   &use_HTTPproxy, d_httpid, false);
				break;

		case kNetworkMode3ButtonItem:
				firemode = 3;
				strcpy(d_keyproxy, "" );
				d_keyport = 0;
				d_uuehttpmode = 1;
				setnetwork(dlgptr, firemode, d_keyproxy, d_keyport,
						   d_httpproxy, d_httpport, d_uuehttpmode,
		   				   &use_keyport, &use_keyproxy, &use_HTTPport,
		   				   &use_HTTPproxy, d_httpid, false);
				break;

		case kNetworkMode4ButtonItem:
				firemode = 4;
				strcpy(d_keyproxy, "" );
				d_keyport = 0;
				d_uuehttpmode = 3;
				setnetwork(dlgptr, firemode, d_keyproxy, d_keyport,
						   d_httpproxy, d_httpport, d_uuehttpmode,
		   				   &use_keyport, &use_keyproxy, &use_HTTPport,
		   				   &use_HTTPproxy, d_httpid, false);
				break;

		case kNetworkMode5ButtonItem:
				firemode = 5;
				setnetwork(dlgptr, firemode, d_keyproxy, d_keyport,
						   d_httpproxy, d_httpport, d_uuehttpmode,
		   				   &use_keyport, &use_keyproxy, &use_HTTPport,
		   				   &use_HTTPproxy, d_httpid, false);
				break;

		case kNetworkUUCheckItem:
				if (d_uuehttpmode > 3) d_uuehttpmode = 0;
				d_uuehttpmode ^= 1;
				setnetwork(dlgptr, firemode, d_keyproxy, d_keyport,
						   d_httpproxy, d_httpport, d_uuehttpmode,
		   				   &use_keyport, &use_keyproxy, &use_HTTPport,
		   				   &use_HTTPproxy, d_httpid, false);
				break;

		case kNetworkHTTPCheckItem:
				if (d_uuehttpmode > 3) d_uuehttpmode = 0;
				d_uuehttpmode ^= 2;
				setnetwork(dlgptr, firemode, d_keyproxy, d_keyport,
						   d_httpproxy, d_httpport, d_uuehttpmode,
		   				   &use_keyport, &use_keyproxy, &use_HTTPport,
		   				   &use_HTTPproxy, d_httpid, false);
				break;
				
		case kNetworkSOCKS4CheckItem:
				d_uuehttpmode = 4;
				setnetwork(dlgptr, firemode, d_keyproxy, d_keyport,
						   d_httpproxy, d_httpport, d_uuehttpmode,
		   				   &use_keyport, &use_keyproxy, &use_HTTPport,
		   				   &use_HTTPproxy, d_httpid, false);
				break;

		case kNetworkSOCKS5CheckItem:
				d_uuehttpmode = 5;
				setnetwork(dlgptr, firemode, d_keyproxy, d_keyport,
						   d_httpproxy, d_httpport, d_uuehttpmode,
		   				   &use_keyport, &use_keyproxy, &use_HTTPport,
		   				   &use_HTTPproxy, d_httpid, false);
				break;

		case kNetworkIDButton:
				disable_network_buttons(dlgptr);
				use_id = IDDialog(userid, pass);
				if (use_id) {
					define_httpid(d_httpid, userid, pass, d_uuehttpmode);
					}
				setnetwork(dlgptr, firemode, d_keyproxy, d_keyport,
						   d_httpproxy, d_httpport, d_uuehttpmode,
	   					   &use_keyport, &use_keyproxy, &use_HTTPport,
	   					   &use_HTTPproxy, d_httpid, true);
				break;
				
		case kNetworkEMailButton:
				disable_network_buttons(dlgptr);
				EMailDialog(default_settings, new_settings);
				setnetwork(dlgptr, firemode, d_keyproxy, d_keyport,
						   d_httpproxy, d_httpport, d_uuehttpmode,
	   					   &use_keyport, &use_keyproxy, &use_HTTPport,
	   					   &use_HTTPproxy, d_httpid, true);
				break;

		default: break;
		}

	if ((itemHit == kGeneralOKItem) || (itemHit == kGeneralCancelItem)) {
		break;
		}
	}
 
/* dispose of dialog and return */
DisposeDialog(dlgptr);
}
 
void RC5App::setnetwork(DialogPtr dlgptr, char firemode, char *keyproxy,
						long keyport, char *httpproxy, long httpport,
						char uuehttpmode, char *use_keyport, char *use_keyproxy,
						char *use_HTTPport, char *use_HTTPproxy,
						char *httpid, Boolean need_enable)
{
char s[256];
char new_use_keyport, new_use_keyproxy;
char new_use_HTTPport, new_use_HTTPproxy;
Boolean did_select_text;
short gtype;
Handle gitem;
Rect gbox;
 
setit(kNetworkMode1ButtonItem, dlgptr, firemode == 1);
setit(kNetworkMode3ButtonItem, dlgptr, firemode == 3);
setit(kNetworkMode4ButtonItem, dlgptr, firemode == 4);
setit(kNetworkMode5ButtonItem, dlgptr, firemode == 5);

setit(kNetworkUUCheckItem, dlgptr, ((uuehttpmode == 1) || (uuehttpmode == 3)));
setit(kNetworkHTTPCheckItem, dlgptr, ((uuehttpmode == 2) || (uuehttpmode == 3)));
setit(kNetworkSOCKS4CheckItem, dlgptr, (uuehttpmode == 4) > 0);
setit(kNetworkSOCKS5CheckItem, dlgptr, (uuehttpmode == 5) > 0);

setactive(kNetworkUUCheckItem, dlgptr, firemode >= 5, colormac);
setactive(kNetworkHTTPCheckItem, dlgptr, firemode >= 5, colormac);
setactive(kNetworkSOCKS4CheckItem, dlgptr, firemode >= 5, colormac);
setactive(kNetworkSOCKS5CheckItem, dlgptr, firemode >= 5, colormac);

if (need_enable) {
	setactive(kNetworkOKItem, dlgptr, 1, colormac);
	setactive(kNetworkCancelItem, dlgptr, 1, colormac);
	setactive(kNetworkDefaultItem, dlgptr, 1, colormac);
	setactive(kNetworkEMailButton, dlgptr, 1, colormac);
	}

setactive(kNetworkIDButton, dlgptr,
	(firemode == 4) || ((firemode == 5) && (uuehttpmode > 1)), colormac); 

GetDialogItem(dlgptr, kNetworkIDButton, &gtype, &gitem, &gbox);
if (strlen(httpid) > 0) {
	set_control_text(gitem, "Change");
	}
else {
	set_control_text(gitem, "Define");
	}

new_use_keyport = firemode >=5;
new_use_keyproxy = firemode >= 5;
new_use_HTTPport = new_use_HTTPproxy = (uuehttpmode > 1) != 0;

did_select_text = false;

sprintf(s, "%d", keyport);
set_network_text(dlgptr, s, kNetworkKeyPortStaticItem,
				 kNetworkKeyPortTextItem, new_use_keyport,
				 use_keyport, &did_select_text);

set_network_text(dlgptr, keyproxy, kNetworkKeyAddrStaticItem,
				 kNetworkKeyAddrTextItem, new_use_keyproxy,
				 use_keyproxy, &did_select_text);

if (firemode < 4) {
	s[0] = 0;
	}
else {
	sprintf(s, "%d", httpport);
	}
set_network_text(dlgptr, s, kNetworkHTTPPortStaticItem,
				 kNetworkHTTPPortTextItem, new_use_HTTPport,
				 use_HTTPport, &did_select_text);

if (firemode < 4) {
	s[0] = 0;
	}
else {
	strcpy(s, httpproxy);
	}
set_network_text(dlgptr, s, kNetworkHTTPAddrStaticItem,
				 kNetworkHTTPAddrTextItem, new_use_HTTPproxy,
				 use_HTTPproxy, &did_select_text);
}

void RC5App::disable_network_buttons(DialogPtr dlgptr)
{
setactive(kNetworkOKItem, dlgptr, 0, colormac);
setactive(kNetworkCancelItem, dlgptr, 0, colormac);
setactive(kNetworkDefaultItem, dlgptr, 0, colormac);
setactive(kNetworkIDButton, dlgptr, 0, colormac);
setactive(kNetworkEMailButton, dlgptr, 0, colormac);
}

void RC5App::set_network_text(DialogPtr dlgptr, char *s, short static_item,
							  short text_item, char use_new, char *use_current,
							  Boolean *did_select_text)
{
short gtype;
Handle gitem;
Rect gbox;
short i;
GrafPtr gp;

GetDialogItem(dlgptr, static_item, &gtype, &gitem, &gbox);
settext(gitem, s);
GetDialogItem(dlgptr, text_item, &gtype, &gitem, &gbox);
settext(gitem, s);
if (use_new != *use_current) {
	if (use_new) {
		HideDialogItem(dlgptr, static_item);
		ShowDialogItem(dlgptr, text_item);
		SetDialogItem(dlgptr, text_item, editText, gitem, &gbox);
		GetPort(&gp);
		SetPort(dlgptr);
		gbox.top -= 3;
		gbox.left -= 3;
		gbox.bottom += 3;
		gbox.right += 3;
		FrameRect(&gbox);
		SetPort(gp);
		if (!(*did_select_text)) {
			i = strlen(s);
			SelectDialogItemText(dlgptr, text_item, i, i);
			*did_select_text = true;
			}
		}
	else {
		HideDialogItem(dlgptr, text_item);
		ShowDialogItem(dlgptr, static_item);
		SetDialogItem(dlgptr, text_item, statText, gitem, &gbox);
		}
	*use_current = use_new;
	}
}

void RC5App::define_httpid(char *httpid, char *userid,
						   char *pass, char uuehttpmode)
{
// null result if no userid
if (userid[0] == 0) {
	httpid[0] = 0;
	return;
	}

// just userid for socks4
if (uuehttpmode == 4) {
	strcpy(httpid, userid);
	return;
	}

// plain text userid:pass for socks5
if (uuehttpmode == 5) {
	sprintf(httpid, "%s:%s", userid, pass);
	return;
	}

// else http
strcpy(httpid, base64encode(userid, pass));
}

#define B64_ENC(Ch) (char) (base64table[(char)(Ch) & 63])
char * RC5App::base64encode(char *username, char *password)
{
  static char in[80], out[80];
  char base64table[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

  u32 length = strlen(username) + strlen(password) + 1;
  if ((length+1) >= sizeof(in) || (length + 2) * 4 / 3 >= sizeof(out)) return NULL;
  sprintf(in, "%s:%s\n", username, password);

  char *b = out, *data = in;
  for (; length > 2; length -= 3, data += 3)
  {
    *b++ = B64_ENC(data[0] >> 2);
    *b++ = B64_ENC(((data[0] << 4) & 060) | ((data[1] >> 4) & 017));
    *b++ = B64_ENC(((data[1] << 2) & 074) | ((data[2] >> 6) & 03));
    *b++ = B64_ENC(data[2] & 077);
  }

  if (length == 1)
  {
    *b++ = B64_ENC(data[0] >> 2);
    *b++ = B64_ENC((data[0] << 4) & 060);
    *b++ = '=';
    *b++ = '=';
  }
  else if (length == 2)
  {
    *b++ = B64_ENC(data[0] >> 2);
    *b++ = B64_ENC(((data[0] << 4) & 060) | ((data[1] >> 4) & 017));
    *b++ = B64_ENC((data[1] << 2) & 074);
    *b++ = '=';
  }
  *b = 0;

  return out;
}

Boolean RC5App::IDDialog(char *userid, char *pass)
{
DialogPtr dlgptr;
Ptr dStorage;
WindowPtr behind;
short itemHit, oldHit;
short gtype;
Handle gitem;
Rect gbox;
char showok;
Str255 instr;
Boolean id_ok, pass_ok;

dStorage = 0;
behind = (WindowPtr)-1;
dlgptr = GetNewDialog(kIDDialog, dStorage, behind);
ctrwindow(dlgptr, kCenterDefault, 20, 0, 0);
ShowWindow(dlgptr);

oldHit = 0;
showok = 1;

framedflt(dlgptr, colormac);

passtext[0] = 0;

while (true) {
#ifdef powerc
	ModalDialog(&passDlgFilterRD, &itemHit);
#else
	ModalDialog(passDlgFilter, &itemHit);
#endif
	switch(itemHit) {
		case kIDOKItem:									/* OK */
				// copy userid
				GetDialogItem(dlgptr, kIDUserTextItem, &gtype, &gitem, &gbox);
				GetDialogItemText(gitem, instr);
				parse_pass(instr);
				if (instr[0] > 63) {
					instr[0] = 63;
					}
				p2cstr(instr);
				strcpy(userid, (char *)instr);
												
				// copy password
				strcpy((char *)instr, passtext);
				c2pstr((char *)instr);
				parse_pass(instr);
				if (instr[0] > 63) {
					instr[0] = 63;
					}
				p2cstr(instr);
				strcpy(pass, (char *)instr);
				break;
				
		case kIDUserTextItem:
		case kIDPassTextItem:
				GetDialogItem(dlgptr, kIDUserTextItem, &gtype, &gitem, &gbox);
				GetDialogItemText(gitem, instr);
				id_ok = parse_pass(instr) || (instr[0] == 0);
				strcpy((char *)instr, passtext);
				c2pstr((char *)instr);
				pass_ok = parse_pass(instr) || (instr[0] == 0);
				if (!(id_ok && pass_ok)) {
					if (showok) {
						showok = 0;
						GetDialogItem(dlgptr, kIDOKItem, &gtype, &gitem, &gbox);
						HiliteControl((ControlHandle)gitem, 255);
						framedflt(dlgptr, colormac);
						}
					}
				else {
					if (!showok) {
						showok = 1;
						GetDialogItem(dlgptr, kIDOKItem, &gtype, &gitem, &gbox);
						HiliteControl((ControlHandle)gitem, 0);
						framedflt(dlgptr, colormac);
						}
					}
				break;
				
		default: break;
		}
	if ((itemHit == 1) || (itemHit == 2)) break;
	}

/* dispose of dialog and return */
DisposeDialog(dlgptr);
return(itemHit == 1);
}

Boolean RC5App::net_is_default_proxy(char *s)
{
short i;

// if default name, return true
if (stricmp(s, "rc5proxy.distributed.net") == 0) return true;

// if blank string return true, else return false
for (i = 0; true; i++) {
	if (s[i] == 0) return true;
	if (s[i] != 0x20) return false;
	}
}

void RC5App::MacOSDialog(DialogPtr configdlg, settings_list *ds,
						 settings_list *ns)
{
DialogPtr dlgptr;
short itemHit, oldHit;
short gtype;
Handle gitem;
Rect gbox;
long r;
char s[256];
short d_resplevel;
long d_customticks;
Boolean d_resume, d_maxcpu, d_use_MP, d_auto_fg;
double d_max_cpu_start_time, d_max_cpu_end_time, d_auto_fg_delay;
short current_text;
 
dlgptr = GetNewDialog(kMacOSDialog, 0, (WindowPtr)-1);
ctrwindow(dlgptr, kCenterDefault, 20, 0, 0);
 
/* copy current values of items */
d_resplevel = ns->resplevel;
d_customticks = ns->customticks;
d_resume = ns->resume;
d_maxcpu = ns->maxcpu;
d_use_MP = ns->use_MP;
d_max_cpu_start_time = ns->max_cpu_start_time;
d_max_cpu_end_time = ns->max_cpu_end_time;
d_auto_fg = ns->auto_fg;
d_auto_fg_delay = ns->auto_fg_delay;

/* set use_MP off and disable item if not available */
if (!haveMP) {
	d_use_MP = 0;
	setactive(kMacOSMPCheckItem, dlgptr, false, colormac);
	}
	
 /* show current values of items */
setmacos(dlgptr, d_resplevel, d_customticks, d_resume, d_maxcpu,
		 d_use_MP, d_max_cpu_start_time, d_max_cpu_end_time,
		 d_auto_fg, d_auto_fg_delay);

/* move cursor to end of text for first item */
set_text_cursor(dlgptr, kMacOSTicksTextItem);
current_text = kMacOSTicksTextItem;

/* show dialog */
ShowWindow(dlgptr);
 
/* frame the default selection */
framedflt(dlgptr, colormac);
 
/* loop to process changes */
oldHit = kMacOSFGMoveTextItem;
while (true) {
#ifdef powerc
	ModalDialog(&DlgFilter2RD, &itemHit);
#else
	ModalDialog(DlgFilter2, &itemHit);
#endif
	if (oldHit != itemHit)
		switch(oldHit) {
		case kMacOSTicksTextItem:	
				GetDialogItem(dlgptr, oldHit, &gtype, &gitem, &gbox);
				GetDialogItemText(gitem, (unsigned char *)s);
				p2cstr((unsigned char *)s);
				if (sscanf(s, "%d", &r) != 1) r = 0;
				if (r < MIN_TICKS) {
					r = MIN_TICKS;
					}
				else if (r > MAX_TICKS) {		// using ms now
					r = MAX_TICKS;
					}
				d_customticks = r;
				settext(gitem, s);
				break;

		case kMacOSBeginTextItem:
				GetDialogItem(dlgptr, oldHit, &gtype, &gitem, &gbox);
				GetDialogItemText(gitem, (unsigned char *)s);
				p2cstr((unsigned char *)s);
				d_max_cpu_start_time = atof(s);
				if (d_max_cpu_start_time < 0.0) d_max_cpu_start_time = 0.0;
				if (d_max_cpu_start_time > 600.0) d_max_cpu_start_time = 600.0;
				sprintf(s, "%.2f", d_max_cpu_start_time);
				settext(gitem, s);
				d_max_cpu_start_time = atof(s);
				break;

		case kMacOSMaxTextItem:
				GetDialogItem(dlgptr, oldHit, &gtype, &gitem, &gbox);
				GetDialogItemText(gitem, (unsigned char *)s);
				p2cstr((unsigned char *)s);
				d_max_cpu_end_time = atof(s);
				if (d_max_cpu_end_time < 0.0) d_max_cpu_end_time = 0.0;
				if (d_max_cpu_end_time > 600.0) d_max_cpu_end_time = 600.0;
				sprintf(s, "%.2f", d_max_cpu_end_time);
				settext(gitem, s);
				d_max_cpu_end_time = atof(s);
				break;

		case kMacOSFGMoveTextItem:
				GetDialogItem(dlgptr, oldHit, &gtype, &gitem, &gbox);
				GetDialogItemText(gitem, (unsigned char *)s);
				p2cstr((unsigned char *)s);
				d_auto_fg_delay = atof(s);
				if (d_auto_fg_delay < 0.0) d_auto_fg_delay = 0.0;
				if (d_auto_fg_delay > 6000.0) d_auto_fg_delay = 6000.0;
				sprintf(s, "%.2f", d_auto_fg_delay);
				settext(gitem, s);
				d_auto_fg_delay = atof(s);
				break;
						
		default:
				break;
		}
	oldHit = itemHit;

	switch(itemHit) {
		case kMacOSOKItem:						/* copy new values */
				if (d_max_cpu_start_time > d_max_cpu_end_time) {
					show_error_string(kCPUTimesError, 0);
					DrawDialog(configdlg);
					framedflt(configdlg, colormac);
					set_text_cursor(dlgptr, current_text);
					continue;
					}

				ns->resplevel = d_resplevel;
				ns->customticks = d_customticks;
				ns->resume = d_resume;
				ns->maxcpu = d_maxcpu;
				ns->use_MP = d_use_MP;
				ns->max_cpu_start_time = d_max_cpu_start_time;
				ns->max_cpu_end_time = d_max_cpu_end_time;
				ns->auto_fg = d_auto_fg;
				ns->auto_fg_delay = d_auto_fg_delay;
				break;

		case kMacOSDefaultItem:					/* set defaults */
				d_resplevel = ds->resplevel;
				d_customticks = ds->customticks;
				d_resume = ds->resume;
				d_maxcpu = ds->maxcpu;
				d_use_MP = ds->use_MP;
				d_max_cpu_start_time = ds->max_cpu_start_time;
				d_max_cpu_end_time = ds->max_cpu_end_time;
				d_auto_fg = ds->auto_fg;
				d_auto_fg_delay = ds->auto_fg_delay;
				setmacos(dlgptr, d_resplevel, d_customticks, d_resume, d_maxcpu,
						 d_use_MP, d_max_cpu_start_time, d_max_cpu_end_time,
						 d_auto_fg, d_auto_fg_delay);
				set_text_cursor(dlgptr, current_text);
				break;

		case kMacOSLowButtonItem:
				d_resplevel = 0;
				d_customticks = LOW_TICKS;
				setmacos(dlgptr, d_resplevel, d_customticks, d_resume, d_maxcpu,
						 d_use_MP, d_max_cpu_start_time, d_max_cpu_end_time,
						 d_auto_fg, d_auto_fg_delay);
				if (current_text == kMacOSTicksTextItem) {
					set_text_cursor(dlgptr, kMacOSTicksTextItem);
					}
				break;

		case kMacOSMediumButtonItem:
				d_resplevel = 1;
				d_customticks = MEDIUM_TICKS;
				setmacos(dlgptr, d_resplevel, d_customticks, d_resume, d_maxcpu,
						 d_use_MP, d_max_cpu_start_time, d_max_cpu_end_time,
						 d_auto_fg, d_auto_fg_delay);
				if (current_text == kMacOSTicksTextItem) {
					set_text_cursor(dlgptr, kMacOSTicksTextItem);
					}
				break;

		case kMacOSHighButtonItem:
				d_resplevel = 2;
				d_customticks = HIGH_TICKS;
				setmacos(dlgptr, d_resplevel, d_customticks, d_resume, d_maxcpu,
						 d_use_MP, d_max_cpu_start_time, d_max_cpu_end_time,
						 d_auto_fg, d_auto_fg_delay);
				if (current_text == kMacOSTicksTextItem) {
					set_text_cursor(dlgptr, kMacOSTicksTextItem);
					}
				break;

		case kMacOSCustomButtonItem:
				d_resplevel = 3;
				setmacos(dlgptr, d_resplevel, d_customticks, d_resume, d_maxcpu,
						 d_use_MP, d_max_cpu_start_time, d_max_cpu_end_time,
						 d_auto_fg, d_auto_fg_delay);
				set_text_cursor(dlgptr, kMacOSTicksTextItem);
				current_text = kMacOSTicksTextItem;
				break;

		case kMacOSTicksTextItem:
				d_resplevel = 3;
				setit(kMacOSLowButtonItem, dlgptr, false);
				setit(kMacOSMediumButtonItem, dlgptr, false);
				setit(kMacOSHighButtonItem, dlgptr, false);
				setit(kMacOSCustomButtonItem, dlgptr, true);
				current_text = kMacOSTicksTextItem;
				break;

		case kMacOSBeginTextItem:
				current_text = kMacOSBeginTextItem;
				break;

		case kMacOSMaxTextItem:
				current_text = kMacOSMaxTextItem;
				break;

		case kMacOSFGMoveTextItem:
				current_text = kMacOSFGMoveTextItem;
				break;

		case kMacOSResumeCheckItem:
				d_resume ^= 1;
				setmacos(dlgptr, d_resplevel, d_customticks, d_resume, d_maxcpu,
						 d_use_MP, d_max_cpu_start_time, d_max_cpu_end_time,
						 d_auto_fg, d_auto_fg_delay);
				break;
				
		case kMacOSMaxCPUCheckItem:
				d_maxcpu ^= 1;
				setmacos(dlgptr, d_resplevel, d_customticks, d_resume, d_maxcpu,
						 d_use_MP, d_max_cpu_start_time, d_max_cpu_end_time,
						 d_auto_fg, d_auto_fg_delay);
				break;

		case kMacOSMPCheckItem:
				d_use_MP ^= 1;
				setmacos(dlgptr, d_resplevel, d_customticks, d_resume, d_maxcpu,
						 d_use_MP, d_max_cpu_start_time, d_max_cpu_end_time,
						 d_auto_fg, d_auto_fg_delay);
				break;

		case kMacOSFGCheckItem:
				d_auto_fg ^= 1;
				setmacos(dlgptr, d_resplevel, d_customticks, d_resume, d_maxcpu,
						 d_use_MP, d_max_cpu_start_time, d_max_cpu_end_time,
						 d_auto_fg, d_auto_fg_delay);
				break;

		default: break;
		}

	if ((itemHit == kMacOSOKItem) || (itemHit == kMacOSCancelItem)) {
		break;
		}
	}
 
/* dispose of dialog and return */
DisposeDialog(dlgptr);
}
 
void RC5App::setmacos(DialogPtr dlgptr, short resplevel, unsigned short customticks,
					  Boolean resume, Boolean maxcpu, Boolean use_MP,
					  double cpu_start, double cpu_end, Boolean auto_fg,
					  double auto_fg_delay)
{
short gtype;
Handle gitem;
Rect gbox;
char s[256];
 
setit(kMacOSLowButtonItem, dlgptr, resplevel == 0);
setit(kMacOSMediumButtonItem, dlgptr, resplevel == 1);
setit(kMacOSHighButtonItem, dlgptr, resplevel == 2);
setit(kMacOSCustomButtonItem, dlgptr, resplevel == 3);

GetDialogItem(dlgptr, kMacOSTicksTextItem, &gtype, &gitem, &gbox);
sprintf(s, "%d", customticks);
settext(gitem, s);
 
GetDialogItem(dlgptr, kMacOSBeginTextItem, &gtype, &gitem, &gbox);
sprintf(s, "%.2f", cpu_start);
settext(gitem, s);

GetDialogItem(dlgptr, kMacOSMaxTextItem, &gtype, &gitem, &gbox);
sprintf(s, "%.2f", cpu_end);
settext(gitem, s);

GetDialogItem(dlgptr, kMacOSFGMoveTextItem, &gtype, &gitem, &gbox);
sprintf(s, "%.2f", auto_fg_delay);
settext(gitem, s);

setit(kMacOSResumeCheckItem, dlgptr,resume);
setit(kMacOSMaxCPUCheckItem, dlgptr, maxcpu);
setit(kMacOSMPCheckItem, dlgptr, use_MP);
setit(kMacOSFGCheckItem, dlgptr, auto_fg);
}

void RC5App::CPUDialog(dialog_settings *default_settings,
						 dialog_settings *new_settings)
{
DialogPtr dlgptr;
short itemHit;
short gtype;
Handle gitem;
Rect gbox;
char s[256];
short d_cputype;
long d_numcpu;
Boolean allcpu;
short avail_cpus;
short max_cpus;
long r;
short oldHit;
 
if (haveMP) {
	dlgptr = GetNewDialog(kCPUDialog, 0, (WindowPtr)-1);
	}
else {
	dlgptr = GetNewDialog(kAltCPUDialog, 0, (WindowPtr)-1);
	}
ctrwindow(dlgptr, kCenterDefault, 20, 0, 0);
 
// copy current values of items
d_cputype = new_settings->cputype;
d_numcpu = new_settings->numcpu;

// get maximum support CPUs
if (haveMP) {
	max_cpus = GetNumberOfSupportedProcessors();
	}
else {
	max_cpus = 1;
	}

/* get number of available CPUs */
#ifdef powerc
if (haveMP && (max_cpus > 1)) {
	avail_cpus = MPProcessors();	// may crash even with haveMP on PPC prototype
	}
else {
	avail_cpus = 1;
	}
#else
	avail_cpus = 1;
#endif

if (avail_cpus > max_cpus) {
	avail_cpus = max_cpus;
	}

if (d_numcpu == -1) {
	allcpu = true;
	d_numcpu = avail_cpus;
	}
else {
	allcpu = false;
	}

if (d_numcpu > max_cpus) d_numcpu = max_cpus;

 /* show current values of items */
setcpu(dlgptr, d_cputype, d_numcpu, allcpu);

/* move cursor to end of text for first item */
if (haveMP) {
	set_text_cursor(dlgptr, kCPUCountUserEditItem);
	}

/* disable numcpu settings if no MP */
if (!haveMP) {
	GetDialogItem(dlgptr, kCPUCountUserItem, &gtype, &gitem, &gbox);
	sprintf(s, "Use %d", d_numcpu);
	c2pstr(s);
	SetControlTitle((ControlHandle)gitem, (unsigned char *)s);
	setactive(kCPUCountAllItem, dlgptr, false, 0);
	setactive(kCPUCountUserItem, dlgptr, false, 0);
	}

/* show dialog */
ShowWindow(dlgptr);
 
/* frame the default selection */
framedflt(dlgptr, colormac);
 
/* loop to process changes */
if (haveMP) {
	oldHit = kCPUCountUserEditItem;
	}

while (true) {
#ifdef powerc
	ModalDialog(&DlgFilter2RD, &itemHit);
#else
	ModalDialog(DlgFilter2, &itemHit);
#endif

if (haveMP) {
	if ((oldHit != itemHit) && (oldHit == kCPUCountUserEditItem)) {
			GetDialogItem(dlgptr, oldHit, &gtype, &gitem, &gbox);
			GetDialogItemText(gitem, (unsigned char *)s);
			p2cstr((unsigned char *)s);
			if (sscanf(s, "%d", &r) != 1) r = 1;
			if (r < 1) {
				r = 1;
				}
			else if (r > max_cpus) {
				r = max_cpus;
				}
			d_numcpu = r;
			settext(gitem, s);
		}

	oldHit = itemHit;
	}

	switch(itemHit) {
		case kCPUOKItem:						/* copy new values */
				new_settings->cputype = d_cputype;
				if (haveMP) {
					if (allcpu) {
						new_settings->numcpu = -1;
						}
					else {
						new_settings->numcpu = d_numcpu;
						}
					}
				break;

		case kCPUDefaultItem:					/* set defaults */
				d_cputype = default_settings->cputype;
				if (haveMP) {
					d_numcpu = default_settings->numcpu;
					if (d_numcpu == -1) {
						allcpu = true;
						d_numcpu = avail_cpus;
						}
					else {
						allcpu = false;
						}
					if (d_numcpu > max_cpus) d_numcpu = max_cpus;
					}
				setcpu(dlgptr, d_cputype, d_numcpu, allcpu);
				if (haveMP) {
					set_text_cursor(dlgptr, kCPUCountUserEditItem);
					}
				break;

		case kCPUTypeAutoItem:
				d_cputype = -1;
				setcpu(dlgptr, d_cputype, d_numcpu, allcpu);
				break;

		case kCPUType601Item:
				d_cputype = 0;
				setcpu(dlgptr, d_cputype, d_numcpu, allcpu);
				break;

		case kCPUType603Item:
				d_cputype = 1;
				setcpu(dlgptr, d_cputype, d_numcpu, allcpu);
				break;

		case kCPUCountAllItem:
				if (!haveMP) break;
				allcpu = true;
				setcpu(dlgptr, d_cputype, d_numcpu, allcpu);
				set_text_cursor(dlgptr, kCPUCountUserEditItem);
				break;

		case kCPUCountUserItem:
				if (!haveMP) break;
				allcpu = false;
				setcpu(dlgptr, d_cputype, d_numcpu, allcpu);
				set_text_cursor(dlgptr, kCPUCountUserEditItem);
				break;

		case kCPUCountUserEditItem:
				if (!haveMP) break;
				allcpu = false;
				setit(kCPUCountAllItem, dlgptr, allcpu);
				setit(kCPUCountUserItem, dlgptr, !allcpu);
				break;

		default: break;
		}

	if ((itemHit == kCPUOKItem) || (itemHit == kCPUCancelItem)) {
		break;
		}
	}
 
/* dispose of dialog and return */
DisposeDialog(dlgptr);
}
 
void RC5App::setcpu(DialogPtr dlgptr, short cputype, short numcpu,
					Boolean allcpu)
{
short gtype;
Handle gitem;
Rect gbox;
char s[256];
 
setit(kCPUTypeAutoItem, dlgptr, cputype == -1);
setit(kCPUType601Item, dlgptr, cputype == 0);
setit(kCPUType603Item, dlgptr, cputype > 0);

if (haveMP) {
	setit(kCPUCountAllItem, dlgptr, allcpu);
	setit(kCPUCountUserItem, dlgptr, !allcpu);

	GetDialogItem(dlgptr, kCPUCountUserEditItem, &gtype, &gitem, &gbox);
	sprintf(s, "%d", numcpu);
	settext(gitem, s);
	}
}

void RC5App::EMailDialog(dialog_settings *default_settings,
						 dialog_settings *new_settings)
{
DialogPtr dlgptr;
short itemHit, oldHit;
short gtype;
Handle gitem;
Rect gbox;
long r;
char s[256];
char d_smtpsrvr[128];
long d_smtpport;
long d_messagelen;
char d_smtpfrom[128];
char d_smtpdest[128];
 
dlgptr = GetNewDialog(kEMailDialog, 0, (WindowPtr)-1);
ctrwindow(dlgptr, kCenterDefault, 20, 0, 0);
 
/* copy current values of items */
strcpy(d_smtpsrvr, new_settings->smtpsrvr);
d_smtpport = new_settings->smtpport;
d_messagelen = new_settings->messagelen;
strcpy(d_smtpfrom, new_settings->smtpfrom);
strcpy(d_smtpdest, new_settings->smtpdest);

 /* show current values of items */
setemail(dlgptr, d_smtpsrvr, d_smtpport, d_messagelen,
		 d_smtpfrom, d_smtpdest);

/* move cursor to end of text for first item */
set_text_cursor(dlgptr, kEMailSMTPAddrTextItem);

/* show dialog */
ShowWindow(dlgptr);
 
/* frame the default selection */
framedflt(dlgptr, colormac);
 
/* loop to process changes */
oldHit = kEMailSMTPAddrTextItem;
while (true) {
#ifdef powerc
	ModalDialog(&DlgFilter2RD, &itemHit);
#else
	ModalDialog(DlgFilter2, &itemHit);
#endif
	if (oldHit != itemHit)
		switch(oldHit) {
		case kEMailSMTPAddrTextItem:	
		case kEMailSMTPPortTextItem:	
		case kEMailLengthTextItem:
		case kEMailFromTextItem:
		case kEMailToTextItem:
				GetDialogItem(dlgptr, oldHit, &gtype, &gitem, &gbox);
				GetDialogItemText(gitem, (unsigned char *)s);
				p2cstr((unsigned char *)s);
				if (oldHit == kEMailSMTPPortTextItem) {
					if (sscanf(s, "%d", &r) != 1) r = 0;
					if (r < 0) {
						r = 25;
						}
					else if (r > 65535) {
						r = 25;
						}
					sprintf(s, "%d", r);
					d_smtpport = r;
					}
				else if (oldHit == kEMailLengthTextItem) {
					if (sscanf(s, "%d", &r) != 1) r = 0;
					if (r < 0) {
						r = 0;
						}
					else if (r > 0x6400000) {
						r = 0;
						}
					sprintf(s, "%d", r);
					d_messagelen = r;
					}
				else if (oldHit == kEMailSMTPAddrTextItem) {
					s[127] = 0;	// truncate
					strcpy(d_smtpsrvr, s);
					}
				else if (oldHit == kEMailFromTextItem) {
					s[127] = 0;	// truncate
					strcpy(d_smtpfrom, s);
					}
				else {	// kEMailToTextItem
					s[127] = 0;	// truncate
					strcpy(d_smtpdest, s);
					}
				settext(gitem, s);
				break;
		default:
				break;
		}
	oldHit = itemHit;

	switch(itemHit) {
		case kEMailOKItem:						/* copy new values */
				strcpy(new_settings->smtpsrvr, d_smtpsrvr);
				new_settings->smtpport = d_smtpport;
				new_settings->messagelen = d_messagelen;
				strcpy(new_settings->smtpfrom, d_smtpfrom);
				strcpy(new_settings->smtpdest, d_smtpdest);
				break;

		case kEMailDefaultItem:					/* set defaults */
				strcpy(d_smtpsrvr, default_settings->smtpsrvr);
				d_smtpport = default_settings->smtpport;
				d_messagelen = default_settings->messagelen;
				strcpy(d_smtpfrom, default_settings->smtpfrom);
				strcpy(d_smtpdest, default_settings->smtpdest);
				setemail(dlgptr, d_smtpsrvr, d_smtpport, d_messagelen,
					d_smtpfrom, d_smtpdest);
				break;

		default: break;
		}
	if ((itemHit == kEMailOKItem) || (itemHit == kEMailCancelItem)) {
		break;
		}
	}
 
/* dispose of dialog and return */
DisposeDialog(dlgptr);
}
 
void RC5App::setemail(DialogPtr dlgptr, char *smtpsrvr, long smtpport,
					  long messagelen, char *smtpfrom, char *smtpdest) {
short gtype;
Handle gitem;
Rect gbox;
char s[256];
 
GetDialogItem(dlgptr, kEMailSMTPAddrTextItem, &gtype, &gitem, &gbox);
settext(gitem, smtpsrvr);

GetDialogItem(dlgptr, kEMailSMTPPortTextItem, &gtype, &gitem, &gbox);
sprintf(s, "%d", smtpport);
settext(gitem, s);
 
GetDialogItem(dlgptr, kEMailLengthTextItem, &gtype, &gitem, &gbox);
sprintf(s, "%d", messagelen);
settext(gitem, s);

GetDialogItem(dlgptr, kEMailFromTextItem, &gtype, &gitem, &gbox);
settext(gitem, smtpfrom);

GetDialogItem(dlgptr, kEMailToTextItem, &gtype, &gitem, &gbox);
settext(gitem, smtpdest);
}

void RC5App::FilesDialog(dialog_settings *default_settings,
						 dialog_settings *new_settings)
{
DialogPtr dlgptr;
short itemHit, oldHit;
short gtype;
Handle gitem;
Rect gbox;
char s[256];
char d_checkpoint[128];
char d_logname[128];

dlgptr = GetNewDialog(kFilesDialog, 0, (WindowPtr)-1);
ctrwindow(dlgptr, kCenterDefault, 20, 0, 0);
 
/* copy current values of items */
strcpy(d_checkpoint, new_settings->checkpoint_file);
if (strcmp(d_checkpoint, "none") == 0) {
	d_checkpoint[0] = 0;
	}
strcpy(d_logname, new_settings->logname);
if (strcmp(d_logname, "none") == 0) {
	d_logname[0] = 0;
	}

 /* show current values of items */
setfiles(dlgptr, d_checkpoint, d_logname);

/* move cursor to end of text for first item */
set_text_cursor(dlgptr, kFilesCheckpointTextItem);

/* show dialog */
ShowWindow(dlgptr);
 
/* frame the default selection */
framedflt(dlgptr, colormac);
 
/* loop to process changes */
oldHit = kFilesCheckpointTextItem;
while (true) {
#ifdef powerc
	ModalDialog(&DlgFilter2RD, &itemHit);
#else
	ModalDialog(DlgFilter2, &itemHit);
#endif
	if (oldHit != itemHit)
		switch(oldHit) {
		case kFilesCheckpointTextItem:	
		case kFilesLogTextItem:	
				GetDialogItem(dlgptr, oldHit, &gtype, &gitem, &gbox);
				GetDialogItemText(gitem, (unsigned char *)s);
				p2cstr((unsigned char *)s);
				if (oldHit == kFilesCheckpointTextItem) {
					s[127] = 0;	// truncate
					strcpy(d_checkpoint, s);
					}
				else {	// kFilesLogTextItem
					s[127] = 0;	// truncate
					strcpy(d_logname, s);
					}
				settext(gitem, s);
				break;
		default:
				break;
		}
	oldHit = itemHit;

	switch(itemHit) {
		case kFilesOKItem:						/* copy new values */
				if (d_checkpoint[0] == 0) {
					strcpy(new_settings->checkpoint_file, "none");
					}
				else {
					strcpy(new_settings->checkpoint_file, d_checkpoint);
					}
				if (d_logname[0] == 0) {
					strcpy(new_settings->logname, "none");
					}
				else {
					strcpy(new_settings->logname, d_logname);
					}
				break;

		case kFilesDefaultItem:					/* set defaults */
				strcpy(d_checkpoint, default_settings->checkpoint_file);
				if (strcmp(d_checkpoint, "none") == 0) {
					d_checkpoint[0] = 0;
					}
				strcpy(d_logname, default_settings->logname);
				if (strcmp(d_logname, "none") == 0) {
					d_logname[0] = 0;
					}
				setfiles(dlgptr, d_checkpoint, d_logname);
				break;

		default: break;
		}
	if ((itemHit == kFilesOKItem) || (itemHit == kFilesCancelItem)) {
		break;
		}
	}
 
/* dispose of dialog and return */
DisposeDialog(dlgptr);
}

void RC5App::setfiles(DialogPtr dlgptr, char *checkpoint, char *logfile)
{
short gtype;
Handle gitem;
Rect gbox;

GetDialogItem(dlgptr, kFilesCheckpointTextItem, &gtype, &gitem, &gbox);
settext(gitem, checkpoint);

GetDialogItem(dlgptr, kFilesLogTextItem, &gtype, &gitem, &gbox);
settext(gitem, logfile);
}

// return true if any differences
Boolean RC5App::compare_settings_list(settings_list *s1, settings_list *s2)
{
if (strcmp(s1->font_name, s2->font_name) != 0) return(true);
if (strcmp(s1->console_log_name, s2->console_log_name) != 0) return(true);
if (s1->customticks != s2->customticks) return(true);
if (s1->log_window_h_loc != s2->log_window_h_loc) return(true);
if (s1->log_window_v_loc != s2->log_window_v_loc) return(true);
if (s1->log_window_width != s2->log_window_width) return(true);
if (s1->log_window_height != s2->log_window_height) return(true);
if (s1->gui_window_h_loc != s2->gui_window_h_loc) return(true);
if (s1->gui_window_v_loc != s2->gui_window_v_loc) return(true);
if (s1->gui_window_width != s2->gui_window_width) return(true);
if (s1->gui_window_height != s2->gui_window_height) return(true);
if (s1->font_size != s2->font_size) return(true);
if (s1->resplevel != s2->resplevel) return(true);
if (s1->writelog != s2->writelog) return(true);
if (s1->log_window_info_stored != s2->log_window_info_stored) return(true);
if (s1->log_window_visible != s2->log_window_visible) return(true);
if (s1->gui_window_info_stored != s2->gui_window_info_stored) return(true);
if (s1->gui_window_visible != s2->gui_window_visible) return(true);
if (s1->resume != s2->resume) return(true);
if (s1->all_fonts != s2->all_fonts) return(true);
if (s1->maxcpu != s2->maxcpu) return(true);
if (s1->max_cpu_start_time != s2->max_cpu_start_time) return(true);
if (s1->max_cpu_end_time != s2->max_cpu_end_time) return(true);
if (s1->font_style != s2->font_style) return(true);
if (s1->auto_fg != s2->auto_fg) return(true);
if (s1->auto_fg_delay != s2->auto_fg_delay) return(true);
if (s1->buffers_contest != s2->buffers_contest) return(true);
if (s1->use_MP != s2->use_MP) return(true);

return(false);
}

Boolean parse_pass(StringPtr dlgtext)
{
char *textptr;
char *endptr;
short i, len;

p2cstr(dlgtext);
textptr = (char *)dlgtext;

// skip leading blanks
while (*textptr != 0) {
	if (*textptr == 0x20) {
		textptr++;
		}
	else {
		break;
		}
	}

// if all blanks return 
if (*textptr == 0) {
	dlgtext[0] = 0;
	return(false);
	}

// delete trailing blanks
endptr = textptr + strlen(textptr) - 1;
while (*endptr == 0x20) endptr--;
*(endptr + 1) = 0;

// copy result
if (textptr != (char*)dlgtext) {
	len = strlen(textptr) + 1;	// copy null
	for (i = 0; i < len; i++) {
		dlgtext[i] = textptr[i];	
		}
	}
c2pstr((char*)dlgtext);
return(true);
}

pascal Boolean passDlgFilter(DialogPtr dlg, EventRecord *eventptr,
							 short *itemptr)
{
unsigned char i;
short gtype;
Handle gitem;
Rect gbox;
unsigned long ticklim;
char cmdkey;
unsigned char currenthilite;
DialogPeek dlgpeek;

dlgpeek = (DialogPeek)dlg;

switch(eventptr->what) {
	case mouseDown:
		/* mousehit = eventptr->where; */
		return(0);
/*	case updateEvt:
		if (((DialogPtr)eventptr->message) != dlg) {
			updevent((GrafPtr)eventptr->message);
			}
		return(0);
		break; */
	case keyDown:
	case autoKey:
		i = (eventptr->message & 0x7f);	/* ascii code */
		cmdkey = (eventptr->modifiers & cmdKey) == cmdKey;
		if ((i == 0x03) || (i == 0x0d)) {
			GetDialogItem(dlg, kIDOKItem, &gtype, &gitem, &gbox);
			currenthilite = (*(ControlHandle)gitem)->contrlHilite;
			if (currenthilite == 255) {	/* button disabled */
				SysBeep(3);
				eventptr->what = nullEvent;
				return(0);
				}
			HiliteControl((ControlHandle)gitem, kControlButtonPart);
			ticklim = LMGetTicks() + 8;
#pragma warn_possunwant off
			while (ticklim > LMGetTicks());
#pragma warn_possunwant reset
			HiliteControl((ControlHandle)gitem, 0);
			(*itemptr) = 1;
			return(-1);
			}
		else if ((i == 0x1b) || ((i == '.') && cmdkey)) {
			GetDialogItem(dlg, kIDCancelItem, &gtype, &gitem, &gbox);
			HiliteControl((ControlHandle)gitem, kControlButtonPart);
			ticklim = LMGetTicks() + 8;
#pragma warn_possunwant off
			while (ticklim > LMGetTicks());
#pragma warn_possunwant reset
			HiliteControl((ControlHandle)gitem, 0);
			(*itemptr) = 2;
			return(-1);
			}
		else if ((dlgpeek->editField == (kIDPassTextItem - 1)) && (i != 0x09)) {
				updpass((*(dlgpeek->textH))->selStart,
						(*(dlgpeek->textH))->selEnd, i);
				if ((i >= 0x20) && (i <= 0x7e)) eventptr->message = 0xa5;
				return(0);
				}

	default:
		return(0);
	}
}

void updpass(short start, short end, unsigned char c)
{
unsigned char origtext[64];
unsigned char newstr[2];

memcpy(origtext, passtext, 64);			/* copy current text */
memset(passtext, 0, 64);				/* clear password */
newstr[0] = c;							/* define string for new character */
newstr[1] = 0;

/* if character is a backspace, and have insertion point, 
   change to selection range of the previous character (if any) */

if ((start == end) && (c == 0x08))
	if (start > 0) start--;

/* ignore changes after the first 63 characters */
if (start > 63) start = 63;
if (end > 63) end = 63;

/* copy text up to insertion point or selection range */
appendpass((unsigned char *)passtext, origtext, start);

/* if character is not a control character, append character */
if (c >= 0x20) appendpass((unsigned char *)passtext, newstr, 1);

/* append text following insertion point or selection range */
appendpass((unsigned char *)passtext, origtext+end, strlen((char *)origtext)-end);
}

void appendpass(unsigned char *text, unsigned char *s, short len)
{
short slen, plen, rlen;

/* check for arguments indicating nothing to do */
if ((s[0] == 0) || (len < 1)) return;

/* reduce length if longer than characters present */
slen = strlen((char *)s);
if (slen < len) len = slen;

/* reduce length if too many to fit */
plen = strlen(passtext);
rlen = 63 - plen;
if (len > rlen) len = rlen;

if (len == 0) return;
memcpy(text+plen, s, len); 
}
