// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: RC5Inifile.cpp,v $
// Revision 1.9  1999/03/23 06:16:09  dicamillo
// Copy inifilename for clients used for reading and writing.
//
// Revision 1.8  1999/03/22 05:53:42  dicamillo
// Update to support client_loadorder instead of preferred_contest
//
// Revision 1.7  1999/01/27 00:22:37  sampo
// Commented out calls to  ValidateConfig() as it no longer exitsts.
//
// Revision 1.6  1999/01/17 23:51:03  dicamillo
// Add comments to indicate ValidateConfig no longer does anything.
//
// Revision 1.5  1999/01/10 06:00:15  dicamillo
// Changes in how .ini file is read and written.
//
// Revision 1.4  1999/01/06 07:31:27  dicamillo
// Default keyport is now 2064 instead of 0.
//
// Revision 1.3  1999/01/06 06:18:24  dicamillo
// Update for one checkpoint file for all contests.
//
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:16:40  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *RC5Inifile_cpp(void) {
return "@(#)$Id: RC5Inifile.cpp,v 1.9 1999/03/23 06:16:09 dicamillo Exp $"; }
#endif

#include "macdefs.h"
#include "WASTE.h"
#include "resdefs.h"
#include "apputils.h"
#include "window_info.h"
#include "DrawGUI.h"
#include <Icons.h>

#include "PointerList.h"
#include "ViewObject.h"
#include "GUIView.h"
#include "WTextView.h"
#include "TextRscView.h"
#include "WindowObject.h"
#include "AppObject.h"
#include "ViewWindow.h"
#include "GUIWindow.h"
#include "WTextDisplayWindow.h"
#include "TextRscWindow.h"
#include "client.h"
#include "Mac_Client.h"
#include "RC5Dialogs.h"
#include "settings.h"
#include "my_settings.h"
#include "RC5App.h"
#include "confrwv.h"

OSErr RC5App::read_ini_settings(dialog_settings *s)
{
Client *theClient;

// Create a separate client to read the settings
try {
	theClient = new Client;
	}
catch (...) {
	return(memFullErr);
	}
strcpy(theClient->inifilename, theThreadApp->inifilename);

// Read the settings
if (ReadConfig(theClient) != noErr) return(readErr);
//ValidateConfig(theClient);	 at 434, does not exist

// Return settings
copy_settings_from_client(s, theClient);

// Delete separate client
delete theClient;

return(noErr);
}

OSErr RC5App::write_ini_settings(dialog_settings *s)
{
Client *theClient;
OSErr rc;

// Create a separate client to write the settings
try {
	theClient = new Client;
	}
catch (...) {
	return(memFullErr);
	}
strcpy(theClient->inifilename, theThreadApp->inifilename);

// Read current settings before making changes
//if (ReadConfig(theClient) == noErr) {
//	ValidateConfig(theClient);	 at 434 does not exist
//	}

// Store new settings values and validate
copy_settings_to_client(s, theClient);
//ValidateConfig(theClient);		 at 434 does not exist

// Write new settings
rc = WriteConfig(theClient, 1);

// Delete separate client
delete theClient;

return(rc ? writErr : noErr);
}

void RC5App::copy_settings_to_client(dialog_settings *s, Client *theClient)
{
short i;

strcpy(theClient->id, s->id);
(theClient->inthreshold)[0] = (s->inthreshold)[0];
(theClient->inthreshold)[1] = (s->inthreshold)[1];
(theClient->outthreshold)[0] = (s->outthreshold)[0];
(theClient->outthreshold)[1] = (s->outthreshold)[1];
theClient->blockcount = s->blockcount;
theClient->minutes = s->minutes;
strcpy(theClient->logname, s->logname);
strcpy(theClient->keyproxy, s->keyproxy);
theClient->keyport = s->keyport;
strcpy(theClient->httpproxy, s->httpproxy);
theClient->httpport = s->httpport;
theClient->uuehttpmode = s->uuehttpmode;
strcpy(theClient->httpid, s->httpid);
theClient->cputype = s->cputype;
theClient->messagelen = s->messagelen;
strcpy(theClient->smtpsrvr, s->smtpsrvr);
theClient->smtpport = s->smtpport;
strcpy(theClient->smtpfrom, s->smtpfrom);
strcpy(theClient->smtpdest, s->smtpdest);
theClient->numcpu = s->numcpu;
strcpy(theClient->checkpoint_file, s->checkpoint_file);
theClient->preferred_blocksize = s->preferred_blocksize;
for (i = 0; i < CONTEST_COUNT; i++) (theClient->loadorder_map)[i] =
	(s->loadorder_map)[i];
theClient->offlinemode = s->offlinemode;
theClient->percentprintingoff = s->percentprintingoff;
theClient->autofindkeyserver = s->autofindkeyserver;
}

void RC5App::copy_settings_from_client(dialog_settings *s, Client *theClient)
{
short i;

strcpy(s->id, theClient->id);
(s->inthreshold)[0] = (theClient->inthreshold)[0];
(s->inthreshold)[1] = (theClient->inthreshold)[1];
(s->outthreshold)[0] = (theClient->outthreshold)[0];
(s->outthreshold)[1] = (theClient->outthreshold)[1];
s->blockcount = theClient->blockcount;
s->minutes = theClient->minutes;
strcpy(s->logname, theClient->logname);
strcpy(s->keyproxy, theClient->keyproxy);
s->keyport = theClient->keyport;
strcpy(s->httpproxy, theClient->httpproxy);
s->httpport = theClient->httpport;
s->uuehttpmode = theClient->uuehttpmode;
strcpy(s->httpid, theClient->httpid);
s->cputype = theClient->cputype;
s->messagelen = theClient->messagelen;
strcpy(s->smtpsrvr, theClient->smtpsrvr);
s->smtpport = theClient->smtpport;
strcpy(s->smtpfrom, theClient->smtpfrom);
strcpy(s->smtpdest, theClient->smtpdest);
s->numcpu = theClient->numcpu;
strcpy(s->checkpoint_file, theClient->checkpoint_file);
s->preferred_blocksize = theClient->preferred_blocksize;
for (i = 0; i < CONTEST_COUNT; i++) (s->loadorder_map)[i] =
	(theClient->loadorder_map)[i];
s->offlinemode = theClient->offlinemode;
s->percentprintingoff = theClient->percentprintingoff;
s->autofindkeyserver = theClient->autofindkeyserver;
}

// return true if any differences
Boolean RC5App::compare_dialog_settings(dialog_settings *ds1, dialog_settings *ds2)
{
if (strcmp(ds1->id, ds2->id) != 0) return(true);
if (ds1->inthreshold[0] != ds2->inthreshold[0]) return(true);
if (ds1->inthreshold[1] != ds2->inthreshold[1]) return(true);
if (ds1->outthreshold[0] != ds2->outthreshold[0]) return(true);
if (ds1->outthreshold[1] != ds2->outthreshold[1]) return(true);
if (ds1->blockcount != ds2->blockcount) return(true);
if (ds1->minutes != ds2->minutes) return(true);
if (strcmp(ds1->logname, ds2->logname) != 0) return(true);
if (strcmp(ds1->keyproxy, ds2->keyproxy) != 0) return(true);
if (ds1->keyport != ds2->keyport) return(true);
if (strcmp(ds1->httpproxy, ds2->httpproxy) != 0) return(true);
if (ds1->httpport != ds2->httpport) return(true);
if (ds1->uuehttpmode != ds2->uuehttpmode) return(true);
if (strcmp(ds1->httpid, ds2->httpid) != 0) return(true);
if (ds1->cputype != ds2->cputype) return(true);
if (ds1->messagelen != ds2->messagelen) return(true);
if (strcmp(ds1->smtpsrvr, ds2->smtpsrvr) != 0) return(true);
if (ds1->smtpport != ds2->smtpport) return(true);
if (strcmp(ds1->smtpfrom, ds2->smtpfrom) != 0) return(true);
if (strcmp(ds1->smtpdest, ds2->smtpdest) != 0) return(true);
if (ds1->numcpu != ds2->numcpu) return(true);
if (strcmp(ds1->checkpoint_file, ds2->checkpoint_file) != 0) return(true);
if (ds1->preferred_blocksize != ds2->preferred_blocksize) return(true);
if (memcmp(ds1->loadorder_map, ds2->loadorder_map, CONTEST_COUNT) != 0) return(true);
if (ds1->offlinemode != ds2->offlinemode) return(true);
if (ds1->percentprintingoff != ds2->percentprintingoff) return(true);
if (ds1->autofindkeyserver != ds2->autofindkeyserver) return(true);
return(false);
}
