// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: TextRscWindow.cpp,v $
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:17:07  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *TextRscWindow_cpp(void) {
return "@(#)$Id: TextRscWindow.cpp,v 1.2 1999/01/01 02:45:17 cramer Exp $"; }
#endif

#include "macdefs.h"
#include "resdefs.h"
#include "window_info.h"
#include "apputils.h"

#include "PointerList.h"
#include "ViewObject.h"
#include "TextRscView.h"
#include "WindowObject.h"
#include "AppObject.h"
#include "TextRscWindow.h"

OSErr TextRscWindow::init_ViewWindow(void *objectPtr)
{
OSErr rc;
Handle text_handle, style_handle;
TextRscView *myTextRscView;
window_info_rec window_info;
short window_count;

rc = WindowObject::init_ViewWindow(objectPtr);
if (rc != noErr) {
	return(rc);
	}
rc = get_res_handle(&text_handle, 'TEXT', 128);
if (rc != noErr) {
	return(rc);
	}
rc = get_res_handle(&style_handle, 'styl', 128);
if (rc != noErr) {
	DisposeHandle(text_handle);
	return(rc);
	}

// allocate new view object
try {
	myTextRscView = new TextRscView;
	}
catch (...) {
	DisposeHandle(text_handle);
	DisposeHandle(style_handle);
	return(memFullErr);
	}

view_list[0] = myTextRscView;

// define pict
myTextRscView->define_text_rsc(text_handle, style_handle, init_window_name);

// fill-in info init_window needs
window_count = (((AppObject *)myApp)->window_list)->CountPointers();
strcpy(window_info.window_name, (char *)view_list[0]->myName);
if (have_initial_window_rect) {
	window_info.initial_rect = initial_window_rect;
	window_info.keep_initial_rect = true;
	}
else {
	window_info.initial_rect = ((AppObject *)myApp)->classicRect;
	window_info.keep_initial_rect = false;
	}
if (have_initial_window_visible) {
	window_info.hide_window = !initial_window_visible;
	}
else {
	window_info.hide_window = false;
	}
window_info.size_rect = ((AppObject *)myApp)->sizeRect;
window_info.drag_rect = ((AppObject *)myApp)->dragRect;
window_info.color_window = ((AppObject *)myApp)->colormac;
window_info.offset_window = true;
window_info.offsets.h = -24 + 8*window_count;
window_info.offsets.v = window_info.offsets.h;
window_info.center_denominator = ((AppObject *)myApp)->center_denominator;
window_info.procID = zoomDocProc;
window_info.grow_window = true;
window_info.TEVersion = ((AppObject *)myApp)->TEVersion;
window_info.drag_mgr_avail = ((AppObject *)myApp)->drag_mgr_avail;

// initialize our window
view_count = 1;
do_h_scroll_list[0] = true;
do_v_scroll_list[0] = true;
update_content_rects(&window_info.initial_rect);

rc = init_window(&window_info);
if (rc != noErr) {
	delete view_list[0];
	view_list[0] = 0;
	view_count = 0;
	return(rc);
	}

return(noErr);
}
