// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: WindowObject.h,v $
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:18:37  dicamillo
// First Checked In.
//

// Definitions for window object

#define MAX_VIEWS 8
// data structure definitions
struct control_info {
	ControlHandle handle;
	long		  reference;
	short		  hilite_value;
	};
typedef struct control_info control_info;

// global variables and methods

class WindowObject {

public:
	// public variables
	ViewObject *view_list[MAX_VIEWS];	// views for this window
	Rect content_list[MAX_VIEWS];		// corresponding content Rects
	scrollinfo scroll_list[MAX_VIEWS];	// corresponding scroll info
	Boolean do_h_scroll_list[MAX_VIEWS];
	Boolean do_v_scroll_list[MAX_VIEWS];
	short view_count;				// number of views
	void *myApp;					// pointer to my AppObject
	WindowPtr myWindow;				// window for this object
	WindowRecord myWindowRecord;	// window record for the window
	char window_name[256];			// name of this window
	Rect dragRect;					// bounds for dragging
	Rect sizeRect;					// bounds for resizing
	Rect h_growRect;				// rects for grow icon & lines
	Rect v_growRect;
	PointerList *control_list;		// list of added controls
	LongRect scrollRect;			// used during scrolling
	LongRect old_scrollRect;		// used during scrolling
	Rect validRect;					// used during scrolling
	RgnHandle backgroundRgn;		// parts of window not part of views
	RgnHandle workRgn;				// for region calculations
	RgnHandle workRgn2;
	RgnHandle workRgn3;
	Boolean color_window;			// true if color window
	Boolean grow_window;			// true to handle grow icon
	Boolean controls_activated;		// window activation state
	short font_item;				// text style menu items
	short size_item;
	short style_bits;
	short TE_view;					// index for current TextEdit view
	short Drag_view;				// index for view to handle dragging
	short last_copy_idx;			// last view to do cut/copy (for export)
	short click_idx;				// idx for click procs
									// data for static drawing code

	char init_window_name[256];			// name for new window
	Rect initial_window_rect;
	Boolean have_initial_window_rect;
	Boolean initial_window_visible;
	Boolean have_initial_window_visible;
	char init_font_name[256];
	short init_font_size;
	Style init_font_style;
	
	// static data for scrolling
	static WindowObject *current_WindowObject;
	static RoutineDescriptor my_scrollProcRD;
protected:
	// protected variables
	
public:
	// public methods
	WindowObject(void);
	virtual ~WindowObject(void);
	virtual OSErr init_ViewWindow(void *theAppObject);
	virtual void update_content_rects(Rect *portRect);
	virtual OSErr init_window(window_info_rec *the_window_info);	
	virtual void set_initial_window_name(char *name);
	virtual void set_initial_window_rect(Rect *r);
	virtual void set_initial_window_visible(Boolean visible);
	virtual void set_initial_font_info(char *name, short size, Style style);
	virtual WindowPtr create_window(WindowPeek wp, Rect *initial_rect,
									StringPtr window_name, short procID);
	virtual OSErr do_init_view(window_info_rec *the_window_info,
							   ViewObject *theView);
	virtual OSErr create_controls(void);
	virtual OSErr add_control(ControlHandle theHandle, long reference,
							  short hilite_value, control_info **info_ptr);
	virtual void delete_my_control_recs(void);
	virtual void do_added_control_click(control_info *cptr, Point where);
	virtual Boolean mouse_in_text(Point mouseloc);
	virtual void draw_window(void);
	virtual void draw_background(RgnHandle background_region);
	virtual void draw_contents(RgnHandle updateRegion,
							   ViewObject *theView);
	virtual void draw_scroll_area(short idx);
	virtual void do_null_event(void);
	virtual Boolean do_click(Point where, EventRecord *theEvent);
	virtual Boolean handle_click_on_view(short idx);
	virtual Boolean do_control_click(Point where, short part_code,
									 ControlHandle theControl, short idx);
	virtual void do_scroll_click(Point where, short part_code,
								 ControlHandle theControl, short idx);
	virtual void deactivate_controls(void);
	virtual void activate_controls(void);
	void change_control_hilite(control_info *cptr, short new_value);
	virtual void save_cursor_state(void);
	virtual void restore_cursor_state(Boolean *app_TEActive, 
									  Boolean *app_waitcursor,
									  Boolean *app_ibeamcursor);
	virtual void save_menu_state(void);
	virtual void restore_menu_state(short *font_item, 
									short *size_item,
									short *style_bits);
	virtual void import_scrap(void);
	virtual void export_scrap(void);
	virtual void update_window_rects(Boolean autoScroll);
	virtual void adjust_scroll_bars(Boolean autoScroll, short idx);
	virtual void adjust_all_scroll_settings(Boolean autoScroll);
	virtual void adjust_scroll_settings(Boolean autoScroll, short idx);
	virtual void get_content_size(long *height, long *width,
								  ViewObject *theView);
	virtual void resize_scroll_draw(Boolean before_resize);
	virtual void adjust_view_rect(short idx);
	virtual void define_new_font(short app_font_item, short font_number);
	virtual void define_new_pointsize(short app_size_item, short font_size);
	virtual void define_new_style(short app_style_bits, Style new_style);
	virtual void do_TEFunction(short theFunction);
	virtual void get_edit_flags(Boolean *cut_ok, Boolean *copy_ok,
								Boolean *paste_ok, Boolean *clear_ok);
	virtual void get_undo_status(Boolean *undo_ok, char *undo_text);
	virtual void do_key_down(EventRecord *theEvent);
	virtual	void hide(void);
	virtual void show(void);
	virtual Boolean is_visible(void);
	virtual OSErr TrackDrag(DragTrackingMessage theMessage,
							DragReference theDrag);
	virtual OSErr ReceiveDrag(DragReference theDrag);
	virtual void handle_view_changed(short idx);
	virtual void handle_style_changed(short idx);
	virtual void scroll_draw(short new_value, Boolean hScroll, short idx);
	virtual void adjust_scroll_rect(short idx);
	virtual void window_scrollProc(ControlHandle theControl, short partCode);
	virtual void calc_scroll_value(ControlHandle theControl, short scrollDistance,
								  short *new_value, Boolean *changed);
	static pascal void my_scrollProc(ControlHandle theControl, short partCode);
protected:
	// protected methods
};
