// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: apputils.c,v $
// Revision 1.3.2.1  1999/05/18 03:27:24  sampo
// large block support added to mac configuration
//
// Revision 1.3  1999/01/17 18:27:04  sampo
// 3rd round fba changes
//
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:13:36  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *apputils_c(void) {
return "@(#)$Id: apputils.c,v 1.3.2.1 1999/05/18 03:27:24 sampo Exp $"; }
#endif

#include "macdefs.h"
#include <Icons.h>
#include "resdefs.h"
#include "apputils.h"

static RGBColor RGBGray = {0x8000, 0x8000, 0x8000};
static RGBColor realblack = {0, 0, 0};
static RGBColor realwhite = {0xffff, 0xffff, 0xffff};
static GrafPtr alert_front_window = 0;

RoutineDescriptor DlgFilter0RD =
	BUILD_ROUTINE_DESCRIPTOR(uppModalFilterProcInfo, DlgFilter0);
RoutineDescriptor DlgFilter1RD =
	BUILD_ROUTINE_DESCRIPTOR(uppModalFilterProcInfo, DlgFilter1);
RoutineDescriptor DlgFilter2RD =
	BUILD_ROUTINE_DESCRIPTOR(uppModalFilterProcInfo, DlgFilter2);
RoutineDescriptor DlgFilter3RD =
	BUILD_ROUTINE_DESCRIPTOR(uppModalFilterProcInfo, DlgFilter3);

Boolean waitcursor;			// true for watch cursor
Boolean ibeamcursor;		// true for I-beam cursor

StringPtr GetRString(StringPtr theString, int theIndex)
{
theString[0] = 0;
GetIndString(theString, kConfigResourceNum, theIndex);
theString[*theString+1] = 0;
return(theString);
}

void GetEString(StringPtr theString, int theIndex)
{
theString[0] = 0;
GetIndString(theString, kErrorResourceNum, theIndex);
p2cstr(theString);
}

long GetRLong(int index)
{
Str255 scratch;
long aLong;
	
GetRString(scratch, index);
if (scratch[0] == 0) {
	return(0L);
	}
else {
	StringToNum(scratch, &aLong);
	return(aLong);
	}
}

short GetResDWRD(OSType type, short resnum)
{
Handle reshandle;
short result;

reshandle = GetResource(type, resnum);
if (reshandle == 0) return(0);
result = **(short**)reshandle;
return(result);
}

long GetResLWRD(OSType type, short resnum)
{
Handle reshandle;
long result;

reshandle = GetResource(type, resnum);
if (reshandle == 0) return(0);
result = **(long**)reshandle;
return(result);
}

void enable_menu_item(MenuHandle theMenu, short item,
					  char enableflag)
{
if (enableflag) {
	EnableItem(theMenu, item);
	}
else {
	DisableItem(theMenu, item);
	}
}

void notifyuser(Boolean notifyavail, Boolean *nmrec_installed,
				NMRec *my_nmrec)
{
OSErr rc;

if (notifyavail) {
	if (*nmrec_installed) return;	/* shouldn't happen */
	memset(my_nmrec, 0, sizeof(NMRec));
	my_nmrec->qType = nmType;
	my_nmrec->nmMark = 1;
	my_nmrec->nmIcon = GetResource('SICN', kAppFREFNum);
	my_nmrec->nmSound = (Handle)-1;
	rc = NMInstall(my_nmrec);
	if (rc == noErr) {
		*nmrec_installed = true;
		}
	else {
		SysBeep(2);
		}
	}
else {
	SysBeep(2);
	}
}

void std_showerr(char *s, GrafPtr front_window)
{
std_showmsg(s, front_window, STOP_ALERT_KIND);
}

void std_showmsg(char *s, GrafPtr front_window, short alert_kind)
{
static unsigned char nullstr[1] = {0};
OSErr rc;

c2pstr(s);
ParamText((unsigned char *)s, nullstr, nullstr, nullstr);
p2cstr((unsigned char *)s);
rc = alert_text_adjust(kShowerrAlert, 2, 2, 1, 0, 0, 0, 0, 0);
ctralrt(kShowerrAlert, kCenterDefault);
alert_front_window = front_window;
#if GENERATINGPOWERPC
switch (alert_kind) {
	case NOTE_ALERT_KIND:
			NoteAlert(kShowerrAlert, (ModalFilterUPP)&DlgFilter0RD);
			break;
	case CAUTION_ALERT_KIND:
			CautionAlert(kShowerrAlert, (ModalFilterUPP)&DlgFilter0RD);
			break;
	default:
			StopAlert(kShowerrAlert, (ModalFilterUPP)&DlgFilter0RD);
			break;
	}
#else
switch (alert_kind) {
	case NOTE_ALERT_KIND:
			NoteAlert(kShowerrAlert, (ModalFilterUPP)DlgFilter0);
			break;
	case CAUTION_ALERT_KIND:
			CautionAlert(kShowerrAlert, (ModalFilterUPP)DlgFilter0);
			break;
	default:
			StopAlert(kShowerrAlert, (ModalFilterUPP)DlgFilter0);
			break;
	}
#endif
alert_front_window = 0;
ParamText(nullstr, nullstr, nullstr, nullstr);
/* activate_controls(); */  /* activate event will do this */
}

void show_message_string(short error_index, WindowPtr front_window,
						 short alert_kind)
{
char error_text[256];

GetEString((StringPtr)error_text, error_index);
std_showmsg(error_text, front_window, alert_kind);
}

void show_error_string(short error_index, WindowPtr front_window)
{
#ifdef MAC_GUI
char error_text[256];

GetEString((StringPtr)error_text, error_index);
std_showerr(error_text, front_window);
#endif
}

void ctralrt(short alertnum, short c_denom)
{				/* alert number */
Handle reshnd;
struct Rect * rptr;
short scrhsize, scrvsize;
short ahsize, avsize;
short mb_height;

mb_height = get_mbar_height();
reshnd = GetResource('ALRT', alertnum);
if (reshnd == 0) return;
rptr = (struct Rect *)*reshnd;
scrhsize = qd.screenBits.bounds.right - qd.screenBits.bounds.left;
scrvsize = qd.screenBits.bounds.bottom - qd.screenBits.bounds.top - mb_height;
ahsize = rptr->right - rptr->left;
avsize = rptr->bottom - rptr->top;
rptr->top = (scrvsize-avsize)/c_denom + qd.screenBits.bounds.top + mb_height;
if (rptr->top < (mb_height + kAlertBorderHeight)) {
	rptr->top = mb_height + kAlertBorderHeight;
	}
rptr->left = (scrhsize-ahsize)/2 + qd.screenBits.bounds.left;
rptr->bottom = rptr->top + avsize;
rptr->right = rptr->left + ahsize;
}

void ctrwindow(GrafPtr wp, short c_denom, short border_height,
			   short h_offset, short v_offset)
{
short scrhsize, scrvsize;
short whsize, wvsize;
short newtop, newbottom;
short mb_height;

mb_height = get_mbar_height();
scrhsize = qd.screenBits.bounds.right - qd.screenBits.bounds.left;
scrvsize = qd.screenBits.bounds.bottom - qd.screenBits.bounds.top - mb_height;
whsize = wp->portRect.right - wp->portRect.left;
wvsize = wp->portRect.bottom - wp->portRect.top;
newtop = (scrvsize-wvsize)/c_denom + qd.screenBits.bounds.top + mb_height
		  + v_offset;
newbottom = newtop + wvsize;
if (newbottom > qd.screenBits.bounds.bottom) {
	newtop = qd.screenBits.bounds.bottom - wvsize;
	}
if (newtop < (mb_height + border_height)) {
	newtop = mb_height + border_height;
	}
MoveWindow(wp, (scrhsize-whsize)/2 + qd.screenBits.bounds.left + h_offset,
		   newtop, 0);
}

void ctrstdfile(short dlgnum, Point *p, Boolean small_screen,
				Rect *screen_rect, short c_denom)
{
Handle reshnd;
struct Rect * rptr;
short scrhsize, scrvsize;
short dhsize, dvsize;
short mb_height;

mb_height = get_mbar_height();
reshnd = GetResource('DLOG', dlgnum);
if (reshnd == 0) {
	switch(dlgnum) {
		case myGetDlgID:
				(*p).h = (screen_rect->right-screen_rect->left-359)/2;
				if (small_screen) {
					(*p).v = (screen_rect->bottom-screen_rect->top-233)/2;
					}
				else {
					(*p).v = (screen_rect->bottom-screen_rect->top-233)/c_denom;
					}
				break;
		case myPutDlgID:
				(*p).h = (screen_rect->right-screen_rect->left-304)/2;
				if (small_screen) {
					(*p).v = (screen_rect->bottom-screen_rect->top-234)/2;
					}
				else {
					(*p).v = (screen_rect->bottom-screen_rect->top-234)/c_denom;
					}
				break;
		case putDlgID:
				(*p).h = (screen_rect->right-screen_rect->left-304)/2;
				if (small_screen) {
					(*p).v = (screen_rect->bottom-screen_rect->top-184)/2;
					}
				else {
					(*p).v = (screen_rect->bottom-screen_rect->top-184)/c_denom;
					}
				break;
		case getDlgID:
		default:
				(*p).h = (screen_rect->right-screen_rect->left-348)/2;
				if (small_screen) {
					(*p).v = (screen_rect->bottom-screen_rect->top-200)/2;
					}
				else {
					(*p).v = (screen_rect->bottom-screen_rect->top-200)/c_denom;
					}
				break;
		}
	return;
	}

rptr = (struct Rect *)*reshnd;
scrhsize = qd.screenBits.bounds.right - qd.screenBits.bounds.left;
scrvsize = qd.screenBits.bounds.bottom - qd.screenBits.bounds.top - mb_height;
dhsize = rptr->right - rptr->left;
dvsize = rptr->bottom - rptr->top;
(*p).v = (scrvsize-dvsize)/c_denom + qd.screenBits.bounds.top + 13 + mb_height;
if ((*p).v < (mb_height + kStdFileBorderHeight)) {
	(*p).v = mb_height + kStdFileBorderHeight;
	}
(*p).h = (scrhsize-dhsize)/2 + qd.screenBits.bounds.left;
}

short get_mbar_height(void)
{
static short mb_height = 0;

if (mb_height != 0) return(mb_height);

mb_height = LMGetMBarHeight();
if (mb_height <= 0) mb_height = kDefaultMBarHeight;
return(mb_height);
}

void clip_rect(Rect *clipRect, Rect *limitRect, Boolean includeScroll)
{
short height, width, max_height, max_width, min_height, min_width;

min_height = limitRect->top;
min_width = limitRect->left;
max_height = limitRect->bottom - 1;
max_width = limitRect->right - 1;
if (includeScroll) {
	max_height -= 15;
	max_width -= 15;
	min_height -= 15;
	min_width -= 15;
	}
height = clipRect->bottom - clipRect->top;
width = clipRect->right - clipRect->left;
if (height < min_height) {
	height = min_height;
	}
if (width < min_width) {
	width = min_width;
	}
if (height > max_height) {
	height = max_height;
	}
if (width > max_width) {
	width = max_width;
	}
clipRect->top = clipRect->left = 0;
clipRect->bottom = height;
clipRect->right = width;
if (includeScroll) {
	clipRect->bottom += 15;
	clipRect->right += 15;
	}
}
void framedflt(DialogPtr dlgptr, Boolean color_mac)
{
short gtype;
Handle gitem;
Rect gbox;
GrafPtr gp;

GetDialogItem(dlgptr, 1, &gtype, &gitem, &gbox);
GetPort(&gp);
SetPort(dlgptr);
OutlineButton((ControlHandle)gitem, colordialog(dlgptr, color_mac));
SetPort(gp);
}

Boolean colordialog(DialogPtr dialogwindow, Boolean color_mac)
{
char colorport;
PixMapHandle portpix;

if (!color_mac) return(false);
colorport =
	((((GrafPtr)dialogwindow)->portBits.rowBytes & 0xc000) == 0xc000);
if (!colorport) return(false);
portpix = ((CGrafPtr)dialogwindow)->portPixMap;
return((*portpix)->pixelSize > 1);
}

void get_port_color_info(Boolean color_mac, SInt16 *depth, Boolean *isColor)
{
GrafPtr thePort;
Boolean colorport;
PixMapHandle portpix;
GDHandle theGDev;
unsigned short gdFlags;

*depth = 1;
*isColor = false;

if (!color_mac) return;

GetPort(&thePort);
colorport =
	(((thePort)->portBits.rowBytes & 0xc000) == 0xc000);
if (!colorport) return;

portpix = ((CGrafPtr)thePort)->portPixMap;
*depth = (*portpix)->pixelSize;

theGDev = GetGDevice();
gdFlags = (*theGDev)->gdFlags;
*isColor = (gdFlags & 0x01) == 0x01;
}

void myPlotIconID(Rect *iconrect, short plotalign, short plottype,
			 short iconresnum, Boolean color_mac)
{
#pragma unused (plotalign)
Handle iconhandle;
long iconbits[32];			/* use long to ensure alignment */
BitMap iconmap;
GrafPtr gp;
char colorok;
RGBColor rgbforesave, rgbbacksave;
PenState savedstate;

/* first plot the icon */
iconhandle = GetResource('ICN#', iconresnum);
if (iconhandle == 0) return;
memcpy(iconbits, *iconhandle, 128);
iconmap.baseAddr = (char *)iconbits;
iconmap.rowBytes = 4;
iconmap.bounds.top = iconmap.bounds.left = 0;
iconmap.bounds.bottom = iconmap.bounds.right = 32;
GetPort(&gp);
colorok = colordialog((DialogPtr)gp, color_mac);
if (colorok) {
	GetForeColor(&rgbforesave);
	GetBackColor(&rgbbacksave);
	RGBBackColor(&realwhite);
	if (plottype == kTransformDisabled) {
		RGBForeColor(&RGBGray);
		}
	else {
		RGBForeColor(&realblack);
		}
	}
EraseRect(iconrect);
CopyBits(&iconmap, &gp->portBits,
		 &iconmap.bounds, iconrect, srcOr, 0);

if (plottype == kTransformNone) {
	if (colorok) {
		RGBBackColor(&rgbbacksave);
		RGBForeColor(&rgbforesave);
		}
	return;
	}

if (plottype == kTransformDisabled) {
	if (colorok) {
		RGBBackColor(&rgbbacksave);
		RGBForeColor(&rgbforesave);
		return;
		}
	GetPenState(&savedstate);
	PenMode(notPatBic);
	PenPat(&qd.gray);
	PaintRect(iconrect);
	SetPenState(&savedstate);
	return;
	}

if (plottype == kTransformSelected) {
	memcpy(iconbits, (*iconhandle)+128, 128);
	CopyBits(&iconmap, &gp->portBits,
			 &iconmap.bounds, iconrect, srcXor, 0);
	if (colorok) {
		RGBBackColor(&rgbbacksave);
		RGBForeColor(&rgbforesave);
		}
	}
}

void OutlineButton(ControlHandle button, Boolean usecolor)
{
/* This routine provided by Macintosh DTS: */
 
/*	Given any control handle, this will draw an outline around it.  This is
	used for the default button of a window.  The extra nice feature here is
	that I'll erase the outline for buttons that are inactive.  Seems like
	there should be a Toolbox call for getting a control's hilite state.
	Since there isn't, I have to look into the control record myself.	This
	should be called for update and activate events.
 
	The method for determining the oval diameters for the roundrect is a
	little different than that recommended by Inside Mac.	IM I-407 suggests
	that you use a hardcoded (16,16) for the diameters. However, this only
	looks good for small roundrects. For larger ones, the outline doesn't
	follow the inner roundrect because the CDEF for simple buttons doesn't
	use (16,16). Instead, it uses half the height of the button as the
	diameter. By using this formula, too, our outlines look better.			*/
 
/*	WARNING: This will set the current port to the control's window.		*/
 
Rect theRect;
PenState curPen;
/* short buttonOval; */
RGBColor rgbsave;
		
if (button != 0) {
	/* SetPort((*button)->contrlOwner); */ /* done by caller */
	GetPenState(&curPen);
	PenNormal();
	if (usecolor) {
		GetForeColor(&rgbsave);
		RGBForeColor(&realblack);
		}
	theRect = (*button)->contrlRect;
	InsetRect(&theRect, kButtonFrameInset, kButtonFrameInset);
	/* buttonOval = (theRect.bottom - theRect.top) / 2; */
	if ((*button)->contrlHilite == 0) {
		PenPat(&qd.black);
		if (usecolor) {
			RGBForeColor(&realblack);
			}
		}
	else {
		if (usecolor) {
			PenPat(&qd.black);
			RGBForeColor(&RGBGray);
			}
		else {
			PenPat(&qd.gray);
			}
		}
	PenSize(kButtonFrameSize, kButtonFrameSize);
	/* FrameRoundRect(&theRect, buttonOval, buttonOval); */
	FrameRoundRect(&theRect, kButtonOvalSize, kButtonOvalSize);
	if (usecolor) {
		RGBForeColor(&rgbsave);
		}
	SetPenState(&curPen);
	}
}

// set_initial_zoom modifies the window state data so that the initial
// window size is always available f

void set_initial_zoom(WindowPtr theWindow)
{
WStateData * wsptr;
short adj;
Rect pRect;

if (((WindowPeek)theWindow)->dataHandle == 0) {
	return;				// can't zoom
	}
wsptr = (struct WStateData *)(*(((WindowPeek)theWindow)->dataHandle));
GetGlobalRect(theWindow, &pRect);
wsptr->stdState = pRect;
adj = (pRect.bottom - pRect.top) / 4;
wsptr->userState.top = pRect.top + adj;
wsptr->userState.bottom = pRect.bottom - adj;
adj = (pRect.right - pRect.left) / 4;
wsptr->userState.left = pRect.left + adj;
wsptr->userState.right = pRect.right - adj;
}

void GetGlobalRect(WindowPtr window, Rect *globalRect)
{
GrafPtr gp;

GetPort(&gp);
SetPort(window);
(*globalRect) = window->portRect;
LocalToGlobal((Point *)(&(globalRect->top)));
LocalToGlobal((Point *)(&(globalRect->bottom)));
SetPort(gp);
}

OSErr dialog_text_adjust(DialogPtr dlgptr, short textitem,
						 short minheight,
						 short item1, short item2, short item3,
						 short item4, short item5, short item6)
{
return(item_text_adjust(0, dlgptr, 0, textitem, minheight,
						item1, item2, item3, item4, item5, item6));
}

OSErr alert_text_adjust(short alertnum, short textitem,
						short minheight,
						short item1, short item2, short item3,
						short item4, short item5, short item6)
{
return(item_text_adjust(1, 0, alertnum, textitem, minheight,
						item1, item2, item3, item4, item5, item6));
}

OSErr item_text_adjust(char alertflag, DialogPtr dlgptr, short alertnum,
					   short textitem, short minheight,
					   short item1, short item2, short item3,
					   short item4, short item5, short item6)
{
AlertTHndl alerthandle;
ItemTHndl ditlhandle;
ItemIPtr textinfoptr;
short itemtype;
Handle itemhandle;
Rect textitemrect;
Rect drawrect, windowrect;
OSErr rc;
GrafPort mp;
GrafPtr gp;
unsigned char *portmapptr;
TEHandle th;
unsigned char textbuff[256];
short lineheight, totalheight, adjustment;

										/* get text item rectangle and text */
if (alertflag) {
	alerthandle = (AlertTHndl)GetResource('ALRT', alertnum);
	if (alerthandle == 0) return(resNotFound);

	ditlhandle = (ItemTHndl)GetResource('DITL', (*alerthandle)->itemsID);
	if (ditlhandle == 0) return(resNotFound);

	rc = getdlgtextitem(ditlhandle, textitem, &textitemrect, textbuff);
	if (rc != noErr) return(rc);
	}
else {
	GetDialogItem(dlgptr, textitem, &itemtype, &itemhandle, &textitemrect);
	GetDialogItemText(itemhandle, textbuff);
	}

										/* compute rectangle to draw text in */
drawrect.left = drawrect.top = 0;
drawrect.right = textitemrect.right - textitemrect.left;
drawrect.bottom = 192;					/* space for up to 12 lines */

										/* define port to draw in */
rc = dlgnewmap(&mp, &drawrect, &portmapptr);
if (rc != noErr) {
	return(rc);
	}
GetPort(&gp);
SetPort(&mp);
										/* have TextEdit draw text */
th = TENew(&drawrect, &drawrect);
if (th == 0) {
	SetPort(gp);
	ClosePort(&mp);
	DisposePtr((Ptr)portmapptr);
	return(1);
	}

define_text(textbuff, th);		/* set text, with ParamText substitution */
								/* get height from TextEdit */

lineheight = (*th)->lineHeight;
totalheight = lineheight * (*th)->nLines;

								/* now done with TextEdit */
TEDispose(th);
SetPort(gp);
ClosePort(&mp);
DisposePtr((Ptr)portmapptr);

								/* make adjustments for minheight */
if (minheight > 0) {
	minheight *= lineheight;
	if (totalheight < minheight) totalheight = minheight;
	}

								/* adjust items */
adjustment = totalheight - textitemrect.bottom + textitemrect.top;
if (alertflag) {
	rc = getdlgitem(ditlhandle, textitem, &textinfoptr);
	if (rc != noErr) return(rc);
	textinfoptr->itemrect.bottom += adjustment;
	adjustalrtitem(ditlhandle, item1, adjustment);
	adjustalrtitem(ditlhandle, item2, adjustment);
	adjustalrtitem(ditlhandle, item3, adjustment);
	adjustalrtitem(ditlhandle, item4, adjustment);
	adjustalrtitem(ditlhandle, item5, adjustment);
	adjustalrtitem(ditlhandle, item6, adjustment);
	}
else {
	textitemrect.bottom += adjustment;
	SetDialogItem(dlgptr, textitem, itemtype, itemhandle, &textitemrect);
	adjustitem(dlgptr, item1, adjustment);
	adjustitem(dlgptr, item2, adjustment);
	adjustitem(dlgptr, item3, adjustment);
	adjustitem(dlgptr, item4, adjustment);
	adjustitem(dlgptr, item5, adjustment);
	adjustitem(dlgptr, item6, adjustment);
	}
								/* adjust dialog window size */
if (alertflag) {
	(*alerthandle)->boundsRect.bottom += adjustment;
	}
else {
	windowrect = ((GrafPtr)dlgptr)->portRect;
	windowrect.bottom += adjustment;
	SizeWindow((WindowPtr)dlgptr, windowrect.right - windowrect.left,
		   		windowrect.bottom - windowrect.top, false);
	}
return(noErr);
}

void define_text(unsigned char *textbuff, TEHandle th)
{
short i, textlen, telength;
register unsigned char c;
unsigned char lastchar;
short start, len;
									/* handles to paramtext values */
unsigned char **parmhandle;			/* note: can't use "Handle" here because */
unsigned char parmtext[256];		/* "unsigned" is necessary!				 */
short parmlength;

textlen = textbuff[0];
if (textlen == 0) return;

c = 0;				/* dummy last character */
start = 1;			/* start and length of string we're accumulating */
len = 0;
telength = 0;		/* length of text in TextEdit record */

for (i=1; i < textlen+1; i++) { 
	lastchar = c;	
	c = textbuff[i];
	if (lastchar == '^') {
		switch(c) {
			case '0':
			case '1':
			case '2':
			case '3':
						len--;			/* don't include previous "^" */
										/* add text up to this point */
						if (len > 0) {
							TEInsert(textbuff+start, (long)len, th);
							telength += len;
							TESetSelect((long)telength, (long)telength, th);
							}
										/* add param text */
						parmhandle = LMGetDAStrings(c - '0');
						if (parmhandle != 0) {
							parmlength = (*parmhandle)[0];
							if (parmlength > 0) {
								memcpy(parmtext, (*parmhandle)+1, parmlength);
								TEInsert(parmtext, (long)parmlength, th);
								telength += parmlength;
								TESetSelect((long)telength, (long)telength, th);
								}
							}
										/* update control variables */
						start = i+1;
						len = 0;
						break;
			default:					/* add as usual */
						len++;
						break;
			}
		}
	else {				/* lastchar not "^": just count character */
		len++;
		}
	}

if (len > 0) {
	TEInsert(textbuff+start, (long)len, th);
	telength += len;
	TESetSelect((long)telength, (long)telength, th);
	}
}

void define_text_buffer(unsigned char **textbuff, unsigned char *resultbuff,
						short maxresultlen, short *resultlen)
{
short i, textlen;
register unsigned char c;
unsigned char lastchar;
short start, len;
									/* handles to paramtext values */
unsigned char **parmhandle;			/* note: can't use "Handle" here because */
									/* "unsigned" is necessary!				 */
short parmlength;
short usedlen, availlen;

textlen = (*textbuff)[0];
if (textlen == 0) return;

c = 0;				/* dummy last character */
start = 1;			/* start and length of string we're accumulating */
len = 0;
usedlen = 0;				/* length of buffer used */
availlen = maxresultlen;	/* length of buffer available */

for (i=1; i < textlen+1; i++) { 
	lastchar = c;	
	c = (*textbuff)[i];
	if (lastchar == '^') {
		switch(c) {
			case '0':
			case '1':
			case '2':
			case '3':
						len--;			/* don't include previous "^" */
										/* add text up to this point */
						if (len > 0) {
							if (len > availlen) len = availlen;
							memcpy(resultbuff+usedlen, (*textbuff)+start, len);
							usedlen += len;
							availlen -= len;
							if (availlen == 0) {
								(*resultlen) = usedlen;
								return;
								}
							}
										/* add param text */
						parmhandle = LMGetDAStrings(c - '0');
						if (parmhandle != 0) {
							parmlength = (*parmhandle)[0];
							if (parmlength > 0) {
								if (parmlength > availlen) parmlength = availlen;
								memcpy(resultbuff+usedlen, (*parmhandle)+1, parmlength);
								usedlen += parmlength;
								availlen -= parmlength;
								if (availlen == 0) {
									(*resultlen) = usedlen;
									return;
									}
								}
							}
										/* update control variables */
						start = i+1;
						len = 0;
						break;
			default:					/* add as usual */
						len++;
						break;
			}
		}
	else {				/* lastchar not "^": just count character */
		len++;
		}
	}

if (len > 0) {
	if (len > availlen) len = availlen;
	memcpy(resultbuff+usedlen, (*textbuff)+start, len);
	usedlen += len;
	}
(*resultlen) = usedlen;
}

void adjustitem(DialogPtr dlgptr, short itemno, short adjustment)
{
short itemtype;
Handle itemhandle;
Rect itembox;

if (itemno == 0) return;
GetDialogItem(dlgptr, itemno, &itemtype, &itemhandle, &itembox);
itembox.top += adjustment;
itembox.bottom += adjustment;
if (itemtype & ctrlItem) {
	MoveControl((ControlHandle)itemhandle, itembox.left, itembox.top);
	}
SetDialogItem(dlgptr, itemno, itemtype, itemhandle, &itembox);
}

void adjustalrtitem(ItemTHndl ditlhandle, short itemno, short adjustment)
{
OSErr rc;
ItemIPtr infoptr;

if (itemno == 0) return;
rc = getdlgitem(ditlhandle, itemno, &infoptr);
if (rc != noErr) return;
infoptr->itemrect.top += adjustment;
infoptr->itemrect.bottom += adjustment;
}

OSErr getdlgtextitem(ItemTHndl itemhandle, short itemnum,
					 Rect *itemrect, unsigned char *textbuff)
{
OSErr rc;
union {
	ItemIPtr iptr;
	unsigned char *cptr;
	} pointers;
unsigned char itemkey;
										/* get pointer to item */
rc = getdlgitem(itemhandle, itemnum, &pointers.iptr);
if (rc != noErr) return(rc);
										/* check it's an item with text */
itemkey = pointers.iptr->key & 0x7f;
switch(itemkey) {
	case 4:									/* Button */
	case 5:									/* CheckBox */
	case 6:									/* RadioButton */
	case 8:									/* StaticText */
	case 16:								/* EditText */
				break;
	default:
				return(3);
	}
										/* return item Rect */	
*itemrect = pointers.iptr->itemrect;
										/* return item text */
textbuff[0] = pointers.iptr->length;
if (textbuff[0] > 0) {
	memcpy(textbuff+1, pointers.cptr + sizeof(ItemInfo), textbuff[0]);
	}
return(noErr);
}

OSErr getdlgitem(ItemTHndl itemhandle, short itemnum, ItemIPtr *infoptr)
{
union {
	ItemIPtr iptr;
	unsigned char *cptr;
	} pointers;
short skipcount;
short itemlength;

										/* check item number is valid */
if (itemnum < 1) return(1);
if (itemnum > (*itemhandle)->itemcount + 1) return(2);
pointers.iptr = &((*itemhandle)->firstitem);
										/* skip to requested item */
skipcount = itemnum - 1;
while (skipcount > 0) {
	itemlength = pointers.iptr->length + sizeof(ItemInfo);
	itemlength += itemlength & 0x01;
	pointers.cptr += itemlength;
	skipcount--;
	}
*infoptr = pointers.iptr;
return(noErr);
}

OSErr dlgnewmap(GrafPtr wp, Rect *box, unsigned char **mapptr)
{
BitMap dlgWriteMap;
Size mapsize;
GrafPtr gp;

dlgWriteMap.bounds = *box;
dlgWriteMap.rowBytes =
	(dlgWriteMap.bounds.right - dlgWriteMap.bounds.left + 7) >> 3;
if (dlgWriteMap.rowBytes%2) dlgWriteMap.rowBytes++;
mapsize = dlgWriteMap.bounds.bottom - dlgWriteMap.bounds.top;
mapsize = mapsize * dlgWriteMap.rowBytes;
(*mapptr) = (unsigned char *)NewPtr(mapsize);
if ((*mapptr) == 0L) return(4);
dlgWriteMap.baseAddr = (Ptr)(*mapptr);
wp->portRect = dlgWriteMap.bounds;
GetPort(&gp);
OpenPort(wp);
SetPortBits(&dlgWriteMap);
EraseRgn(wp->visRgn);
SetPort(gp);
return(0);
}

short getit(short item, DialogPtr dlgptr)
{
short gtype;
Handle gitem;
Rect gbox;
GetDialogItem(dlgptr, item, &gtype, &gitem, &gbox);
return (GetControlValue((ControlHandle)gitem));
}

void setit(short item, DialogPtr dlgptr, short code)
{
short gtype;
Handle gitem;
Rect gbox;

GetDialogItem(dlgptr, item, &gtype, &gitem, &gbox);
SetControlValue((ControlHandle)gitem, code);
}

void setactive(short item, DialogPtr dlgptr, char flag, char colormac)
{
short gtype;
Handle gitem;
Rect gbox;

GetDialogItem(dlgptr, item, &gtype, &gitem, &gbox);
if (flag) {
	HiliteControl((ControlHandle)gitem, 0);
	}
else {
	HiliteControl((ControlHandle)gitem, 255);
	}
if (item == 1) framedflt(dlgptr, colormac);
}

void settext(Handle gitem, char *new_text)
{
char current_text[256];

GetDialogItemText(gitem, (unsigned char *)current_text);
p2cstr((unsigned char *)current_text);
if (strcmp(current_text, new_text) == 0) {
	return;
	}
c2pstr(new_text);
SetDialogItemText(gitem, (unsigned char *)new_text);
p2cstr((unsigned char *)new_text);
}

void set_control_text(Handle gitem, char *new_text)
{
char current_text[256];

GetControlTitle((ControlHandle)gitem, (unsigned char *)current_text);
p2cstr((unsigned char *)current_text);
if (strcmp(current_text, new_text) == 0) {
	return;
	}
c2pstr(new_text);
SetControlTitle((ControlHandle)gitem, (unsigned char *)new_text);
p2cstr((unsigned char *)new_text);
}

void set_text_cursor(DialogPtr dlgptr, short item)
{
short gtype;
Handle gitem;
Rect gbox;
long r;
char s[256];

GetDialogItem(dlgptr,item , &gtype, &gitem, &gbox);
GetDialogItemText(gitem, (unsigned char *)s);
p2cstr((unsigned char *)s);
r = strlen(s);
SelectDialogItemText(dlgptr, item, r, r);
}

pascal Boolean DlgFilter0(DialogPtr dlg, EventRecord *eventptr,
						  short *itemptr)
{
return(myDlgFilter(dlg, eventptr, itemptr, 0));
}

pascal Boolean DlgFilter1(DialogPtr dlg, EventRecord *eventptr,
						  short *itemptr)
{
return(myDlgFilter(dlg, eventptr, itemptr, 1));
}

pascal Boolean DlgFilter2(DialogPtr dlg, EventRecord *eventptr,
						  short *itemptr)
{
return(myDlgFilter(dlg, eventptr, itemptr, 2));
}

pascal Boolean DlgFilter3(DialogPtr dlg, EventRecord *eventptr,
						  short *itemptr)
{
return(myDlgFilter(dlg, eventptr, itemptr, 3));
}

Boolean myDlgFilter(DialogPtr dlg, EventRecord *eventptr,
					short *itemptr, short cancelnum)
{
unsigned char i;
short gtype;
Handle gitem;
Rect gbox;
unsigned long ticklim;
char cmdkey;
unsigned char currenthilite;
GrafPtr gp;

if (alert_front_window != 0) {
	GetPort(&gp);
	SetPort(alert_front_window);
	DrawGrowIcon(alert_front_window);
	SetPort(gp);
	alert_front_window = 0;
	}

switch(eventptr->what) {
	case mouseDown:
		/* mousehit = eventptr->where; */
		return(0);
	case updateEvt:
		if (((DialogPtr)eventptr->message) != dlg) {
			do_filter_update((GrafPtr)eventptr->message);
			}
		return(0);
		break;
	case keyDown:
		i = (eventptr->message & 0x7f);	/* ascii code */
		cmdkey = (eventptr->modifiers & cmdKey) == cmdKey;
		if ((i == 0x03) || (i == 0x0d)) {
			GetDialogItem(dlg, 1, &gtype, &gitem, &gbox);
			currenthilite = (*(ControlHandle)gitem)->contrlHilite;
			if (currenthilite == 255) {	/* button disabled */
				SysBeep(3);
				eventptr->what = nullEvent;
				return(0);
				}
			HiliteControl((ControlHandle)gitem, kControlButtonPart);
			ticklim = LMGetTicks() + 8;
#pragma warn_possunwant off
			while (ticklim > LMGetTicks());
#pragma warn_possunwant reset
			HiliteControl((ControlHandle)gitem, 0);
			(*itemptr) = 1;
			return(-1);
			}
		else if ((i == 0x1b) || ((i == '.') && cmdkey)) {
			if (cancelnum == 0) {
				return(0);
				}
			GetDialogItem(dlg, cancelnum, &gtype, &gitem, &gbox);
			HiliteControl((ControlHandle)gitem, kControlButtonPart);
			ticklim = LMGetTicks() + 8;
#pragma warn_possunwant off
			while (ticklim > LMGetTicks());
#pragma warn_possunwant reset
			HiliteControl((ControlHandle)gitem, 0);
			(*itemptr) = cancelnum;
			return(-1);
			}
	default:
		return(0);
	}
}

void do_filter_update(GrafPtr thePort)
{
GrafPtr gp;

GetPort(&gp);
SetPort(thePort);
BeginUpdate(thePort);
EndUpdate(thePort);
SetPort(gp);
}

Boolean longSectRect(LongRect *r, LongRect *s)
{
if (r->right <= s->left) return(false);
if (s->right <= r->left) return(false);
if (r->bottom <= s->top) return(false);
if (s->bottom <= r->top) return(false);
return(true);
}

void mySetCursor(short cursor_type)
{
#ifdef MAC_GUI
static Boolean watchflag;
static short watchindex;
static unsigned long watchticks;
static CursHandle ibeamHandle;			// system I-beam cursor
static CursHandle watchHandles[8];		// watch cursors
short i;

switch(cursor_type) {
	case kInitCursor:
									// initialize watch cursors
						ibeamHandle = GetCursor(1);
						for (i=0; i < 8; i++) {
							watchHandles[i] = GetCursor(kWatchCursorResnum+i);
							}
									// watch cursor at start
						SetCursor(*(watchHandles[0]));
						watchflag = true;
						watchindex = 0;
						watchticks = LMGetTicks();						
									// set status variables
						waitcursor = true;
						ibeamcursor = false;
						break;
	case kNextCursor:
						if (!watchflag) break;
						if ((LMGetTicks() - watchticks) < 30) break;
						watchticks = LMGetTicks();
						watchindex++;
						if (watchindex > 7) watchindex = 0;
						SetCursor(*(watchHandles[watchindex]));
						break;
	case kArrowCursor:
						SetCursor(&qd.arrow);
						watchflag = false;
						break;
	case kWatchCursor:
						SetCursor(*(watchHandles[0]));
						watchflag = true;
						watchindex = 0;
						watchticks = LMGetTicks();						
						break;
	case kIbeamCursor:
						SetCursor(*ibeamHandle);
						watchflag = false;
						break;
	default:
						break;
	}
#endif
}

void redrawCursor(void)
{
if (waitcursor) {
	mySetCursor(kWatchCursor);
	}
else {
	if (ibeamcursor) {
		mySetCursor(kIbeamCursor);
		}
	else {
		mySetCursor(kArrowCursor);
		}
	}
}

OSErr get_res_handle(Handle *resultHandle, OSType resType, short resNum)
{
Handle resHandle;
OSErr rc;

resHandle = GetResource(resType, resNum);
if (resHandle == 0) {
	*resultHandle = 0;
	return(resNotFound);
	}

*resultHandle = resHandle;
rc = HandToHand(resultHandle);
if (rc != noErr) {
	*resultHandle = 0;
	return(rc);
	}
return(noErr);
}

short font_name_to_item(MenuHandle mh, char *font_name)
{
short numitems, i;
char item_name[256];

numitems = CountMItems(mh);
if (numitems == 0) return(0);
for (i = 1; i <= numitems; i++) {
	GetMenuItemText(mh, i, (StringPtr)item_name);
	p2cstr((StringPtr)item_name);
	if (strcmp(font_name, item_name) == 0) {
		return(i);
		}
	}
return(0);
}

short font_size_to_item(MenuHandle mh, short font_size)
{
short numitems, i;
char item_name[256];
long item_value;

numitems = CountMItems(mh);
if (numitems == 0) return(0);
for (i = 1; i <= numitems; i++) {
	GetMenuItemText(mh, i, (StringPtr)item_name);
	p2cstr((StringPtr)item_name);
	item_value = strtol(item_name, 0, 0);
	if (item_value == font_size) {
		return(i);
		}
	}
return(0);
}

void delete_rect_from_rgn(Rect *r, RgnHandle theRgn, RgnHandle workRgn)
{
RectRgn(workRgn, r);
DiffRgn(theRgn, workRgn, theRgn);
}

OSErr GetSystemVersion(short *major_version, char *version_text)
{
OSErr rc;
char version_string[16];
unsigned long gestalt_info;
short version_length;

version_text[0] = 0;
rc = Gestalt(gestaltSystemVersion, (long *)&gestalt_info);
if (rc == noErr) {
	sprintf(version_string, "%lx", gestalt_info);
	version_length = strlen(version_string);
	if (version_length > 2) {
		version_string[version_length + 2] = 0;
		version_string[version_length + 1] = version_string[version_length - 1];
		version_string[version_length] = '.';
		version_string[version_length - 1] = version_string[version_length - 2];
		version_string[version_length - 2] = '.';
		if (version_string[version_length + 1] == '0') {
			version_string[version_length] = 0;
			}
		}
	strcpy(version_text, version_string);
	*major_version = version_string[0] - '0';
	return(noErr);
	}
else {
	return(rc);
	}
}

/*	pstrcpy copies Pascal format strings.
*/

void pstrcpy (StringPtr to, StringPtr from)
{
	BlockMove(from, to, *from+1);
}

short myGetNumProcs(Boolean *haveFinder)
{
ProcessSerialNumber curProc;
short numProcs;
ProcessInfoRec procInfo;
OSErr rc;

numProcs = 0;
curProc.highLongOfPSN = 0;
curProc.lowLongOfPSN = kNoProcess;
*haveFinder = false;

while (GetNextProcess(&curProc)==noErr) {
	numProcs++;

	if (!(*haveFinder)) {
		procInfo.processInfoLength = sizeof(ProcessInfoRec);
		procInfo.processName = 0;
		procInfo.processAppSpec = 0;
		rc = GetProcessInformation(&curProc, &procInfo);
		if (rc == noErr) {
			if ((procInfo.processType == 'FNDR') &&
				(procInfo.processSignature == 'MACS')) {
				*haveFinder = true;
				}
			}
		}
	}

return numProcs;
}

/*void pause(short secs)
{
unsigned long tick_limit;

tick_limit = LMGetTicks() + secs * 60;
while (LMGetTicks() < tick_limit);
}*/
