// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: console_api.c,v $
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:13:57  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *console_api_c(void) {
return "@(#)$Id: console_api.c,v 1.2 1999/01/01 02:45:17 cramer Exp $"; }
#endif

#define DEFINE_CONSOLE_GLOBALS
#include "console_api.h"
#include "String.h"
#include "stdio.h"
#include "DrawGUI.h"

#include "macdefs.h"
#include <MP.h>
#include "WASTE.h"
#include "resdefs.h"
#include "apputils.h"
#include "window_info.h"
#include "PointerList.h"
#include "ViewObject.h"
#include "GUIView.h"
#include "WTextView.h"
#include "TextRscView.h"
#include "WindowObject.h"
#include "AppObject.h"
#include "ViewWindow.h"
#include "GUIWindow.h"
#include "WTextDisplayWindow.h"
#include "TextRscWindow.h"
#include "client.h"
#include "Mac_Client.h"
#include "RC5Dialogs.h"
#include "settings.h"
#include "my_settings.h"
#include "RC5App.h"

/*
 *	The following four functions provide the UI for the console package.
 *	Users wishing to replace SIOUX with their own console package need
 *	only provide the four functions below in a library.
 */

/*
 *	extern short InstallConsole(short fd);
 *
 *	Installs the Console package, this function will be called right
 *	before any read or write to one of the standard streams.
 *
 *	short fd:		The stream which we are reading/writing to/from.
 *	returns short:	0 no error occurred, anything else error.
 */
extern volatile unsigned long  SignalTriggered;
extern Boolean pending_console_data;
extern void YieldToMain(char force_events);
extern RC5App *theApp;
//extern short MP_active;

short InstallConsole(short fd)
{
#pragma unused (fd)
static Boolean did_init = false;
static short init_result;

if (!did_init) {
	did_init = true;
	messages.the_text = 0;
	messages.current_length = 0;
	messages.maximum_length = MSG_BUFFER_SIZE;
	commands.the_text = 0;
	commands.current_length = 0;
	commands.maximum_length = CMMD_BUFFER_SIZE;
	// attempt to allocate buffers
	messages.the_text = NewPtr(MSG_BUFFER_SIZE);
	if (messages.the_text == 0) {
		init_result = memFullErr;
		return(init_result);
		}
	commands.the_text = NewPtr(CMMD_BUFFER_SIZE);
	if (commands.the_text == 0) {
		init_result = memFullErr;
		return(init_result);
		}
	}

init_result = noErr;
return(init_result);
}

/*
 *	extern void RemoveConsole(void);
 *
 *	Removes the console package.  It is called after all other streams
 *	are closed and exit functions (installed by either atexit or _atexit)
 *	have been called.  Since there is no way to recover from an error,
 *	this function doesn't need to return any.
 */

void RemoveConsole(void)
{
if (messages.the_text != 0) {
	DisposePtr(messages.the_text);
	messages.the_text = 0;
	}
if (commands.the_text != 0) {
	DisposePtr(commands.the_text);
	commands.the_text = 0;
	}
}

/*
 *	extern long WriteCharsToConsole(char *buffer, long n);
 *
 *	Writes a stream of output to the Console window.  This function is
 *	called by write.
 *
 *	char *buffer:	Pointer to the buffer to be written.
 *	long n:			The length of the buffer to be written.
 *	returns short:	Actual number of characters written to the stream,
 *					-1 if an error occurred.
 */

long WriteCharsToConsole(char *the_text, long textlen)
{
long availlen;

if (textlen == 0) {
	return(0);
	}

availlen = messages.maximum_length - messages.current_length;
if (availlen <= 0) {
	return(0);
	}
if (availlen < textlen) {
	textlen = availlen;
	}
/*for (i = 0; i < textlen; i++) {
	if (the_text[i] == 0x0d) {
		messages.the_text[messages.current_length + i] = 0x0a;
		}
	else {
		messages.the_text[messages.current_length + i] = the_text[i];
		}
	}*/
strncpy(messages.the_text + messages.current_length, the_text, textlen);
messages.current_length += textlen;

pending_console_data = true;

return(textlen);
}

void ConsoleInputProc(char *the_text, long textlen)
{
long availlen;
long i;
char *destptr;
register char c;

availlen = commands.maximum_length - commands.current_length;
if (availlen <= 0) {
	SysBeep(1);
	return;
	}
if (availlen < textlen) {
	SysBeep(1);
	textlen = availlen;
	}
destptr = commands.the_text + commands.current_length;
for (i = 0; i < textlen; i++) {
	destptr[i] = c = the_text[i];
	if (c == 0x0d) {
		con_input_line_count++;
		}
	}
commands.current_length += textlen;
}

/*
 *	extern long ReadCharsFromConsole(char *buffer, long n);
 *
 *	Reads from the Console into a buffer.  This function is called by
 *	read.
 *
 *	char *buffer:	Pointer to the buffer which will recieve the input.
 *	long n:			The maximum amount of characters to be read (size of
 *					buffer).
 *	returns short:	Actual number of characters read from the stream,
 *					-1 if an error occurred.
 */

long ReadCharsFromConsole(char *buffer, long n)
{
long readlen, i;
long remainlen;
register char c;

if (commands.current_length < n) {
	readlen = commands.current_length;
	}
else {
	readlen = n;
	}

if (readlen == 0) {
	return(0);
	}

for (i = 0; i < readlen; i++) {
	buffer[i]= c = commands.the_text[i];
	if (c == 0x0d) {
		con_input_line_count--;
		}
	}

remainlen = commands.current_length - readlen;
memcpy(commands.the_text, commands.the_text + readlen, remainlen);
commands.current_length = remainlen;

return(readlen);
}

/*
 *	extern char *__ttyname(long fildes);
 *
 *	Return the name of the current terminal (only valid terminals are
 *	the standard stream (ie stdin, stdout, stderr).
 *
 *	long fildes:	The stream to query.
 *
 *	returns char*:	A pointer to static global data which contains a C string
 *					or NULL if the stream is not valid.
 */

extern char *__ttyname(long fildes)
{
#pragma unused (fildes)
	/* all streams have the same name */
	static char *__devicename = "console window";

	if (fildes >= 0 && fildes <= 2)
		return (__devicename);

	return (0L);
}

short SIOUXHandleOneEvent(EventRecord *userevent)
{
#pragma unused(userevent)
// provided for linker only- replaced by myDefaultSpin
SysBeep(1);
return(0);
}

/*
int myDefaultSpin(spin_msg msg, long arg)
{
	EventRecord	theEvent;
	long sleepTime	=	6;	// 1/10 of a second by default
	Boolean wne_result;

	if (SignalTriggered) goto interrupt;

	switch (msg) {
	case SP_SLEEP:
	case SP_SELECT:
		if (arg >= sleepTime)				// Only sleep if patience guaranteed
			break;
		// Otherwise, fall through	
	case SP_AUTO_SPIN:
		sleepTime = 0;
		break;
	default:
		break;
		}
		
if (sleepTime == 0) {
	YieldToMain(false);
	return 0;
	}

#if defined(MULTITHREAD)
// this is the code that executes while waiting for the threads to do work
YieldToMain(false);

#else
// waiting for net connection to open, etc.
if (pending_console_data) {
	theApp->update_log(false);
	}
wne_result = WaitNextEvent(everyEvent, &theEvent, sleepTime, 0L);
theApp->last_yield = LMGetTicks();
if (wne_result) {
	theApp->handle_one_event(&theEvent);
	}
else {
	theApp->handle_null_event();
	}
#endif

return 0;

interrupt:
#if defined(MULTITHREAD)
	while (MP_active) {
		YieldToMain(true);	// forcing events allows threads to run immediately
		}
#endif
	return -1;
} */

unsigned long mp_sleep(unsigned long seconds)
{
unsigned long end_ticks;

end_ticks = LMGetTicks() + seconds * 60;
while (LMGetTicks() < end_ticks) {
	MPYield();
	};

return(0);
}

/*
pascal void  SpinCursor(Cursors cursorKind)
{
#pragma unused (cursorKind)
} 

// GUSIDefaultSpin calls RotateCursor
pascal void RotateCursor(long counter)
{
#pragma unused (counter)
} */
