// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: window_info.h,v $
// Revision 1.2  1999/01/01 02:45:17  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 06:18:14  dicamillo
// First Checked In.
//

// window_info_rec is used when initializing a new window

struct window_info_rec {
	char window_name[256];
	Rect size_rect;				// for GrowWindow
	Rect drag_rect;				// for DragWindow
	Rect initial_rect;			// initial Rect for window creation
	Point offsets;				// offsets if offset_window is true
	short center_denominator;	// center 1 nth of the way from top
	Boolean color_window;		// use color
	Boolean offset_window;		// use offsets to adjust from center
	Boolean grow_window;		// handle grow icon
	Boolean drag_mgr_avail;		// Drag Manager present
	Boolean keep_initial_rect;	// use initial rect for location (& size)
	Boolean hide_window;		// don't show window after init
	short procID;				// procID for new window
	short TEVersion;			// version of TextEdit available
	};

typedef struct window_info_rec window_info_rec;	

// scrollinfo keeps control information for one set of scroll bars

struct scrollinfo {
	Rect h_Rect;
	Rect v_Rect;
	long h_Offset;
	long v_Offset;
	ControlHandle h_Handle;
	ControlHandle v_Handle;
	RgnHandle drawRgn;
	};

typedef struct scrollinfo scrollinfo;

typedef void (*InputProcPtr)(char *text, long length);
typedef void (*NewlineProcPtr)(void *theWindow);
