// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: GNEWatch.c,v $
// Revision 1.2  1999/01/01 02:45:18  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 03:55:43  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *GNEWatch_c(void) {
return "@(#)$Id: GNEWatch.c,v 1.2 1999/01/01 02:45:18 cramer Exp $"; }
#endif

#include <A4Stuff.h>

#define jGNEFilter 0x29a
#define Ticks 0x16a

void  *old_filter;
unsigned long last_event_ticks;

pascal OSErr mySelectorFunction(OSType selector, unsigned long **response);
asm void myFilter(void);

pascal void main(void)
{
void **filter_ptr;

EnterCodeResource();

// Set up GetNextEvent filter
last_event_ticks = 0;
filter_ptr = (void **)jGNEFilter;
old_filter = *filter_ptr;
*filter_ptr = myFilter;

// Set up our Gestalt selector
NewGestalt('RC5m', (SelectorFunctionUPP)mySelectorFunction);

ExitCodeResource();
}

pascal OSErr mySelectorFunction(OSType selector, unsigned long **response)
{
#pragma unused(selector)

EnterCodeResource();
*response = &last_event_ticks;
ExitCodeResource();
return(noErr);
}

asm void myFilter (void)
{
	subq	#4,sp					// reserve room for old filter addr
	movem.l	d0-d2/a0/a1/a4,-(sp)	// save registers
	jsr		SetCurrentA4			// set a4 (changes others)
	move.l	old_filter,24(sp)		// save old filter value
// at this point, a4 is set and registers may be used as needed
	move.l	16(sp),a1				// restore a1
	cmpi.w	#0,0(a1)				// check for null event
	beq.s	isnull					// skip if null
	move.l	Ticks,d0				// save current tick count
	move.l	d0,last_event_ticks
isnull:
// code for returning
	movem.l	(sp)+,d0-d2/a0/a1/a4	//restore registers
	tst.l	(sp)					//test old filter address
	bne.s	useold					//if non-zero use it
	addq	#4,sp					//else remove it from the stack
useold:
	rts								//return
}
