// $Log: charset.c,v $
// Revision 1.1  1998/12/15 05:47:54  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *charset_c(void) {
return "@(#)$Id: charset.c,v 1.1 1998/12/15 05:47:54 dicamillo Exp $"; }
#endif

/*----------------------------------------------------------------------------

	charset.c

	This reusable module deals with character set issues (currently only 
	ISO 8859-1, Latin-1).
	
	You must call the "InitLatin1" function to initialize this package before
	calling any of the other functions.
	
	Copyright  1994-1998, Northwestern University.

----------------------------------------------------------------------------*/

#include <string.h>

#include "charset.h"
#include "memutil.h"
#include "resutil.h"

static unsigned char **gLatin1ToMacTable = nil;
static unsigned char **gMacToLatin1Table = nil;



/*----------------------------------------------------------------------------
	InitLatin1
	
	Initialize Mac <--> Latin1 character set mapping.
	
	Entry:	resType = resource type of mapping tables (e.g., 'taBL').
			latin1ToMacID = resource id of Latin1 -> Mac table.
			macToLatin1ID = resource id of Mac -> Latin1 table.
----------------------------------------------------------------------------*/

OSErr InitLatin1 (OSType resType, short latin1ToMacID, short macToLatin1ID)
{
	OSErr err = noErr;

	err = MyGet1Resource(resType, latin1ToMacID, &gLatin1ToMacTable);
	if (err != noErr) return err;
	err = MyGet1Resource(resType, macToLatin1ID, &gMacToLatin1Table);
	if (err != noErr) return err;
	return noErr;
}



/*----------------------------------------------------------------------------
	MapLatin1ToMacPtr
	
	Map Latin-1 8 bit characters to Mac 8 bit characters.
	
	Entry:	ptr = pointer to text to be mapped.
			len = length of text.
	
	Exit:	function result = true if any 8 bit characters encountered.
----------------------------------------------------------------------------*/

Boolean MapLatin1ToMacPtr (char *ptr, long len)
{
	unsigned char *p, *pEnd;
	Boolean result = false;
	unsigned char *table;
	
	table = *gLatin1ToMacTable;
	for (p = (unsigned char*)ptr, pEnd = p + len; p < pEnd; p++) {
		if ((char)*p < 0) {
			*p = table[*p];
			result = true;
		}
	}
	return result;
}



/*----------------------------------------------------------------------------
	MapLatin1ToMacHandle
	
	Map Latin-1 8 bit characters to Mac 8 bit characters.
	
	Entry:	text = handle to text to be mapped.
	
	Exit:	function result = true if any 8 bit characters encountered.
----------------------------------------------------------------------------*/

Boolean MapLatin1ToMacHandle (Handle text)
{
	char state;
	Boolean result;
	
	state = MyHGetState(text);
	MyHLock(text);
	result = MapLatin1ToMacPtr(*text, MyGetHandleSize(text));
	MyHSetState(text, state);
	return result;
}



/*----------------------------------------------------------------------------
	MapLatin1ToMacStr
	
	Map Latin-1 8 bit characters to Mac 8 bit characters.
	
	Entry:	str1 = pointer to source string.
			str2 = pointer to destination string (may be same as str1).
	
	Exit:	function result = true if any 8 bit characters encountered.
----------------------------------------------------------------------------*/

void MapLatin1ToMacStr (char *str1, char *str2)
{
	unsigned char *p, *q;
	unsigned char *table;
	
	table = *gLatin1ToMacTable;
	for (p = (unsigned char*)str1, q = (unsigned char*)str2; *p != 0; p++, q++) {
		*q = table[*p];
	}
	*q = 0;
}	



/*----------------------------------------------------------------------------
	MapMacToLatin1Ptr
	
	Map Mac 8 bit characters to Latin-1 8 bit characters.
	
	Entry:	ptr = pointer to text to be mapped.
			len = length of text.
	
	Exit:	function result = true if any 8 bit characters encountered.
----------------------------------------------------------------------------*/

Boolean MapMacToLatin1Ptr (char *ptr, long len)
{
	unsigned char *p, *pEnd;
	Boolean result = false;
	unsigned char *table;

	table = *gMacToLatin1Table;
	for (p = (unsigned char*)ptr, pEnd = p + len; p < pEnd; p++) {
		if ((char)*p < 0) {
			*p = table[*p];
			result = true;
		}
	}
	return result;
}



/*----------------------------------------------------------------------------
	MapMacToLatin1Handle
	
	Map Mac 8 bit characters to Latin-1 8 bit characters.
	
	Entry:	text = handle to text to be mapped.
	
	Exit:	function result = true if any 8 bit characters encountered.
----------------------------------------------------------------------------*/

Boolean MapMacToLatin1Handle (Handle text)
{
	char state;
	Boolean result;
	
	state = MyHGetState(text);
	MyHLock(text);
	result = MapMacToLatin1Ptr(*text, MyGetHandleSize(text));
	MyHSetState(text, state);
	return result;
}
