// $Log: net.h,v $
// Revision 1.3  1999/01/01 02:45:18  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.2  1998/12/24 05:16:41  dicamillo
// Add support for ioctl and for specifying the connection timeout.
//
// Revision 1.1  1998/12/15 05:48:53  dicamillo
// First Checked In.
//

#ifndef __NET__
#define __NET__

#include "def.h"

#define netOpenDriverErr		100
#define netOpenStreamErr		101
#define netLostConnectionErr	102
#define netDNRErr				103
#define netTruncatedErr			104

typedef struct NetStreamPrivateData {
	char private_data[1];
} NetStreamPrivateData, **NetStreamRef;

typedef struct NetServerErrInfo {
	CStr255 command;
	CStr255 response;
	long responseCode;
} NetServerErrInfo;

typedef OSErr (*NetGiveTimeFunction) (void);
typedef void (*NetLogFunction) (char logEntryType, unsigned long serverAddr,
	unsigned short serverPort, unsigned short localPort, char *str);
typedef void (*NetDoOneResponse) (long responseCode, CStr255 response, Ptr userDataPtr);
typedef OSErr (*NetChunkFunction) (Ptr t, long tLen, Ptr userDataPtr,
	long *truncPos);

OSErr NetInit (NetGiveTimeFunction giveTime, NetLogFunction log, short numBuffs);
OSErr NetIdle (void);
OSErr NetTerm (void);

OSErr NetOpen (unsigned long addr, unsigned short port, Boolean getHello, Boolean latin1,
	NetStreamRef *stream, long *responseCode, CStr255 response);
OSErr NetNewStream(NetStreamRef *stream);
OSErr NetOpenStream (NetStreamRef stream, unsigned long addr,
	unsigned short port);
OSErr NetClose (NetStreamRef stream);
void NetCloseStream (NetStreamRef stream);
OSErr NetCommand (NetStreamRef stream, char *command, 
	long *responseCode, CStr255 response);
OSErr NetGetExtraResponse (NetStreamRef stream, long *responseCode, 
	CStr255 response);
OSErr NetBatchedCommands (NetStreamRef stream, Handle commands, 
	NetDoOneResponse doOneResponse, Ptr userDataPtr);
OSErr NetPutText (NetStreamRef stream, Handle text, Boolean munge);
OSErr NetGetText (NetStreamRef stream, Handle *text, 
	NetChunkFunction chunkFunction, Ptr userDataPtr);

OSErr NetFTPDataPassiveOpen (Boolean latin1, unsigned short *port, NetStreamRef *stream);
OSErr NetFTPDataClose (NetStreamRef stream);
OSErr NetFTPDataWaitForConnection (NetStreamRef stream);
OSErr NetPutFTPData (NetStreamRef stream, Boolean mapCR, Handle data);
OSErr NetGetFTPData (NetStreamRef stream, Boolean mapCR, Handle *data);

OSErr NetGetMyAddr (unsigned long *addr);
OSErr NetGetMyAddrStr (char *addrStr);
OSErr NetGetMyName (CStr255 name);
OSErr NetNameToAddr (char *name, unsigned short defaultPort, 
	unsigned long *addr, unsigned short *port);
OSErr NetNameToAddresses(char *name, unsigned long *addresses);
OSErr NetAddrToName (unsigned long addr, CStr255 name);

Boolean NetMacTCPDNROperationInProgress (void);
void NetGetServerErrInfo (NetStreamRef stream, NetServerErrInfo *serverErrInfo);
void NetGetStreamStats (NetStreamRef stream, long *bytesIn, long *bytesOut);
Boolean NetHaveOT (void);
short NetGetNumOpenStreams (void);

OSErr NetSend(NetStreamRef stream, Ptr data, unsigned short len, Boolean push);
OSErr NetRcv(NetStreamRef stream, Ptr data, unsigned short *len);
void NetSetConnTimeout(NetStreamRef stream, short seconds);
void NetSetBlocking(NetStreamRef stream, Boolean value);
Boolean NetGetBlocking(NetStreamRef stream);

#endif
