// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: gettime.c,v $
// Revision 1.6  1999/04/08 08:18:43  dicamillo
// DST adjustment needed after all
//
// Revision 1.5  1999/04/08 07:12:37  dicamillo
// Comment-out IsDaylightSavingsOn, since it isn't needed.
//
// Revision 1.4  1999/04/08 00:43:40  sampo
// sampo learns MacOS Toolbox date and time calls
//
// Revision 1.3  1999/01/01 02:45:18  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.2  1998/12/15 07:01:19  dicamillo
// Use "_" instead of "/" in Mac header file names for CVS.
//
// Revision 1.1  1998/12/15 05:36:43  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *gettime_c(void) {
return "@(#)$Id: gettime.c,v 1.6 1999/04/08 08:18:43 dicamillo Exp $"; }
#endif

#include <sys_time.h>
#include <OSUtils.h>
#include <LowMem.h>
//#include "MicrosecondTrap.h"

int gettimeofday_ticks(struct timeval *tp, struct timezone *dummy);
extern Boolean timing_active;
#define TICKS ((unsigned long *)0x16a)
#define TIME ((unsigned long *)0x20c)

#define K1E6 1000000

/*
int gettimeofday(struct timeval *tp, struct timezone *dummy)
{
static Boolean first_time = true;
static Boolean use_microseconds;
static unsigned long long micro_offset;
struct timeval TOD_val;
unsigned long long micro_time;

if (first_time) {
	first_time = false;
	// check for Microsecond trap
#if defined(MULTITHREAD)
	use_microseconds = false;
#else
	use_microseconds = MicrosecondTrapPresent();
#endif
	// save difference between time of day and microsecond timer
	if (use_microseconds) {
		Microseconds((UnsignedWide *)&micro_time);
		gettimeofday_ticks(&TOD_val, 0);
		micro_offset = TOD_val.tv_sec * (unsigned long long)K1E6;
		micro_offset = micro_offset - micro_time;
		}
	}

if (use_microseconds) {
	Microseconds((UnsignedWide *)&micro_time);
	micro_time += micro_offset;
	tp->tv_sec = micro_time / K1E6;
	tp->tv_usec = micro_time % K1E6;
	return(0);
	}
else {
	return(gettimeofday_ticks(tp, dummy));
	}
}
*/

//int gettimeofday_ticks(struct timeval *tp, struct timezone *dummy)
int gettimeofday(struct timeval *tp, struct timezone *dummy)
{
#pragma unused(dummy)
static Boolean first_time = true;
static unsigned long long micro_offset;
unsigned long long micro_time;

if (first_time) {
	first_time = false;
	micro_time = (*TICKS) * (unsigned long long)16667;
	/* Subtract offset to get Unix time- since 1/1/1970 */
	micro_offset = ((*TIME) - 2082844800) * (unsigned long long)K1E6;
	micro_offset = micro_offset - micro_time;
	}

micro_time = (*TICKS) * (unsigned long long)16667;
micro_time += micro_offset;
tp->tv_sec = micro_time / K1E6;
tp->tv_usec = micro_time % K1E6;
return(0);
}

long GetGmtDelta(MachineLocation myLocation)
{
	long	internalGMTDelta;

	internalGMTDelta = myLocation.u.gmtDelta & 0x00ffffff;  // mask off dlsDelta
	if ( (internalGMTDelta >> 23) & 1 )  // need to sign extend gmtDelta
		internalGMTDelta |= 0xff000000;
	return (internalGMTDelta);
}


int IsDaylightSavingsOn()
{
	int retVal = 0;
	MachineLocation theLocation;
	ReadLocation(&theLocation);
	
	if (theLocation.u.dlsDelta == (signed char) 0x80) {
		retVal = 1;
	}
	
	return(retVal);
}
