// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: mac_extras.h,v $
// Revision 1.5  1999/04/08 08:19:04  dicamillo
// DST adjustment needed after all
//
// Revision 1.4  1999/04/08 07:13:13  dicamillo
// Comment-out IsDaylightSavingsOn, since it isn't needed.
//
// Revision 1.3  1999/04/08 00:44:35  sampo
// sampo learns MacOS Toolbox date and time calls
//
// Revision 1.2  1999/01/01 02:45:18  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 05:36:47  dicamillo
// First Checked In.
//

/* Values for the second argument to access.
   These may be OR'd together.  */
#define R_OK    4               /* Test for read permission.  */
#define W_OK    2               /* Test for write permission.  */
#define X_OK    1               /* Test for execute permission.  */
#define F_OK    0               /* Test for existence.  */

/* permission bits */
#define S_IRWXU 00700
#define S_IRUSR 00400
#define S_IWUSR 00200
#define S_IXUSR 00100

#define S_IRWXG 00070
#define S_IRGRP 00040
#define S_IWGRP 00020
#define S_IXGRP 00010

#define S_IRWXO 00007
#define S_IROTH 00004
#define S_IWOTH 00002
#define S_IXOTH 00001

/* Some synonyms used historically in the kernel and elsewhere */
#define S_IREAD         S_IRUSR /* read permission, owner */
#define S_IWRITE        S_IWUSR /* write permission, owner */
#define S_IEXEC         S_IXUSR /* execute/search permission, owner */

int stricmp(const char *s1, const char *s2);
int strnicmp(const char *s1, const char *s2, int n);
int access(const char *pathname, int mode);
int chmod(const char *pathname, mode_t mode);
unsigned int my_getopenfilelength(int filedes);
long GetGmtDelta(MachineLocation myLocation);
int IsDaylightSavingsOn(void);