// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: my_path2fss.c,v $
// Revision 1.2  1999/01/01 02:45:18  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 05:36:48  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *my_path2fss_c(void) {
return "@(#)$Id: my_path2fss.c,v 1.2 1999/01/01 02:45:18 cramer Exp $"; }
#endif

/*  Metrowerks Standard Library  Version 2.4  1998 March 10  */

/*  $Date: 1999/01/01 02:45:18 $ 
 *  $Revision: 1.2 $ 
 *  $NoKeywords: $ 
 *
 *		Copyright  1995-1998 Metrowerks, Inc.
 *		All rights reserved.
 */

/*
 *	path2fss.c
 *	
 *	
 *	Routines
 *	--------
 *		__path2fss
 *
 *	Description
 *	-----------
 *
 *		This function is similar to PBMakeFSSpec with three major
 *		differences:
 *
 *		   1) Takes only a path name as input (as a C string);
 *					no parameter block
 *
 *		   2) Only makes FSSpecs for files, not directories.
 *
 *		   3) Works on *any* HFS Mac (Mac 512KE, Mac Plus or later)
 *					under any system version that supports HFS.
 *
 *		   4) Deals correctly with MFS disks (correctly traps
 *					file names longer than 63 chars and returns bdNamErr).
 *
 *		Like PBMakeFSSpec, this function returns fnfErr if the specified
 *		file does not exist but the FSSpec is still valid for the purposes
 *		of creating a new file. Errors are also returned for invalid path
 *		names or path names that specify directories rather than files
 *		(directories are excluded because you can't talk about them in
 *		stdio, but maybe this needs rethinking for unixio).
 *
 *
 */

#include <Errors.h>
#include <Files.h>
#include <string.h>
#include "path2fss.h"

extern FCBPBRec myFCB;

static void copy_c_to_pascal_str(StringPtr dst, const char * src)
{
	size_t len = strlen(src);
	
	memcpy(&dst[1], &src[0], len);
	
	dst[0] = len;
}

OSErr __path2fss(const char * fileName, FSSpecPtr spec)
{
	int						fileNameLen;
	FInfo					fndrInfo;
	OSErr					result;
	
	if (!fileName || !*fileName)
		return(bdNamErr);

	fileNameLen = strlen(fileName);
	
/*	if (!fileNameLen || fileNameLen > sizeof(spec->name) - 1 || *fileName == '.')   hh 10/25/97*/
/* Want to allow filenames begining with '.'.  */
	if (!fileNameLen || fileNameLen > sizeof(spec->name) - 1)
		return(bdNamErr);
	
	copy_c_to_pascal_str(spec->name, fileName);
    spec->vRefNum = myFCB.ioFCBVRefNum;
    spec->parID = myFCB.ioFCBParID;

/* check if file exists */
	result = FSpGetFInfo(spec, &fndrInfo);
	if (result != noErr) {
		return fnfErr;
		}
	else {
		return noErr;
		}
}

/*  Change Record
 *	16-Aug-95 JFH  First code release.
 * hh 971025  File names beginning with '.' can now be opened
*/
