// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: my_setting.c,v $
// Revision 1.4  1999/01/09 03:47:14  dicamillo
// Change "use_mp" to "use_mp_support" so old setting will be ignore.
//
// Revision 1.3  1999/01/01 02:45:18  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.2  1998/12/31 08:17:51  dicamillo
// Add new "use_mp" settings variable.
//
// Revision 1.1  1998/12/15 05:36:50  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *my_setting_c(void) {
return "@(#)$Id: my_setting.c,v 1.4 1999/01/09 03:47:14 dicamillo Exp $"; }
#endif

#include <stdio.h>
#include "settings.h"
#include "my_settings.h"

settings_list ds;

settings_list cs;		// current settings

settings_list fs;		// file settings

keyinfo keytab[] = {
	{"response_level", 'c', 1, &ds.resplevel, &cs.resplevel, &fs.resplevel,
		"Responsiveness level (0-3)", respproc, 0},
	{"custom_ticks", 'u', 2, &ds.customticks, &cs.customticks, &fs.customticks,
		"Custom tick count", tickproc, 0},
	{"max_cpu", 'b', 1, &ds.maxcpu, &cs.maxcpu,
		&fs.maxcpu, "Try to use all CPU time (flag)", 0, 0},
	{"max_cpu_start_time", 'd', sizeof(double), &ds.max_cpu_start_time, &cs.max_cpu_start_time,
		&fs.max_cpu_start_time, "Wait time (mins.) before using more CPU", 0, 0},
	{"max_cpu_end_time", 'd', sizeof(double), &ds.max_cpu_end_time, &cs.max_cpu_end_time,
		&fs.max_cpu_end_time, "Time (mins.) until maximum CPU usage", 0, 0},
	{"auto_foreground", 'b', 1, &ds.auto_fg, &cs.auto_fg,
		&fs.auto_fg, "Auto move to foreground (flag)", 0, 0},
	{"auto_foreground_delay", 'd', sizeof(double), &ds.auto_fg_delay, &cs.auto_fg_delay,
		&fs.auto_fg_delay, "Wait time (mins.) before moving to foreground", 0, 0},
	{"write_log", 'b', 1, &ds.writelog, &cs.writelog, &fs.writelog,
		"True to write log file (flag)", 0, 0},
	{"console_log_name", 's', 31, ds.console_log_name, cs.console_log_name,
		fs.console_log_name, "client console log", 0, 0},
	{"auto_resume", 'b', 1, &ds.resume, &cs.resume, &fs.resume,
		"True to resume at launch (flag)", 0, 0},
	{"log_window_h_loc", 'i', 2, &ds.log_window_h_loc, &cs.log_window_h_loc, &fs.log_window_h_loc,
		"Log window top-left horizontal location", 0, 0},
	{"log_window_v_loc", 'i', 2, &ds.log_window_v_loc, &cs.log_window_v_loc, &fs.log_window_v_loc,
		"Log window top-left vertical location", 0, 0},
	{"log_window_width", 'i', 2, &ds.log_window_width, &cs.log_window_width, &fs.log_window_width,
		"Log window width", 0, 0},
	{"log_window_height", 'i', 2, &ds.log_window_height, &cs.log_window_height, &fs.log_window_height,
		"Log window height", 0, 0},
	{"log_window_visible", 'b', 1, &ds.log_window_visible, &cs.log_window_visible, &fs.log_window_visible,
		"Log window visible (flag)", 0, 0},
	{"log_window_info_stored", 'b', 1, &ds.log_window_info_stored, &cs.log_window_info_stored,
		&fs.log_window_info_stored, "Log window settings valid (flag)", 0, 0},
	{"gui_window_h_loc", 'i', 2, &ds.gui_window_h_loc, &cs.gui_window_h_loc, &fs.gui_window_h_loc,
		"GUI window top-left horizontal location", 0, 0},
	{"gui_window_v_loc", 'i', 2, &ds.gui_window_v_loc, &cs.gui_window_v_loc, &fs.gui_window_v_loc,
		"GUI window top-left vertical location", 0, 0},
	{"gui_window_width", 'i', 2, &ds.gui_window_width, &cs.gui_window_width, &fs.gui_window_width,
		"GUI window width", 0, 0},
	{"gui_window_height", 'i', 2, &ds.gui_window_height, &cs.gui_window_height, &fs.gui_window_height,
		"GUI window height", 0, 0},
	{"gui_window_visible", 'b', 1, &ds.gui_window_visible, &cs.gui_window_visible, &fs.gui_window_visible,
		"GUI window visible (flag)", 0, 0},
	{"gui_window_info_stored", 'b', 1, &ds.gui_window_info_stored, &cs.gui_window_info_stored,
		&fs.gui_window_info_stored, "GUI window settings valid (flag)", 0, 0},
	{"use_mp_support", 'b', 1, &ds.use_MP, &cs.use_MP,
		&fs.use_MP, "Use MP support when available", 0, 0},
	{"all_fonts", 'b', 1, &ds.all_fonts, &cs.all_fonts,
		&fs.all_fonts, "Include all fonts in Fonts menu", 0, 0},
	{"font_name", 's', 255, ds.font_name, cs.font_name, fs.font_name,
		"Font name", 0, 0},
	{"font_size", 'i', 2, &ds.font_size, &cs.font_size, &fs.font_size,
		"Font size", 0, 0},
	{"font_style", 'x', 1, &ds.font_style, &cs.font_style, &fs.font_style,
		"Font style", 0, 0},
	{"buffers_contest", 'i', 2, &ds.buffers_contest, &cs.buffers_contest, &fs.buffers_contest,
		"Contest for buffers popup control (0 = RC5, 1 = DES)", 0, 0},
// obsolete settings- accepted without error but ignored
	{"log_name", '*', 31, 0, 0, 0, 0, 0, 0},
	{"init_file_name", '*', 31, 0, 0, 0, 0, 0, 0},
	{"window_h_loc", '*', 2, 0, 0, 0, 0, 0, 0},
	{"window_v_loc", '*', 2, 0, 0, 0, 0, 0, 0},
	{"window_width", '*', 2, 0, 0, 0, 0, 0, 0},
	{"window_height", '*', 2, 0, 0, 0, 0, 0, 0},
	{"window_visible", '*', 1, 0, 0, 0, 0, 0, 0},
	{"window_info_stored", '*', 1, 0, 0, 0, 0, 0, 0},
	{"use_mp", '*', 1, 0, 0, 0, 0, 0, 0},
// end of list termination
	{0, 0, 0, 0, 0, 0, 0, 0, 0}
	};

short respproc(void *resultptr)
{
short num;

num = *((short *)resultptr);
if ((num >= 0) && (num <= 3)) return(0);
return(1);
}

short tickproc(void *resultptr)
{
unsigned short num;

num = *((unsigned short *)resultptr);
if ((num >= 2) && (num <= 18000)) return(0);
return(1);
}
