// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: my_sleep.c,v $
// Revision 1.4.2.1  1999/07/10 23:21:37  sampo
// get rid of a pair of warnings
//
// Revision 1.4  1999/04/29 06:17:08  dicamillo
// Fix error in WNE sleep calculation could which could result in a huge value.
//
// Revision 1.3  1999/01/01 02:45:18  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.2  1998/12/31 10:25:59  dicamillo
// Change tick_sleep so it can be called safely from an active thread.
//
// Revision 1.1  1998/12/15 05:38:57  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *my_sleep_c(void) {
return "@(#)$Id: my_sleep.c,v 1.4.2.1 1999/07/10 23:21:37 sampo Exp $"; }
#endif

#include "macdefs.h"
#include <MP.h>
#include "WASTE.h"
#include "resdefs.h"
#include "apputils.h"
#include "window_info.h"
#include "DrawGUI.h"

#include "PointerList.h"
#include "ViewObject.h"
#include "GUIView.h"
#include "WTextView.h"
#include "TextRscView.h"
#include "WindowObject.h"
#include "AppObject.h"
#include "ViewWindow.h"
#include "GUIWindow.h"
#include "WTextDisplayWindow.h"
#include "TextRscWindow.h"
#include "client.h"
#include "Mac_Client.h"
#include "RC5Dialogs.h"
#include "settings.h"
#include "my_settings.h"
#include "RC5App.h"
#include "triggers.h"

// Replacement for MSL routine

extern RC5App *theApp;
extern Boolean pending_console_data;
extern short MP_active;

void tick_sleep(unsigned long tickcount);
unsigned int my_sleep(unsigned int seconds);
void usleep(unsigned int usec);

unsigned int my_sleep(unsigned int seconds)
{
tick_sleep(seconds * 60L);
return(0);
}

void usleep(unsigned int usec)
{
tick_sleep((usec * 3 + 25000) / 50000);
}

void tick_sleep(unsigned long tickcount)
{
unsigned long tick_limit, new_ticks;
Boolean wne_result;
EventRecord theEvent;

tick_limit = LMGetTicks() + tickcount;

do {	// yield once for count of zero
	if (MP_active > 0) {
		if (MPTaskIsToolboxSafe(MPCurrentTaskID())) {
			// this is the code that executes while waiting for the threads to do work
			SystemTask();	// need to get MP scheduling
			YieldToMain(false);
			}
		else {		// can only do MPYield if called from a thread
			MPYield();
			}
		}
	else {
	// waiting for net connection to open, etc.
		if (pending_console_data) {
			theApp->update_log(false);
			}
		new_ticks = LMGetTicks();
		if (new_ticks >= tick_limit) break;
		do_yield_processing();
		// WNE sleep time is "tick_limit - new_ticks", and is unsigned.
		// Be very careful this value can never negative (which becomes a huge
		// positive sleep time)
		wne_result = WaitNextEvent(everyEvent, &theEvent, tick_limit - new_ticks, 0L);
		theApp->last_yield = LMGetTicks();
		if (wne_result) {
			theApp->handle_one_event(&theEvent);
			}
		else {
			theApp->handle_null_event();
			}
		}
	} while (LMGetTicks() < tick_limit);
}
