/* Copyright distributed.net 1997-1999 - All Rights Reserved
 * For use in distributed.net projects only.
 * Any other distribution or use of this source violates copyright.
 *
 * Created by Cyrus Patel <cyp@fb14.uni-mainz.de>
 *
 * This module contains general utility stuff including some functions
 * that are called from the installer.
 *
 * $Id: w32ini.cpp,v 1.1.2.1 2000/04/21 08:55:35 jlawson Exp $
*/

#include "cputypes.h"
#include "baseincs.h"


#define NT_INIMAPPING_MINVER 3000 /* 2000 to enable, >=3000 to disable */

static char DCTI_KEYCTX[80] = "Distributed Computing Technologies, Inc.\0";

/* ---------------------------------------------------- */

const char *SetDCTIProfileContext(const char *ctx)
{
  if (!ctx || !*ctx)
    ctx = "Distributed Computing Technologies, Inc.";
  strncpy( DCTI_KEYCTX, ctx, sizeof(DCTI_KEYCTX) );
  DCTI_KEYCTX[sizeof(DCTI_KEYCTX)-1] = '\0';
  return DCTI_KEYCTX;  
}    

/* ---------------------------------------------------- */

int WriteDCTIProfileString(const char *sect, const char *entry, const char *val)
{
  int rc = 0;  LONG ec;
  HKEY hInstKey, hBaseKey = (( HKEY ) 0x80000002 );/*HKEY_LOCAL_MACHINE;*/
  char fullentryname[MAX_PATH + 2], scratch[MAX_PATH + 2];
  if (entry && sect && *sect) /* !delete section */
    entry = lstrcat( lstrcat( lstrcpy( fullentryname, sect ), "." ), entry );
  sect = DCTI_KEYCTX;
  
  if (winGetVersion() >= NT_INIMAPPING_MINVER)
  {
    lstrcat( lstrcpy( scratch, "Software\\" ), sect );
    if ( RegOpenKey( hBaseKey, scratch, &hInstKey ) != ERROR_SUCCESS)
    {
      if (RegCreateKey(hBaseKey, scratch, &hInstKey) != ERROR_SUCCESS)    
        return 0;
    }
    RegCloseKey( hInstKey );
    lstrcpy( scratch, "\\Software\\Microsoft\\Windows" );
    if (winGetVersion() >= 2000) lstrcat( scratch, " NT" );
    lstrcat( scratch, "\\CurrentVersion\\IniFileMapping\\win.ini" );
    if (RegOpenKey( hBaseKey, scratch, &hInstKey) != ERROR_SUCCESS)
    {
      if (RegCreateKey( hBaseKey, scratch, &hInstKey) != ERROR_SUCCESS)
        return 0;
    }
    lstrcat(lstrcpy(scratch,"@SYS:"),sect);
    ec = RegSetValue(hInstKey,sect,REG_SZ,scratch,lstrlen(scratch));
    RegCloseKey( hInstKey );
    if (ec != ERROR_SUCCESS)
      return 0;
    WriteProfileString(NULL,NULL,NULL);
  }
  
  #if (CLIENT_OS == OS_WIN32)
  if (winGetVersion() >= 400 && winGetVersion() < NT_INIMAPPING_MINVER)
  {
    lstrcat(lstrcpy(scratch,"Software\\"),sect);
    if (entry == NULL || val == NULL) /* delete section or delete key=val */
    {      
      rc = 1;
      if (RegOpenKey(hBaseKey, scratch, &hInstKey) == ERROR_SUCCESS)
      {
        if (entry != NULL) /* delete key=val */
        {
          RegDeleteKey( hInstKey, entry );
          RegCloseKey( hInstKey );
        }
        else
        {
          while (rc) 
          {
            #if (CLIENT_OS == OS_WIN32)
            if (winGetVersion() >= 400)
            {
              FILETIME ft;
              DWORD gsz = sizeof(fullentryname);
              ec = RegEnumKeyEx( hInstKey, 0, fullentryname, &gsz, NULL,
                        NULL, NULL, &ft );
            }   
            else                             
            #endif                             
            ec = RegEnumKey(hInstKey,0,fullentryname,sizeof(fullentryname));
            if (ec != ERROR_SUCCESS)
              break;
            if (RegDeleteKey(hInstKey, fullentryname ) != ERROR_SUCCESS)
              break;
            RegCloseKey( hInstKey );
            if (RegOpenKey(hBaseKey, fullentryname, &hInstKey) != ERROR_SUCCESS)
              rc = 0;
          }
          if (rc)
            RegCloseKey( hInstKey );
          rc = 0;
          if (RegOpenKey(hBaseKey, "Software", &hInstKey) == ERROR_SUCCESS)
          {
            if (RegDeleteKey( hInstKey, sect ) == ERROR_SUCCESS)
              rc = 1;
            RegCloseKey( hInstKey );
          }
        }
      } 
    }
    else if (RegCreateKey(hBaseKey, scratch, &hInstKey) == ERROR_SUCCESS)
    {
      unsigned int len = lstrlen(val);

      #if (CLIENT_OS == OS_WIN32)
      if (winGetVersion() >= 400) 
        ec = RegSetValueEx(hInstKey,entry,0,REG_SZ,(BYTE *)val,len);
      else
      #endif
        ec = RegSetValue(hInstKey,entry,REG_SZ,(char *)val,len);

      RegCloseKey(hInstKey);
      rc = (ec == ERROR_SUCCESS);
    }
  }
  else
  #endif
  {
    if ((rc = WriteProfileString(sect,entry,val)) == 0)
      rc = WriteProfileString(sect,entry,val);
  }
  return rc;
}  

/* ---------------------------------------------------- */

unsigned int GetDCTIProfileString(const char *sect, const char *entry, 
                        const char *def, char *buf, unsigned int bufsize )
{
  char fullentryname[MAX_PATH + 2];
  if (!buf || !bufsize || !entry)
    return 0;
  buf[0] = 0;
  if (bufsize < 2)
    return 0;
  if (sect && *sect)
    entry = lstrcat( lstrcat( lstrcpy( fullentryname, sect ), "." ), entry );
  sect = DCTI_KEYCTX;

  #if (CLIENT_OS == OS_WIN32)
  if (winGetVersion() >= 400 && winGetVersion() < NT_INIMAPPING_MINVER)
  {
    int usedef = 1;
    HKEY hInstKey, hBaseKey = (( HKEY ) 0x80000002 );/* HKEY_LOCAL_MACHINE; */
    char scratch[MAX_PATH + 2];
    if (RegOpenKey( hBaseKey, lstrcat(lstrcpy(scratch,"Software\\"),sect), &hInstKey) == ERROR_SUCCESS)
    {
      #if (CLIENT_OS == OS_WIN32)
      if (winGetVersion() >= 400) 
      {
        DWORD typ = REG_SZ, size = bufsize;
        if (RegQueryValueEx(hInstKey,entry,NULL,&typ,(BYTE *)buf,&size)
            == ERROR_SUCCESS) 
        {
          bufsize = (unsigned int)size;
          usedef = 0;
        }
      }
      else
      #endif
      {
        LONG size = bufsize;
        if (RegQueryValue( hInstKey, entry, buf, &size ) == ERROR_SUCCESS)
        {
          bufsize = (unsigned int)size;
          usedef = 0;
        }
      }
      RegCloseKey(hInstKey);
    }
    if (usedef)
    {
      if (!def || !*def)
        bufsize = 0;
      else
      {
        strncpy( buf, def, bufsize );
        buf[bufsize-1] = '\0';
        bufsize = lstrlen( buf );
      }
    }
  }
  else
  #endif
  {
    bufsize = GetProfileString(sect, entry, def, buf, (short)bufsize) & 0xffff;
  }
  return bufsize;
}

/* ---------------------------------------------------- */

int GetDCTIProfileInt(const char *sect, const char *entry, int defval )
{
  char s[sizeof(long)*3]; int x;
  if ((x = (int)GetDCTIProfileString(sect, entry, "", s, sizeof(s))) == 0)
    return defval;
  else if (x==2 && (s[0]|' ')=='o' && (s[1]|' ')=='n')
    return 1;
  else if (x==3 && (s[0]|' ')=='y' && (s[1]|' ')=='e' && (s[2]|' ')=='s')
    return 1;
  else if (x==4 && (s[0]|' ')=='t' && (s[1]|' ')=='r' && (s[2]|' ')=='u' && (s[3]|' ')=='e')
    return 1;
  x = defval = 0; if (s[0] == '-' || s[0]=='+') x++;
  while(s[x]>='0' && s[x]<='9') defval = (defval*10)+(s[x++]-'0');
  return ((s[0]=='-') ? -defval : defval);
}

/* ---------------------------------------------------- */

int WriteDCTIProfileInt(const char *sect, const char *entry, int val )
{
  char str[sizeof(long)*3];
  unsigned int x = (unsigned int) (val<0)?(-val):(val);
  int pos = sizeof(str);
  str[--pos]='\0';
  do {
    str[--pos] = (char) ('0' + (char)(x % 10));
    x /= 10;
  } while (x);
  if (val < 0) str[--pos] = '-';
  return WriteDCTIProfileString(sect, entry, &str[pos] );
}

/* ---------------------------------------------------- */

