/* Copyright distributed.net 1997-1999 - All Rights Reserved
 * For use in distributed.net projects only.
 * Any other distribution or use of this source violates copyright.
 *
 * Created by Cyrus Patel <cyp@fb14.uni-mainz.de>
 *
 * This module contains general utility stuff including some functions
 * that are called from the installer.
 * 
*/

#if (!defined(lint) && defined(__showids__))
const char *w32gen_cpp(void) {
return "@(#)$Id: w32util.cpp,v 1.1.2.13 2000/04/21 08:55:35 jlawson Exp $"; }
#endif


#include "cputypes.h"
#define INCLUDE_SHELLAPI_H /* __WINDOWS386__ */
#include "baseincs.h"
#include <shellapi.h>


/* ScreenSaver boot vector (initialized from w32ss.cpp if linked) */
int (PASCAL *__SSMAIN)(HINSTANCE,HINSTANCE,LPSTR,int) = NULL;

/* ---------------------------------------------------- */

/* get DOS style version: (major*100)+minor. major is >=20 if NT */
/* Windows 3.11 = 311, Windows 95/98/ME with 16-bit client = 401 */
/* Windows 95 = 400, Windows 98 = 410, Windows ME = 490 */
/* WinNT 3.1 = 2310, WinNT 3.5 = 2350, WinNT 4.0 = 2400, Win2k = 2500 */

long winGetVersion(void)
{
  static long ver = 0;

  if (ver == 0)
  {
    unsigned int versionmajor = 0, versionminor = 0;
    #if (CLIENT_OS == OS_WIN32)
    {
      OSVERSIONINFO osver;

      osver.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
      GetVersionEx(&osver);
      versionmajor = (int)osver.dwMajorVersion;
      versionminor = (int)osver.dwMinorVersion;
      if (VER_PLATFORM_WIN32_NT == osver.dwPlatformId)
        versionmajor += 20;
      else if (VER_PLATFORM_WIN32s == osver.dwPlatformId)
      {   /* version number is unusable (1.xx) */
        DWORD dwVersion = GetVersion();
        versionmajor = LOBYTE(LOWORD(dwVersion));
        versionminor = HIBYTE(LOWORD(dwVersion));  
      }
    }
    #else
    {
      DWORD dwVersion = GetVersion();
      versionmajor = LOBYTE(LOWORD(dwVersion));
      versionminor = HIBYTE(LOWORD(dwVersion));  
      //build number in (HIWORD(dwVersion) & 0x7FFF) in all but plain win3x
 
      if (versionmajor == 3 && versionminor >= 95)
      {
        versionmajor = 4;
        versionminor = 1;
      }
      else if (dwVersion < 0x80000000) //winNT or win3x without win32s
      {
        if ( GetModuleHandle("KERNEL32") != NULL )
          versionmajor += 20;
      }
    }
    #endif

    ver = (((long)(versionmajor))*100)+versionminor;
  }
  return ver;
}

/* ---------------------------------------------------- */


