#ifndef __RC5PM_H__
#define __RC5PM_H__

// rc5pm.h
// Variables for the PM Version of the RC5 cracking client

#define INCL_WIN
#define INCL_DOSMISC
#define INCL_PM
#define INCL_DOSPROCESS
#define INCL_DOSQUEUES
#define INCL_DOSSEMAPHORES
#include <os2.h>
#include "client.h"
#include "rc5gui.h"
#include "guithrd.h"
#include <io.h>      // For access()

//#define printf MainClient->LogScreenf

#ifndef MIA_ENABLED
#define MIA_ENABLED  0
#endif

#define MAX_TEXT           80
#define WARP_40            40
#define SCREENQUENAME      "\\queues\\RC5_ScreenData.que"
#define MAX_ENTRYTEXT      128
#define NUM_PRIORITY_LIST  3
#define NUM_NETWORK_LIST   5
#define NUM_CPU_LIST       6
#define CONTEST_LIST       2
#define MAX_CHARS          255
#define MAX_LINES          4     // Save 3 lines

#define DEFAULT_THRESHOLD  5

// Window Margins and over values
#define buttonMargin    5
#define buttonHeight    1.5
#define buttonWidth     12
#define outputYMargin   35
#define windowXMargin   5
#define windowYMargin   5

/* User Defined Messages */
#define WM_MY_PRINT     WM_USER+1
#define WM_MY_SETUP     WM_USER+2
#define WM_MY_STATUS    WM_USER+3
#define WM_MY_PERCENT   WM_USER+4
#define WM_MY_MENU      WM_USER+5
#define WM_MY_BUTTON    WM_USER+6
#define WM_UPDATE_PERCENT  WM_USER+7

typedef int THREADRET;

/* Prototypes of functions referenced somewhere else (client.cpp) */
int gettimeofday(struct timeval *tv, struct timezone *);

enum {ClientRun = 1, ClientSelectCore, ClientBenchmark, ClientBenchmark2,
	ClientTest, ClientFlush, ClientFetch, ClientUpdate, ClientQuit};

/****************************************************************************
	Rc5Thread
*****************************************************************************/
class Rc5Thread : public MyThread
	{
	THREADRET Run(void);
	int job;
	BOOL cracking;
	public:
		Rc5Thread() : MyThread(), job(0), cracking(FALSE) {}
		void SetWork(int Job) {job = Job;}
		int GetWork(void) {return job;}
	};

/****************************************************************************
   NBPAGE
*****************************************************************************/
struct NBPAGE
	{
	PFNWP    pDialogWndProc;         // Window procedure
	HWND     hwndNBPage;             // Window handle
	ULONG    ulIDPage;               // ID of notebook page
	PSZ      pszStatusLine;          // Status line text
	PSZ      pszTab;                 // Tab text
	ULONG    ulIDDialogPage;         // ID of a dialog resource
	ULONG    ulIDFocus;              // ID of control to receive focus
	};
	
#define NOTEBOOKPAGE_CX    300
#define NOTEBOOKPAGE_CY    100

/****************************************************************************
	MyClient
*****************************************************************************/
class MyClient : public Client
{
private:
    // The various Notebook pages
	 static MRESULT EXPENTRY ConfigDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
	 static MRESULT EXPENTRY NotebookDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
    static MRESULT EXPENTRY EmailDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
	 static MRESULT EXPENTRY BlockDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
    static MRESULT EXPENTRY NetworkDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
	 static MRESULT EXPENTRY SystemDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
	 static MRESULT EXPENTRY MessageDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
	 static MRESULT EXPENTRY GetProxyPassProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
	 static MRESULT EXPENTRY OS2OptionsDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
	 static MRESULT EXPENTRY OptionsDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
//    static MRESULT EXPENTRY DlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
	 
	 // Sets the password for SOCKS4 or HTTP/Pass
	 static void SetPass(HWND hwnd);

	 int rc5pid;
	 Rc5Thread workThread;

	 char buffer[MAX_TEXT];
	 // percent[MAX_TEXT], 

    // Text Buffer
	 char ScreenBuffer[MAX_LINES][MAX_CHARS];
	 char *ScreenPtr;
	 int  ScreenIndex;
	 
	 HQUEUE  hqScreenQue;

    bool changed;
    ULONG OS2_Version;

public:
	// Commandline Arguments
   int argc;
	char **argv;
   char statustext[MAX_TEXT];
	HWND hwndClient, hwndOutput, hwndStatus, hwndPercent, hwndMenu;

	// Window size information
	int WindowWidth, WindowHeight;
	int percentHeight;
	int percentbar;        // fix point arith of the percentage

	/* OS2 Settings in rc5pm.ini file */
	s32 autorun, automin;
	
	MyClient(HWND hwnd);
	~MyClient();

	void PrintBanner();
	
	/*****************************
	   Configure window
		Note: Bovine Code
	******************************/
	s32 Configure();

	/************************************
		Draws the actual percentage bar
		percent = the percent of the bar (0-100)
		cpu = which CPU the precent represents, 1 will have no CPU indication
   *************************************/
	void DrawPercentage(s32 percent, s32 cpu);

	/************************************
		Does a graphical percentage bar
   *************************************/
	void LogScreenPercentSingle(u32 percent, u32 lastpercent,
												  bool restarted);

	/******************************
		Sets various network modes
   *******************************/
	void SetNetworkMode(HWND hwnd, int mode);

	/****************
		Starts a job
	*****************/
	void StartThread(int Job);

	int GetRc5PID()
		{return rc5pid;}

	/*************************
		Set the status hwnd
		hwnd = parent handle
	**************************/
/*	void SetHwnd(HWND hwnd)
		{hwndOutput = WinWindowFromID(hwndClient, ID_OUTPUT);
		hwndStatus = WinWindowFromID(hwndClient, ID_STATUS);
		hwndPercent = WinWindowFromID(hwndClient, ID_PERCENT_BAR);}

*/
		/****************************
			Sets the status line text
		*****************************/
		void SetStatusText(const char *text)
			{/*WinSetWindowText(hwndStatus, text); */}

		/**********************************************
			Posts a message to update the status line
			Note: Used in threads
      ***********************************************/
    void SetStatus(const char *fmt, ...)
      {
        static char text[MAX_TEXT];
        va_list argptr;

        // format the buffer
        va_start(argptr, fmt);
        vsprintf(text, fmt, argptr);
        va_end(argptr);

		  strcpy(statustext, text);
		  WinPostMsg(hwndClient, WM_UPDATE_PERCENT, 0, 0);
//        WinPostMsg(hwndClient, WM_MY_STATUS, MPFROMP(text), 0);
      };


		/*************************************************************
		Custom INI file updaters
		**************************************************************/
		virtual void InternalReadConfig(IniSection &ini);
		virtual void InternalWriteConfig(IniSection &ini);


		/*************************************************************
      Writes a message out to the OS2 status window (listbox)
      message = char string to output with 200 line limit
		**************************************************************/
//		void WriteScreen(const char *text);
		void WriteScreen();
     						  
		/*************************************************************
      Posts a message to write to a screen. Uses WriteScreen()
		**************************************************************/
		virtual void LogScreen ( const char *text );

/*
		void LogPercent()
		 {WinSetWindowText(hwndPercent, percent);}
*/
/*		void Percentf(const char *fmt, ...)
			{
			va_list argptr;

			// format the buffer
			va_start(argptr, fmt);
			vsprintf(buffer, fmt, argptr);
			va_end(argptr);

			strncat(percent, buffer, MAX_TEXT);

//			if(percentprintingoff == 1)
				WinPostMsg(hwndClient, WM_MY_PERCENT, 0, 0);
			};
*/
      void PercentClear()
			{/*percent[0]=0;
			 WinPostMsg(hwndClient, WM_MY_PERCENT, 0, 0);*/};


		/*************************************************************
      Dialog control modification functions
		**************************************************************/
		void Menu(int id, int state)
			{
			WinPostMsg(hwndClient, WM_MY_MENU,
						  MPFROMSHORT(id), MPFROMSHORT(state));
			}
		
		void Button(int id, int state)
			{
			WinPostMsg(hwndClient, WM_MY_BUTTON,
						  MPFROMSHORT(id), MPFROMSHORT(state));
			}

		void UpdateWindow(BOOL state)
			{
			if(state == TRUE)
				WinShowWindow(hwndOutput, TRUE);
			else
				WinEnableWindowUpdate(hwndOutput, FALSE);
			}

    void MenuToggle(HWND hwndMenu, int menuItem, int status)
      {
        WinSendMsg(hwndMenu, MM_SETITEMATTR,
	           MPFROM2SHORT(menuItem, TRUE),
				  MPFROM2SHORT(MIA_DISABLED, status));
      }
		void GetEntryFieldText(HWND hwndOwner, ULONG id, char text[MAX_TEXT])
      {
      	HWND hwndEntry;
      	LONG textlen;
	
      	hwndEntry = WinWindowFromID(hwndOwner, id);     /* Get the Entry hwnd */
      	textlen = WinQueryWindowTextLength(hwndEntry);  /* Get the text length */

      	if(textlen+1 > MAX_TEXT)
      		text[0] = NULL;
      	else
      		/* Get the actual text now */
      		WinQueryWindowText(hwndEntry, textlen+1, text);
      }
      
	};

extern MyClient *MainClient;

#endif

