/*
 * Copyright distributed.net 1999-2002 - All Rights Reserved
 + For use in distributed.net projects only.
 * Any other distribution or use of this source violates copyright.
 *
 * Generate buff-in.ogr files
 *
 * $Id: mkstub.cpp,v 1.2 2002/09/02 00:35:47 andreasb Exp $
*/

#include "cputypes.h"
#include "client.h"
#include "buffbase.h"
#include "random.h"
#include "baseincs.h"
#include "ogr.h"

static void usage()
{
	fprintf(stderr, "Usage:  mkstub <filename> <stub-definition> [...]\n"
		"\twhere <stub-definition> is:  marks N diff1 diff2 ... diffN\n\n"
		"Example:  to create stub 24/1-12-7-25-3 you would use this command line:\n"
		"\tmkstub buff-in.ogr 24 5 1 12 7 25 3\n");
}

int main(int argc, char** argv)
{
	int err = 0;
  unsigned long count = 0;
  const char* filename = "";

  InitRandom();
  
	if (argc < 3)
	{
		usage();
		err = 1;
	}
	else
	{
    filename = argv[1];
		u32 numEntries = 0;
		int argnum = 2;				// first argument to process

    printf("Writing to buffer file '%s'\n", filename);
		while (argnum < argc)	// loop until we have no more stubs
		{
      WorkRecord wr;
			memset(&wr, 0, sizeof(wr));

      if (argc - argnum < 2) {
        fprintf(stderr, "ERROR: not enough arguments %d %d\n", argc, argnum);
        usage();
        err = 1;
        break;
      }

			wr.work.ogr.workstub.stub.marks = atoi(argv[argnum++]);
			wr.work.ogr.workstub.stub.length = atoi(argv[argnum++]);

      if (argc - argnum < wr.work.ogr.workstub.stub.length) {
        fprintf(stderr, "ERROR: not enough diffs %d %d %d\n", argc, argnum, wr.work.ogr.workstub.stub.length);
        usage();
        err = 1;
        break;
      }
      
			for (u32 i = 0; i < wr.work.ogr.workstub.stub.length; i++)
			{
				wr.work.ogr.workstub.stub.diffs[i] = atoi(argv[argnum++]);
			}

			wr.contest = OGR;
      strncpy(wr.id, "mkstub generated", sizeof(wr.id));
      wr.id[sizeof(wr.id)-1] = 0;

			fprintf(stdout, "Writing OGR record: %s\n", ogr_stubstr(&wr.work.ogr.workstub.stub));
      if (BufferPutFileRecord(filename, &wr, &count) != 0) {
        fprintf(stderr, "ERROR: write error in '%s'\n", filename);
        err = 2;
        break;
      }

			numEntries++;
		}
	}
  if (err == 0) {
    printf("'%s' contains %ld stubs\n", filename, count);
  }
	return err;
}
