#include "myclient.h"

#define TitleBarText "OS/2 RC5 Cracking Client"

MyClient *MainClient = NULL;

struct cmdargs
	{
	int argc;
	char **argv;
	};

MRESULT EXPENTRY MyWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY AboutDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

// Global command line arguments
cmdargs CmdArgs;

int main(int argc, char **argv)
	{
	HAB   hab;
	HMQ   hmq;
	HWND  hwndClient;
	QMSG  qmsg;
	TID   tid;
	const CHAR  szClientClass[] = "RC5_Client";

	ULONG flFrameFlags = FCF_TITLEBAR | FCF_SYSMENU | FCF_SIZEBORDER
		| FCF_MINMAX | FCF_TASKLIST | FCF_MENU;

	CmdArgs.argc = argc;
	CmdArgs.argv = argv;

	tid = 0;
	hab = WinInitialize(0);
	hmq = WinCreateMsgQueue(hab,0);

	WinRegisterClass(hab, szClientClass, MyWndProc, CS_SIZEREDRAW, 0);

	hwndClient = WinCreateStdWindow(HWND_DESKTOP, 0L, &flFrameFlags,
											 szClientClass, TitleBarText, 0L, 0,
											 ID_RESOURCE, NULL);

	// Set default size and position of window
	WinSetWindowPos(hwndClient, NULL, 10, 10, 450, 300,
						 SWP_MOVE | SWP_SIZE);
	
	while(WinGetMsg (hab, &qmsg, NULLHANDLE, 0,0 ))
		WinDispatchMsg(hab, &qmsg);

	/* Boost RC5 thread prioirty */
	DosSetPriority(PRTYS_PROCESS, PRTYC_REGULAR, 0, 0);
	SignalTriggered = 1;

	/* Wait until thread finishes */
   tid = MainClient->GetRc5PID();
	DosWaitThread(&tid, DCWW_WAIT);
	
	WinDestroyWindow(hwndClient);
	WinDestroyMsgQueue(hmq);
	WinTerminate(hab);
	return 0;
	}

 /*FOLD00*/
MRESULT EXPENTRY MyWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
	{
	static char inipath[128];
   static BOOL MinMax;
   static PSZ pAppName, pKeyName;
	
	/* New additions to the system menu */
	static CHAR *MenuText[6] = {NULL, "~Fetch", "F~lush", "~Update",
	                            NULL, "~About..." };
	static MENUITEM mi[6] = {MIT_END, MIS_SEPARATOR, 0, 0, 0, 0,
		                      MIT_END, MIS_TEXT, 0, IDM_FETCH, 0, 0,
                            MIT_END, MIS_TEXT, 0, IDM_FLUSH, 0, 0,
									 MIT_END, MIS_TEXT, 0, IDM_UPDATE, 0, 0,
									 MIT_END, MIS_SEPARATOR, 0, 0, 0, 0,
	                         MIT_END, MIS_TEXT, 0, IDM_ABOUT, 0, 0};

	static HWND hwndtmp;
	INT iItem, idSysMenu;
	MENUITEM miSysMenu;
	SWP swp;
	TID tid = 0;
	POINTL   ptl[2];
	FONTMETRICS fm;


	HPS      hps;
	HBITMAP  hbm;
	enum {Button_Fetch, Button_Flush, Button_Update};
	static   HWND widget[4];      // keeps track of the buttons
	static   int  i, j,
	         cxFont, cyFont;

	// Constants
//	char szFont[] = "9.WarpSans";
	static CHAR szFont[] = "8.Helv";

	// Bitmap Size
	const int sx = 231,
	          sy = 231;
   CHAR buffer[128];    // misc text buffer

	/* RC5 Classes */
	static MyClient client(hwnd);

	switch(msg)
		{
/***************************************************************************
      Window Initalization
****************************************************************************/
		case WM_CREATE:
         WinAlarm(HWND_DESKTOP, WA_NOTE);

		   /* Create Client Window */
   		// Set Font
		   WinSetPresParam(hwnd, PP_FONTNAMESIZE, strlen(szFont) + 1, szFont);
		
		   // Create Flush Button
		   hps = WinGetPS(hwnd);

			GpiQueryFontMetrics(hps, sizeof fm, &fm);
			cxFont = fm.lAveCharWidth;
			cyFont = fm.lMaxBaselineExt;
			cxFont *= buttonWidth;     // Width of button
			cyFont *= buttonHeight;     // Height of button
         client.percentHeight = fm.lMaxBaselineExt * 1.5;   // percentage bar height
			
			WinReleasePS(hps);

			widget[Button_Flush] =
				WinCreateWindow(hwnd, WC_BUTTON, "Flush",
									 WS_VISIBLE | BS_PUSHBUTTON | BS_NOBORDER,
									 0, 0,
									 cxFont, cyFont,
									 hwnd, HWND_BOTTOM, ID_FLUSH, NULL, NULL);

			widget[Button_Fetch] =
				WinCreateWindow(hwnd, WC_BUTTON, "Fetch",
									 WS_VISIBLE | BS_PUSHBUTTON | BS_NOBORDER,
									 0, 0,
									 cxFont, cyFont,
									 hwnd, HWND_BOTTOM, ID_FETCH, NULL, NULL);

			widget[Button_Update] =
				WinCreateWindow(hwnd, WC_BUTTON, "Update",
									 WS_VISIBLE | BS_PUSHBUTTON | BS_NOBORDER,
									 0, 0,
									 cxFont, cyFont,
									 hwnd, HWND_BOTTOM, ID_UPDATE, NULL, NULL);

			client.hwndOutput =
				WinCreateWindow(hwnd, WC_LISTBOX, NULL,
									 WS_VISIBLE | LS_NOADJUSTPOS,
									 0, 0,
									 100, 100,
									 hwnd, HWND_BOTTOM, ID_OUTPUT, NULL, NULL);

			/* Set up the System Menu */
			hwndtmp = WinWindowFromID(WinQueryWindow(hwnd, QW_PARENT),
													FID_SYSMENU);
			idSysMenu = SHORT1FROMMR(WinSendMsg(hwndtmp,
															MM_ITEMIDFROMPOSITION,
															NULL, NULL));

			WinSendMsg(hwndtmp, MM_QUERYITEM, MPFROM2SHORT(idSysMenu, FALSE),
							  MPFROMP(&miSysMenu));

			for(iItem = 0; iItem < 6; iItem++)
				WinSendMsg(miSysMenu.hwndSubMenu, MM_INSERTITEM,
							  MPFROMP(mi+iItem), MPFROMP(MenuText[iItem]));

			/* Set the window as Maximized */
			MinMax = TRUE;

			/* Set the Font for the output window */
			WinSetPresParam(client.hwndOutput,
								 PP_FONTNAMESIZE, strlen(szFont) + 1, szFont);
/*			WinSetPresParam(WinWindowFromID(hwnd, ID_STATUS),
								 PP_FONTNAMESIZE, strlen(myFont) + 1, myFont);
			WinSetPresParam(WinWindowFromID(hwnd, ID_PERCENT),
								 PP_FONTNAMESIZE, strlen(szFont) + 1, szFont);
*/
			/* Make status line longer */
/* 		hwndOutput = WinWindowFromID(hwnd, ID_STATUS);
			WinSendMsg(hwndOutput, EM_SETTEXTLIMIT, (MPARAM)MAX_TEXT, (MPARAM)0);
*/
			/* Set Font for Percent window */
/*         hwndOutput = WinWindowFromID(hwnd, ID_PERCENT);
			WinSetPresParam(hwndOutput, PP_FONTNAMESIZE, strlen(myFont) + 1, myFont);
*/
			{
			client.argc = CmdArgs.argc;
			client.argv = CmdArgs.argv;

			// See if there's an INI file
			if ( getenv( "RC5INI" ) != NULL )
   			strncpy( client.inifilename, getenv( "RC5INI" ), 127 );
			else
				{
				char fndrive[_MAX_DRIVE], fndir[_MAX_DIR], fname[_MAX_FNAME];

				_splitpath(client.argv[0], fndrive, fndir, fname, NULL);
				_makepath(client.inifilename, fndrive, fndir, fname, ".ini");
				}

			// See if there's a command line parameter to override the INI filename...
			for (i = 1; i < client.argc; i++)
				{
				if ( strcmp(client.argv[i], "-ini" ) == 0)
					{
					strcpy( client.inifilename, client.argv[i+1] );
					i++; // Don't try and parse the next argument
					}
				}

			// generate the paths of the other files based on the ini filename
			char buffer[200];
			strcpy( buffer,client.inifilename );
			char *slash = strrchr(buffer, '/');
			if (slash == NULL)
				{
				strcpy(client.in_buffer_file[0],"buff-in.rc5");
				strcpy(client.out_buffer_file[0],"buff-out.rc5");
				strcpy(client.in_buffer_file[1],"buff-in.des");
				strcpy(client.out_buffer_file[1],"buff-out.des");
				strcpy(client.exit_flag_file,"exitrc5.now");
				}
			else
				{
				*(slash+1) = 0;
				strcpy(client.in_buffer_file[0],buffer);
				strcpy(client.out_buffer_file[0],buffer);
				strcpy(client.in_buffer_file[1],buffer);
				strcpy(client.out_buffer_file[1],buffer);
				strcpy(client.exit_flag_file,buffer);
				strcat(client.in_buffer_file[0],"buff-in.rc5");
				strcat(client.out_buffer_file[0],"buff-out.rc5");
				strcat(client.in_buffer_file[1],"buff-in.des");
				strcat(client.out_buffer_file[1],"buff-out.des");
				strcat(client.exit_flag_file,"exitrc5.now");
				}

			client.ValidateConfig();

			// Test to see if there's an ini file
			if(access(client.inifilename, R_OK) != 0)
				{
				// no INI files so go and make one before anything else
				client.Configure();
				client.WriteConfig();
				}

			s32 inimissing = client.ReadConfig();
			// start parsing the command line
			client.ParseCommandlineOptions(client.argc,
													 client.argv, inimissing);
			client.ValidateConfig();
			}

			// Turn off show percent, default is on
			if(client.percentprintingoff == 1)
				WinSendMsg(client.hwndMenu, MM_SETITEMATTR,
							  MPFROM2SHORT(IDM_SHOWPERCENT, TRUE),
							  MPFROM2SHORT(MIA_CHECKED, 0));

			// The parent window handle
			hwndtmp = WinQueryWindow(hwnd, QW_PARENT);

			// Set the pointer for the dialog box
			WinSendMsg(hwndtmp, WM_SETICON,
						  (MPARAM)WinLoadPointer(HWND_DESKTOP, NULL,ID_MONARCH),
						  (MPARAM)TRUE);

			client.PrintBanner();
			
         WinPostMsg(hwnd, WM_MY_SETUP, 0, 0);
			return 0;

/***************************************************************************
      Thread Messages
****************************************************************************/
		case WM_MY_SETUP:
			if(client.autorun == TRUE)
				{
				/* Auto start client */
				WinSendMsg(hwnd, WM_COMMAND, MPFROMSHORT(IDM_START),
							  MPFROM2SHORT(CMDSRC_MENU, FALSE));
				}

   		if(client.automin == TRUE)
				{
				// Auto Minimize Client
				WinQueryWindowPos(hwndtmp, &swp);
				WinSetWindowPos(hwndtmp, NULL, swp.x, swp.y, swp.cx, swp.cy,
									 SWP_MINIMIZE | SWP_MOVE | SWP_SIZE | SWP_SHOW);
				}
			else
				// Set window to saved size
				WinSetWindowPos(hwndtmp, NULL, 10, 10, 450, 300,
									 SWP_MOVE | SWP_SIZE | SWP_SHOW);

         return 0;

		case WM_MY_PRINT:
		   client.WriteScreen();
   		return 0;

		case WM_MY_STATUS:
		   client.SetStatusText((char *)PVOIDFROMMP(mp1));
		   return 0;
			
		case WM_MY_PERCENT:
//		   client.LogPercent();
		   return 0;
		
		case WM_MY_MENU:
			client.MenuToggle(client.hwndMenu, LONGFROMMP(mp1), LONGFROMMP(mp2));
         return 0;

		case WM_MY_BUTTON:
   		WinEnableWindow(WinWindowFromID(hwnd, LONGFROMMP(mp1)),
								 LONGFROMMP(mp2));
		   return 0;

/***************************************************************************
      Window Messages
****************************************************************************/
		case WM_COMMAND:
	      switch(COMMANDMSG(&msg)->cmd)
				{
            /* The main Buttons */
				case ID_FETCH:                            /* Fetch Keys */
				case IDM_FETCH:
               client.StartThread(ClientFetch);
				   return 0;
				case ID_FLUSH:                            /* Flush Keys */
				case IDM_FLUSH:
				   client.StartThread(ClientFlush);
               return 0;
				case ID_UPDATE:                           /* Update Keys */
   			case IDM_UPDATE:
	   			client.StartThread(ClientUpdate);
				   return 0;

				/* Options */
                        /* Client */
				case IDM_START:
   				client.StartThread(ClientRun);
   				client.SetStatus("Cracking Thread Running...");
				   return 0;

				case IDM_STOP:
   				DosSetPriority(PRTYS_PROCESS, PRTYC_REGULAR, 0, 0);
               SignalTriggered = 1;
					client.SetStatus("Cracking Thread Stopped...");
					return 0;

				case IDM_SHOWPERCENT:
   				if(client.percentprintingoff == 0)
						{
						client.percentprintingoff = 1;
                  WinSetWindowText(WinWindowFromID(hwnd, ID_PERCENT), "");
						}
					else
						{
						client.percentprintingoff = 0;
//                 client.LogPercent();
						}
						
					WinSendMsg(client.hwndMenu, MM_SETITEMATTR,
								  MPFROM2SHORT(IDM_SHOWPERCENT, TRUE),
								  MPFROM2SHORT(MIA_CHECKED,
													((client.percentprintingoff == 0)
													 ? MIA_CHECKED : 0)));
					return 0;
					
					         /* Config */
				case IDM_CONFIG:
				   if(client.Configure() == 1)
						client.WriteConfig();
					return 0;
                        /* Benchmarking */
				case IDM_BENCH:
				   client.StartThread(ClientBenchmark);
   				return 0;

				case IDM_BENCH2:
				   client.StartThread(ClientBenchmark2);
   				return 0;
				            /* Testing */
				case IDM_TEST:
				   client.StartThread(ClientTest);
				   return 0;
                       /* About */
				case IDM_ABOUT:                           /* About Menu */
   				WinDlgBox(HWND_DESKTOP, hwnd, AboutDlgProc, NULLHANDLE,
								 DID_ABOUT, NULL);
				   return 0;
				}
         return MRFROMSHORT(FALSE);

/***************************************************************************
      Window Control messages
****************************************************************************/
		case WM_SIZE:
		   client.WindowWidth = SHORT1FROMMP(mp2);
		   client.WindowHeight = SHORT2FROMMP(mp2);

			// Move Flush
         i = client.WindowWidth/2 - (1.5 * cxFont);
         j = client.WindowHeight - cyFont - buttonMargin;
			WinSetWindowPos(widget[Button_Flush], NULLHANDLE,
								 i,
								 j, 0, 0, SWP_MOVE);
         i += cxFont + buttonMargin;
			// Move Fetch
			WinSetWindowPos(widget[Button_Fetch], NULLHANDLE,
								 i,
								 j, 0, 0, SWP_MOVE);
			i += cxFont + buttonMargin;
			// Move Update
			WinSetWindowPos(widget[Button_Update], NULLHANDLE,
								 i,
								 j, 0, 0, SWP_MOVE);

			// Move Output
			WinSetWindowPos(client.hwndOutput, HWND_TOP, windowXMargin,
								 outputYMargin,
								 client.WindowWidth-(windowXMargin * 2),
								 client.WindowHeight - cyFont-(buttonMargin*2)-outputYMargin,
								 SWP_MOVE | SWP_SIZE);
			
			return 0;   // do not do default processing
		case WM_PAINT:
		   hps = WinBeginPaint(hwnd, NULLHANDLE, NULL);

		   // Load BG Image
		   hbm = GpiLoadBitmap(hps, NULLHANDLE, IMG_TEXTURE, sx, sy);

			// Tile it
			for(i = 0; i <= client.WindowHeight; i+=sy)
				for(j = 0; j <= client.WindowWidth; j+=sx)
					{
					ptl[0].x = j;  // Lower Left
					ptl[0].y = i;
					ptl[1].x = sx+j;  // Upper right
					ptl[1].y = sy+i;

					WinDrawBitmap(hps, hbm, NULL, ptl, CLR_NEUTRAL,
									  CLR_BACKGROUND, DBM_STRETCH);
					}
         GpiDeleteBitmap(hbm);

			// Draw Percentage Meter
			ptl[0].x = windowXMargin;
			ptl[0].y = windowYMargin;
			GpiMove(hps, &ptl[0]);
         // ptl[0].x is the same
			ptl[0].y = client.percentHeight;
			ptl[1].x = client.WindowWidth - windowXMargin;
         ptl[1].y = client.percentHeight;

			GpiSetColor(hps, CLR_DARKGRAY);
			GpiPolyLine(hps, 2, ptl);

			// Draw opposite white line
			ptl[1].x = ptl[0].x;
         ptl[1].y = windowYMargin;
			ptl[0].x = client.WindowWidth - windowXMargin;
			ptl[0].y = windowYMargin;

			GpiSetColor(hps, CLR_WHITE);
			GpiPolyLine(hps, 2, ptl);

			// Draw Dark inner line
			ptl[0].x = windowXMargin+1;
			ptl[0].y = windowYMargin+1;
			GpiMove(hps, &ptl[0]);
         // ptl[0].x is the same
			ptl[0].y = client.percentHeight-1;
			ptl[1].x = client.WindowWidth - windowXMargin - 1;
         ptl[1].y = client.percentHeight - 1;

			GpiSetColor(hps, CLR_BLACK);
			GpiPolyLine(hps, 2, ptl);

			// fall through and process the percent of status
			WinEndPaint(hps);

		case WM_UPDATE_PERCENT:
   		hps = WinGetPS(hwnd);
		
   		// Paint percent bg color
			ptl[0].x = windowXMargin+2;
			ptl[0].y = windowYMargin+1;
			GpiMove(hps, &ptl[0]);

			ptl[0].x = client.WindowWidth - windowXMargin - 1;
			ptl[0].y = client.percentHeight - 2;
			GpiSetColor(hps, CLR_PALEGRAY);
			GpiBox(hps, DRO_OUTLINEFILL, &ptl[0], 0L, 0L);

			if(!client.percentprintingoff)
				client.DrawPercentage(client.percentbar, client.numcpu-1);
			else if(client.statustext[0] != 0)
				{
				// Show status text instead
				i = sprintf(buffer, client.statustext);

				ptl[0].x = windowXMargin + 2;
            // Half of the text to display to center
				ptl[0].y = client.percentHeight / 2 - 2;

				GpiSetColor(hps, CLR_BLACK);
				GpiCharStringAt(hps, &ptl[0], i, buffer);

				}
			WinReleasePS(hps);
			return 0;   // no other default processing

		case WM_MINMAXFRAME:
		   hwndtmp = WinWindowFromID(WinQueryWindow(hwnd, QW_PARENT),
											  FID_SYSMENU);
   		if(MinMax == TRUE)
				// Minmize button hit
				MinMax = i = (int)FALSE;
			else
				{
				// Maximize button
				MinMax = i = (int)TRUE;
				}
/*
//			WinShowWindow(WinWindowFromID(hwnd, ID_STATUS), (BOOL)i);
//			WinShowWindow(WinWindowFromID(hwnd, ID_PERCENT), (BOOL)i);
			WinShowWindow(WinWindowFromID(hwnd, ID_OUTPUT), (BOOL)i);
*/			// then break and do default stuff
         break;

		case WM_CLOSE:
   		client.SetStatusText("Shutting down, waiting for all threads to finish...");
		   WinPostMsg(hwnd, WM_QUIT, 0L, 0L);
		   return 0;
		}
	return WinDefWindowProc(hwnd, msg, mp1, mp2);
	}

/*************/
/* About Box */
/*************/
MRESULT EXPENTRY AboutDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
	{
	char Text[MAX_TEXT];
	
	switch(msg)
		{
		case WM_INITDLG:
		   // Set the correct client version
		   sprintf(Text, "RC5-DES v2.%d.%d Client",
					  CLIENT_CONTEST*100 + CLIENT_BUILD, CLIENT_BUILD_FRAC);
		   WinSetWindowText(WinWindowFromID(hwnd, ID_ABOUT_VERSION), Text);
		   break;
		case WM_COMMAND:
   		switch(COMMANDMSG(&msg)->cmd)
				{
				case ID_OK:
				   WinDismissDlg(hwnd,TRUE);
				   return 0;
				}
      break;
		}
	return WinDefDlgProc(hwnd, msg, mp1, mp2);
	}

/*
	End
*/
