! Copyright distributed.net 2003 - All Rights Reserved
! For use in distributed.net projects only.
! Any other distribution or use of this source violates copyright.
!
! Author: Andreas Beckmann <andreasb@distributed.net>
!
! $Id: r72-anbe1.s,v 1.3 2007/10/22 16:48:36 jlawson Exp $
!
! This 1 pipeline core is optimized for a low instruction count by storing
! parts of S[] in registers to avoid ld/st S[i] pairs.
! This works best for not superscalar cpus and/or cpus with a small instruction
! cache. The mainloop (1020 instructions) is a little bit smaller than 4 KByte.
! Tested on a SS5 clone with a microSPARC II processor and 8 KB L1I.
!
!
! ***** Do NOT edit THIS file, edit r72-anbe1.gcc.S instead! *****
!
! This file was generated from r72-anbe1.S using the command
! gcc -E -P r72-anbe1.gcc.S | perl -pe '... see r72-anbe1.gcc.S ...' > r72-anbe1.s
! (the full perl formatting expression can be viewed in r72-anbe1.gcc.S)


.section ".text"

! extern "C" s32 rc5_72_unit_func_anbe_1( RC5_72UnitWork *, u32 *, void *)
.global rc5_72_unit_func_anbe_1
rc5_72_unit_func_anbe_1:

! Input:
! %i0 = RC5_72UnitWork *
! %i1 = u32 *iterations
! %i2 = (unused)

! Output:
! [rc5_72unitwork]
! [iterations]
! %i0 = RESULT_{NOTHING|FOUND}
        save	%sp,-(((4*(16+1+6))+(4+44 +4*(1+3+3+1+2+2))+4*(1+26+26))+(((4*(16+1+6))+(4+44 +4*(1+3+3+1+2+2))+4*(1+26+26)) % 8)),%sp
        st	%i7,[%sp+(4*(16+1+6))+0]

        st	%i0,[%fp-4]
! copy r72unitwork to %sp+(4*(16+1+6))
        ld	[%i0+0],%l0
        ld	[%i0+4],%l1
        ld	[%i0+8],%l2
        ld	[%i0+12],%l3
        ld	[%i0+28],%l4
        ld	[%i0+32],%l5
        ld	[%i0+36],%l6
        ld	[%i0+40],%l7
        st	%l0,[%fp-4-44 +(0)]
        st	%l1,[%fp-4-44 +(4)]
        st	%l2,[%fp-4-44 +(8)]
        st	%l3,[%fp-4-44 +(12)]
        st	%l4,[%fp-4-44 +(28)]
        st	%l5,[%fp-4-44 +(32)]
        st	%l6,[%fp-4-44 +(36)]
        st	%l7,[%fp-4-44 +(40)]
        st	%i1,[%fp-4-44 -4]
! about registers
! do not use %sp, %fp, %g0, %g5, %g6, %g7
! save before use: %i7
! all other registers are available for free use unless we are going to call
! some functions

! free registers: none
        ld	[%i1],%i2
        ld	[%i0+16],%i5
        ld	[%i0+20],%i4
        ld	[%i0+24],%i3

        st	%i3,[%fp-4-44 -4 -4 -4 -4 -4]
        st	%i4,[%fp-4-44 -4 -4 -4 -4 -4 -4]
        st	%i5,[%fp-4-44 -4 -4 -4 -4 -4 -4 -4]
        st	%i2,[%fp-4-44 -4 -4 -4 -4 -4 -4 -4 -4]

KEYINIT:
!! S[i] = 0xB7E15163 + i*0x9E3779B9
!! Sinit[0] = 0xB7E15163
!! Sinit[i] = Sinit[i-1]+0x9E3779B9


        set	0xB7E15163,%o7
        set	0x9E3779B9,%l5
        st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*0)]

        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*1)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*2)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*3)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*4)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*5)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*6)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*7)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*8)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*9)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*10)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*11)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*12)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*13)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*14)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*15)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*16)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*17)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*18)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*19)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*20)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*21)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*22)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*23)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*24)]
        add	%o7,%l5,%o7
	st	%o7,[%sp+(4*(16+1+6))+4+4*26+(4*25)]

! preset constant values: s0
ROUND1_S_i0_j0:
        !! S[0] = ROTL3(S[0])
        set	0xBF0A8B1D,%o1
        st	%o1,[%fp-4-44 -4 -4]

! precalculate seldom changing values in ROUND1: s1, s2, l0, l1
CALCULATE_RGLlo_DEPS_init:
	ld	[%fp-4-44 -4 -4],%o1
	ld	[%fp-4-44 -4 -4 -4 -4 -4],%i3
	add	%i3,%o1,%l0
	sll	%l0,(0xBF0A8B1D % 32),%g2
	srl	%l0,(32 - (0xBF0A8B1D % 32)),%l0
	or	%l0,%g2,%o4
	st	%o4,[%fp-4-44 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4]
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*1)],%g4
	add	%o1,%o4,%g1
	add	%g1,%g4,%g1
	sll	%g1,3,%g2
	srl	%g1,29,%g1
	or	%g1,%g2,%o2
	st	%o2,[%fp-4-44 -4 -4 -4]
CALCULATE_RGLmid_DEPS_init:
	ld	[%fp-4-44 -4 -4 -4],%o2
	ld	[%fp-4-44 -4 -4 -4 -4 -4 -4],%i4
	ld	[%fp-4-44 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4],%o4
	add	%o2,%o4,%g2
	add	%i4,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	or	%l1,%g3,%o5
	st	%o5,[%fp-4-44 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4]
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*2)],%g4
	add	%o2,%o5,%g1
	add	%g1,%g4,%g1
	sll	%g1,3,%g2
	srl	%g1,29,%g1
	or	%g1,%g2,%o3
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*3)],%g4
	add	%o5,%o3,%i7
	add	%o3,%g4,%o0
	st	%o3,[%fp-4-44 -4 -4 -4 -4]
	st	%i7,[%fp-4-44 -4 -4 -4 -4 -4 -4 -4 -4 -4]
	st	%o0,[%fp-4-44 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4]

! ##########################################################################

        b	mainloop
        nop
.align 16
mainloop:

! ROUND 1 - key expansion
        ! Precalculated:
        !! S[0] = ROTL3(S[0])
        ! RCS0	= RCP_ROTL3
        !! L[0] = ROTL(L[0]+S[0],S[0])
        ! RGL0	= ROTL(RGLlo+RCS0,0xBF0A8B1D)
        !! S[1] = ROTL3(S[1]+(S[0]+L[0]))
        ! RGS1	= ROTL3(Sinit[1]+RCS0+RGL0)
        !! L[1] = ROTL(L[1]+(S[1]+L[0]),(S[1]+L[0]))
        ! RGL1	= ROTL(RGLmid+(RGS1+RGL0),(RGS1+RGL0))
        !! S[2] = ROTL3(S[2]+S[1]+L[1])
        ! RGS2	= ROTL3(Sinit[2]+RGS1+RGL1)
        ! RGL1S2	= RGL1+RGS2
        ! RGS2S3	= RGS2+Sinit[3]


!INLINE_ROUND1_L_i2_j2:
        !! L[2] = ROTL(L[2]+(S[2]+L[1]),(S[2]+L[1]))
        !! L[2] = ROTL(RGLhi+(RGL1S2),(RGL1S2))
        !ld	[%fp-4-44 -4 -4 -4 -4 -4 -4 -4],%i5 ! keep %i5 from end of last iteration
        ld	[%fp-4-44 -4 -4 -4 -4 -4 -4 -4 -4 -4],%i7
        add	%i5,%i7,%g4
        sll	%g4,%i7,%g3
        neg	%i7,%g2
        srl	%g4,%g2,%l2
        or	%l2,%g3,%l2

INLINE_ROUND1_S_i3_j0:
        !! S[3] = ROTL3(S[3]+S[2]+L[2])
        !! S[3] = ROTL3(RGS2S3+L[2])
        ld	[%fp-4-44 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4],%o0
        add	%o0,%l2,%g1
        sll	%g1,3,%g2
        srl	%g1,29,%g1
        or	%g1,%g2,%g1


        !! S[i] = ROTL3(S[i]+S[i-1]+L[j-1])
        !! L[j] = ROTL(L[j]+(S[i]+L[j-1]),(S[i]+L[j-1]))

        !! the	ROUND1*(i,j,*) macros calculate the values reordered:
        !! L[j-1] = ROTL(L[j-1]+(S[i-1]+L[j-2]),(S[i-1]+L[j-2]))
        !! S[i] = ROTL3(S[i]+S[i-1]+L[j-1])

        ld	[%fp-4-44 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4],%o4
ROUND1_L_S_i4_j1:
	add	%g1,%l2,%g2
	add	%o4,%g2,%l0
	st	%g1,[%sp+(4*(16+1+6))+4+4*(((4 -1)+26) % 26)]
	sll	%l0,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*4)],%g4
	srl	%l0,%g2,%l0
	or	%l0,%g3,%l0
	add	%g1,%g4,%g1
	add	%g1,%l0,%g1
	sll	%g1,3,%g2
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
        ld	[%fp-4-44 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4],%o5
ROUND1_L_S_i5_j2:
	add	%g1,%l0,%g2
	add	%o5,%g2,%l1
	st	%g1,[%sp+(4*(16+1+6))+4+4*(((5 -1)+26) % 26)]
	sll	%l1,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*5)],%g4
	srl	%l1,%g2,%l1
	or	%l1,%g3,%l1
	add	%g1,%g4,%g1
	add	%g1,%l1,%g1
	sll	%g1,3,%g2
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
ROUND1_L_S_MR_i6_j0:
	add	%g1,%l1,%g2
	add	%l2,%g2,%l2
	st	%g1,[%sp+(4*(16+1+6))+4+4*(((6 -1)+26) % 26)]
	sll	%l2,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*6)],%g4
	srl	%l2,%g2,%l2
	or	%l2,%g3,%l2
	add	%g1,%g4,%l3
	add	%l3,%l2,%l3
	sll	%l3,3,%g2
	srl	%l3,29,%l3
	or	%l3,%g2,%l3
ROUND1_L_S_RR_i7_j1:
	add	%l3,%l2,%g2
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*7)],%g4
	srl	%l0,%g2,%l0
	or	%l0,%g3,%l0
	add	%l3,%g4,%l4
	add	%l4,%l0,%l4
	sll	%l4,3,%g2
	srl	%l4,29,%l4
	or	%l4,%g2,%l4
ROUND1_L_S_RR_i8_j2:
	add	%l4,%l0,%g2
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*8)],%g4
	srl	%l1,%g2,%l1
	or	%l1,%g3,%l1
	add	%l4,%g4,%l6
	add	%l6,%l1,%l6
	sll	%l6,3,%g2
	srl	%l6,29,%l6
	or	%l6,%g2,%l6
ROUND1_L_S_RR_i9_j0:
	add	%l6,%l1,%g2
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*9)],%g4
	srl	%l2,%g2,%l2
	or	%l2,%g3,%l2
	add	%l6,%g4,%l7
	add	%l7,%l2,%l7
	sll	%l7,3,%g2
	srl	%l7,29,%l7
	or	%l7,%g2,%l7
ROUND1_L_S_RR_i10_j1:
	add	%l7,%l2,%g2
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*10)],%g4
	srl	%l0,%g2,%l0
	or	%l0,%g3,%l0
	add	%l7,%g4,%i0
	add	%i0,%l0,%i0
	sll	%i0,3,%g2
	srl	%i0,29,%i0
	or	%i0,%g2,%i0
ROUND1_L_S_RR_i11_j2:
	add	%i0,%l0,%g2
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*11)],%g4
	srl	%l1,%g2,%l1
	or	%l1,%g3,%l1
	add	%i0,%g4,%i1
	add	%i1,%l1,%i1
	sll	%i1,3,%g2
	srl	%i1,29,%i1
	or	%i1,%g2,%i1
ROUND1_L_S_RR_i12_j0:
	add	%i1,%l1,%g2
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*12)],%g4
	srl	%l2,%g2,%l2
	or	%l2,%g3,%l2
	add	%i1,%g4,%i2
	add	%i2,%l2,%i2
	sll	%i2,3,%g2
	srl	%i2,29,%i2
	or	%i2,%g2,%i2
ROUND1_L_S_RR_i13_j1:
	add	%i2,%l2,%g2
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*13)],%g4
	srl	%l0,%g2,%l0
	or	%l0,%g3,%l0
	add	%i2,%g4,%i3
	add	%i3,%l0,%i3
	sll	%i3,3,%g2
	srl	%i3,29,%i3
	or	%i3,%g2,%i3
ROUND1_L_S_RR_i14_j2:
	add	%i3,%l0,%g2
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*14)],%g4
	srl	%l1,%g2,%l1
	or	%l1,%g3,%l1
	add	%i3,%g4,%i4
	add	%i4,%l1,%i4
	sll	%i4,3,%g2
	srl	%i4,29,%i4
	or	%i4,%g2,%i4
ROUND1_L_S_RR_i15_j0:
	add	%i4,%l1,%g2
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*15)],%g4
	srl	%l2,%g2,%l2
	or	%l2,%g3,%l2
	add	%i4,%g4,%i5
	add	%i5,%l2,%i5
	sll	%i5,3,%g2
	srl	%i5,29,%i5
	or	%i5,%g2,%i5
ROUND1_L_S_RR_i16_j1:
	add	%i5,%l2,%g2
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*16)],%g4
	srl	%l0,%g2,%l0
	or	%l0,%g3,%l0
	add	%i5,%g4,%i7
	add	%i7,%l0,%i7
	sll	%i7,3,%g2
	srl	%i7,29,%i7
	or	%i7,%g2,%i7
ROUND1_L_S_RR_i17_j2:
	add	%i7,%l0,%g2
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*17)],%g4
	srl	%l1,%g2,%l1
	or	%l1,%g3,%l1
	add	%i7,%g4,%o0
	add	%o0,%l1,%o0
	sll	%o0,3,%g2
	srl	%o0,29,%o0
	or	%o0,%g2,%o0
ROUND1_L_S_RR_i18_j0:
	add	%o0,%l1,%g2
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*18)],%g4
	srl	%l2,%g2,%l2
	or	%l2,%g3,%l2
	add	%o0,%g4,%o1
	add	%o1,%l2,%o1
	sll	%o1,3,%g2
	srl	%o1,29,%o1
	or	%o1,%g2,%o1
ROUND1_L_S_RR_i19_j1:
	add	%o1,%l2,%g2
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*19)],%g4
	srl	%l0,%g2,%l0
	or	%l0,%g3,%l0
	add	%o1,%g4,%o2
	add	%o2,%l0,%o2
	sll	%o2,3,%g2
	srl	%o2,29,%o2
	or	%o2,%g2,%o2
ROUND1_L_S_RR_i20_j2:
	add	%o2,%l0,%g2
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*20)],%g4
	srl	%l1,%g2,%l1
	or	%l1,%g3,%l1
	add	%o2,%g4,%o3
	add	%o3,%l1,%o3
	sll	%o3,3,%g2
	srl	%o3,29,%o3
	or	%o3,%g2,%o3
ROUND1_L_S_RR_i21_j0:
	add	%o3,%l1,%g2
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*21)],%g4
	srl	%l2,%g2,%l2
	or	%l2,%g3,%l2
	add	%o3,%g4,%o4
	add	%o4,%l2,%o4
	sll	%o4,3,%g2
	srl	%o4,29,%o4
	or	%o4,%g2,%o4
ROUND1_L_S_RR_i22_j1:
	add	%o4,%l2,%g2
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*22)],%g4
	srl	%l0,%g2,%l0
	or	%l0,%g3,%l0
	add	%o4,%g4,%o5
	add	%o5,%l0,%o5
	sll	%o5,3,%g2
	srl	%o5,29,%o5
	or	%o5,%g2,%o5
ROUND1_L_S_RR_i23_j2:
	add	%o5,%l0,%g2
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*23)],%g4
	srl	%l1,%g2,%l1
	or	%l1,%g3,%l1
	add	%o5,%g4,%o7
	add	%o7,%l1,%o7
	sll	%o7,3,%g2
	srl	%o7,29,%o7
	or	%o7,%g2,%o7
ROUND1_L_S_RR_i24_j0:
	add	%o7,%l1,%g2
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*24)],%g4
	srl	%l2,%g2,%l2
	or	%l2,%g3,%l2
	add	%o7,%g4,%l5
	add	%l5,%l2,%l5
	sll	%l5,3,%g2
	srl	%l5,29,%l5
	or	%l5,%g2,%l5
ROUND1_L_S_RM_i25_j1:
	add	%l5,%l2,%g2
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*25)],%g4
	srl	%l0,%g2,%l0
	or	%l0,%g3,%l0
	add	%l5,%g4,%g1
	add	%g1,%l0,%g1
	sll	%g1,3,%g2
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
ROUND1_L_i26_j2:
	add	%g1,%l0,%g2
	add	%l1,%g2,%l1
	st	%g1,[%sp+(4*(16+1+6))+4+4*(((26 -1)+26) % 26)]
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	or	%l1,%g3,%l1

! ##########################################################################

! ROUND 2 - key expansion
        !! S[i] = ROTL3(S[i]+S[i-1]+L[j-1])
        !! L[j] = ROTL(L[j]+(S[i]+L[j-1]),(S[i]+L[j-1]))

        !! the	ROUND2*(i,j,*) macros calculate the values reordered:
        !! L[j-1] = ROTL(L[j-1]+(S[i-1]+L[j-2]),(S[i-1]+L[j-2]))
        !! S[i] = ROTL3(S[i]+S[i-1]+L[j-1])

ROUND2_S_i0_j2:
	ld	[%fp-4-44 -4 -4],%g2
	add	%g1,%l1,%g1
	add	%g1,%g2,%g1
	sll	%g1,3,%g2
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
	st	%g1,[%sp+(4*(16+1+6))+4+4*(((0)+26) % 26)]
ROUND2_L_S_i1_j0:
	add	%g1,%l1,%g2
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	srl	%l2,%g2,%l2
	or	%l2,%g3,%l2
	ld	[%fp-4-44 -4 -4 -4],%g2
	add	%g1,%l2,%g1
	add	%g1,%g2,%g1
	sll	%g1,3,%g2
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
	st	%g1,[%sp+(4*(16+1+6))+4+4*(((1)+26) % 26)]
ROUND2_L_S_i2_j1:
	add	%g1,%l2,%g2
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	srl	%l0,%g2,%l0
	or	%l0,%g3,%l0
	ld	[%fp-4-44 -4 -4 -4 -4],%g2
	add	%g1,%l0,%g1
	add	%g1,%g2,%g1
	sll	%g1,3,%g2
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
	st	%g1,[%sp+(4*(16+1+6))+4+4*(((2)+26) % 26)]
ROUND2_L_S_i3_j2:
	add	%g1,%l0,%g2
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	or	%l1,%g3,%l1
	ld	[%sp+(4*(16+1+6))+4+4*(((3)+26) % 26)],%g2
	add	%g1,%l1,%g1
	add	%g1,%g2,%g1
	sll	%g1,3,%g2
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
	st	%g1,[%sp+(4*(16+1+6))+4+4*(((3)+26) % 26)]
ROUND2_L_S_i4_j0:
	add	%g1,%l1,%g2
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	srl	%l2,%g2,%l2
	or	%l2,%g3,%l2
	ld	[%sp+(4*(16+1+6))+4+4*(((4)+26) % 26)],%g2
	add	%g1,%l2,%g1
	add	%g1,%g2,%g1
	sll	%g1,3,%g2
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
	st	%g1,[%sp+(4*(16+1+6))+4+4*(((4)+26) % 26)]
ROUND2_L_S_i5_j1:
	add	%g1,%l2,%g2
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	srl	%l0,%g2,%l0
	or	%l0,%g3,%l0
	ld	[%sp+(4*(16+1+6))+4+4*(((5)+26) % 26)],%g2
	add	%g1,%l0,%g1
	add	%g1,%g2,%g1
	sll	%g1,3,%g2
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
	st	%g1,[%sp+(4*(16+1+6))+4+4*(((5)+26) % 26)]
ROUND2_L_S_MR_i6_j2:
	add	%g1,%l0,%g2
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	or	%l1,%g3,%l1
	add	%g1,%l3,%l3
	add	%l3,%l1,%l3
	sll	%l3,3,%g2
	srl	%l3,29,%l3
	or	%l3,%g2,%l3
        st	%l3,[%sp+(4*(16+1+6))+4+4*(((6)+26) % 26)]
ROUND2_L_S_RR_i7_j0:
	add	%l3,%l1,%g2
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	srl	%l2,%g2,%l2
	or	%l2,%g3,%l2
	add	%l3,%l4,%l4
	add	%l4,%l2,%l4
	sll	%l4,3,%g2
	srl	%l4,29,%l4
	or	%l4,%g2,%l4
        st	%l4,[%sp+(4*(16+1+6))+4+4*(((7)+26) % 26)]
ROUND2_L_S_RR_i8_j1:
	add	%l4,%l2,%g2
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	srl	%l0,%g2,%l0
	or	%l0,%g3,%l0
	add	%l4,%l6,%l6
	add	%l6,%l0,%l6
	sll	%l6,3,%g2
	srl	%l6,29,%l6
	or	%l6,%g2,%l6
ROUND2_L_S_RR_i9_j2:
	add	%l6,%l0,%g2
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	or	%l1,%g3,%l1
	add	%l6,%l7,%l7
	add	%l7,%l1,%l7
	sll	%l7,3,%g2
	srl	%l7,29,%l7
	or	%l7,%g2,%l7
ROUND2_L_S_RR_i10_j0:
	add	%l7,%l1,%g2
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	srl	%l2,%g2,%l2
	or	%l2,%g3,%l2
	add	%l7,%i0,%i0
	add	%i0,%l2,%i0
	sll	%i0,3,%g2
	srl	%i0,29,%i0
	or	%i0,%g2,%i0
ROUND2_L_S_RR_i11_j1:
	add	%i0,%l2,%g2
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	srl	%l0,%g2,%l0
	or	%l0,%g3,%l0
	add	%i0,%i1,%i1
	add	%i1,%l0,%i1
	sll	%i1,3,%g2
	srl	%i1,29,%i1
	or	%i1,%g2,%i1
ROUND2_L_S_RR_i12_j2:
	add	%i1,%l0,%g2
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	or	%l1,%g3,%l1
	add	%i1,%i2,%i2
	add	%i2,%l1,%i2
	sll	%i2,3,%g2
	srl	%i2,29,%i2
	or	%i2,%g2,%i2
ROUND2_L_S_RR_i13_j0:
	add	%i2,%l1,%g2
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	srl	%l2,%g2,%l2
	or	%l2,%g3,%l2
	add	%i2,%i3,%i3
	add	%i3,%l2,%i3
	sll	%i3,3,%g2
	srl	%i3,29,%i3
	or	%i3,%g2,%i3
ROUND2_L_S_RR_i14_j1:
	add	%i3,%l2,%g2
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	srl	%l0,%g2,%l0
	or	%l0,%g3,%l0
	add	%i3,%i4,%i4
	add	%i4,%l0,%i4
	sll	%i4,3,%g2
	srl	%i4,29,%i4
	or	%i4,%g2,%i4
ROUND2_L_S_RR_i15_j2:
	add	%i4,%l0,%g2
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	or	%l1,%g3,%l1
	add	%i4,%i5,%i5
	add	%i5,%l1,%i5
	sll	%i5,3,%g2
	srl	%i5,29,%i5
	or	%i5,%g2,%i5
ROUND2_L_S_RR_i16_j0:
	add	%i5,%l1,%g2
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	srl	%l2,%g2,%l2
	or	%l2,%g3,%l2
	add	%i5,%i7,%i7
	add	%i7,%l2,%i7
	sll	%i7,3,%g2
	srl	%i7,29,%i7
	or	%i7,%g2,%i7
ROUND2_L_S_RR_i17_j1:
	add	%i7,%l2,%g2
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	srl	%l0,%g2,%l0
	or	%l0,%g3,%l0
	add	%i7,%o0,%o0
	add	%o0,%l0,%o0
	sll	%o0,3,%g2
	srl	%o0,29,%o0
	or	%o0,%g2,%o0
ROUND2_L_S_RR_i18_j2:
	add	%o0,%l0,%g2
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	or	%l1,%g3,%l1
	add	%o0,%o1,%o1
	add	%o1,%l1,%o1
	sll	%o1,3,%g2
	srl	%o1,29,%o1
	or	%o1,%g2,%o1
ROUND2_L_S_RR_i19_j0:
	add	%o1,%l1,%g2
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	srl	%l2,%g2,%l2
	or	%l2,%g3,%l2
	add	%o1,%o2,%o2
	add	%o2,%l2,%o2
	sll	%o2,3,%g2
	srl	%o2,29,%o2
	or	%o2,%g2,%o2
ROUND2_L_S_RR_i20_j1:
	add	%o2,%l2,%g2
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	srl	%l0,%g2,%l0
	or	%l0,%g3,%l0
	add	%o2,%o3,%o3
	add	%o3,%l0,%o3
	sll	%o3,3,%g2
	srl	%o3,29,%o3
	or	%o3,%g2,%o3
ROUND2_L_S_RR_i21_j2:
	add	%o3,%l0,%g2
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	or	%l1,%g3,%l1
	add	%o3,%o4,%o4
	add	%o4,%l1,%o4
	sll	%o4,3,%g2
	srl	%o4,29,%o4
	or	%o4,%g2,%o4
ROUND2_L_S_RR_i22_j0:
	add	%o4,%l1,%g2
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	srl	%l2,%g2,%l2
	or	%l2,%g3,%l2
	add	%o4,%o5,%o5
	add	%o5,%l2,%o5
	sll	%o5,3,%g2
	srl	%o5,29,%o5
	or	%o5,%g2,%o5
ROUND2_L_S_RR_i23_j1:
	add	%o5,%l2,%g2
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	srl	%l0,%g2,%l0
	or	%l0,%g3,%l0
	add	%o5,%o7,%o7
	add	%o7,%l0,%o7
	sll	%o7,3,%g2
	srl	%o7,29,%o7
	or	%o7,%g2,%o7
ROUND2_L_S_RR_i24_j2:
	add	%o7,%l0,%g2
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	or	%l1,%g3,%l1
	add	%o7,%l5,%l5
	add	%l5,%l1,%l5
	sll	%l5,3,%g2
	srl	%l5,29,%l5
	or	%l5,%g2,%l5
ROUND2_L_S_RM_i25_j0:
	add	%l5,%l1,%g2
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	srl	%l2,%g2,%l2
	or	%l2,%g3,%l2
	ld	[%sp+(4*(16+1+6))+4+4*(((25)+26) % 26)],%g2
	add	%l5,%l2,%g1
	add	%g1,%g2,%g1
	sll	%g1,3,%g2
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
	st	%g1,[%sp+(4*(16+1+6))+4+4*(((25)+26) % 26)]
ROUND2_L_i26_j1:
	add	%g1,%l2,%g2
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	srl	%l0,%g2,%l0
	or	%l0,%g3,%l0

! ##########################################################################

! ROUND 3 - key expansion and encryption
        !! S[i] = ROTL3(S[i]+S[i-1]+L[j-1])
        !! L[j] = ROTL(L[j]+(S[i]+L[j-1]),(S[i]+L[j-1]))
        !! i	even:
        !! A	= ROTL(A^B,B)+S[i]
        !! i	odd:
        !! B	= ROTL(B^A,A)+S[i]

        !! the	ROUND3*(i,j,A,B,*) macros calculate the values reordered:
        !! L[j-1] = ROTL(L[j-1]+(S[i-1]+L[j-2]),(S[i-1]+L[j-2]))
        !! S[i] = ROTL3(S[i]+S[i-1]+L[j-1])
        !! A	= ROTL(A^B)+S[i]

        ld	[%fp-4-44 +(4)],%l3
        ld	[%fp-4-44 +(0)],%l4

ROUND3_S_i0_j1:
	ld	[%sp+(4*(16+1+6))+4+4*(((0)+26) % 26)],%g2
	add	%g1,%l0,%g1
	add	%g1,%g2,%g1
	sll	%g1,3,%g2
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
        add	%l3,%g1,%l3

ROUND3_L_S_i1_j2:
	add	%g1,%l0,%g2
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	or	%l1,%g3,%l1
	ld	[%sp+(4*(16+1+6))+4+4*(((1)+26) % 26)],%g2
	add	%g1,%l1,%g1
	add	%g1,%g2,%g1
	sll	%g1,3,%g2
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
        add	%l4,%g1,%l4

ROUND3_L_S_A_i2_j0:
	add	%g1,%l1,%g2
	xor	%l3,%l4,%l3
	sll	%l3,%l4,%g4
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	srl	%l2,%g2,%l2
	neg	%l4,%g2
	srl	%l3,%g2,%l3
	or	%l2,%g3,%l2
	ld	[%sp+(4*(16+1+6))+4+4*(((2)+26) % 26)],%g2
	add	%g1,%g2,%g1
	add	%g1,%l2,%g1
	sll	%g1,3,%g2
	or	%l3,%g4,%l3
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
	add	%l3,%g1,%l3
ROUND3_L_S_A_i3_j1:
	add	%g1,%l2,%g2
	xor	%l4,%l3,%l4
	sll	%l4,%l3,%g4
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	srl	%l0,%g2,%l0
	neg	%l3,%g2
	srl	%l4,%g2,%l4
	or	%l0,%g3,%l0
	ld	[%sp+(4*(16+1+6))+4+4*(((3)+26) % 26)],%g2
	add	%g1,%g2,%g1
	add	%g1,%l0,%g1
	sll	%g1,3,%g2
	or	%l4,%g4,%l4
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
	add	%l4,%g1,%l4
ROUND3_L_S_A_i4_j2:
	add	%g1,%l0,%g2
	xor	%l3,%l4,%l3
	sll	%l3,%l4,%g4
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	neg	%l4,%g2
	srl	%l3,%g2,%l3
	or	%l1,%g3,%l1
	ld	[%sp+(4*(16+1+6))+4+4*(((4)+26) % 26)],%g2
	add	%g1,%g2,%g1
	add	%g1,%l1,%g1
	sll	%g1,3,%g2
	or	%l3,%g4,%l3
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
	add	%l3,%g1,%l3
ROUND3_L_S_A_i5_j0:
	add	%g1,%l1,%g2
	xor	%l4,%l3,%l4
	sll	%l4,%l3,%g4
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	srl	%l2,%g2,%l2
	neg	%l3,%g2
	srl	%l4,%g2,%l4
	or	%l2,%g3,%l2
	ld	[%sp+(4*(16+1+6))+4+4*(((5)+26) % 26)],%g2
	add	%g1,%g2,%g1
	add	%g1,%l2,%g1
	sll	%g1,3,%g2
	or	%l4,%g4,%l4
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
	add	%l4,%g1,%l4
ROUND3_L_S_A_i6_j1:
	add	%g1,%l2,%g2
	xor	%l3,%l4,%l3
	sll	%l3,%l4,%g4
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	srl	%l0,%g2,%l0
	neg	%l4,%g2
	srl	%l3,%g2,%l3
	or	%l0,%g3,%l0
	ld	[%sp+(4*(16+1+6))+4+4*(((6)+26) % 26)],%g2
	add	%g1,%g2,%g1
	add	%g1,%l0,%g1
	sll	%g1,3,%g2
	or	%l3,%g4,%l3
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
	add	%l3,%g1,%l3
ROUND3_L_S_A_i7_j2:
	add	%g1,%l0,%g2
	xor	%l4,%l3,%l4
	sll	%l4,%l3,%g4
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	neg	%l3,%g2
	srl	%l4,%g2,%l4
	or	%l1,%g3,%l1
	ld	[%sp+(4*(16+1+6))+4+4*(((7)+26) % 26)],%g2
	add	%g1,%g2,%g1
	add	%g1,%l1,%g1
	sll	%g1,3,%g2
	or	%l4,%g4,%l4
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
	add	%l4,%g1,%l4
ROUND3_L_S_A_MR_i8_j0:
	add	%g1,%l1,%g2
	xor	%l3,%l4,%l3
	sll	%l3,%l4,%g4
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	srl	%l2,%g2,%l2
	neg	%l4,%g2
	srl	%l3,%g2,%l3
	or	%l2,%g3,%l2
	add	%g1,%l6,%l6
	add	%l6,%l2,%l6
	sll	%l6,3,%g2
	or	%l3,%g4,%l3
	srl	%l6,29,%l6
	or	%l6,%g2,%l6
	add	%l3,%l6,%l3
ROUND3_L_S_A_RR_i9_j1:
	add	%l6,%l2,%g2
	xor	%l4,%l3,%l4
	sll	%l4,%l3,%g4
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	srl	%l0,%g2,%l0
	neg	%l3,%g2
	srl	%l4,%g2,%l4
	or	%l0,%g3,%l0
	add	%l6,%l7,%l7
	add	%l7,%l0,%l7
	sll	%l7,3,%g2
	or	%l4,%g4,%l4
	srl	%l7,29,%l7
	or	%l7,%g2,%l7
	add	%l4,%l7,%l4
ROUND3_L_S_A_RR_i10_j2:
	add	%l7,%l0,%g2
	xor	%l3,%l4,%l3
	sll	%l3,%l4,%g4
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	neg	%l4,%g2
	srl	%l3,%g2,%l3
	or	%l1,%g3,%l1
	add	%l7,%i0,%i0
	add	%i0,%l1,%i0
	sll	%i0,3,%g2
	or	%l3,%g4,%l3
	srl	%i0,29,%i0
	or	%i0,%g2,%i0
	add	%l3,%i0,%l3
ROUND3_L_S_A_RR_i11_j0:
	add	%i0,%l1,%g2
	xor	%l4,%l3,%l4
	sll	%l4,%l3,%g4
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	srl	%l2,%g2,%l2
	neg	%l3,%g2
	srl	%l4,%g2,%l4
	or	%l2,%g3,%l2
	add	%i0,%i1,%i1
	add	%i1,%l2,%i1
	sll	%i1,3,%g2
	or	%l4,%g4,%l4
	srl	%i1,29,%i1
	or	%i1,%g2,%i1
	add	%l4,%i1,%l4
ROUND3_L_S_A_RR_i12_j1:
	add	%i1,%l2,%g2
	xor	%l3,%l4,%l3
	sll	%l3,%l4,%g4
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	srl	%l0,%g2,%l0
	neg	%l4,%g2
	srl	%l3,%g2,%l3
	or	%l0,%g3,%l0
	add	%i1,%i2,%i2
	add	%i2,%l0,%i2
	sll	%i2,3,%g2
	or	%l3,%g4,%l3
	srl	%i2,29,%i2
	or	%i2,%g2,%i2
	add	%l3,%i2,%l3
ROUND3_L_S_A_RR_i13_j2:
	add	%i2,%l0,%g2
	xor	%l4,%l3,%l4
	sll	%l4,%l3,%g4
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	neg	%l3,%g2
	srl	%l4,%g2,%l4
	or	%l1,%g3,%l1
	add	%i2,%i3,%i3
	add	%i3,%l1,%i3
	sll	%i3,3,%g2
	or	%l4,%g4,%l4
	srl	%i3,29,%i3
	or	%i3,%g2,%i3
	add	%l4,%i3,%l4
ROUND3_L_S_A_RR_i14_j0:
	add	%i3,%l1,%g2
	xor	%l3,%l4,%l3
	sll	%l3,%l4,%g4
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	srl	%l2,%g2,%l2
	neg	%l4,%g2
	srl	%l3,%g2,%l3
	or	%l2,%g3,%l2
	add	%i3,%i4,%i4
	add	%i4,%l2,%i4
	sll	%i4,3,%g2
	or	%l3,%g4,%l3
	srl	%i4,29,%i4
	or	%i4,%g2,%i4
	add	%l3,%i4,%l3
ROUND3_L_S_A_RR_i15_j1:
	add	%i4,%l2,%g2
	xor	%l4,%l3,%l4
	sll	%l4,%l3,%g4
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	srl	%l0,%g2,%l0
	neg	%l3,%g2
	srl	%l4,%g2,%l4
	or	%l0,%g3,%l0
	add	%i4,%i5,%i5
	add	%i5,%l0,%i5
	sll	%i5,3,%g2
	or	%l4,%g4,%l4
	srl	%i5,29,%i5
	or	%i5,%g2,%i5
	add	%l4,%i5,%l4
ROUND3_L_S_A_RR_i16_j2:
	add	%i5,%l0,%g2
	xor	%l3,%l4,%l3
	sll	%l3,%l4,%g4
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	neg	%l4,%g2
	srl	%l3,%g2,%l3
	or	%l1,%g3,%l1
	add	%i5,%i7,%i7
	add	%i7,%l1,%i7
	sll	%i7,3,%g2
	or	%l3,%g4,%l3
	srl	%i7,29,%i7
	or	%i7,%g2,%i7
	add	%l3,%i7,%l3
ROUND3_L_S_A_RR_i17_j0:
	add	%i7,%l1,%g2
	xor	%l4,%l3,%l4
	sll	%l4,%l3,%g4
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	srl	%l2,%g2,%l2
	neg	%l3,%g2
	srl	%l4,%g2,%l4
	or	%l2,%g3,%l2
	add	%i7,%o0,%o0
	add	%o0,%l2,%o0
	sll	%o0,3,%g2
	or	%l4,%g4,%l4
	srl	%o0,29,%o0
	or	%o0,%g2,%o0
	add	%l4,%o0,%l4
ROUND3_L_S_A_RR_i18_j1:
	add	%o0,%l2,%g2
	xor	%l3,%l4,%l3
	sll	%l3,%l4,%g4
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	srl	%l0,%g2,%l0
	neg	%l4,%g2
	srl	%l3,%g2,%l3
	or	%l0,%g3,%l0
	add	%o0,%o1,%o1
	add	%o1,%l0,%o1
	sll	%o1,3,%g2
	or	%l3,%g4,%l3
	srl	%o1,29,%o1
	or	%o1,%g2,%o1
	add	%l3,%o1,%l3
ROUND3_L_S_A_RR_i19_j2:
	add	%o1,%l0,%g2
	xor	%l4,%l3,%l4
	sll	%l4,%l3,%g4
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	neg	%l3,%g2
	srl	%l4,%g2,%l4
	or	%l1,%g3,%l1
	add	%o1,%o2,%o2
	add	%o2,%l1,%o2
	sll	%o2,3,%g2
	or	%l4,%g4,%l4
	srl	%o2,29,%o2
	or	%o2,%g2,%o2
	add	%l4,%o2,%l4
ROUND3_L_S_A_RR_i20_j0:
	add	%o2,%l1,%g2
	xor	%l3,%l4,%l3
	sll	%l3,%l4,%g4
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	srl	%l2,%g2,%l2
	neg	%l4,%g2
	srl	%l3,%g2,%l3
	or	%l2,%g3,%l2
	add	%o2,%o3,%o3
	add	%o3,%l2,%o3
	sll	%o3,3,%g2
	or	%l3,%g4,%l3
	srl	%o3,29,%o3
	or	%o3,%g2,%o3
	add	%l3,%o3,%l3
ROUND3_L_S_A_RR_i21_j1:
	add	%o3,%l2,%g2
	xor	%l4,%l3,%l4
	sll	%l4,%l3,%g4
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	srl	%l0,%g2,%l0
	neg	%l3,%g2
	srl	%l4,%g2,%l4
	or	%l0,%g3,%l0
	add	%o3,%o4,%o4
	add	%o4,%l0,%o4
	sll	%o4,3,%g2
	or	%l4,%g4,%l4
	srl	%o4,29,%o4
	or	%o4,%g2,%o4
	add	%l4,%o4,%l4
ROUND3_L_S_A_RR_i22_j2:
	add	%o4,%l0,%g2
	xor	%l3,%l4,%l3
	sll	%l3,%l4,%g4
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	neg	%l4,%g2
	srl	%l3,%g2,%l3
	or	%l1,%g3,%l1
	add	%o4,%o5,%o5
	add	%o5,%l1,%o5
	sll	%o5,3,%g2
	or	%l3,%g4,%l3
	srl	%o5,29,%o5
	or	%o5,%g2,%o5
	add	%l3,%o5,%l3
ROUND3_L_S_A_RR_i23_j0:
	add	%o5,%l1,%g2
	xor	%l4,%l3,%l4
	sll	%l4,%l3,%g4
	add	%l2,%g2,%l2
	sll	%l2,%g2,%g3
	neg	%g2
	srl	%l2,%g2,%l2
	neg	%l3,%g2
	srl	%l4,%g2,%l4
	or	%l2,%g3,%l2
	add	%o5,%o7,%o7
	add	%o7,%l2,%o7
	sll	%o7,3,%g2
	or	%l4,%g4,%l4
	srl	%o7,29,%o7
	or	%o7,%g2,%o7
	add	%l4,%o7,%l4
ROUND3_L_S_A_RR_i24_j1:
	add	%o7,%l2,%g2
	xor	%l3,%l4,%l3
	sll	%l3,%l4,%g4
	add	%l0,%g2,%l0
	sll	%l0,%g2,%g3
	neg	%g2
	srl	%l0,%g2,%l0
	neg	%l4,%g2
	srl	%l3,%g2,%l3
	or	%l0,%g3,%l0
	add	%o7,%l5,%l5
	add	%l5,%l0,%l5
	sll	%l5,3,%g2
	or	%l3,%g4,%l3
	srl	%l5,29,%l5
	or	%l5,%g2,%l5
	add	%l3,%l5,%l3
! delay ROUND3ODD_RM_i25_j2 (calculates cypher_hi) after a successful
! cypher_lo test

! ############################################################################

        ld	[%fp-4-44 +(12)],%i0
        ld	[%fp-4-44 -4 -4 -4 -4 -4 -4 -4],%i5
test_pipe_1:
        cmp	%l3,%i0
        be	partial_success
         ld	[%fp-4-44 -4 -4 -4 -4 -4 -4 -4 -4],%i2

increment_key:
        add	%i5,1,%i5
        andcc	%i5,0xff,%i5
        bz	complex_increment
         st	%i5,[%fp-4-44 -4 -4 -4 -4 -4 -4 -4]
                ! keep	the value of %i5 til the beginning of next iteration
increment_key_done:


        subcc	%i2,1,%i2
        bnz	mainloop
         st	%i2,[%fp-4-44 -4 -4 -4 -4 -4 -4 -4 -4]

! ############################################################################

end_of_mainloop:
        b	finish
         mov	1,%i0

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

complex_increment:
        ! increment	RGLmid
        ld	[%fp-4-44 -4 -4 -4 -4 -4 -4],%i4
        set	0x01000000,%l3
        set	0xFF000000,%l4
        add	%i4,%l3,%i4
        btst	%l4,%i4
        bnz	update_RGLmid
         set	0x00010000,%g2
        !set	0x00FFFFFF,RI0x00FFFFFF !!! 2 ops
        !sub	%l3,1,RI0x00FFFFFF
        add	%i4,%g2,%i4
        set	0x00FF0000,%l0
        !and	%i4,RI0x00FFFFFF,%i4
        andn	%i4,%l4,%i4
        btst	%l0,%i4
        bnz	update_RGLmid
         sub	%g2,1,%l1
        add	%i4,0x0100,%i4
        !set	0x0000FF00,%l2 !!! 2 ops
        andn	%l1,0xff,%l2
        and	%i4,%l1,%i4
        btst	%l2,%i4
        bnz	update_RGLmid
         nop
        add	%i4,0x01,%i4
        andcc	%i4,0xff,%i4
        bnz	update_RGLmid
         nop

        ! increment	RGLlo
        ld	[%fp-4-44 -4 -4 -4 -4 -4],%i3
        add	%i3,%l3,%i3
        btst	%l4,%i3
        bnz	update_RGLlo
         nop
        add	%i3,%g2,%i3
        !and	%i3,RI0x00FFFFFF,%i3
        andn	%i3,%l4,%i3
        btst	%l0,%i3
        bnz	update_RGLlo
         nop
        add	%i3,0x0100,%i3
        and	%i3,%l1,%i3
        btst	%l2,%i3
        bnz	update_RGLlo
         nop
        add	%i3,0x01,%i3
        and	%i3,0xff,%i3
        !b	update_RGLlo
        ! nop

update_RGLlo:
        st	%i3,[%fp-4-44 -4 -4 -4 -4 -4]

        ! update	precalculated values RGL0, RGS1, RGL1, RGS2
        ! first	calculate RGL0, RGS1
CALCULATE_RGLlo_DEPS_increment:
	ld	[%fp-4-44 -4 -4],%o1
	ld	[%fp-4-44 -4 -4 -4 -4 -4],%i3
	add	%i3,%o1,%l0
	sll	%l0,(0xBF0A8B1D % 32),%g2
	srl	%l0,(32 - (0xBF0A8B1D % 32)),%l0
	or	%l0,%g2,%o4
	st	%o4,[%fp-4-44 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4]
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*1)],%g4
	add	%o1,%o4,%g1
	add	%g1,%g4,%g1
	sll	%g1,3,%g2
	srl	%g1,29,%g1
	or	%g1,%g2,%o2
	st	%o2,[%fp-4-44 -4 -4 -4]
        ! and	fall through to calculate RGL1, RGS2

update_RGLmid:
        st	%i4,[%fp-4-44 -4 -4 -4 -4 -4 -4]

        ! update	precalculated values RGL1, RGS2
CALCULATE_RGLmid_DEPS_increment:
	ld	[%fp-4-44 -4 -4 -4],%o2
	ld	[%fp-4-44 -4 -4 -4 -4 -4 -4],%i4
	ld	[%fp-4-44 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4],%o4
	add	%o2,%o4,%g2
	add	%i4,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	or	%l1,%g3,%o5
	st	%o5,[%fp-4-44 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4]
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*2)],%g4
	add	%o2,%o5,%g1
	add	%g1,%g4,%g1
	sll	%g1,3,%g2
	srl	%g1,29,%g1
	or	%g1,%g2,%o3
	ld	[%sp+(4*(16+1+6))+4+4*26+(4*3)],%g4
	add	%o5,%o3,%i7
	add	%o3,%g4,%o0
	st	%o3,[%fp-4-44 -4 -4 -4 -4]
	st	%i7,[%fp-4-44 -4 -4 -4 -4 -4 -4 -4 -4 -4]
	st	%o0,[%fp-4-44 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4]
        b	increment_key_done
         nop

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

partial_success:
ROUND3_L_S_A_RM_i25_j2:
	add	%l5,%l0,%g2
	xor	%l4,%l3,%l4
	sll	%l4,%l3,%g4
	add	%l1,%g2,%l1
	sll	%l1,%g2,%g3
	neg	%g2
	srl	%l1,%g2,%l1
	neg	%l3,%g2
	srl	%l4,%g2,%l4
	or	%l1,%g3,%l1
	ld	[%sp+(4*(16+1+6))+4+4*(((25)+26) % 26)],%g2
	add	%l5,%g2,%g1
	add	%g1,%l1,%g1
	sll	%g1,3,%g2
	or	%l4,%g4,%l4
	srl	%g1,29,%g1
	or	%g1,%g2,%g1
	add	%l4,%g1,%l4
        !ld	[%fp-4-44 +(12)],RGcypher_lo
        !cmp	%l3,RGcypher_lo
        !be	test_pipe_1_lo_success
        ! nop
test_pipe_1_lo_success:
        ld	[%fp-4-44 +(28)],%g2
        ld	[%fp-4-44 -4 -4 -4 -4 -4],%i3
        ld	[%fp-4-44 -4 -4 -4 -4 -4 -4],%i4
        inc	%g2
        st	%i5,[%fp-4-44 +(32)]
        st	%i4,[%fp-4-44 +(36)]
        st	%i3,[%fp-4-44 +(40)]
        st	%g2,[%fp-4-44 +(28)]
        ld	[%fp-4-44 +(8)],%g3
        cmp	%l4,%g3
        bne	increment_key
         nop	! mov RCP,RGSinit
test_pipe_1_lohi_success:
        ld	[%fp-4-44 -4],%g2
        ld	[%fp-4-44 -4 -4 -4 -4 -4 -4 -4 -4],%i2
        ld	[%g2],%g3
        sub	%g3,%i2,%g3
        st	%g3,[%g2]
        !b	finish
         mov	2,%i0

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

finish:

! copy r72unitwork from %sp+(4*(16+1+6)) back into supplied memory
        ld	[%fp-4],%g1
        ld	[%fp-4-44 -4 -4 -4 -4 -4],%i3
        ld	[%fp-4-44 -4 -4 -4 -4 -4 -4],%i4
        ld	[%fp-4-44 -4 -4 -4 -4 -4 -4 -4],%i5
        st	%i3,[%g1+24]
        st	%i4,[%g1+20]
        st	%i5,[%g1+16]
        ld	[%fp-4-44 +(28)],%l0
        ld	[%fp-4-44 +(32)],%l1
        ld	[%fp-4-44 +(36)],%l2
        ld	[%fp-4-44 +(40)],%l3
        st	%l0,[%g1+28]
        st	%l1,[%g1+32]
        st	%l2,[%g1+36]
        st	%l3,[%g1+40]

        ld	[%sp+(4*(16+1+6))+0],%i7

        ret
        restore
