# B.4 How does capitalism affect liberty?

Private property is in many ways like a private form of state. The owner
determines what goes on within the area he or she "owns," and therefore
exercises a monopoly of power over it. When power is exercised over one's
self, it is a source of freedom, but under capitalism it is a source of
coercive authority. As Bob Black points out in **The Abolition of Work** :

> _"The liberals and conservatives and Libertarians who lament totalitarianism
> are phoneys and hypocrites. . . You find the same sort of hierarchy and
> discipline in an office or factory as you do in a prison or a monastery. . .
> A worker is a part-time slave. The boss says when to show up, when to leave,
> and what to do in the meantime. He tells you how much work to do and how
> fast. He is free to carry his control to humiliating extremes, regulating,
> if he feels like it, the clothes you wear or how often you go to the
> bathroom. With a few exceptions he can fire you for any reason, or no
> reason. He has you spied on by snitches and supervisors, he amasses a
> dossier on every employee. Talking back is called 'insubordination,' just as
> if a worker is a naughty child, and it not only gets you fired, it
> disqualifies you for unemployment compensation. . .The demeaning system of
> domination I've described rules over half the waking hours of a majority of
> women and the vast majority of men for decades, for most of their lifespans.
> For certain purposes it's not too misleading to call our system democracy or
> capitalism or -- better still -- industrialism, but its real names are
> factory fascism and office oligarchy. Anybody who says these people are
> 'free' is lying or stupid."_ [ **The Abolition of Work and other essays** ,
> p. 21]

In response to this, defenders of capitalism usually say something along the
lines of _"It's a free market and if you don't like it, find another job."_ Of
course, there are a number of problems with this response. Most obviously is
the fact that capitalism is not and has never been a "free market." As we
noted in [section B.2](secB2.md), a key role of the state has been to
protect the interests of the capitalist class and, as a consequence of this,
it has intervened time and time again to skew the market in favour of the
bosses. As such, to inform us that capitalism is something it has never been
in order to defend it from criticism is hardly convincing.

However, there is another more fundamental issue with the response, namely the
assumption that tyranny is an acceptable form of human interaction. To say
that your option is either tolerate this boss or seek out another (hopefully
more liberal) one suggests an utter lack of understanding what freedom is.
Freedom is not the opportunity to pick a master, it is to be have autonomy
over yourself. What capitalist ideology has achieved is to confuse having the
ability to pick a master with freedom, that consent equates to liberty --
regardless of the objective circumstances shaping the choices being made or
the nature of the social relationships such choices produce.

While we return to this argument in [section B.4.3](secB4.md#secb43), a few
words seem appropriate now. To see why the capitalist response misses the
point, we need only transfer the argument from the economic regime to the
political. Let us assume a system of dictatorial states on an island. Each
regime is a monarchy (i.e. a dictatorship). The King of each land decrees what
his subjects do, who they associate with and, moreover, appropriates the fruit
of their labour in exchange for food, clothing and shelter for however many
hours a day he wants (the King is generous and allows his subjects some time
to themselves in the evening and weekends). Some of the Kings even decree what
their subjects will wear and how they will greet their fellow subjects. Few
people would say that those subject to such arrangements are free.

Now, if we add the condition that any subject is free to leave a Kingdom but
only if another King will let them join his regime, does that make it any more
freer? Slightly, but not by much. The subjects how have a limited choice in
who can govern them but the **nature** of the regime they are subjected to
does not change. What we would expect to see happen is that those subjects
whose skills are in demand will get better, more liberal, conditions than the
others (as long as they are in demand). For the majority the conditions they
are forced to accept will be as bad as before as they are easily replaceable.
Both sets of subjects, however, are still under the autocratic rule of the
monarchs. Neither are free but the members of one set have a more liberal
regime than the others, dependent on the whims of the autocrats and their need
for labour.

That this thought experiment reflects the way capitalism operates is clear.
Little wonder anarchists have echoed Proudhon's complaint that _"our large
capitalist associations [are] organised in the spirit of commercial and
industrial feudalism."_ [ **Selected Writings of Pierre-Joseph Proudhon** , p.
72] Ironically, rather than deny the anarchist claim, defenders of capitalism
have tried to convince us that such a regime is liberty incarnate. Yet the
statist nature of private property can be seen in (right-wing) "Libertarian"
(i.e. "classical" liberal) works representing the extremes of laissez-faire
capitalism:

> _"[I]f one starts a private town, on land whose acquisition did not and does
> not violate the Lockean proviso [of non-aggression], persons who chose to
> move there or later remain there would have no **right** to a say in how the
> town was run, unless it was granted to them by the decision procedures for
> the town which the owner had established."_ [Robert Nozick, **Anarchy, State
> and Utopia** , p. 270]

This is voluntary feudalism, nothing more. And, indeed, it was. Such private
towns have existed, most notably the infamous company towns of US history.
Howard Zinn summarises the conditions of such "private towns" in the Colorado
mine fields:

> _"Each mining camp was a feudal dominion, with the company acting as lord
> and master. Every camp had a marshal, a law enforcement officer paid by the
> company. The 'laws' were the company's rules. Curfews were imposed,
> 'suspicious' strangers were not allowed to visit the homes, the company
> store had a monopoly on goods sold in the camp. The doctor was a company
> doctor, the schoolteachers hired by the company . . . Political power in
> Colorado rested in the hands of those who held economic power. This meant
> that the authority of Colorado Fuel & Iron and other mine operators was
> virtually supreme . . . Company officials were appointed as election judges.
> Company-dominated coroners and judges prevented injured employees from
> collecting damages."_ [ **The Colorado Coal Strike, 1913-14** , pp. 9-11]

Unsurprisingly, when the workers rebelled against this tyranny, they were
evicted from their homes and the private law enforcement agents were extremely
efficient in repressing the strikers: _"By the end of the strike, most of the
dead and injured were miners and their families."_ The strike soon took on the
features of a war, with battles between strikers and their supporters and the
company thugs. Ironically, when the National Guard was sent in to "restore
order" the _"miners, having faced in the first five weeks of the strike what
they considered a reign of terror at the hands of the private guards, . . .
looked forward"_ to their arrival. They _"did not know that the governor was
sending these troops under pressure from the mine operators."_ Indeed, the
banks and corporations lent the state funds to pay for the militia. It was
these company thugs, dressed in the uniform of the state militia, who murdered
woman and children in the infamous Ludlow Massacre of April 20th, 1914. [
**Op. Cit.** , p. 22, p. 25, p. 35]

Without irony the **New York Times** editorialised that the _"militia was as
impersonal and impartial as the law."_ The corporation itself hired Ivy Lee (
_"the father of public relations in the United States"_ ) to change public
opinion after the slaughter. Significantly, Lee produced a series of tracts
labelled _"Facts Concerning the Struggle in Colorado for Industrial Freedom."_
The head of the corporation (Rockefeller) portrayed his repression of the
strikers as blow for workers' freedom, to _"defend the workers' right to
work."_ [quoted by Zinn, **Op. Cit.** , p. 44, p. 51 and p. 50] So much for
the capitalism being the embodiment of liberty.

Of course, it can be claimed that "market forces" will result in the most
liberal owners being the most successful, but a nice master is still a master
(and, of course, capitalism then was more "free market" than today, suggesting
that this is simply wishful thinking). To paraphrase Tolstoy, _"the liberal
capitalist is like a kind donkey owner. He will do everything for the donkey
-- care for it, feed it, wash it. Everything except get off its back!"_ And as
Bob Black notes, _"Some people giving orders and others obeying them: this is
the essence of servitude. . . . But freedom means more than the right to
change masters."_ [ _The Libertarian as Conservative_ , **The Abolition of
Work and other essays** , p. 147] That supporters of capitalism often claim
that this "right" to change masters **is** the essence of "freedom" is a
telling indictment of the capitalist notion of "liberty."

Needless to say, the authoritarianism of capitalism is not limited to the
workplace. Capitalists seek to bolster their power within society as a whole,
via the state. Capitalists call upon and support the state when it acts in
**their** interests and when it supports **their** authority and power. Any
apparent "conflict" between state and capital is like two gangsters fighting
over the proceeds of a robbery: they will squabble over the loot and who has
more power in the gang, but they need each other to appropriate the goods and
defend their "property" against those from whom they stole it.

Unlike a company, however, the democratic state can be influenced by its
citizens, who are able to act in ways that limit (to some extent) the power of
the ruling elite to be "left alone" to enjoy their power. As a result, the
wealthy hate the democratic aspects of the state, and its ordinary citizens,
as potential threats to their power. This "problem" was noted by Alexis de
Tocqueville in early 19th-century America:

> _"It is easy to perceive that the wealthy members of the community entertain
> a hearty distaste to the democratic institutions of their country. The
> populace is at once the object of their scorn and their fears."_

These fears have not changed, nor has the contempt for democratic ideas. To
quote one US Corporate Executive, _"one man, one vote will result in the
eventual failure of democracy as we know it."_ [L. Silk and D. Vogel, **Ethics
and Profits: The Crisis of Confidence in American Business** , pp. 189f]

This contempt for democracy does not mean that capitalists are **anti**
-state. Far from it. As previously noted, capitalists depend on the state.
This is because _"[classical] Liberalism, is in theory a kind of anarchy
without socialism, and therefore is simply a lie, for freedom is not possible
without equality. . .The criticism liberals direct at government consists only
of wanting to deprive it some of its functions and to call upon the
capitalists to fight it out amongst themselves, but it cannot attack the
repressive functions which are of its essence: for without the **gendarme**
the property owner could not exist."_ [Errico Malatesta, **Anarchy** , p. 47]

We have discussed the state and how the ruling elite control in [section
B.2](secB2.md) and will not do so here. Nor we will discuss the ways in
which the elite use that state to enforce private property (see [section
B.3](secB3.md)) or use the state to intervene in society (see [section
D.1](secD1.md)). Rather, the rest of this section will discuss how
capitalism impacts on freedom and autonomy and why the standard apologetics by
defenders of capitalism fail.

## B.4.1 Is capitalism based on freedom?

For anarchists, freedom means both _"freedom from"_ and _"freedom to."_
"Freedom from" signifies not being subject to domination, exploitation,
coercive authority, repression, or other forms of degradation and humiliation.
"Freedom to" means being able to develop and express one's abilities, talents,
and potentials to the fullest possible extent compatible with the maximum
freedom of others. Both kinds of freedom imply the need for self-management,
responsibility, and independence, which basically means that people have a say
in the decisions that affect their lives. And since individuals do not exist
in a social vacuum, it also means that freedom **must** take on a collective
aspect, with the associations that individuals form with each other (e.g.
communities, work groups, social groups) being run in a manner which allows
the individual to participate in the decisions that the group makes. Thus
freedom for anarchists requires participatory democracy, which means face-to-
face discussion and voting on issues by the people affected by them.

Are these conditions of freedom met in the capitalist system? Obviously not.
Despite all their rhetoric about "democracy," most of the "advanced"
capitalist states remain only superficially democratic -- and this because the
majority of their citizens are employees who spend about half their waking
hours under the thumb of capitalist dictators (bosses) who allow them no voice
in the crucial economic decisions that affect their lives most profoundly and
require them to work under conditions inimical to independent thinking. If the
most basic freedom, namely freedom to think for oneself, is denied, then
freedom itself is denied.

The capitalist workplace is profoundly undemocratic. Indeed, as Noam Chomsky
points out, the oppressive authority relations in the typical corporate
hierarchy would be called fascist or totalitarian if we were referring to a
political system. In his words :

> _"There's nothing individualistic about corporations. These are big
> conglomerate institutions, essentially totalitarian in character, but hardly
> individualistic. There are few institutions in human society that have such
> strict hierarchy and top-down control as a business organisation. Nothing
> there about 'don't tread on me`. You're being tread on all the time."_ [
> **Keeping the Rabble in Line** , p. 280]

Far from being "based on freedom," then, capitalism actually destroys freedom.
In this regard, Robert E. Wood, the chief executive officer of Sears, spoke
plainly when he said _"[w]e stress the advantages of the free enterprise
system, we complain about the totalitarian state, but... we have created more
or less of a totalitarian system in industry, particularly in large
industry."_ [quoted by Allan Engler, **Apostles of Greed** , p. 68]

Or, as Chomsky puts it, supporters of capitalism do not understand _"the
**fundamental** doctrine, that you should be free from domination and control,
including the control of the manager and the owner"_ [Feb. 14th, 1992
appearance on **Pozner/Donahue** ].

Under corporate authoritarianism, the psychological traits deemed most
desirable for average citizens to possess are efficiency, conformity,
emotional detachment, insensitivity, and unquestioning obedience to authority
-- traits that allow people to survive and even prosper as employees in the
company hierarchy. And of course, for "non-average" citizens, i.e., bosses,
managers, administrators, etc., **authoritarian** traits are needed, the most
important being the ability and willingness to dominate others.

But all such master/slave traits are inimical to the functioning of real (i.e.
participatory/libertarian) democracy, which requires that citizens have
qualities like flexibility, creativity, sensitivity, understanding, emotional
honesty, directness, warmth, realism, and the ability to mediate, communicate,
negotiate, integrate and co-operate. Therefore, capitalism is not only **un**
democratic, it is **anti** -democratic, because it promotes the development of
traits that make real democracy (and so a libertarian society) impossible.

Many capitalist apologists have attempted to show that capitalist authority
structures are "voluntary" and are, therefore, somehow not a denial of
individual and social freedom. Milton Friedman (a leading free market
capitalist economist) has attempted to do just this. Like most apologists for
capitalism he ignores the authoritarian relations explicit within wage labour
(within the workplace, "co-ordination" is based upon top-down command, **not**
horizontal co-operation). Instead he concentrates on the decision of a worker
to sell their labour to a **specific** boss and so ignores the lack of freedom
within such contracts. He argues that _"individuals are effectively free to
enter or not enter into any particular exchange, so every transaction is
strictly voluntary. . . The employee is protected from coercion by the
employer because of other employers for whom he can work."_ [ **Capitalism and
Freedom** , pp. 14-15]

Friedman, to prove the free nature of capitalism, compares capitalism with a
simple exchange economy based upon independent producers. He states that in
such a simple economy each household _"has the alternative of producing
directly for itself, [and so] it need not enter into any exchange unless it
benefits from it. Hence no exchange will take place unless both parties do
benefit from it. Co-operation is thereby achieved without coercion."_ Under
capitalism (or the _"complex"_ economy) Friedman states that _"individuals are
effectively free to enter or not to enter into any particular exchange, so
that every transaction is strictly voluntary."_ [ **Op. Cit.** , p. 13 and p.
14]

A moments thought, however, shows that capitalism is not based on _"strictly
voluntary"_ transactions as Friedman claims. This is because the proviso that
is required to make every transaction _"strictly voluntary"_ is **not**
freedom not to enter any **particular** exchange, but freedom not to enter
into any exchange **at all.**

This, and only this, was the proviso that proved the simple model Friedman
presents (the one based upon artisan production) to be voluntary and non-
coercive; and nothing less than this would prove the complex model (i.e.
capitalism) is voluntary and non-coercive. But Friedman is clearly claiming
above that freedom not to enter into any **particular** exchange is enough and
so, **only by changing his own requirements** , can he claim that capitalism
is based upon freedom.

It is easy to see what Friedman has done, but it is less easy to excuse it
(particularly as it is so commonplace in capitalist apologetics). He moved
from the simple economy of exchange between independent producers to the
capitalist economy without mentioning the most important thing that
distinguishes them - namely the separation of labour from the means of
production. In the society of independent producers, the worker had the choice
of working for themselves - under capitalism this is not the case. For
capitalist economists like Friedman, workers choose whether to work or not.
The bosses must pay a wage to cover the "disutility" of labour. In reality, of
course, most workers face the choice of working or starvation/poverty.
Capitalism is based upon the existence of a labour force without access to
capital or land, and therefore without a choice as to whether to put its
labour in the market or not. Friedman would, hopefully, agree that where there
is no choice there is coercion. His attempted demonstration that capitalism
co-ordinates without coercion therefore fails.

Capitalist apologists are able to convince some people that capitalism is
"based on freedom" only because the system has certain superficial
**appearances** of freedom. On closer analysis these appearances turn out to
be deceptions. For example, it is claimed that the employees of capitalist
firms have freedom because they can always quit. To requote Bob Black:

> _"Some people giving orders and others obeying them: this is the essence of
> servitude. Of course, as [right-Libertarians] smugly [observe], 'one can at
> least change jobs,' but you can't avoid having a job -- just as under
> statism one can at least change nationalities but you can't avoid subjection
> to one nation-state or another. But freedom means more than the right to
> change masters."_ [ _"The Libertarian as Conservative"_ , **The Abolition of
> Work and other essays** , p. 147]

Under capitalism, workers have only the Hobson's choice of being
governed/exploited or living on the street.

Anarchists point out that for choice to be real, free agreements and
associations must be based on the social equality of those who enter into
them, and both sides must receive roughly equivalent benefit. But social
relations between capitalists and employees can never be equal, because
private ownership of the means of production gives rise to social hierarchy
and relations of coercive authority and subordination, as was recognised even
by Adam Smith (see [below](secB4.md#secb43)).

The picture painted by Walter Reuther (one time head of the US autoworkers'
union) of working life in America before the Wagner act is a commentary on
class inequality : _"Injustice was as common as streetcars. When men walked
into their jobs, they left their dignity, their citizenship and their humanity
outside. They were required to report for duty whether there was work or not.
While they waited on the convenience of supervisors and foremen they were
unpaid. They could be fired without a pretext. They were subjected to
arbitrary, senseless rules . . . Men were tortured by regulations that made
difficult even going to the toilet. Despite grandiloquent statements from the
presidents of huge corporations that their door was open to any worker with a
complaint, there was no one and no agency to which a worker could appeal if he
were wronged. The very idea that a worker could be wronged seemed absurd to
the employer."_ Much of this indignity remains, and with the globalisation of
capital, the bargaining position of workers is further deteriorating, so that
the gains of a century of class struggle are in danger of being lost.

A quick look at the enormous disparity of power and wealth between the
capitalist class and the working class shows that the benefits of the
"agreements" entered into between the two sides are far from equal. Walter
Block, a leading ideologue of the Canadian right-libertarian "think-tank" the
Fraser Institute, makes clear the differences in power and benefits when
discussing sexual harassment in the workplace:

> _"Consider the sexual harassment which continually occurs between a
> secretary and a boss . . . while objectionable to many women, [it] is not a
> coercive action. It is rather part of a package deal in which the secretary
> agrees to **all** aspects of the job when she agrees to accept the job, and
> especially when she agrees to **keep** the job. The office is, after all,
> private property. The secretary does not have to remain if the 'coercion' is
> objectionable."_ [quoted by Engler, **Op. Cit.** , p. 101]

The primary goal of the Fraser Institute is to convince people that all other
rights must be subordinated to the right to enjoy wealth. In this case, Block
makes clear that under private property, only bosses have "freedom to," and
most also desire to ensure they have "freedom from" interference with this
right.

So, when capitalists gush about the "liberty" available under capitalism, what
they are really thinking of is their state-protected freedom to exploit and
oppress workers through the ownership of property, a freedom that allows them
to continue amassing huge disparities of wealth, which in turn insures their
continued power and privileges. That the capitalist class in liberal-
democratic states **gives** workers the right to change masters (though this
is not true under state capitalism) is far from showing that capitalism is
based on freedom, For as Peter Kropotkin rightly points out, _"freedoms are
not given, they are taken."_ [Peter Kropotkin, **Words of a Rebel** , p. 43]
In capitalism, you are "free" to do anything you are permitted to do by your
masters, which amounts to "freedom" with a collar and leash.

## B.4.2 Is capitalism based on self-ownership?

Murray Rothbard, a leading "libertarian" capitalist, claims that capitalism is
based on the _"basic axiom"_ of _"the right to self-ownership."_ This
_"axiom"_ is defined as _"the absolute right of each man [sic] . . . to
control [his or her] body free of coercive interference. Since each individual
must think, learn, value, and choose his or her ends and means in order to
survive and flourish, the right to self-ownership gives man [sic] the right to
perform these vital activities without being hampered by coercive
molestation."_ [ **For a New Liberty** , pp. 26-27]

At first sight, this appears to sound reasonable. That we "own" ourselves and,
consequently, we decide what we do with ourselves has an intuitive appeal.
Surely this is liberty? Thus, in this perspective, liberty _"is a condition in
which a person's ownership rights in his own body and his legitimate material
property are **not** invaded, are not aggressed against."_ It also lends
itself to contrasts with slavery, where one individual owns another and _"the
slave has little or no right to self-ownership; his person and his produce are
systematically expropriated by his master by the use of violence."_ [Rothbard,
**Op. Cit.** , p. 41] This means that "self-ownership" can be portrayed as the
opposite of slavery: we have the dominion over ourselves that a slaveholder
has over their slave. This means that slavery is wrong because the slave owner
has stolen the rightful property of the slave, namely their body (and its
related abilities). This concept is sometimes expressed as people having a
"natural" or "inalienable" right to own their own body and the product of
their own labour.

Anarchists, while understanding the appeal of the idea, are not convinced.
That "self-ownership," like slavery, places issues of freedom and
individuality within the context of private property -- as such it shares the
most important claim of slavery, namely that people can be objects of the
rules of private property. It suggests an alienated perspective and, moreover,
a fatal flaw in the dogma. This can be seen from how the axiom is used in
practice. In as much as the term "self-ownership" is used simply as an synonym
for "individual autonomy" anarchists do not have an issue with it. However,
the "basic axiom" is not used in this way by the theorists of capitalism.
Liberty in the sense of individual autonomy is not what "self-ownership" aims
to justify. Rather, it aims to justify the denial of liberty, not its
exercise. It aims to portray social relationships, primarily wage labour, in
which one person commands another as examples of liberty rather than what they
are, examples of domination and oppression. In other words, "self-ownership"
becomes the means by which the autonomy of individuals is limited, if not
destroyed, in the name of freedom and liberty.

This is exposed in the right-libertarian slogan _"human rights are property
rights."_ Assuming this is true, it means that you can alienate your rights,
rent them or sell them like any other kind of property. Moreover, if you have
no property, you have no human rights as you have no place to exercise them.
As Ayn Rand, another ideologue for "free market" capitalism stated, _"there
can be no such thing as the right to unrestricted freedom of speech (or of
action) on someone else's property."_ [ **Capitalism: The Unknown Ideal** , p.
258] If you are in someone else's property (say at work) you have no basic
rights at all, beyond the right not to be harmed (a right bosses habitually
violate anyway by ignoring health and safety issues).

Self-ownership justifies this. You have rented out the property in your person
(labour services) and, consequently, another person can tell you what to do,
when to do and how to do it. Thus property comes into conflict with liberty.
If you argue that _"human rights are property rights"_ you automatically
ensure that human rights are continually violated in practice simply because
there is a conflict between property and liberty. This is not surprising, as
the "property rights" theory of liberty was created to justify the denial of
other people's liberty and the appropriation of their labour.

Clearly, then, we reach a problem with "self-ownership" (or property in the
person) once we take into account private property and its distribution. In a
nutshell, capitalists don't pay their employees to perform the other _"vital
activities"_ listed by Rothbard (learning, valuing, choosing ends and means)
-- unless, of course, the firm requires that workers undertake such activities
in the interests of company profits. Otherwise, workers can rest assured that
any efforts to engage in such _"vital activities"_ on company time **will** be
_"hampered"_ by _"coercive molestation."_ Therefore wage labour (the basis of
capitalism) in practice **denies** the rights associated with "self-
ownership," thus alienating the individual from his or her basic rights. Or as
Michael Bakunin expressed it, _"the worker sells his person and his liberty
for a given time"_ under capitalism. [ **The Political Philosophy of Bakunin**
, p. 187]

In a society of relative equals, "property" would not be a source of power as
use would co-incidence with occupancy (i.e. private property would be replaced
by possession). For example, you would still be able to fling a drunk out of
your home. But in a system based on wage labour (i.e. capitalism), property is
a different thing altogether, becoming a source of **institutionalised** power
and coercive authority through hierarchy. As Noam Chomsky writes, capitalism
is based on _"a **particular form** of authoritarian control. Namely, the kind
that comes through private ownership and control, which is an **extremely**
rigid system of domination."_ When "property" is purely what you, as an
individual, use (i.e. **possession** ) it is not a source of power. In
capitalism, however, "property" rights no longer coincide with **use** rights,
and so they become a **denial** of freedom and a source of authority and power
over the individual.

As we've seen in the discussion of hierarchy (sections
[A.2.8](secA2.md#seca28) and [B.1](secB1.md)), all forms of authoritarian
control depend on _"coercive molestation"_ \-- i.e. the use or threat of
sanctions. This is definitely the case in company hierarchies under
capitalism. Bob Black describes the authoritarian nature of capitalism as
follows:

> _"[T]he place where [adults] pass the most time and submit to the closest
> control is at work. Thus . . . it's apparent that the source of the greatest
> direct duress experienced by the ordinary adult is **not** the state but
> rather the business that employs him. Your foreman or supervisor gives you
> more or-else orders in a week than the police do in a decade."_ [ _"The
> Libertarian as Conservative"_ , **The Abolition of Work and other essays** ,
> p. 145]

In developing nations, this control can easily been seen to be an utter
affront to human dignity and liberty. There a workplace is often _"surrounded
by barbed wire. Behind its locked doors . . . workers are supervised by guards
who beat and humiliate them on the slightest pretext . . . Each worker repeats
the same action -- sewing on a belt loop, stitching a sleeve -- maybe two
thousand times a day. They work under painfully bright lights, for twelve- to
fourteen-hour shifts, in overheated factories, with too few bathroom breaks,
and restricted access to water (to reduce the need for more bathroom breaks),
which is often foul and unfit for human consumption in any event."_ The
purpose is _"to maximise the amount of profit that could be wrung out"_ of the
workers, with the _"time allocated to each task"_ being calculated in _"units
of ten thousands of a second."_ [Joel Bakan, **The Corporation** , pp. 66-7]
While in the developed world the forms of control are, in general, nowhere as
extreme (in thanks due to hard won labour organising and struggle) the basic
principle is the same. Only a sophist would argue that the workers "owned"
themselves and abilities for the period in question -- yet this is what the
advocates of "self-ownership" do argue.

So if by the term "self-ownership" it is meant "individual autonomy" then, no,
capitalism is not based on it. Ironically, the theory of "self-ownership" is
used to undercut and destroy genuine self-ownership during working hours (and,
potentially, elsewhere). The logic is simple. As I own myself I am, therefore,
able to sell myself as well, although few advocates of "self-ownership" are as
blunt as this (as we discuss in [section F.2.2](secF2.md#secf22) right-
libertarian Robert Nozick accepts that voluntary slavery flows from this
principle). Instead they stress that we "own" our labour and we contract them
to others to use. Yet, unlike other forms of property, labour cannot be
alienated. Therefore when you sell your labour you sell yourself, your
liberty, for the time in question. By alienating your labour power, you
alienate the substance of your being, your personality, for the time in
question.

As such, "self-ownership" ironically becomes the means of justifying
authoritarian social relationships which deny the autonomy it claims to
defend. Indeed, these relationships have similarities with slavery, the very
thing which its advocates like to contrast "self-ownership" to. While modern
defenders of capitalism deny this, classical economist James Mill let the cat
out of the bag by directly comparing the two. It is worthwhile to quote him at
length:

> _"The great capitalist, the owner of a manufactory, if he operated with
> slaves instead of free labourers, like the West India planter, would be
> regarded as owner both of the capital, and of the labour. He would be owner,
> in short, of both instruments of production: and the whole of the produce,
> without participation, would be his own.  
>  _
>
> _"What is the difference, in the case of the man, who operates by means of
> labourers receiving wages? The labourer, who receives wages, sells his
> labour for a day, a week, a month, or a year, as the case may be. The
> manufacturer, who pays these wages, buys the labour, for the day, the year,
> or whatever period it may be. He is equally therefore the owner of the
> labour, with the manufacturer who operates with slaves. The only difference
> is, in the mode of purchasing. The owner of the slave purchases, at once,
> the whole of the labour, which the man can ever perform: he, who pays wages,
> purchases only so much of a man's labour as he can perform in a day, or any
> other stipulated time. Being equally, however, the owner of the labour, so
> purchased, as the owner of the slave is of that of the slave, the produce,
> which is the result of this labour, combined with his capital, is all
> equally his own. In the state of society, in which we at present exist, it
> is in these circumstances that almost all production is effected: the
> capitalist is the owner of both instruments of production: and the whole of
> the produce is his."_ [ _"Elements of Political Economy"_ quoted by David
> Ellerman, **Property and Contract in Economics** , pp. 53-4

Thus the only _"difference"_ between slavery and capitalist labour is the
_"mode of purchasing."_ The labour itself and its product in both cases is
owned by the _"great capitalist."_ Clearly this is a case of, to use
Rothbard's words, during working hours the worker _"has little or no right to
self-ownership; his person and his produce are systematically expropriated by
his master."_ Little wonder anarchists have tended to call wage labour by the
more accurate term _**"wage slavery."**_ For the duration of the working day
the boss owns the labour power of the worker. As this cannot be alienated from
its "owner" this means that the boss effectively owns the worker -- and keeps
the product of their labour for the privilege of so doing!

There are key differences of course. At the time, slavery was not a voluntary
decision and the slaves could not change their master (although in some
cultures, such as Ancient Rome, people over the could sell themselves in
slavery while _" **voluntary** slavery is sanctioned in the Bible."_
[Ellerman, **Op. Cit.** , p. 115 and p. 114]). Yet the fact that under wage
slavery people are not forced to take a specific job and can change masters
does not change the relations of authority created between the two parties. As
we note in the [next section](secB4.md#secb43), the objection that people
can leave their jobs just amounts to saying "love it or leave it!" and does
not address the issue at hand. The vast majority of the population cannot
avoid wage labour and remain wage workers for most of their adult lives. It is
virtually impossible to distinguish being able to sell your liberty/labour
piecemeal over a lifetime from alienating your whole lifetime's labour at one
go. Changing who you alienate your labour/liberty to does not change the act
and experience of alienation.

Thus the paradox of self-ownership. It presupposes autonomy only in order to
deny it. In order to enter a contract, the worker exercises autonomy in
deciding whether it is advantageous to rent or sell his or her property (their
labour power) for use by another (and given that the alternative is, at best,
poverty unsurprisingly people do consider it "advantageous" to "consent" to
the contract). Yet what is rented or sold is **not** a piece of property but
rather a self-governing individual. Once the contract is made and the property
rights are transferred, they no longer have autonomy and are treated like any
other factor of production or commodity.

In the "self-ownership" thesis this is acceptable due to its assumption that
people and their labour power are property. Yet the worker cannot send along
their labour by itself to an employer. By its very nature, the worker has to
be present in the workplace if this "property" is to be put to use by the
person who has bought it. The consequence of contracting out your labour (your
property in the person) is that your autonomy (liberty) is restricted, if not
destroyed, depending on the circumstances of the particular contract signed.
This is because employers hire people, not a piece of property.

So far from being based on the "right to self-ownership," then, capitalism
effectively denies it, alienating the individual from such basic rights as
free speech, independent thought, and self-management of one's own activity,
which individuals have to **give up** when they are employed. But since these
rights, according to Rothbard, are the products of humans **as** humans, wage
labour alienates them from themselves, exactly as it does the individual's
labour power and creativity. For you do not sell your skills, as these skills
are **part** of you. Instead, what you have to sell is your **time** , your
labour power, and so **yourself.** Thus under wage labour, rights of "self-
ownership" are always placed below property rights, the only "right" being
left to you is that of finding another job (although even this right is denied
in some countries if the employee owes the company money).

It should be stressed that this is **not** a strange paradox of the "self-
ownership" axiom. Far from it. The doctrine was most famously expounded by
John Locke, who argued that _"every Man has a **Property** in his own
**Person.** This no Body has any Right to but himself."_ However, a person can
sell, _"for a certain time, the Service he undertakes to do, in exchange for
Wages he is to receive."_ The buyer of the labour then owns both it and its
product. _"Thus the Grass my Horse has bit; the Turfs my Servant has cut; and
the Ore I have digg'd in any place where I have a right to them in common with
others, becomes my **Property,** without the assignation or consent of any
body. The **labour** that was mine . . . hath **fixed** my **Property** in
them."_ [ **Second Treatise on Government** , Section 27, Section 85 and
Section 28]

Thus a person (the servant) becomes the equivalent of an animal (the horse)
once they have sold their labour to the boss. Wage labour denies the basic
humanity and autonomy of the worker. Rather than being equals, private
property produces relations of domination and alienation. Proudhon compared
this to an association in which, _"while the partnership lasts, the profits
and losses are divided between them; since each produces, not for himself, but
for the society; when the time of distribution arrives it is not the producer
who is considered, but the associated. That is why the slave, to whom the
planter gives straw and rice; and the civilised labour, to whom the capitalist
pays a salary which is always too small, -- not being associated with their
employers, although producing with them, -- are disregarded when the product
is divided. Thus the horse who draws our coaches . . . produce with us, but
are not associated with us; we take their product but do not share it with
them. The animals and labourers whom we employ hold the same relation to us."_
[ **What is Property?** , p. 226]

So while the capitalist Locke sees nothing wrong in comparing a person to an
animal, the anarchist Proudhon objects to the fundamental injustice of a
system which turns a person into a resource for another to use. And we do mean
resource, as the self-ownership thesis is also the means by which the poor
become little more than spare parts for the wealthy. After all, the poor own
their bodies and, consequently, can sell all or part of it to a willing party.
This means that someone in dire economic necessity can sell parts of their
body to the rich. Ultimately, _"[t]o tell a poor man that he **has** property
because he **has** arms and legs -- that the hunger from which he suffers, and
his power to sleep in the open air are his property, -- is to play upon words,
and to add insult to injury."_ [Proudhon, **Op. Cit.** , p. 80]

Obviously the ability to labour is **not** the property of a person -- it is
their possession. Use and ownership are fused and cannot be separated out. As
such, anarchists argue that the history of capitalism shows that there is a
considerable difference whether one said (like the defenders of capitalism)
that slavery is wrong because every person has a natural right to the property
of their own body, or because every person has a natural right freely to
determine their own destiny (like the anarchists). The first kind of right is
alienable and in the context of a capitalist regime ensures that the many
labour for those who own the means of life. The second kind of right is
inalienable as long as a person remained a person and, therefore, liberty or
self-determination is not a claim to ownership which might be both acquired
and surrendered, but an inextricable aspect of the activity of being human.

The anarchist position on the inalienable nature of human liberty also forms
the basis for the excluded to demand access to the means necessary to labour.
_"From the distinction between possession and property,"_ argued Proudhon,
_"arise two sorts of rights: the **jus in re** , the right **in** a thing, the
right by which I may reclaim the property which I have acquired, in whatever
hands I find it; and **jus ad rem** , the right **to** a thing, which gives me
a claim to become a proprietor . . . In the first, possession and property are
united; the second includes only naked property. With me who, as a labourer,
have a right to the possession of the products of Nature and my own industry
-- and who, as a proletaire, enjoy none of them -- it is by virtue of the
**jus de rem** that I demand admittance to the **jus in re.** "_ [ **Op.
Cit.** , p. 65] Thus to make the self-ownership of labour and its products a
reality for those who do the actual work in society rather than a farce,
property must be abolished -- both in terms of the means of life and also in
defining liberty and what it means to be free.

So, contrary to Rothbard's claim, capitalism in practice uses the rhetoric of
self-ownership to alienate the right to genuine self-ownership because of the
authoritarian structure of the workplace, which derives from private property.
If we desire real self-ownership, we cannot renounce it for most of our adult
lives by becoming wage slaves. Only workers' self-management of production,
not capitalism, can make self-ownership a reality:

> _"They speak of 'inherent rights', 'inalienable rights', 'natural rights,'
> etc . . . Unless the material conditions for equality exist, it is worse
> than mockery to pronounce men equal. And unless there is equality (and by
> equality I mean equal chances for every one to make the most of himself [or
> herself]) unless, I say, these equal changes exist, freedom, either of
> though, speech, or action, is equally a mockery . . . As long as the
> working-people . . . tramp the streets, whose stones they lay, whose filth
> they clean, whose sewers they dig, yet upon which they must not stand too
> long lest the policeman bid them 'move on'; as long as they go from factory
> to factory, begging for the opportunity to be a slave, receiving the insults
> of bosses and foreman, getting the old 'no,' the old shake of the head, in
> these factories they built, whose machines they wrought; so long as they
> consent to be herd like cattle, in the cities, driven year after year, more
> and more, off the mortgaged land, the land they cleared, fertilised,
> cultivated, rendered of value . . . so long as they continue to do these
> things vaguely relying upon some power outside themselves, be it god, or
> priest, or politician, or employer, or charitable society, to remedy
> matters, so long deliverance will be delayed. When they conceive the
> possibility of a complete international federation of labour, whose
> constituent groups shall take possession of land, mines, factories, all the
> instruments of production . . . , in short, conduct their own industry
> without regulative interference from law-makers or employers, then we may
> hope for the only help which counts for aught -- Self-Help; the only
> condition which can guarantee free speech [along with their other rights]
> (and no paper guarantee needed)."_ [Voltairine de Cleyre, **The Voltairine
> de Cleyre Reader** , pp. 4-6]

To conclude, the idea that capitalism is based on self-ownership is radically
at odds with reality if, by self-ownership, it is meant self-determination or
individual autonomy. However, this is not surprising given that the rationale
behind the self-ownership thesis is precisely to justify capitalist hierarchy
and its resulting restrictions on liberty. Rather than being a defence of
liberty, self-ownership is designed to facilitate its erosion. In order to
make the promise of autonomy implied by the concept of "self-ownership" a
reality, private property will need to be abolished.

For more discussion of the limitations, contradictions and fallacies of
defining liberty in terms of self-ownership and property rights, see [section
F.2](secF2.md).

## B.4.3 But no one forces you to work for them!

Of course it is claimed that entering wage labour is a "voluntary"
undertaking, from which both sides allegedly benefit. However, due to **past**
initiations of force (e.g. the seizure of land by conquest), the control of
the state by the capitalist class plus the tendency for capital to
concentrate, a relative handful of people now control vast wealth, depriving
all others access to the means of life. Thus denial of free access to the
means of life is based ultimately on the principle of "might makes right." And
as Murray Bookchin so rightly points out, _"the means of life must be taken
for what they literally are: the means without which life is impossible. To
deny them to people is more than 'theft' . . . it is outright homicide."_ [
**Remaking Society** , p. 187]

David Ellerman has also noted that the past use of force has resulted in the
majority being limited to those options allowed to them by the powers that be:

> _"It is a veritable mainstay of capitalist thought . . . that the moral
> flaws of chattel slavery have not survived in capitalism since the workers,
> unlike the slaves, are free people making voluntary wage contracts. But it
> is only that, in the case of capitalism, the denial of natural rights is
> less complete so that the worker has a residual legal personality as a free
> 'commodity owner.' He is thus allowed to voluntarily put his own working
> life to traffic. When a robber denies another person's right to make an
> infinite number of other choices besides losing his money or his life and
> the denial is backed up by a gun, then this is clearly robbery even though
> it might be said that the victim making a 'voluntary choice' between his
> remaining options. When the legal system itself denies the natural rights of
> working people in the name of the prerogatives of capital, and this denial
> is sanctioned by the legal violence of the state, then the theorists of
> 'libertarian' capitalism do not proclaim institutional robbery, but rather
> they celebrate the 'natural liberty' of working people to choose between the
> remaining options of selling their labour as a commodity and being
> unemployed."_ [quoted by Noam Chomsky, **The Chomsky Reader** , p. 186]

Therefore the existence of the labour market depends on the worker being
separated from the means of production. The natural basis of capitalism is
wage labour, wherein the majority have little option but to sell their skills,
labour and time to those who **do** own the means of production. In advanced
capitalist countries, less than 10% of the working population are self-
employed (in 1990, 7.6% in the UK, 8% in the USA and Canada - however, this
figure includes **employers** as well, meaning that the number of self-
employed **workers** is even smaller!). Hence for the vast majority, the
labour market is their only option.

Michael Bakunin notes that these facts put the worker in the position of a
serf with regard to the capitalist, even though the worker is formally "free"
and "equal" under the law:

> _"Juridically they are both equal; but economically the worker is the serf
> of the capitalist . . . thereby the worker sells his person and his liberty
> for a given time. The worker is in the position of a serf because this
> terrible threat of starvation which daily hangs over his head and over his
> family, will force him to accept any conditions imposed by the gainful
> calculations of the capitalist, the industrialist, the employer. . . .The
> worker always has the **right** to leave his employer, but has he the means
> to do so? No, he does it in order to sell himself to another employer. He is
> driven to it by the same hunger which forces him to sell himself to the
> first employer. Thus the worker's liberty . . . is only a theoretical
> freedom, lacking any means for its possible realisation, and consequently it
> is only a fictitious liberty, an utter falsehood. The truth is that the
> whole life of the worker is simply a continuous and dismaying succession of
> terms of serfdom -- voluntary from the juridical point of view but
> compulsory from an economic sense -- broken up by momentarily brief
> interludes of freedom accompanied by starvation; in other words, it is real
> slavery."_ [ **The Political Philosophy of Bakunin** , pp. 187-8]

Obviously, a company cannot **force** you to work for them but, in general,
you have to work for **someone**. How this situation developed is, of course,
usually ignored. If not glossed over as irrelevant, some fairy tale is spun in
which a few bright people saved and worked hard to accumulate capital and the
lazy majority flocked to be employed by these (almost superhuman) geniuses. In
the words of one right-wing economist (talking specifically of the industrial
revolution but whose argument is utilised today):

> _"The factory owners did not have the power to compel anybody to take a
> factory job. They could only hire people who were ready to work for the
> wages offered to them. Low as these wage rates were, they were nonetheless
> much more than these paupers could earn in any other field open to them."_
> [Ludwig von Mises, **Human Action** , pp. 619-20]

Notice the assumptions. The workers just happen have such a terrible set of
options -- the employing classes have absolutely nothing to do with it. And
these owners just happen to have all these means of production on their hands
while the working class just happen to be without property and, as a
consequence, forced to sell their labour on the owners' terms. That the state
enforces capitalist property rights and acts to defend the power of the owning
class is just another co-incidence among many. The possibility that the
employing classes might be directly implicated in state policies that reduced
the available options of workers is too ludicrous even to mention.

Yet in the real world, the power of coincidence to explain all is less
compelling. Here things are more grim as the owning class clearly benefited
from numerous acts of state violence and a general legal framework which
restricted the options available for the workers. Apparently we are meant to
believe that it is purely by strange co-incidence the state was run by the
wealthy and owning classes, not the working class, and that a whole host of
anti-labour laws and practices were implemented by random chance.

It should be stressed that this nonsense, with its underlying assumptions and
inventions, is still being peddled today. It is being repeated to combat the
protests that "multinational corporations exploit people in poor countries."
Yes, it will be readily admitted, multinationals **do** pay lower wages in
developing countries than in rich ones: that is why they go there. However, it
is argued, this represents economic advancement compares to what the other
options available are. As the corporations do not force them to work for them
and they would have stayed with what they were doing previously the charge of
exploitation is wrong. Would you, it is stressed, leave your job for one with
less pay and worse conditions? In fact, the bosses are doing them a favour in
paying such low wages for the products the companies charge such high prices
in the developed world for.

And so, by the same strange co-incidence that marked the industrial
revolution, capitalists today (in the form of multinational corporations)
gravitate toward states with terrible human rights records. States where, at
worse, death squads torture and "disappear" union and peasant co-operative
organisers or where, at best, attempts to organise a union can get you
arrested or fired and blacklisted. States were peasants are being forced of
their land as a result of government policies which favour the big landlords.
By an equally strange coincidence, the foreign policy of the American and
European governments is devoted to making sure such anti-labour regimes stay
in power. It is a co-incidence, of course, that such regimes are favoured by
the multinationals and that these states spend so much effort in providing a
"market friendly" climate to tempt the corporations to set up their sweatshops
there. It is also, apparently, just a co-incidence that these states are
controlled by the local wealthy owning classes and subject to economic
pressure by the transnationals which invest and wish to invest there.

It is clear that when a person who is mugged hands over their money to the
mugger they do so because they prefer it to the "next best alternative." As
such, it is correct that people agree to sell their liberty to a boss because
their "next best alternative" is worse (utter poverty or starvation are not
found that appealing for some reason). But so what? As anarchists have been
pointing out over a century, the capitalists have systematically used the
state to create a limit options for the many, to create buyers' market for
labour by skewing the conditions under which workers can sell their labour in
the bosses favour. To then merrily answer all criticisms of this set-up with
the response that the workers "voluntarily agreed" to work on those terms is
just hypocrisy. Does it really change things if the mugger (the state) is only
the agent (hired thug) of another criminal (the owning class)?

As such, hymns to the "free market" seem somewhat false when the reality of
the situation is such that workers do not need to be forced at gun point to
enter a specific workplace because of **past** (and more often than not,
current) "initiation of force" by the capitalist class and the state which
have created the objective conditions within which we make our employment
decisions. Before any **specific** labour market contract occurs, the
separation of workers from the means of production is an established fact (and
the resulting "labour" market usually gives the advantage to the capitalists
as a class). So while we can usually pick which capitalist to work for, we, in
general, cannot choose to work for ourselves (the self-employed sector of the
economy is tiny, which indicates well how spurious capitalist liberty actually
is). Of course, the ability to leave employment and seek it elsewhere is an
important freedom. However, this freedom, like most freedoms under capitalism,
is of limited use and hides a deeper anti-individual reality.

As Karl Polanyi puts it:

> _"In human terms such a postulate [of a labour market] implied for the
> worker extreme instability of earnings, utter absence of professional
> standards, abject readiness to be shoved and pushed about indiscriminately,
> complete dependence on the whims of the market. [Ludwig Von] Mises justly
> argued that if workers 'did not act as trade unionists, but reduced their
> demands and changed their locations and occupations according to the labour
> market, they would eventually find work.' This sums up the position under a
> system based on the postulate of the commodity character of labour. It is
> not for the commodity to decide where it should be offered for sale, to what
> purpose it should be used, at what price it should be allowed to change
> hands, and in what manner it should be consumed or destroyed."_ [ **The
> Great Transformation** , p. 176]

(Although we should point out that von Mises argument that workers will
"eventually" find work as well as being nice and vague -- how long is
"eventually"?, for example -- is contradicted by actual experience. As the
Keynesian economist Michael Stewart notes, in the nineteenth century workers
_"who lost their jobs had to redeploy fast or starve (and even this feature of
the ninetheenth century economy. . . did not prevent prolonged recessions)"_ [
**Keynes in the 1990s** , p. 31] Workers "reducing their demands" may actually
worsen an economic slump, causing more unemployment in the short run and
lengthening the length of the crisis. We address the issue of unemployment and
workers "reducing their demands" in more detail in [section C.9](secC9.md)).

It is sometimes argued that capital needs labour, so both have an equal say in
the terms offered, and hence the labour market is based on "liberty." But for
capitalism to be based on real freedom or on true free agreement, both sides
of the capital/labour divide must be equal in bargaining power, otherwise any
agreement would favour the most powerful at the expense of the other party.
However, due to the existence of private property and the states needed to
protect it, this equality is de facto impossible, regardless of the theory.
This is because. in general, capitalists have three advantages on the "free"
labour market-- the law and state placing the rights of property above those
of labour, the existence of unemployment over most of the business cycle and
capitalists having more resources to fall back on. We will discuss each in
turn.

The first advantage, namely property owners having the backing of the law and
state, ensures that when workers go on strike or use other forms of direct
action (or even when they try to form a union) the capitalist has the full
backing of the state to employ scabs, break picket lines or fire "the ring-
leaders." This obviously gives employers greater power in their bargaining
position, placing workers in a weak position (a position that may make them,
the workers, think twice before standing up for their rights).

The existence of unemployment over most of the business cycle ensures that
_"employers have a structural advantage in the labour market, because there
are typically more candidates. . . than jobs for them to fill."_ This means
that _"[c]ompetition in labour markets us typically skewed in favour of
employers: it is a buyers market. And in a buyer's market, it is the sellers
who compromise. Competition for labour is not strong enough to ensure that
workers' desires are always satisified."_ [Juliet B. Schor, **The Overworked
American** , p. 71, p. 129] If the labour market generally favours the
employer, then this obviously places working people at a disadvantage as the
threat of unemployment and the hardships associated with it encourages workers
to take any job and submit to their bosses demands and power while employed.
Unemployment, in other words, serves to discipline labour. The higher the
prevailing unemployment rate, the harder it is to find a new job, which raises
the cost of job loss and makes it less likely for workers to strike, join
unions, or to resist employer demands, and so on.

As Bakunin argued, _"the property owners... are **likewise** forced to seek
out and purchase labour... **but not in the same measure** . . . [there is no]
equality between those who offer their labour and those who purchase it."_ [
**Op. Cit.** , p. 183] This ensures that any "free agreements" made benefit
the capitalists more than the workers (see the [next
section](secB4.md#secb44) on periods of full employment, when conditions
tilt in favour of working people).

Lastly, there is the issue of inequalities in wealth and so resources. The
capitalist generally has more resources to fall back on during strikes and
while waiting to find employees (for example, large companies with many
factories can swap production to their other factories if one goes on strike).
And by having more resources to fall back on, the capitalist can hold out
longer than the worker, so placing the employer in a stronger bargaining
position and so ensuring labour contracts favour them. This was recognised by
Adam Smith:

> _"It is not difficult to foresee which of the two parties [workers and
> capitalists] must, upon all ordinary occasions... force the other into a
> compliance with their terms... In all such disputes the masters can hold out
> much longer... though they did not employ a single workman [the masters]
> could generally live a year or two upon the stocks which they already
> acquired. Many workmen could not subsist a week, few could subsist a month,
> and scare any a year without employment. In the long-run the workman may be
> as necessary to his master as his master is to him; but the necessity is not
> so immediate. . . [I]n disputes with their workmen, masters must generally
> have the advantage."_ [ **Wealth of Nations** , pp. 59-60]

How little things have changed.

So, while it is definitely the case that no one forces you to work for them,
the capitalist system is such that you have little choice but to sell your
liberty and labour on the "free market." Not only this, but the labour market
(which is what makes capitalism capitalism) is (usually) skewed in favour of
the employer, so ensuring that any "free agreements" made on it favour the
boss and result in the workers submitting to domination and exploitation. This
is why anarchists support collective organisation (such as unions) and
resistance (such as strikes), direct action and solidarity to make us as, if
not more, powerful than our exploiters and win important reforms and
improvements (and, ultimately, change society), even when faced with the
disadvantages on the labour market we have indicated. The despotism associated
with property (to use Proudhon's expression) is resisted by those subject to
it and, needless to say, the boss does not always win.

## B.4.4 But what about periods of high demand for labour?

Of course there are periods when the demand for labour exceeds supply, but
these periods hold the seeds of depression for capitalism, as workers are in
an excellent position to challenge, both individually and collectively, their
allotted role as commodities. This point is discussed in more detail in
section C.7 ([What causes the capitalist business cycle? ](secC7.md)) and so
we will not do so here. For now it's enough to point out that during normal
times (i.e. over most of the business cycle), capitalists often enjoy
extensive authority over workers, an authority deriving from the unequal
bargaining power between capital and labour, as noted by Adam Smith and many
others.

However, this changes during times of high demand for labour. To illustrate,
let us assume that supply and demand approximate each other. It is clear that
such a situation is only good for the worker. Bosses cannot easily fire a
worker as there is no one to replace them and the workers, either collectively
by solidarity or individually by "exit" (i.e. quitting and moving to a new
job), can ensure a boss respects their interests and, indeed, can push these
interests to the full. The boss finds it hard to keep their authority intact
or from stopping wages rising and causing a profits squeeze. In other words,
as unemployment drops, workers power increases.

Looking at it another way, giving someone the right to hire and fire an input
into a production process vests that individual with considerable power over
that input unless it is costless for that input to move; that is unless the
input is perfectly mobile. This is only approximated in real life for labour
during periods of full employment, and so perfect mobility of **labour** costs
problems for a capitalist firm because under such conditions workers are not
dependent on a particular capitalist and so the level of worker effort is
determined far more by the decisions of workers (either collectively or
individually) than by managerial authority. The threat of firing cannot be
used as a threat to increase effort, and hence production, and so full
employment increases workers power.

With the capitalist firm being a fixed commitment of resources, this situation
is intolerable. Such times are bad for business and so occur rarely with free
market capitalism (we must point out that in neo-classical economics, it is
assumed that all inputs - including capital - are perfectly mobile and so the
theory ignores reality and assumes away **capitalist production** itself!).

During the last period of capitalist boom, the post-war period, we can see the
breakdown of capitalist authority and the fear this held for the ruling elite.
The Trilateral Commission's 1975 report, which attempted to "understand" the
growing discontent among the general population, makes our point well. In
periods of full employment, according to the report, there is _"an excess of
democracy."_ In other words, due to the increased bargaining power workers
gained during a period of high demand for labour, people started thinking
about and acting upon their needs as **humans,** not as commodities embodying
labour power. This naturally had devastating effects on capitalist and statist
authority: _"People no longer felt the same compulsion to obey those whom they
had previously considered superior to themselves in age, rank, status,
expertise, character, or talent"_.

This loosening of the bonds of compulsion and obedience led to _"previously
passive or unorganised groups in the population, blacks, Indians, Chicanos,
white ethnic groups, students and women... embark[ing] on concerted efforts to
establish their claims to opportunities, rewards, and privileges, which they
had not considered themselves entitled to before."_

Such an _"excess"_ of participation in politics of course posed a serious
threat to the status quo, since for the elites who authored the report, it was
considered axiomatic that _"the effective operation of a democratic political
system usually requires some measure of apathy and non-involvement on the part
of some individuals and groups. . . . In itself, this marginality on the part
of some groups is inherently undemocratic, but it is also one of the factors
which has enabled democracy to function effectively."_ Such a statement
reveals the hollowness of the establishment's concept of 'democracy,' which in
order to function effectively (i.e. to serve elite interests) must be
_"inherently undemocratic."_

Any period where people feel empowered allows them to communicate with their
fellows, identify their needs and desires, and resist those forces that deny
their freedom to manage their own lives. Such resistance strikes a deadly blow
at the capitalist need to treat people as commodities, since (to re-quote
Polanyi) people no longer feel that it _"is not for the commodity to decide
where it should be offered for sale, to what purpose it should be used, at
what price it should be allowed to change hands, and in what manner it should
be consumed or destroyed."_ Instead, as thinking and feeling people, they act
to reclaim their freedom and humanity.

As noted at the beginning of this section, the economic effects of such
periods of empowerment and revolt are discussed in [section C.7](secC7.md).
We will end by quoting the Polish economist Michal Kalecki, who noted that a
continuous capitalist boom would **not** be in the interests of the ruling
class. In 1943, in response to the more optimistic Keynesians, he noted that
_"to maintain the high level of employment. . . in the subsequent boom, a
strong opposition of 'business leaders' is likely to be encountered. . .
lasting full employment is not at all to their liking. The workers would 'get
out of hand' and the 'captains of industry' would be anxious 'to teach them a
lesson'"_ because _"under a regime of permanent full employment, 'the sack'
would cease to play its role as a disciplinary measure. The social position of
the boss would be undermined and the self assurance and class consciousness of
the working class would grow. Strikes for wage increases and improvements in
conditions of work would create political tension. . . 'discipline in the
factories' and 'political stability' are more appreciated by business leaders
than profits. Their class interest tells them that lasting full employment is
unsound from their point of view and that unemployment is an integral part of
the normal capitalist system."_ [quoted by Malcolm C. Sawyer, **The Economics
of Michal Kalecki** , p. 139 and p. 138]

Therefore, periods when the demand for labour outstrips supply are not healthy
for capitalism, as they allow people to assert their freedom and humanity --
both fatal to the system. This is why news of large numbers of new jobs sends
the stock market plunging and why capitalists are so keen these days to
maintain a "natural" rate of unemployment (that it has to be maintained
indicates that it is **not** "natural"). Kalecki, we must point out, also
correctly predicted the rise of _"a powerful bloc"_ between _"big business and
the rentier interests"_ against full employment and that _"they would probably
find more than one economist to declare that the situation was manifestly
unsound."_ The resulting _"pressure of all these forces, and in particular big
business"_ would _"induce the Government to return to. . . orthodox policy."_
[Kalecki, quoted by Sawyer, **Op. Cit.** , p. 140] This is exactly what
happened in the 1970s, with the monetarists and other sections of the "free
market" right providing the ideological support for the business lead class
war, and whose "theories" (when applied) promptly generated massive
unemployment, thus teaching the working class the required lesson.

So, although detrimental to profit-making, periods of recession and high
unemployment are not only unavoidable but are necessary to capitalism in order
to _"discipline"_ workers and _"teach them a lesson."_ And in all, it is
little wonder that capitalism rarely produces periods approximating full
employment -- they are **not** in its interests (see also section
[C.9](secC9.md)). The dynamics of capitalism makes recession and
unemployment inevitable, just as it makes class struggle (which creates these
dynamics) inevitable.

## B.4.5 But I want to be "left alone"!

It is ironic that supporters of laissez-faire capitalism, such as
"Libertarians" and "anarcho"-capitalists, should claim that they want to be
"left alone," since capitalism **never** allows this. As Max Stirner expressed
it:

> _"Restless acquisition does not let us take breath, take a calm
> **enjoyment**. We do not get the comfort of our possessions. . ."_ [Max
> Stirner **The Ego and Its Own** , p. 268]

Capitalism cannot let us _"take breath"_ simply because it needs to grow or
die, which puts constant pressure on both workers and capitalists (see
[section D.4.1](secD4.md#secd41)). Workers can never relax or be free of
anxiety about losing their jobs, because if they do not work, they do not eat,
nor can they ensure that their children will get a better life. Within the
workplace, they are not "left alone" by their bosses in order to manage their
own activities. Instead, they are told what to do, when to do it and how to do
it. Indeed, the history of experiments in workers' control and self-management
within capitalist companies confirms our claims that, for the worker,
capitalism is incompatible with the desire to be "left alone." As an
illustration we will use the _**"Pilot Program"**_ conducted by General
Electric between 1968 and 1972.

General Electric proposed the "Pilot Program" as a means of overcoming the
problems they faced with introducing Numeric Control (N/C) machinery into its
plant at Lynn River Works, Massachusetts. Faced with rising tensions on the
shop floor, bottle-necks in production and low-quality products, GE management
tried a scheme of _"job enrichment"_ based on workers' control of production
in one area of the plant. By June 1970 the workers' involved were _"on their
own"_ (as one manager put it) and _"[i]n terms of group job enlargement this
was when the Pilot Project really began, with immediate results in increased
output and machine utilisation, and a reduction on manufacturing losses. As
one union official remarked two years later, 'The fact that we broke down a
traditional policy of GE [that the union could never have a hand in managing
the business] was in itself satisfying, especially when we could throw success
up to them to boot.'"_ [David Noble, **Forces of Production** , p. 295]

The project, after some initial scepticism, proved to be a great success with
the workers involved. Indeed, other workers in the factory desired to be
included and the union soon tried to get it spread throughout the plant and
into other GE locations. The success of the scheme was that it was based on
workers' managing their own affairs rather than being told what to do by their
bosses -- _"We are human beings,"_ said one worker, _"and want to be treated
as such."_ [quoted by Noble, **Op. Cit.** , p. 292] To be fully human means to
be free to govern oneself in all aspects of life, including production.

However, just after a year of the workers being given control over their
working lives, management stopped the project. Why? _"In the eyes of some
management supporters of the 'experiment,' the Pilot Program was terminated
because management as a whole refused to give up any of its traditional
authority . . . [t]he Pilot Program foundered on the basic contradiction of
capitalist production: Who's running the shop?"_ [Noble, **Op. Cit.** , p.
318]

Noble goes on to argue that to GE's top management, _"the union's desire to
extend the program appeared as a step toward greater workers control over
production and, as such, a threat to the traditional authority rooted in
private ownership of the means of production. Thus the decision to terminate
represented a defence not only of the prerogatives of production supervisors
and plant managers but also of the power vested in property ownership."_ He
notes that this result was not an isolated case and that the _"demise of the
GE Pilot Program followed the typical pattern for such 'job enrichment
experiments'"_ [ **Op. Cit.** , p. 318 and p. 320] Even though _"[s]everal
dozen well-documented experiments show that productivity increases and social
problems decrease when workers participate in the work decisions affecting
their lives"_ [Department of Health, Education and Welfare study quoted by
Noble, **Op. Cit.** , p. 322] such schemes are ended by bosses seeking to
preserve their own power, the power that flows from private property.

As one worker in the GE Pilot Program stated, _"[w]e just want to be left
alone."_ They were not -- capitalist social relations prohibit such a
possibility (as Noble correctly notes, _"the 'way of life' for the management
meant controlling the lives of others"_ [ **Op. Cit.** , p. 294 and p. 300]).
In spite of improved productivity, projects in workers' control are scrapped
because they undermined both the power of the capitalists -- and by
undermining their power, you potentially undermine their profits too ( _"If
we're all one, for manufacturing reasons, we must share in the fruits
equitably, just like a co-op business."_ [GE Pilot Program worker, quoted by
Noble, **Op. Cit.** , p. 295]).

As we argue in more detail in [ section J.5.12](secJ5.md#secj512), profit
maximisation can work against efficiency, meaning that capitalism can harm the
overall economy by promoting less efficient production techniques (i.e.
hierarchical ones against egalitarian ones) because it is in the interests of
capitalists to do so and the capitalist market rewards that behaviour. This is
because, ultimately, profits are unpaid labour. If you empower labour, give
workers' control over their work then they will increase efficiency and
productivity (they know how to do their job the best) but you also erode
authority structures within the workplace. Workers' will seek more and more
control (freedom naturally tries to grow) and this, as the Pilot Program
worker clearly saw, implies a co-operative workplace in which workers',
**not** managers, decide what to do with the surplus produced. By threatening
power, you threaten profits (or, more correctly, who controls the profit and
where it goes). With the control over production **and** who gets to control
any surplus in danger, it is unsurprising that companies soon abandon such
schemes and return to the old, less efficient, hierarchical schemes based on
_"Do what you are told, for as long as you are told."_ Such a regime is hardly
fit for free people and, as Noble notes, the regime that replaced the GE Pilot
Program was _"designed to 'break' the pilots of their new found 'habits' of
self-reliance, self-discipline, and self-respect."_ [ **Op. Cit.** , p. 307]

Thus the experience of workers' control project within capitalist firms
indicates well that capitalism cannot _"leave you alone"_ if you are a wage
slave.

Moreover, capitalists themselves cannot relax because they must ensure their
workers' productivity rises faster than their workers' wages, otherwise their
business will fail (see sections [C.2](secC2.md) and [C.3](secC3.md)).
This means that every company has to innovate or be left behind, to be put out
of business or work. Hence the boss is not "left alone" -- their decisions are
made under the duress of market forces, of the necessities imposed by
competition on individual capitalists. Restless acquisition -- in this
context, the necessity to accumulate capital in order to survive in the market
-- always haunts the capitalist. And since unpaid labour is the key to
capitalist expansion, work must continue to exist and grow -- necessitating
the boss to control the working hours of the worker to ensure that they
produce more goods than they receive in wages. The boss is not "left alone"
nor do they leave the worker alone.

These facts, based upon the authority relations associated with private
property and relentless competition, ensure that the desire to be "left alone"
cannot be satisfied under capitalism.

As Murray Bookchin observes:

> _"Despite their assertions of autonomy and distrust of state authority . . .
> classical liberal thinkers did not in the last instance hold to the notion
> that the individual is completely free from lawful guidance. Indeed, their
> interpretation of autonomy actually presupposed quite definite arrangements
> beyond the individual -- notably, the laws of the marketplace. Individual
> autonomy to the contrary, these laws constitute a social organising system
> in which all 'collections of individuals' are held under the sway of the
> famous 'invisible hand' of competition. Paradoxically, the laws of the
> marketplace override the exercise of 'free will' by the same sovereign
> individuals who otherwise constitute the "collection of individuals."_ [
> _"Communalism: The Democratic Dimension of Anarchism"_ , pp. 1-17,
> **Democracy and Nature** no. 8, p. 4]

Human interaction is an essential part of life. Anarchism proposes to
eliminate only undesired social interactions and authoritarian impositions,
which are inherent in capitalism and indeed in any hierarchical form of socio-
economic organisation (e.g. state socialism). Hermits soon become less than
human, as social interaction enriches and develops individuality. Capitalism
may attempt to reduce us to hermits, only "connected" by the market, but such
a denial of our humanity and individuality inevitably feeds the spirit of
revolt. In practice the "laws" of the market and the hierarchy of capital will
never "leave one alone," but instead, crush one's individuality and freedom.
Yet this aspect of capitalism conflicts with the human "instinct for freedom,"
as Noam Chomsky describes it, and hence there arises a counter-tendency toward
radicalisation and rebellion among any oppressed people (see [section
J](secJcon.md)).

One last point. The desire to "be left alone" often expresses two drastically
different ideas -- the wish to be your own master and manage your own affairs
and the desire by bosses and landlords to have more power over their property.
However, the authority exercised by such owners over their property is also
exercised over **those who use that property.** Therefore, the notion of
"being left alone" contains two contradictory aspects within a class ridden
and hierarchical society. Obviously anarchists are sympathetic to the first,
inherently libertarian, aspect -- the desire to manage your own life, in your
own way -- but we reject the second aspect and any implication that it is in
the interests of the governed to leave those in power alone. Rather, it is in
the interest of the governed to subject those with authority over them to as
much control as possible -- for obvious reasons.

Therefore, working people are more or less free to the extent that they
**restrict** the ability of their bosses to be "left alone." One of the aims
of anarchists within a capitalist society is **ensure** that those in power
are **not** "left alone" to exercise their authority over those subject to it.
We see solidarity, direct action and workplace and community organisation as a
means of interfering with the authority of the state, capitalists and property
owners until such time as we can destroy such authoritarian social
relationships once and for all.

Hence anarchist dislike of the term "laissez-faire" -- within a class society
it can only mean protecting the powerful against the working class (under the
banner of "neutrally" enforcing property rights and so **the power derived
from them** ). However, we are well aware of the other, libertarian, vision
expressed in the desire to be "left alone." That is the reason we have
discussed why capitalist society can never actually achieve that desire -- it
is handicapped by its hierarchical and competitive nature -- and how such a
desire can be twisted into a means of enhancing the power of the few over the
many.

[‹ B.3 Why are anarchists against private property?](secB3.md "Go to
previous page") [up](secBcon.md "Go to parent page") [B.5 Is capitalism
empowering and based on human action? ›](secB5.md "Go to next page")

