# C.5 Why does Big Business get a bigger slice of profits?

As described in the [last section](secC4.md), due to the nature of the
capitalist market, large firms soon come to dominate. Once a few large
companies dominate a particular market, they form an oligopoly from which a
large number of competitors have effectively been excluded, thus reducing
competitive pressures. In this situation there is a tendency for prices to
rise above what would be the "market" level, as the oligopolistic producers do
not face the potential of new capital entering "their" market (due to the
relatively high capital costs and other entry/movement barriers).

The domination of a market by a few big firms results in exploitation, but of
a different kind than that rooted in production. Capitalism is based on the
extraction of surplus value of workers in the production process. When a
market is marked by oligopoly, this exploitation is supplemented by the
exploitation of **consumers** who are charged higher prices than would be the
case in a more competitive market. This form of competition results in Big
Business having an "unfair" slice of available profits as oligopolistic
profits are _"created at the expense of individual capitals still caught up in
competition."_ [Paul Mattick, **Economics, Politics, and the Age of
Inflation** , p. 38]

To understand why big business gets a bigger slice of the economic pie, we
need to look at what neo-classical economics tries to avoid, namely production
and market power. Mainstream economics views capitalism as a mode of
distribution (the market), not a mode of production. Rather than a world of
free and equal exchanges, capitalism is marked by hierarchy, inequality and
power. This reality explains what regulates market prices and the impact of
big business. In the long term, market price cannot be viewed independently of
production. As David Ricardo put it:

> _"It is the cost of production which must ultimately regulate the price of
> commodities, and not, as has been often said, the proportion between the
> supply and demand: the proportion between supply and demand may, indeed, for
> a time, affect the market value of a commodity, until it is supplied in
> greater or less abundance, according as the demand may have increased or
> diminished; but this effect will be only of temporary duration."_ [ **The
> Principles of Political Economy and Taxation** , p. 260]

Market prices, in this (classical) analysis, are the prices that prevail at
any given time on the market (and change due to transient and random
variations). Natural prices are the cost of production and act as centres of
gravitational attraction for market prices. Over time, market prices are tend
towards natural prices but are considered unlikely to exactly meet them.
Natural prices can only change due to changes in the productive process (for
example, by introducing new, more productive, machinery and/or by decreasing
the wages of the workforce relative to its output). Surplus value (the
difference between market and natural prices) are the key to understanding how
supply changes to meet demand. This produces the dynamic of market forces:

> _"Let us suppose that all commodities are at their natural price, and
> consequently that the profits of capital in all employments are exactly at
> the same rate . . . Suppose now that a change of fashion should increase the
> demand for silks, and lessen that for woollens; their natural price, the
> quantity of labour necessary to their production, would continue unaltered,
> but the market price of silks would rise, and that of woollens would fall;
> and consequently the profits of the silk manufacturer would be above, whilst
> those of the woollen manufacturer would be below, the general and adjusted
> rate of profits . . . This increased demand for silks would however soon be
> supplied, by the transference of capital and labour from the woollen to the
> silk manufacture; when the market prices of silks and woollens would again
> approach their natural prices, and then the usual profits would be obtained
> by the respective manufacturers of those commodities. It is then the desire,
> which every capitalist has, of diverting his funds from a less to a more
> profitable employment, that prevents the market price of commodities from
> continuing for any length of time either much above, or much below their
> natural price."_ [ **Op. Cit.** , p. 50]

This means that _"capital moves from relatively stagnating into rapidly
developing industries . . . The extra profit, in excess of the average profit,
won at a given price level disappears again, however, with the influx of
capital from profit-poor into profit-rich industries,"_ so increasing supply
and reducing prices, and thus profits. In other words, _"market relations are
governed by the production relations."_ [Paul Mattick, **Economic Crisis and
Crisis Theory** , p. 49 and p. 51]

In a developed capitalist economy it is not as simple as this -- there are
various "average" profits depending on what Michal Kalecki termed the
_**"degree of monopoly"**_ within a market. This theory _"indicates that
profits arise from monopoly power, and hence profits accrue to firms with more
monopoly power . . . A rise in the degree of monopoly caused by the growth of
large firms would result in the shift of profits from small business to big
business."_ [Malcolm C. Sawyer, **The Economics of Michal Kalecki** , p. 36]
This means that a market with a high "degree of monopoly" will have a few
firms in it with higher than average profit levels (or rate of return)
compared to the smaller firms in the sector or to those in more competitive
markets.

The "degree of monopoly" reflects such factors as level of market
concentration and power, market share, extent of advertising, barriers to
entry/movement, collusion and so on. The higher these factors, the higher the
degree of monopoly and the higher the mark-up of prices over costs (and so the
share of profits in value added). Our approach to this issue is similar to
Kalecki's in many ways although we stress that the degree of monopoly affects
how profits are distributed **between** firms, **not** how they are created in
the first place (which come, as argued in [section C.2](secC2.md), from the
_"unpaid labour of the poor"_ \-- to use Kropotkin's words).

There is substantial evidence to support such a theory. J.S Bain in **Barriers
in New Competition** noted that in industries where the level of seller
concentration was very high and where entry barriers were also substantial,
profit rates were higher than average. Research has tended to confirm Bain's
findings. Keith Cowling summarises this later evidence:

> _"[A]s far as the USA is concerned. . . there are grounds for believing that
> a significant, but not very strong, relationship exists between
> profitability and concentration. . . [along with] a significant relationship
> between advertising and profitability [an important factor in a market's
> "degree of monopoly"]. . . [Moreover w]here the estimation is restricted to
> an appropriate cross-section [of industry] . . . both concentration and
> advertising appeared significant [for the UK]. By focusing on the impact of
> changes in concentration overtime . . . [we are] able to circumvent the
> major problems posed by the lack of appropriate estimates of price
> elasticities of demand . . . [to find] a significant and positive
> concentration effect. . . It seems reasonable to conclude on the basis of
> evidence for both the USA and UK that there is a significant relationship
> between concentration and price-cost margins."_ [ **Monopoly Capitalism** ,
> pp. 109-110]

We must note that the price-cost margin variable typically used in these
studies subtracts the wage and **salary** bill from the value added in
production. This would have a tendency to reduce the margin as it does not
take into account that most management salaries (particularly those at the top
of the hierarchy) are more akin to profits than costs (and so should **not**
be subtracted from value added). Also, as many markets are regionalised
(particularly in the USA) nation-wide analysis may downplay the level of
concentration existing in a given market.

The argument is not that big business charges "high prices" in respect to
smaller competitors but rather they charge high prices in comparison to their
costs. This means that a corporation can sell at the standard market price (or
even undercut the prices of small business) and still make higher profits than
average. In other words, market power ensures that prices do not fall to cost.
Moreover, market power ensures that "costs" are often inflicted on others as
big business uses its economic clout to externalise costs onto suppliers and
its workers. For example, this means that farmers and other small producers
will agree to lower prices for goods when supplying large supermarkets while
the employees have to put up with lower wages and benefits (which extend
through the market, creating lower wages and fewer jobs for retail workers in
the surrounding area). Possibly, lower prices can be attributed to lower
quality products (which workers are forced to buy in order to make their lower
wages go further).

This means that large firms can maintain their prices and profits above
"normal" (competitive) levels without the assistance of government simply due
to their size and market power (and let us not forget the important fact that
Big Business rose during the period in which capitalism was closest to
"laissez faire" and the size and activity of the state was small). As much of
mainstream economics is based on the idea of "perfect competition" (and the
related concept that the free market is an efficient allocater of resources
when it approximates this condition) it is clear that such a finding cuts to
the heart of claims that capitalism is a system based upon equal opportunity,
freedom and justice. The existence of Big Business and the impact it has on
the rest of the economy and society at large exposes capitalist economics as a
house built on sand.

Another side effect of oligopoly is that the number of mergers will tend to
increase in the run up to a slump. Just as credit is expanded in an attempt to
hold off the crisis (see [section C.8](secC8.md)), so firms will merge in an
attempt to increase their market power and so improve their profit margins by
increasing their mark-up over costs. As the rate of profit levels off and
falls, mergers are an attempt to raise profits by increasing the degree of
monopoly in the market/economy. However, this is a short term solution and can
only postpone, but stop, the crisis as its roots lie in production, **not**
the market (see [section C.7](secC7.md)) -- there is only so much surplus
value around and the capital stock cannot be wished away. Once the slump
occurs, a period of cut-throat competition will start and then, slowly, the
process of concentration will start again (as weak firms go under, successful
firms increase their market share and capital stock and so on).

The development of oligopolies within capitalism thus causes a redistribution
of profits away from small capitalists to Big Business (i.e. small businesses
are squeezed by big ones due to the latter's market power and size). Moreover,
the existence of oligopoly can and does result in increased costs faced by Big
Business being passed on in the form of price increases, which can force other
companies, in unrelated markets, to raise **their** prices in order to realise
sufficient profits. Therefore, oligopoly has a tendency to create price
increases across the market as a whole and can thus be inflationary.

For these (and other) reasons many small businessmen and members of the
middle-class wind up hating Big Business (while trying to replace them!) and
embracing ideologies which promise to wipe them out. Hence we see that both
ideologies of the "radical" middle-class -- Libertarianism and fascism --
attack Big Business, either as "the socialism of Big Business" targeted by
Libertarianism or the "International Plutocracy" by Fascism. As Peter Sabatini
notes:

> _"At the turn of the century, local entrepreneurial
> (proprietorship/partnership) business [in the USA] was overshadowed in short
> order by transnational corporate capitalism. . . . The various strata
> comprising the capitalist class responded differentially to these
> transpiring events as a function of their respective position of benefit.
> Small business that remained as such came to greatly resent the economic
> advantage corporate capitalism secured to itself, and the sweeping changes
> the latter imposed on the presumed ground rules of bourgeois competition.
> Nevertheless, because capitalism is liberalism's raison d'etre, small
> business operators had little choice but to blame the state for their
> financial woes, otherwise they moved themselves to another ideological camp
> (anti-capitalism). Hence, the enlarged state was imputed as the primary
> cause for capitalism's 'aberration' into its monopoly form, and thus it
> became the scapegoat for small business complaint."_ [ **Libertarianism:
> Bogus Anarchy** ]

However, despite the complaints of small capitalists, the tendency of markets
to become dominated by a few big firms is an obvious side-effect of capitalism
itself. _"If the home of 'Big Business' was once the public utilities and
manufacturing it now seems to be equally comfortable in any environment."_
[M.A. Utton, **Op. Cit.** , p. 29] This is because in their drive to expand
(which they must do in order to survive), capitalists invest in new machinery
and plants in order to reduce production costs and so increase profits. Hence
a successful capitalist firm will grow in size over time in order to squeeze
out competitors and, in so doing, it naturally creates formidable natural
barriers to competition -- excluding all but other large firms from
undermining its market position.

## C.5.1 Aren't the super-profits of Big Business due to its higher
efficiency?

Obviously the analysis of Big Business profitability presented in [section
C.5](secC5.md) is denied by supporters of capitalism. H. Demsetz of the
pro-"free" market "Chicago School" of economists (which echoes the "Austrian"
school's position that whatever happens on a free market is for the best)
argues that **efficiency** (not degree of monopoly) is the cause of the super-
profits for Big Business. His argument is that if oligopolistic profits are
due to high levels of concentration, then the big firms in an industry will
not be able to stop smaller ones reaping the benefits of this in the form of
higher profits. So if concentration leads to high profits (due, mostly, to
collusion between the dominant firms) then smaller firms in the same industry
should benefit too.

However, his argument is flawed as it is not the case that oligopolies
practice overt collusion. The barriers to entry/mobility are such that the
dominant firms in a oligopolistic market do not have to compete by price and
their market power allows a mark-up over costs which market forces cannot
undermine. As their only possible competitors are similarly large firms,
collusion is not required as these firms have no interest in reducing the
mark-up they share and so they "compete" over market share by non-price
methods such as advertising (advertising, as well as being a barrier to entry,
reduces price competition and increases mark-up).

In his study, Demsetz notes that while there is a positive correlation between
profit rate and market concentration, smaller firms in the oligarchic market
are **not** more profitable than their counterparts in other markets. [M.A.
Utton, **The Political Economy of Big Business** , p. 98] From this Demsetz
concludes that oligopoly is irrelevant and that the efficiency of increased
size is the source of excess profits. But this misses the point -- smaller
firms in concentrated industries will have a similar profitability to firms of
similar size in less concentrated markets, **not** higher profitability. The
existence of super profits across **all** the firms in a given industry would
attract firms to that market, so reducing profits. However, because
profitability is associated with the large firms in the market the barriers of
entry/movement associated with Big Business stops this process happening.
**If** small firms were as profitable, then entry would be easier and so the
"degree of monopoly" would be low and we would see an influx of smaller firms.

While it is true that bigger firms may gain advantages associated with
economies of scale the question surely is, what stops the smaller firms
investing and increasing the size of their companies in order to reap
economies of scale within and between workplaces? What is stopping market
forces eroding super-profits by capital moving into the industry and
increasing the number of firms, and so increasing supply? If barriers exist to
stop this process occurring, then concentration, market power and other
barriers to entry/movement (not efficiency) is the issue. Competition is a
**process,** not a state, and this indicates that "efficiency" is not the
source of oligopolistic profits (indeed, what creates the apparent
"efficiency" of big firms is likely to be the barriers to market forces which
add to the mark-up!).

It is important to recognise what is "small" and "big" is dependent on the
industry in question and so size advantages obviously differ from industry to
industry. The optimum size of plant may be large in some sectors but
relatively small in others (some workplaces have to be of a certain size in
order to be technically efficient in a given market). However, this relates to
technical efficiency, rather than overall "efficiency" associated with a firm.
This means that technological issues cannot, by themselves, explain the size
of modern corporations. Technology may, at best, explain the increase in size
of the factory, but it does not explain why the modern large firm comprises
multiple factories. In other words, the company, the **administrative** unit,
is usually much larger than the workplace, the **production** unit. The
reasons for this lie in the way in which production technologies interacted
with economic institutions and market power.

It seems likely that large firms gather "economies of scale" due to the size
of the firm, not plant, as well as from the level of concentration within an
industry: _"Considerable evidence indicates that economies of scale [at plant
level] . . . do not account for the high concentration levels in U.S.
industry"_ [Richard B. Du Boff, **Accumulation and Power** , p. 174] Further,
_"the explanation for the enormous growth in aggregate concentration must be
found in factors other than economies of scale at plant level."_ [M.A. Utton,
**Op. Cit.** , p. 44] Co-ordination of individual plants by the visible hand
of management seems to play a key role in creating and maintaining dominant
positions within a market. And, of course, these structures are costly to
create and maintain as well as taking time to build up. Thus the size of the
firm, with the economies of scale **beyond** the workplace associated with the
economic power this produces within the marke creates formidable barriers to
entry/movement.

So an important factor influencing the profitability of Big Business is the
clout that market power provides. This comes in two main forms - horizontal
and vertical controls:

> _"Horizontal controls allow oligopolies to control necessary steps in an
> economic process from material supplies to processing, manufacturing,
> transportation and distribution. Oligopolies. . . [control] more of the
> highest quality and most accessible supplies than they intend to market
> immediately. . . competitors are left with lower quality or more expensive
> supplies. . . [It is also] based on exclusive possession of technologies,
> patents and franchises as well as on excess productive capacity . . .  
>  _
>
> _"Vertical controls substitute administrative command for exchange between
> steps of economic processes. The largest oligopolies procure materials from
> their own subsidiaries, process and manufacture these in their own
> refineries, mills and factories, transport their own goods and then market
> these through their own distribution and sales network."_ [Allan Engler,
> **Apostles of Greed** , p. 51]

Moreover, large firms reduce their costs due to their privileged access to
credit and resources. Both credit and advertising show economies of scale,
meaning that as the size of loans and advertising increase, costs go down. In
the case of finance, interest rates are usually cheaper for big firms than
small ones and while _"firms of all sizes find most [about 70% between 1970
and 1984] of their investments without having to resort to [financial] markets
or banks"_ size does have an impact on the _"importance of banks as a source
of finance"_ : _"Firms with assets under $100 million relied on banks for
around 70% of their long-term debt. . . those with assets from $250 million to
$1 billion, 41%; and those with over $1 billion in assets, 15%."_ [Doug
Henwood, **Wall Street** , p. 75] Also dominant firms can get better deals
with independent suppliers and distributors due to their market clout and
their large demand for goods/inputs, also reducing their costs.

This means that oligopolies are more "efficient" (i.e. have higher profits)
than smaller firms due to the benefits associated with their market power
rather than vice versa. Concentration (and firm size) leads to "economies of
scale" which smaller firms in the same market cannot gain access to. Hence the
claim that any positive association between concentration and profit rates is
simply recording the fact that the largest firms tend to be most efficient,
and hence more profitable, is wrong. In addition, _"Demsetz's findings have
been questioned by non-Chicago [school] critics"_ due to the inappropriateness
of the evidence used as well as some of his analysis techniques. Overall,
_"the empirical work gives limited support"_ to this "free-market" explanation
of oligopolistic profits and instead suggest market power plays the key role.
[William L. Baldwin, **Market Power, Competition and Anti-Trust Policy** , p.
310, p. 315]

Unsurprisingly we find that the _"bigger the corporation in size of assets or
the larger its market share, the higher its rate of profit: these findings
confirm the advantages of market power. . . Furthermore, 'large firms in
concentrated industries earn systematically higher profits than do all other
firms, about 30 percent more. . . on average,' and there is less variation in
profit rates too."_ Thus, concentration, not efficiency, is the key to
profitability, with those factors what create "efficiency" themselves being
very effective barriers to entry which helps maintain the "degree of monopoly"
(and so mark-up and profits for the dominant firms) in a market. Oligopolies
have varying degrees of administrative efficiency and market power, all of
which consolidate its position. Thus the _"barriers to entry posed by
decreasing unit costs of production and distribution and by national
organisations of managers, buyers, salesmen, and service personnel made
oligopoly advantages cumulative -- and were as global in their implications as
they were national."_ [Richard B. Du Boff, **Accumulation and Power** , p. 175
and p. 150]

This explains why capitalists always seek to acquire monopoly power, to
destroy the assumptions of neo-classical economics, so they can influence the
price, quantity and quality of the product. It also ensures that in the real
world there are, unlike the models of mainstream economics, entrenched
economic forces and why there is little equal opportunity. Why, in other
words, the market in most sectors is an oligopoly.

This recent research confirms Kropotkin's analysis of capitalism found in his
classic work **Fields, Factories and Workshops**. Kropotkin, after extensive
investigation of the actual situation within the economy, argued that _"it is
not the superiority of the **technical** organisation of the trade in a
factory, nor the economies realised on the prime-mover, which militate against
the small industry . . . but the more advantageous conditions for **selling**
the produce and for **buying** the raw produce which are at the disposal of
big concerns."_ Since the _"manufacture being a strictly private enterprise,
its owners find it advantageous to have all the branches of a given industry
under their own management: they thus cumulate the profits of the successful
transformations of the raw material. . . [and soon] the owner finds his
advantage in being able to hold the command of the market. But from a
**technical** point of view the advantages of such an accumulation are
trifling and often doubtful."_ He sums up by stating that _"[t]his is why the
'concentration' so much spoken of is often nothing but an amalgamation of
capitalists for the purpose of **dominating the market,** not for cheapening
the technical process."_ [ **Fields, Factories and Workshops Tomorrow** , p.
147, p. 153 and p. 154]

It should be stressed that Kropotkin, like other anarchists, recognised that
technical efficiencies differed from industry to industry and so the optimum
size of plant may be large in some sectors but relatively small in others. As
such, he did not fetishise "smallness" as some Marxists assert (see [section
H.2.3](secH2.md#sech23)). Rather, Kropotkin was keenly aware that capitalism
operated on principles which submerged technical efficiency by the price
mechanism which, in turn, was submerged by economic power. While not denying
that "economies of scale" existed, Kropotkin recognised that what counts as
"efficient" under capitalism is specific to that system. Thus whatever
increases profits is "efficient" under capitalism, whether it is using market
power to drive down costs (credit, raw materials or labour) or internalising
profits by building suppliers. Under capitalism profit is used as a
(misleading) alternative for efficiency (influenced, as it is, by market
power) and this distorts the size of firms/workplaces. In a sane society, one
based on economic freedom, workplaces would be re-organised to take into
account technical efficiency and the needs of the people who used them rather
than what maximises the profits and power of the few.

All this means is that the "degree of monopoly" within an industry helps
determine the distribution of profits within an economy, with some of the
surplus value "created" by other companies being realised by Big Business.
Hence, the oligopolies reduce the pool of profits available to other companies
in more competitive markets by charging consumers higher prices than a more
competitive market would. As high capital costs reduce mobility within and
exclude most competitors from entering the oligopolistic market, it means that
only if the oligopolies raise their prices **too** high can real competition
become possible (i.e. profitable) again and so _"it should not be concluded
that oligopolies can set prices as high as they like. If prices are set too
high, dominant firms from other industries would be tempted to move in and
gain a share of the exceptional returns. Small producers -- using more
expensive materials or out-dated technologies -- would be able to increase
their share of the market and make the competitive rate of profit or better."_
[Allan Engler, **Op. Cit.** , p. 53]

Big Business, therefore, receives a larger share of the available surplus
value in the economy, due to its size advantage and market power, not due to
"higher efficiency".

[‹ C.4 Why does the market become dominated by Big Business?](secC4.md "Go
to previous page") [up](secCcon.md "Go to parent page") [C.6 Can market
dominance by Big Business change? ›](secC6.md "Go to next page")

