/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.SearchPathHelper;
import cz.startnet.utils.pgdiff.schema.PgColumn;
import cz.startnet.utils.pgdiff.schema.PgColumnPrivilege;
import cz.startnet.utils.pgdiff.schema.PgRelationPrivilege;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgView;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PgDiffViews {
    public static void createViews(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgView pgView : pgSchema2.getViews()) {
            PgView pgView2 = null;
            if (Objects.nonNull(pgSchema)) {
                pgView2 = pgSchema.getView(pgView.getName());
            }
            if (pgSchema != null && pgSchema.containsView(pgView.getName()) && !PgDiffViews.isViewModified(pgView2, pgView)) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.println(pgView.getCreationSQL());
            if (pgView.getOwnerTo() != null && pgView2 == null) {
                printWriter.println();
                printWriter.println("ALTER VIEW " + PgDiffUtils.getQuotedName(pgView.getName()) + " OWNER TO " + pgView.getOwnerTo() + ";");
            }
            for (PgRelationPrivilege pgRelationPrivilege : pgView.getPrivileges()) {
                printWriter.println("REVOKE ALL ON TABLE " + PgDiffUtils.getQuotedName(pgView.getName()) + " FROM " + pgRelationPrivilege.getRoleName() + ";");
                if (!"".equals(pgRelationPrivilege.getPrivilegesSQL(true))) {
                    printWriter.println("GRANT " + pgRelationPrivilege.getPrivilegesSQL(true) + " ON TABLE " + PgDiffUtils.getQuotedName(pgView.getName()) + " TO " + pgRelationPrivilege.getRoleName() + " WITH GRANT OPTION;");
                }
                if ("".equals(pgRelationPrivilege.getPrivilegesSQL(false))) continue;
                printWriter.println("GRANT " + pgRelationPrivilege.getPrivilegesSQL(false) + " ON TABLE " + PgDiffUtils.getQuotedName(pgView.getName()) + " TO " + pgRelationPrivilege.getRoleName() + ";");
            }
        }
    }

    public static void dropViews(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        if (pgSchema == null) {
            return;
        }
        for (PgView pgView : pgSchema.getViews()) {
            PgView pgView2 = pgSchema2.getView(pgView.getName());
            if (pgView2 != null && !PgDiffViews.isViewModified(pgView, pgView2)) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.println(pgView.getDropSQL());
        }
    }

    private static boolean isViewModified(PgView pgView, PgView pgView2) {
        if (!pgView.getQuery().trim().equals(pgView2.getQuery().trim())) {
            return true;
        }
        if (pgView.isMaterialized() != pgView2.isMaterialized()) {
            return true;
        }
        List<String> list = pgView.getDeclaredColumnNames();
        List<String> list2 = pgView2.getDeclaredColumnNames();
        if (list != null && list2 != null) {
            return !list.equals(list2);
        }
        return list != list2;
    }

    public static void alterViews(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        if (pgSchema == null) {
            return;
        }
        for (PgView pgView : pgSchema.getViews()) {
            PgView pgView2 = pgSchema2.getView(pgView.getName());
            if (pgView2 == null) continue;
            PgDiffViews.diffDefaultValues(printWriter, pgView, pgView2, searchPathHelper);
            if (pgView.getComment() == null && pgView2.getComment() != null || pgView.getComment() != null && pgView2.getComment() != null && !pgView.getComment().equals(pgView2.getComment())) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.print("COMMENT ON VIEW ");
                printWriter.print(PgDiffUtils.getQuotedName(pgView2.getName()));
                printWriter.print(" IS ");
                printWriter.print(pgView2.getComment());
                printWriter.println(';');
            } else if (pgView.getComment() != null && pgView2.getComment() == null) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.print("COMMENT ON VIEW ");
                printWriter.print(PgDiffUtils.getQuotedName(pgView2.getName()));
                printWriter.println(" IS NULL;");
            }
            ArrayList<String> arrayList = new ArrayList<String>(pgView2.getColumns().size());
            for (PgColumn pgColumn : pgView2.getColumns()) {
                arrayList.add(pgColumn.getName());
            }
            for (PgColumn pgColumn : pgView.getColumns()) {
                if (arrayList.contains(pgColumn.getName())) continue;
                arrayList.add(pgColumn.getName());
            }
            for (String string : arrayList) {
                String string2 = null;
                String string3 = null;
                PgColumn pgColumn = pgView.getColumn(string);
                PgColumn pgColumn2 = pgView2.getColumn(string);
                if (pgColumn != null) {
                    string2 = pgColumn.getComment();
                }
                if (pgColumn2 != null) {
                    string3 = pgColumn2.getComment();
                }
                if (string2 == null && string3 != null || string2 != null && string3 != null && !string2.equals(string3)) {
                    searchPathHelper.outputSearchPath(printWriter);
                    printWriter.println();
                    printWriter.print("COMMENT ON COLUMN ");
                    printWriter.print(PgDiffUtils.getQuotedName(pgView2.getName()));
                    printWriter.print('.');
                    printWriter.print(PgDiffUtils.getQuotedName(pgColumn2.getName()));
                    printWriter.print(" IS ");
                    printWriter.print(pgColumn2.getComment());
                    printWriter.println(';');
                    continue;
                }
                if (string2 == null || string3 != null) continue;
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.print("COMMENT ON COLUMN ");
                printWriter.print(PgDiffUtils.getQuotedName(pgView2.getName()));
                printWriter.print('.');
                printWriter.print(PgDiffUtils.getQuotedName(pgColumn.getName()));
                printWriter.println(" IS NULL;");
            }
            if (pgView.getOwnerTo() != null && !pgView2.getOwnerTo().equals(pgView.getOwnerTo())) {
                printWriter.println();
                printWriter.println("ALTER VIEW " + PgDiffUtils.getQuotedName(pgView2.getName()) + " OWNER TO " + pgView2.getOwnerTo() + ";");
            }
            PgDiffViews.alterPrivileges(printWriter, pgView, pgView2, searchPathHelper);
            PgDiffViews.alterPrivilegesColumns(printWriter, pgView, pgView2, searchPathHelper);
        }
    }

    private static void diffDefaultValues(PrintWriter printWriter, PgView pgView, PgView pgView2, SearchPathHelper searchPathHelper) {
        PgColumn pgColumn;
        for (PgColumn pgColumn2 : pgView.getColumns()) {
            if (pgColumn2.getDefaultValue() == null) continue;
            pgColumn = pgView2.getColumn(pgColumn2.getName());
            if (pgColumn != null && pgColumn.getDefaultValue() != null) {
                if (pgColumn2.getDefaultValue().equals(pgColumn.getDefaultValue())) continue;
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.print("ALTER TABLE ");
                printWriter.print(PgDiffUtils.getQuotedName(pgView2.getName()));
                printWriter.print(" ALTER COLUMN ");
                printWriter.print(PgDiffUtils.getQuotedName(pgColumn.getName()));
                printWriter.print(" SET DEFAULT ");
                printWriter.print(pgColumn.getDefaultValue());
                printWriter.println(';');
                continue;
            }
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.print("ALTER TABLE ");
            printWriter.print(PgDiffUtils.getQuotedName(pgView2.getName()));
            printWriter.print(" ALTER COLUMN ");
            printWriter.print(PgDiffUtils.getQuotedName(pgColumn2.getName()));
            printWriter.println(" DROP DEFAULT;");
        }
        for (PgColumn pgColumn2 : pgView2.getColumns()) {
            pgColumn = pgView.getColumn(pgColumn2.getName());
            if (pgColumn != null && pgColumn.getDefaultValue() != null || pgColumn2.getDefaultValue() == null) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.print("ALTER TABLE ");
            printWriter.print(PgDiffUtils.getQuotedName(pgView2.getName()));
            printWriter.print(" ALTER COLUMN ");
            printWriter.print(PgDiffUtils.getQuotedName(pgColumn2.getName()));
            printWriter.print(" SET DEFAULT ");
            printWriter.print(pgColumn2.getDefaultValue());
            printWriter.println(';');
        }
    }

    private static void alterPrivileges(PrintWriter printWriter, PgView pgView, PgView pgView2, SearchPathHelper searchPathHelper) {
        PgRelationPrivilege pgRelationPrivilege;
        boolean bl = false;
        for (PgRelationPrivilege pgRelationPrivilege2 : pgView.getPrivileges()) {
            pgRelationPrivilege = pgView2.getPrivilege(pgRelationPrivilege2.getRoleName());
            if (pgRelationPrivilege == null) {
                if (!bl) {
                    printWriter.println();
                }
                printWriter.println("REVOKE ALL ON TABLE " + PgDiffUtils.getQuotedName(pgView.getName()) + " FROM " + pgRelationPrivilege2.getRoleName() + ";");
                continue;
            }
            if (pgRelationPrivilege2.isSimilar(pgRelationPrivilege)) continue;
            if (!bl) {
                printWriter.println();
            }
            printWriter.println("REVOKE ALL ON TABLE " + PgDiffUtils.getQuotedName(pgView2.getName()) + " FROM " + pgRelationPrivilege.getRoleName() + ";");
            if (!"".equals(pgRelationPrivilege.getPrivilegesSQL(true))) {
                printWriter.println("GRANT " + pgRelationPrivilege.getPrivilegesSQL(true) + " ON TABLE " + PgDiffUtils.getQuotedName(pgView2.getName()) + " TO " + pgRelationPrivilege.getRoleName() + " WITH GRANT OPTION;");
            }
            if ("".equals(pgRelationPrivilege.getPrivilegesSQL(false))) continue;
            printWriter.println("GRANT " + pgRelationPrivilege.getPrivilegesSQL(false) + " ON TABLE " + PgDiffUtils.getQuotedName(pgView2.getName()) + " TO " + pgRelationPrivilege.getRoleName() + ";");
        }
        for (PgRelationPrivilege pgRelationPrivilege2 : pgView2.getPrivileges()) {
            pgRelationPrivilege = pgView.getPrivilege(pgRelationPrivilege2.getRoleName());
            if (pgRelationPrivilege != null) continue;
            if (!bl) {
                printWriter.println();
            }
            printWriter.println("REVOKE ALL ON TABLE " + PgDiffUtils.getQuotedName(pgView2.getName()) + " FROM " + pgRelationPrivilege2.getRoleName() + ";");
            if (!"".equals(pgRelationPrivilege2.getPrivilegesSQL(true))) {
                printWriter.println("GRANT " + pgRelationPrivilege2.getPrivilegesSQL(true) + " ON TABLE " + PgDiffUtils.getQuotedName(pgView2.getName()) + " TO " + pgRelationPrivilege2.getRoleName() + " WITH GRANT OPTION;");
            }
            if ("".equals(pgRelationPrivilege2.getPrivilegesSQL(false))) continue;
            printWriter.println("GRANT " + pgRelationPrivilege2.getPrivilegesSQL(false) + " ON TABLE " + PgDiffUtils.getQuotedName(pgView2.getName()) + " TO " + pgRelationPrivilege2.getRoleName() + ";");
        }
    }

    private static void alterPrivilegesColumns(PrintWriter printWriter, PgView pgView, PgView pgView2, SearchPathHelper searchPathHelper) {
        boolean bl = false;
        for (PgColumn pgColumn : pgView2.getColumns()) {
            PgColumnPrivilege pgColumnPrivilege;
            PgColumn pgColumn2 = pgView.getColumn(pgColumn.getName());
            if (pgColumn2 != null) {
                for (PgColumnPrivilege pgColumnPrivilege2 : pgColumn2.getPrivileges()) {
                    pgColumnPrivilege = pgColumn.getPrivilege(pgColumnPrivilege2.getRoleName());
                    if (pgColumnPrivilege != null) continue;
                    if (!bl) {
                        bl = true;
                        printWriter.println();
                    }
                    printWriter.println("REVOKE ALL (" + PgDiffUtils.getQuotedName(pgColumn.getName()) + ") ON TABLE " + PgDiffUtils.getQuotedName(pgView2.getName()) + " FROM " + pgColumnPrivilege2.getRoleName() + ";");
                }
            }
            if (pgColumn == null) continue;
            for (PgColumnPrivilege pgColumnPrivilege2 : pgColumn.getPrivileges()) {
                pgColumnPrivilege = null;
                if (pgColumn2 != null) {
                    pgColumnPrivilege = pgColumn2.getPrivilege(pgColumnPrivilege2.getRoleName());
                }
                if (pgColumnPrivilege2.isSimilar(pgColumnPrivilege)) continue;
                if (!bl) {
                    bl = true;
                    printWriter.println();
                }
                printWriter.println("REVOKE ALL (" + PgDiffUtils.getQuotedName(pgColumn.getName()) + ") ON TABLE " + PgDiffUtils.getQuotedName(pgView2.getName()) + " FROM " + pgColumnPrivilege2.getRoleName() + ";");
                if (!"".equals(pgColumnPrivilege2.getPrivilegesSQL(true, PgDiffUtils.getQuotedName(pgColumn.getName())))) {
                    printWriter.println("GRANT " + pgColumnPrivilege2.getPrivilegesSQL(true, PgDiffUtils.getQuotedName(pgColumn.getName())) + " ON TABLE " + PgDiffUtils.getQuotedName(pgView2.getName()) + " TO " + pgColumnPrivilege2.getRoleName() + " WITH GRANT OPTION;");
                }
                if ("".equals(pgColumnPrivilege2.getPrivilegesSQL(false, PgDiffUtils.getQuotedName(pgColumn.getName())))) continue;
                printWriter.println("GRANT " + pgColumnPrivilege2.getPrivilegesSQL(false, PgDiffUtils.getQuotedName(pgColumn.getName())) + " ON TABLE " + PgDiffUtils.getQuotedName(pgView2.getName()) + " TO " + pgColumnPrivilege2.getRoleName() + ";");
            }
        }
    }

    private PgDiffViews() {
    }
}

