/* SPDX-License-Identifier: GPL-2.0-or-later */

#include <baseboard/gpio.h>
#include <baseboard/variants.h>
#include <gpio.h>

/* Pad configuration in ramstage */
static const struct pad_config override_gpio_table[] = {
	/* A23 : ESPI_CS1# ==> NC */
	PAD_NC_LOCK(GPP_A23, NONE, LOCK_CONFIG),
	/* B7  : ISH_12C1_SDA ==> PCH_I2C_MISCB_SDA */
	PAD_CFG_NF_LOCK(GPP_B7, NONE, NF2, LOCK_CONFIG),
	/* B8  : ISH_I2C1_SCL ==> PCH_I2C_MISCB_SCL */
	PAD_CFG_NF_LOCK(GPP_B8, NONE, NF2, LOCK_CONFIG),
	/* B16 : I2C5_SDA ==> PCH_I2C_TPU_SDA */
	PAD_CFG_NF_LOCK(GPP_B16, NONE, NF2, LOCK_CONFIG),
	/* B17 : I2C5_SCL ==> PCH_I2C_TPU_SCL */
	PAD_CFG_NF_LOCK(GPP_B17, NONE, NF2, LOCK_CONFIG),

	/* D0  : ISH_GP0 ==> DEV_MODE_CTRL */
	PAD_NC_LOCK(GPP_D0, NONE, LOCK_CONFIG),
	/* D1  : ISH_GP1 ==> HDMI_IN_PLUGIN */
	PAD_CFG_GPO_LOCK(GPP_D1, 1, LOCK_CONFIG),
	/* D2  : ISH_GP2 ==> REC_MODE */
	PAD_NC_LOCK(GPP_D2, NONE, LOCK_CONFIG),
	/* D3  : ISH_GP3 ==> QSPI_MR_N */
	PAD_NC_LOCK(GPP_D3, NONE, LOCK_CONFIG),
	/* D9  : ISH_SPI_CS# ==> NC */
	PAD_NC_LOCK(GPP_D9, NONE, LOCK_CONFIG),
	/* D10  : ISH_SPI_CS# ==> NC */
	PAD_NC_LOCK(GPP_D10, NONE, LOCK_CONFIG),
	/* D13  : ISH_UART0_RXD ==> PCH_I2C_U3A0_SDA */
	PAD_CFG_NF_LOCK(GPP_D13, NONE, NF3, LOCK_CONFIG),
	/* D14  : ISH_UART0_TXD ==> PCH_I2C_U3A0_SCL */
	PAD_CFG_NF_LOCK(GPP_D14, NONE, NF3, LOCK_CONFIG),
	/* D15  : ISH_UART0_RTS# ==> BOOT_SET_N */
	PAD_NC_LOCK(GPP_D15, NONE, LOCK_CONFIG),
	/* D16  : ISH_UART0_CTS# ==> BOOT_IND */
	PAD_NC_LOCK(GPP_D16, NONE, LOCK_CONFIG),
	/* D17  : UART1_RXD ==> PCH_UART1_RX_ADB_TX */
	PAD_CFG_NF_LOCK(GPP_D17, NONE, NF1, LOCK_CONFIG),
	/* D18  : UART1_TXD ==> PCH_UART1_TX_ADB_RX */
	PAD_CFG_NF_LOCK(GPP_D18, NONE, NF1, LOCK_CONFIG),
	/* D19  : ISH_SPI_MOSI ==> NC */
	PAD_NC_LOCK(GPP_D19, NONE, LOCK_CONFIG),

	/* E1  : THC0_SPI1_IO2 ==> NC */
	PAD_NC_LOCK(GPP_E1, NONE, LOCK_CONFIG),
	/* E2  : THC0_SPI1_IO3 ==> LAN_I350_WAKE# */
	PAD_CFG_GPI_IRQ_WAKE(GPP_E2, NONE, DEEP, LEVEL, INVERT),
	/* E12 : THC0_SPI1_IO1 ==> TPU_RST_PIN40 */
	PAD_CFG_GPO(GPP_E12, 1, DEEP),
	/* E13 : THC0_SPI1_IO2 ==> TPU_RST_PIN42 */
	PAD_CFG_GPO(GPP_E13, 1, DEEP),
	/* E14 : DDSP_HPDA ==> HDMIA_HPD */
	PAD_CFG_NF(GPP_E14, NONE, DEEP, NF1),
	/* E20 : DDP2_CTRLCLK ==> HDMIA_CTRLCLK */
	PAD_CFG_NF(GPP_E20, NONE, DEEP, NF1),
	/* E21 : DDP2_CTRLDATA ==> HDMIA_CTRLDATA_STRAP */
	PAD_CFG_NF(GPP_E21, NONE, DEEP, NF1),

	/* F11 : THC1_SPI2_CLK ==> MEM_CH_SEL */
	PAD_CFG_GPI_LOCK(GPP_F11, NONE, LOCK_CONFIG),
	/* F12 : GSXDOUT ==> MEM_STRAP_1 */
	PAD_CFG_GPI_LOCK(GPP_F12, NONE, LOCK_CONFIG),
	/* F13 : GSXDOUT ==> MEM_STRAP_2 */
	PAD_CFG_GPI_LOCK(GPP_F13, NONE, LOCK_CONFIG),
	/* F15 : GSXSRESET# ==> MEM_STRAP_3 */
	PAD_CFG_GPI_LOCK(GPP_F15, NONE, LOCK_CONFIG),
	/* F16 : GSXCLK ==> MEM_STRAP_0 */
	PAD_CFG_GPI_LOCK(GPP_F16, NONE, LOCK_CONFIG),

	/* H4  : I2C0_SDA ==> PCH_I2C_AUD_SDA */
	PAD_CFG_NF(GPP_H4, NONE, DEEP, NF1),
	/* H5  : I2C0_SCL ==> PCH_I2C_AUD_SCL */
	PAD_CFG_NF(GPP_H5, NONE, DEEP, NF1),
	/* H12 : I2C7_SDA ==> PCH_I2C_U3A1_SDA */
	PAD_CFG_NF(GPP_H12, NONE, DEEP, NF1),
	/* H13 : I2C7_SCL ==> PCH_I2C_U3A1_SCL */
	PAD_CFG_NF(GPP_H13, NONE, DEEP, NF1),
	/* H19 : SRCCLKREQ4# ==> M2_TPU1_CLKREQ_ODL */
	PAD_CFG_NF(GPP_H19, NONE, DEEP, NF1),

	/* R0 : HDA_BCLK ==> NC */
	PAD_NC_LOCK(GPP_R0, NONE, LOCK_CONFIG),
	/* R1 : HDA_SYNC ==> NC */
	PAD_NC_LOCK(GPP_R1, NONE, LOCK_CONFIG),
	/* R2 : HDA_SDO ==> NC */
	PAD_NC_LOCK(GPP_R2, NONE, LOCK_CONFIG),
	/* R3 : HDA_SDIO ==> NC */
	PAD_NC_LOCK(GPP_R3, NONE, LOCK_CONFIG),
	/* R4 : HDA_RST# ==> NC */
	PAD_NC_LOCK(GPP_R4, NONE, LOCK_CONFIG),
	/* R5 : HDA_SDI1 ==> NC */
	PAD_NC_LOCK(GPP_R5, NONE, LOCK_CONFIG),
	/* R6 : I2S2_TXD ==> NC */
	PAD_NC_LOCK(GPP_R6, NONE, LOCK_CONFIG),
	/* R7 : I2S2_RXD ==> NC */
	PAD_NC_LOCK(GPP_R7, NONE, LOCK_CONFIG),
};

/* Early pad configuration in bootblock */
static const struct pad_config early_gpio_table[] = {
	/* A13 : PMC_I2C_SCL ==> GSC_PCH_INT_ODL */
	PAD_CFG_GPI_APIC(GPP_A13, NONE, PLTRST, LEVEL, INVERT),
	/* B4  : PROC_GP3 ==> SSD_PERST_L */
	PAD_CFG_GPO(GPP_B4, 0, DEEP),
	/* E15 : RSVD_TP ==> PCH_WP_OD */
	PAD_CFG_GPI_GPIO_DRIVER(GPP_E15, NONE, DEEP),
	/* F11 : THC0_SPI1_CLK ==> MEM_CH_SEL */
	PAD_CFG_GPI(GPP_F11, NONE, DEEP),
	/* F14 : GSXDIN ==> EN_PP3300_SSD */
	PAD_CFG_GPO(GPP_F14, 1, DEEP),
	/* F18 : THC1_SPI2_INT# ==> EC_IN_RW_OD */
	PAD_CFG_GPI(GPP_F18, NONE, DEEP),
	/* H6  : I2C1_SDA ==> PCH_I2C_TPM_SDA */
	PAD_CFG_NF(GPP_H6, NONE, DEEP, NF1),
	/* H7  : I2C1_SCL ==> PCH_I2C_TPM_SCL */
	PAD_CFG_NF(GPP_H7, NONE, DEEP, NF1),
	/* H10 : UART0_RXD ==> UART_PCH_RX_DBG_TX */
	PAD_CFG_NF(GPP_H10, NONE, DEEP, NF2),
	/* H11 : UART0_TXD ==> UART_PCH_TX_DBG_RX */
	PAD_CFG_NF(GPP_H11, NONE, DEEP, NF2),

	/* CPU PCIe VGPIO for PEG60 */
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_48, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_49, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_50, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_51, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_52, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_53, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_54, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_55, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_56, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_57, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_58, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_59, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_60, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_61, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_62, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_63, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_76, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_77, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_78, NONE, PLTRST, NF1),
	PAD_CFG_NF_VWEN(GPP_vGPIO_PCIE_79, NONE, PLTRST, NF1),
};

const struct pad_config *variant_gpio_override_table(size_t *num)
{
	*num = ARRAY_SIZE(override_gpio_table);
	return override_gpio_table;
}

const struct pad_config *variant_early_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(early_gpio_table);
	return early_gpio_table;
}
